/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumVector;
import org.das2.datum.DomainDivider;
import org.das2.datum.DomainDividerUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.TickVDescriptor;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.GrannyTextRenderer;
import org.das2.util.LoggerManager;

public class LookupAxis
extends DasCanvasComponent {
    private static final Logger logger = LoggerManager.getLogger((String)"org.das2.graph.lookupaxis");
    int maxWidth = 100;
    int maxHeight = 100;
    DasAxis axis;
    QDataSet tt;
    QDataSet ff;
    QDataSet xpos;
    QDataSet fpos;
    QDataSet xposMinor;
    QDataSet fposMinor;
    DatumFormatter format;
    private final PropertyChangeListener updateListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LookupAxis.this.resize();
            try {
                LookupAxis.this.updateTicks();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, null, e);
            }
        }
    };

    public LookupAxis(DasAxis axis) {
        this.setAxis(axis);
    }

    public void setDataSet(QDataSet yy) {
        this.tt = SemanticOps.xtagsDataSet((QDataSet)yy);
        this.ff = yy;
    }

    public void setDataSet(QDataSet xx, QDataSet yy) {
        this.tt = xx;
        this.ff = yy;
    }

    public void setAxis(DasAxis axis) {
        axis.addPropertyChangeListener(this.updateListener);
        this.axis = axis;
    }

    @Override
    protected void uninstallComponent() {
        if (this.axis != null) {
            this.axis.removePropertyChangeListener(this.updateListener);
        }
    }

    private static QDataSet interpWow(Datum y, QDataSet xx, QDataSet yy) {
        QDataSet zipzip = Ops.multiply((QDataSet)Ops.subtract((Object)y, (Object)yy.trim(0, yy.length() - 1)), (QDataSet)Ops.subtract((Object)yy.trim(1, yy.length()), (Object)y));
        QDataSet r = Ops.where((QDataSet)Ops.ge((Object)zipzip, (Object)0));
        QDataSet div = Ops.subtract((QDataSet)DataSetOps.applyIndex((QDataSet)yy, (QDataSet)Ops.add((Object)r, (Object)1)), (QDataSet)DataSetOps.applyIndex((QDataSet)yy, (QDataSet)r));
        QDataSet ff = Ops.divide((QDataSet)Ops.subtract((QDataSet)Ops.dataset((Object)y), (QDataSet)DataSetOps.applyIndex((QDataSet)yy, (QDataSet)r)), (QDataSet)div);
        QDataSet rzero = Ops.where((QDataSet)Ops.eq((Object)Ops.abs((QDataSet)div), (Object)0));
        if (rzero.length() > 0) {
            throw new IllegalArgumentException("yy cannot have repeating values");
        }
        if (UnitsUtil.isIntervalMeasurement((Units)SemanticOps.getUnits((QDataSet)xx))) {
            return Ops.interpolate((QDataSet)xx, (QDataSet)ff);
        }
        return Ops.add((QDataSet)Ops.multiply((QDataSet)DataSetOps.applyIndex((QDataSet)xx, (QDataSet)r), (QDataSet)Ops.subtract((Object)1, (Object)ff)), (QDataSet)Ops.multiply((QDataSet)DataSetOps.applyIndex((QDataSet)xx, (QDataSet)Ops.add((Object)r, (Object)1)), (QDataSet)ff));
    }

    private void drawMessage(Graphics g1, String message) {
        Graphics2D g = (Graphics2D)g1;
        Rectangle r = this.getBounds();
        g.setColor(Color.GRAY);
        g.fillRoundRect(0, 0, r.width - 1, r.height - 1, 7, 7);
        g.setColor(Color.BLACK);
        g.drawRoundRect(0, 0, r.width - 1, r.height - 1, 7, 7);
        g.drawString(message, 0, g.getFont().getSize());
    }

    @Override
    public void paintComponent(Graphics g) {
        int ix;
        QDataSet d;
        TickVDescriptor tickV = this.axis.tickV;
        if (tickV == null) {
            return;
        }
        DatumVector ticks = tickV.getMinorTicks();
        if (this.tt == null) {
            this.drawMessage(g, "no times");
            return;
        }
        if (this.ff == null) {
            this.drawMessage(g, "no data");
            return;
        }
        if (!SemanticOps.getUnits((QDataSet)this.tt).isConvertibleTo(ticks.getUnits())) {
            if (UnitsUtil.isTimeLocation((Units)SemanticOps.getUnits((QDataSet)this.tt))) {
                this.drawMessage(g, "inconvertible units");
                return;
            }
            this.tt = Ops.putProperty((QDataSet)this.tt, (String)"UNITS", (Object)ticks.getUnits());
        }
        g.setColor(Color.BLACK);
        int ascent = g.getFontMetrics().getAscent();
        int height = this.getHeight();
        int myY = this.getY();
        int myX = this.getX();
        this.maxWidth = 0;
        this.maxHeight = 0;
        if (this.xpos == null) {
            try {
                this.updateTicks();
            }
            catch (RuntimeException ex) {
                logger.info(ex.getMessage());
                this.drawMessage(g, "error while updating ticks: " + ex.getMessage());
                return;
            }
        }
        if (this.xpos == null) {
            this.drawMessage(g, "no ticks found!");
            return;
        }
        for (int j = 0; j < this.xpos.length(); ++j) {
            int ix0 = -999;
            d = this.xpos.slice(j);
            ix = (int)this.axis.transform(d);
            if (ix == ix0) continue;
            ix0 = ix;
            if (this.axis.isHorizontal()) {
                if (ix < this.getColumn().getDMinimum() || ix > this.getColumn().getDMaximum()) continue;
                g.drawLine(ix - myX, height + 1, ix - myX, height - 5);
            } else {
                if (ix < this.getRow().getDMinimum() || ix > this.getRow().getDMaximum()) continue;
                g.drawLine(0, ix - myY, 5, ix - myY);
            }
            GrannyTextRenderer gtr = new GrannyTextRenderer();
            gtr.setString(g, this.format.format(DataSetUtil.asDatum((QDataSet)this.fpos.slice(j))));
            if (this.axis.isHorizontal()) {
                gtr.draw(g, (float)(ix - myX - (int)gtr.getWidth() / 2), (float)(height - 5 - 3));
                int height0 = (int)gtr.getHeight() + 8;
                if (height0 <= this.maxHeight) continue;
                this.maxHeight = height0;
                continue;
            }
            gtr.draw(g, 8.0f, (float)(ix + ascent / 2 - myY));
            int width0 = (int)gtr.getWidth();
            if (width0 <= this.maxWidth) continue;
            this.maxWidth = width0;
        }
        this.maxHeight = Math.max(this.maxHeight, 6);
        this.maxWidth = Math.max(this.maxWidth, 6);
        g.setColor(Color.BLACK);
        myY = this.getY();
        int ix0 = -999;
        for (int j = 0; j < this.xposMinor.length(); ++j) {
            d = this.xposMinor.slice(j);
            ix = (int)this.axis.transform(d);
            if (ix == ix0) continue;
            ix0 = ix;
            if (this.axis.isHorizontal()) {
                g.drawLine(ix - myX, height + 1, ix - myX, height - 3);
                continue;
            }
            g.drawLine(0, ix - myY, 3, ix - myY);
        }
    }

    public void updateTicks() {
        DomainDivider dd;
        TickVDescriptor tickV = this.axis.tickV;
        if (tickV == null) {
            return;
        }
        DatumVector ticks = tickV.getMinorTicks();
        Datum fmin = Ops.datum((Object)1.0E20);
        Datum fmax = Ops.datum((Object)-1.0E20);
        if (this.tt == null) {
            logger.fine("no xtags");
            return;
        }
        if (this.ff == null) {
            logger.fine("no data");
            return;
        }
        if (!SemanticOps.getUnits((QDataSet)this.tt).isConvertibleTo(ticks.getUnits())) {
            if (UnitsUtil.isTimeLocation((Units)SemanticOps.getUnits((QDataSet)this.tt))) {
                logger.fine("inconvertible units");
                return;
            }
            this.tt = Ops.putProperty((QDataSet)this.tt, (String)"UNITS", (Object)ticks.getUnits());
        }
        DatumRange axisRange = this.axis.getDatumRange();
        for (int i = 0; i < ticks.getLength(); ++i) {
            QDataSet ffint;
            QDataSet f;
            Datum x = ticks.get(i);
            if (!axisRange.contains(x) || !((f = Ops.findex((QDataSet)this.tt, (QDataSet)Ops.dataset((Object)x))).value() > 0.0) || !(f.value() < (double)this.tt.length()) || Ops.valid((QDataSet)(ffint = Ops.interpolate((QDataSet)this.ff, (QDataSet)f))).value() == 0.0) continue;
            fmin = Ops.datum((Object)Ops.lesserOf((Object)fmin, (Object)ffint));
            fmax = Ops.datum((Object)Ops.greaterOf((Object)fmax, (Object)ffint));
        }
        if (fmin.ge(fmax)) {
            logger.fine("no ticks visible");
            return;
        }
        DomainDivider ytickvdd = DomainDividerUtil.getDomainDivider((Datum)Ops.datum((Object)fmin), (Datum)Ops.datum((Object)fmax));
        while (ytickvdd.boundaryCount(fmin, fmax) < 10L && (dd = ytickvdd.finerDivider(false)) != null) {
            ytickvdd = dd;
        }
        while (ytickvdd.boundaryCount(fmin, fmax) > 20L && (dd = ytickvdd.coarserDivider(false)) != null) {
            ytickvdd = dd;
        }
        ticks = ytickvdd.boundaries(fmin, fmax);
        DatumRange dr = new DatumRange(fmin, fmax);
        this.format = DomainDividerUtil.getDatumFormatter((DomainDivider)ytickvdd, (DatumRange)dr);
        this.maxWidth = 0;
        this.maxHeight = 0;
        DataSetBuilder xposBuilder = new DataSetBuilder(1, 100);
        DataSetBuilder fposBuilder = new DataSetBuilder(1, 100);
        for (int i = 0; i < ticks.getLength(); ++i) {
            Datum atick = ticks.get(i);
            QDataSet dds = LookupAxis.interpWow(atick, this.tt, this.ff);
            int ix0 = -999;
            for (int j = 0; j < dds.length(); ++j) {
                QDataSet d = dds.slice(j);
                int ix = (int)this.axis.transform(d);
                if (ix == ix0) continue;
                ix0 = ix;
                if (this.axis.isHorizontal()) {
                    if (ix < this.getColumn().getDMinimum() || ix > this.getColumn().getDMaximum()) continue;
                    xposBuilder.nextRecord(d);
                    fposBuilder.nextRecord(atick);
                    continue;
                }
                if (ix < this.getRow().getDMinimum() || ix > this.getRow().getDMaximum()) continue;
                xposBuilder.nextRecord(d);
                fposBuilder.nextRecord(atick);
            }
        }
        DataSetBuilder xposMinorBuilder = new DataSetBuilder(1, 100);
        DataSetBuilder fposMinorBuilder = new DataSetBuilder(1, 100);
        ticks = ytickvdd.finerDivider(true).boundaries(fmin, fmax);
        for (int i = 0; i < ticks.getLength(); ++i) {
            Datum atick = ticks.get(i);
            QDataSet dds = LookupAxis.interpWow(atick, this.tt, this.ff);
            int ix0 = -999;
            for (int j = 0; j < dds.length(); ++j) {
                QDataSet d = dds.slice(j);
                int ix = (int)this.axis.transform(d);
                if (ix == ix0) continue;
                ix0 = ix;
                if (this.axis.isHorizontal()) {
                    if (ix < this.getColumn().getDMinimum() || ix > this.getColumn().getDMaximum()) continue;
                    xposMinorBuilder.nextRecord(d);
                    fposMinorBuilder.nextRecord(atick);
                    continue;
                }
                if (ix < this.getRow().getDMinimum() || ix > this.getRow().getDMaximum()) continue;
                xposMinorBuilder.nextRecord(d);
                fposMinorBuilder.nextRecord(atick);
            }
        }
        this.xpos = xposBuilder.getDataSet();
        this.fpos = fposBuilder.getDataSet();
        this.xposMinor = xposMinorBuilder.getDataSet();
        this.fposMinor = fposMinorBuilder.getDataSet();
    }

    @Override
    public void resize() {
        if (this.getColumn() == null || this.getColumn().getParent() == null) {
            return;
        }
        if (this.maxHeight < 6) {
            this.maxHeight = 6;
        }
        if (this.maxWidth < 6) {
            this.maxWidth = 6;
        }
        if (this.axis.isHorizontal()) {
            int x = this.getColumn().getDMinimum();
            int y = this.getRow().getDMinimum();
            Rectangle rect = new Rectangle(x, y - this.maxHeight, this.getColumn().getWidth(), this.maxHeight);
            this.setBounds(rect);
        } else {
            int x = this.getColumn().getDMaximum();
            int y = this.getRow().getDMinimum();
            Rectangle rect = new Rectangle(x, y, this.maxWidth, this.getRow().getHeight());
            this.setBounds(rect);
        }
    }
}

