/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.das2.components.propertyeditor.Displayable;
import org.das2.components.propertyeditor.Enumeration;

public final class SymColor
extends Color
implements Enumeration,
Displayable {
    private String name;
    private ImageIcon imageIcon;
    public static final SymColor black = new SymColor("black", Color.black);
    public static final SymColor blue = new SymColor("blue", Color.blue);
    public static final SymColor lightRed = new SymColor("lightRed", new Color(255, 128, 128));
    public static final SymColor red = new SymColor("red", Color.red);
    public static final SymColor darkRed = new SymColor("darkRed", Color.red.darker());
    public static final SymColor green = new SymColor("green", Color.green);
    public static final SymColor darkGreen = new SymColor("darkGreen", Color.green.darker());
    public static final SymColor white = new SymColor("white", Color.white);
    public static final SymColor gray = new SymColor("gray", Color.gray);
    public static final SymColor magenta = new SymColor("magenta", Color.magenta);

    private SymColor(String name, Color color) {
        this(name, color.getRGB());
    }

    private SymColor(String name, int rgb) {
        super(rgb);
        this.name = name;
        BufferedImage i = new BufferedImage(10, 10, 1);
        Graphics g = ((Image)i).getGraphics();
        g.setColor(this);
        g.fillRect(0, 0, 10, 10);
        this.imageIcon = new ImageIcon(i);
    }

    @Override
    public Icon getListIcon() {
        return this.imageIcon;
    }

    @Override
    public void drawListIcon(Graphics2D g, int x, int y) {
        ImageIcon i = (ImageIcon)this.getListIcon();
        g.drawImage(i.getImage(), x, y, null);
    }

    @Override
    public String getListLabel() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public Color toColor() {
        return this;
    }

    public static SymColor parseSymColor(String str) {
        if (str.equals("black")) {
            return black;
        }
        if (str.equals("blue")) {
            return blue;
        }
        if (str.equals("red")) {
            return red;
        }
        if (str.equals("green")) {
            return green;
        }
        if (str.equals("white")) {
            return white;
        }
        if (str.equals("gray")) {
            return gray;
        }
        throw new IllegalArgumentException(str);
    }
}

