/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.graph.DasAxis;
import org.das2.graph.TickVDescriptor;
import org.das2.util.LoggerManager;

public class TickMaster {
    private static final Logger logger = LoggerManager.getLogger((String)"das2.graphics.axis.tickmaster");
    private final HashSet<WeakReference<DasAxis>> axes = new HashSet();
    private final HashSet<WeakReference<DasAxis>> pendingAxes = new HashSet();
    private static final TickMaster instance = new TickMaster();

    public static TickMaster getInstance() {
        return instance;
    }

    public synchronized void register(DasAxis h) {
        this.pendingAxes.add(new WeakReference<DasAxis>(h));
    }

    public synchronized TickVDescriptor requestTickV(DasAxis h) {
        DasAxis p = this.findParent(h);
        if (p != null) {
            return p.getTickV();
        }
        return null;
    }

    private DasAxis findParent(DasAxis h) {
        DasAxis parent = null;
        for (WeakReference<DasAxis> da : this.axes) {
            DasAxis a = (DasAxis)da.get();
            if (a == null || a.getCanvas() == null || a.getOrientation() != h.getOrientation() || Math.abs(a.getDLength() - h.getDLength()) >= 2 || a.isLog() != h.isLog() || !a.getDatumRange().equals((Object)h.getDatumRange()) || !a.isVisible() || !a.isTickLabelsVisible()) continue;
            parent = a;
            break;
        }
        return parent;
    }

    public synchronized void offerTickV(DasAxis h, TickVDescriptor ticks) {
        logger.finer("Enter offerTickV");
        HashSet<WeakReference<DasAxis>> rm = new HashSet<WeakReference<DasAxis>>();
        for (WeakReference<DasAxis> da : this.pendingAxes) {
            DasAxis a = (DasAxis)da.get();
            if (a != null && a.getCanvas() == null) continue;
            rm.add(da);
        }
        this.pendingAxes.removeAll(rm);
        this.axes.addAll(rm);
        ArrayList<String> axesUsing = new ArrayList<String>();
        if (h.isVisible() && h.isTickLabelsVisible()) {
            if (ticks == null) {
                logger.log(Level.FINE, "axes {0} offers ticks: null", new Object[]{h.getDasName()});
            } else {
                logger.log(Level.FINE, "axes {0} offers ticks: {1}", new Object[]{h.getDasName(), ticks.toString()});
            }
            int count = 0;
            int mecount = 0;
            rm = new HashSet();
            for (WeakReference<DasAxis> da : this.axes) {
                DasAxis a = (DasAxis)da.get();
                if (a == h) {
                    ++mecount;
                }
                if (a == null) {
                    rm.add(da);
                    continue;
                }
                if (a.getCanvas() == null) {
                    rm.add(da);
                    continue;
                }
                if (a.getOrientation() != h.getOrientation() || Math.abs(a.getDLength() - h.getDLength()) >= 2 || a.isLog() != h.isLog() || !a.getDatumRange().equals((Object)h.getDatumRange())) continue;
                a.resetTickV(ticks);
                ++count;
                axesUsing.add(a.getDasName());
            }
            if (mecount == 0) {
                h.resetTickV(ticks);
            }
            if (rm.size() > 0) {
                logger.log(Level.FINE, "remove old axes: {0}", rm);
                this.axes.removeAll(rm);
            }
            logger.log(Level.FINE, "axes using these ticks: {0} {1}", new Object[]{count, axesUsing});
        }
        logger.finer("Exit offerTickV");
    }
}

