/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph;

import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.CancelledOperationException;
import org.das2.DasApplication;
import org.das2.dataset.DataSetAdapter;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;
import org.das2.graph.DasAxis;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DataLoader;
import org.das2.graph.Renderer;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.stream.StreamException;
import org.das2.system.DasLogger;
import org.das2.util.monitor.ProgressMonitor;

public class XAxisDataLoader
extends DataLoader
implements DataSetUpdateListener {
    DasAxis xaxis;
    DataSetDescriptor dsd;
    ProgressMonitor progressMonitor;
    private static final Logger logger = DasLogger.getLogger(DasLogger.GRAPHICS_LOG, "XAxisDataLoader");
    DataLoader.Request currentRequest;
    List unsolicitedRequests;
    final Object lockObject = new Object();
    private boolean fullResolution = false;

    public XAxisDataLoader(Renderer r, DataSetDescriptor dsd) {
        super(r);
        this.dsd = dsd;
        if (dsd != null) {
            dsd.addDataSetUpdateListener(this);
        }
        this.unsolicitedRequests = new ArrayList();
    }

    @Override
    public void update() {
        if (this.isActive()) {
            logger.finer("enter XAxisDataLoader.update");
            DasPlot p = this.getRenderer().getParent();
            if (p == null) {
                logger.fine("plot is null, no need to load");
            } else {
                DasAxis xAxis = p.getXAxis();
                DasAxis yAxis = p.getYAxis();
                if (!xAxis.valueIsAdjusting() && !yAxis.valueIsAdjusting()) {
                    this.loadDataSet(xAxis, yAxis);
                }
            }
        } else {
            logger.finer("enter XAxisDataLoader.update, ignored not active");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDataSet(DasAxis xAxis, DasAxis yAxis) {
        logger.log(Level.FINE, "render requests dataset for x:{0} y:{1}", new Object[]{xAxis.getMemento(), yAxis.getMemento()});
        if (this.xaxis == null) {
            this.xaxis = xAxis;
        }
        if (this.xaxis.getColumn() == DasColumn.NULL) {
            logger.fine("column not set yet");
            return;
        }
        if (this.dsd == null) {
            logger.fine("dsd is null, nothing to do");
            return;
        }
        Object object = this.lockObject;
        synchronized (object) {
            if (this.currentRequest != null) {
                if (!xAxis.getMemento().equals(this.currentRequest.xmem)) {
                    logger.log(Level.FINE, "cancel old request: {0}", this.currentRequest);
                    ProgressMonitor monitor = this.currentRequest.monitor;
                    this.currentRequest = null;
                    monitor.cancel();
                } else {
                    logger.fine("ignore repeat request");
                    return;
                }
            }
            Datum dataRange1 = xAxis.getDataMaximum().subtract(xAxis.getDataMinimum());
            double deviceRange = Math.floor((double)xAxis.getColumn().getDMaximum() + 0.5) - Math.floor((double)xAxis.getColumn().getDMinimum() + 0.5);
            Datum resolution = this.isFullResolution() ? null : dataRange1.divide(deviceRange);
            if (deviceRange == 0.0) {
                return;
            }
            DasPlot parent = this.renderer.getParent();
            DatumRange loadRange = xAxis.getDatumRange();
            CacheTag cacheTag = new CacheTag(loadRange, resolution);
            if (this.dsd.getDataSetCache().haveStored(this.dsd, cacheTag)) {
                this.renderer.setDataSet((QDataSet)DataSetAdapter.create(this.dsd.getDataSetCache().retrieve(this.dsd, cacheTag)));
                this.currentRequest = null;
            } else {
                this.progressMonitor = this.getMonitor("dsd.requestDataSet " + this.dsd + ":" + loadRange + " @ " + (resolution == null ? "intrinsic" : "" + DatumUtil.asOrderOneUnits((Datum)resolution)));
                parent.repaint(0, 0, parent.getWidth(), parent.getHeight());
                logger.log(Level.FINE, "request data from dsd: {0} @ {1}", new Object[]{loadRange, resolution});
                this.currentRequest = new DataLoader.Request(this.progressMonitor, xAxis.getMemento(), yAxis.getMemento());
                this.dsd.requestDataSet(loadRange.min(), loadRange.max(), resolution, this.progressMonitor, parent.getCanvas());
            }
        }
    }

    private boolean rendererHandlesException(Exception e) {
        boolean result;
        boolean bl = result = e instanceof InterruptedIOException || e instanceof NoDataInIntervalException || e instanceof StreamException || e instanceof CancelledOperationException;
        if (!result) {
            result = e.getCause() instanceof InterruptedIOException;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataSetUpdated(DataSetUpdateEvent e) {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.renderer.getDataLoader() != this) {
                return;
            }
            logger.log(Level.FINE, "got dataset update:{0}", e);
            if (e.getException() != null && e.getDataSet() != null) {
                throw new IllegalStateException("both exception and data set");
            }
            if (e.getException() != null) {
                logger.log(Level.FINE, "got dataset update exception: " + e.getException().getMessage(), e.getException());
                Exception exception = e.getException();
                if (!this.rendererHandlesException(exception)) {
                    DasApplication.getDefaultApplication().getExceptionHandler().handle((Throwable)exception);
                }
                ProgressMonitor mon = e.getMonitor();
                if (this.currentRequest != null) {
                    if (mon == null || mon == this.currentRequest.monitor) {
                        this.renderer.setException(exception);
                        this.renderer.setDataSet(null);
                        logger.log(Level.FINE, "current request completed w/exception: " + e.getException().getMessage(), this.currentRequest);
                        this.currentRequest = null;
                    } else {
                        logger.fine("got exception but not for currentRequest ");
                    }
                } else {
                    logger.fine("got exception but currentRequest ");
                }
                if (!this.rendererHandlesException(exception)) {
                    DasApplication.getDefaultApplication().getExceptionHandler().handle((Throwable)exception);
                }
            } else {
                if (e.getDataSet() == null) {
                    logger.fine("got dataset update notification (no dataset).");
                    this.loadDataSet(this.renderer.getParent().getXAxis(), this.renderer.getParent().getYAxis());
                    return;
                }
                if (this.currentRequest == null) {
                    logger.fine("ignore update w/dataset, currentRequest=null");
                } else {
                    QDataSet ds = e.getDataSet();
                    ProgressMonitor mon = e.getMonitor();
                    if (mon == null || this.currentRequest.monitor == mon) {
                        logger.log(Level.FINE, "got dataset update w/dataset: {0}", ds);
                        if (ds != null) {
                            if (ds.length() > 0) {
                                logger.log(Level.FINE, "  ds range: {0}", Ops.extent((QDataSet)ds).slice(0));
                            } else {
                                logger.fine("  ds range: (empty)");
                            }
                        }
                        this.renderer.setDataSet(ds);
                        logger.log(Level.FINE, "current request completed w/dataset: {0}", this.currentRequest.xmem);
                        this.currentRequest = null;
                    } else {
                        logger.log(Level.FINE, "got dataset update w/dataset but not my monitor: {0}", ds);
                    }
                }
            }
        }
    }

    public void setDataSetDescriptor(DataSetDescriptor dsd) {
        logger.log(Level.FINE, "set dsd: {0}", dsd);
        if (this.dsd != null) {
            this.dsd.removeDataSetUpdateListener(this);
        }
        this.dsd = dsd;
        if (dsd != null) {
            dsd.addDataSetUpdateListener(this);
        }
        this.update();
    }

    public DataSetDescriptor getDataSetDescriptor() {
        return this.dsd;
    }

    @Override
    public void setReloadDataSet(boolean reloadDataSet) {
        super.setReloadDataSet(reloadDataSet);
        this.dsd.reset();
    }

    @Override
    public boolean isFullResolution() {
        return this.fullResolution;
    }

    @Override
    public void setFullResolution(boolean b) {
        if (this.fullResolution == b) {
            return;
        }
        this.fullResolution = b;
    }

    public DataLoader.Request getCurrentRequest() {
        return this.currentRequest;
    }

    public DataLoader.Request[] getUnsolicitedRequests() {
        return this.unsolicitedRequests.toArray(new DataLoader.Request[this.unsolicitedRequests.size()]);
    }

    public DataLoader.Request getUnsolicitedRequests(int i) {
        return (DataLoader.Request)this.unsolicitedRequests.get(i);
    }
}

