/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.das2.dasml.Processor;
import org.das2.graph.DasCanvas;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class TransferableCanvas
implements Transferable {
    public static final DataFlavor CANVAS_FLAVOR;
    private DasCanvas canvas;

    public TransferableCanvas(DasCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(CANVAS_FLAVOR)) {
            return this.canvas;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                document.appendChild(Processor.getDOMElement(this.canvas, document));
                StringWriter writer = new StringWriter();
                DOMImplementationLS ls = (DOMImplementationLS)document.getImplementation().getFeature("LS", "3.0");
                LSOutput output = ls.createLSOutput();
                output.setEncoding("UTF-8");
                output.setCharacterStream(writer);
                LSSerializer serializer = ls.createLSSerializer();
                serializer.write(document, output);
                return writer.toString();
            }
            catch (ParserConfigurationException pce) {
                throw new RuntimeException(pce);
            }
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{CANVAS_FLAVOR, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(CANVAS_FLAVOR) || flavor.equals(DataFlavor.stringFlavor);
    }

    static {
        try {
            String typeStr = "application/x-java-jvm-local-objectref;class=org.das2.graph.DasCanvas";
            CANVAS_FLAVOR = new DataFlavor(typeStr);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(cnfe);
        }
    }
}

