/*
 * Decompiled with CFR 0.152.
 */
package org.das2.graph.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.das2.DasApplication;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.event.BoxRenderer;
import org.das2.event.BoxSelectionEvent;
import org.das2.event.BoxSelectionListener;
import org.das2.event.BoxSelectorMouseModule;
import org.das2.event.LabelDragRenderer;
import org.das2.event.MouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Legend;
import org.das2.graph.Renderer;
import org.das2.system.DasLogger;
import org.das2.util.DenseConsoleFormatter;
import org.das2.util.GrannyTextRenderer;
import org.das2.util.ObjectLocator;

public class GraphicalLogHandler
extends Handler {
    List records = new ArrayList();
    List yAxisValuesThread = new ArrayList();
    List yAxisValuesClass = new ArrayList();
    List yAxisValuesLogger = new ArrayList();
    List times = new ArrayList();
    Renderer renderer;
    boolean updating = false;
    Thread updateThread;
    long time0;
    HashMap loggerMap = new HashMap();
    HashMap<String, Integer> yaxisMapThread = new HashMap();
    HashMap<String, Integer> yaxisMapClass = new HashMap();
    HashMap<String, Integer> yaxisMapLogger = new HashMap();
    private static final int YAXIS_THREAD = -199;
    private static final int YAXIS_CLASS = -198;
    private static final int YAXIS_LOGNAME = -197;
    private int yaxisDimension = -197;
    DasAxis xaxis;
    Legend legend;
    JFrame frame;
    long sleepInitiallyTime = 2000L;
    private static GraphicalLogHandler instance = null;
    ObjectLocator objectLocator;

    private GraphicalLogHandler() {
        this.time0 = System.currentTimeMillis();
    }

    public static GraphicalLogHandler getInstance() {
        if (instance == null) {
            instance = new GraphicalLogHandler();
        }
        return instance;
    }

    private void createCanvas() {
        if (this.loggerMap.isEmpty()) {
            this.loggerMap.put(DasLogger.getLogger(DasLogger.APPLICATION_LOG).getName(), Color.black);
            this.loggerMap.put(DasLogger.getLogger(DasLogger.DATA_OPERATIONS_LOG).getName(), Color.blue);
            this.loggerMap.put(DasLogger.getLogger(DasLogger.DATA_TRANSFER_LOG).getName(), Color.YELLOW);
            this.loggerMap.put(DasLogger.getLogger(DasLogger.GRAPHICS_LOG).getName(), Color.PINK);
            this.loggerMap.put(DasLogger.getLogger(DasLogger.SYSTEM_LOG).getName(), Color.gray);
            this.loggerMap.put(DasLogger.getLogger(DasLogger.GUI_LOG).getName(), Color.green);
            this.loggerMap.put(DasLogger.getLogger(DasLogger.DASML_LOG).getName(), Color.LIGHT_GRAY);
        }
        DasCanvas canvas = new DasCanvas(800, 400);
        DasPlot plot = DasPlot.createPlot(new DatumRange(0.0, 10.0, Units.seconds), new DatumRange(0.0, 10.0, Units.dimensionless));
        this.xaxis = plot.getXAxis();
        this.xaxis.setAnimated(false);
        this.renderer.setDataSetLoader(null);
        plot.addRenderer(this.renderer);
        canvas.add(plot, new DasRow(canvas, 0.1, 0.9), DasColumn.create(canvas));
        MouseModule mm = this.getMouseModule();
        plot.getDasMouseInputAdapter().addMouseModule(mm);
        plot.getDasMouseInputAdapter().setPrimaryModule(mm);
        mm = this.getShowLogMouseModule(plot);
        plot.getDasMouseInputAdapter().addMouseModule(mm);
        plot.getDasMouseInputAdapter().setSecondaryModule(mm);
        this.legend = new Legend();
        canvas.add(this.legend, new DasRow(canvas, 0.1, 0.5), new DasColumn(canvas, 0.65, 0.98));
        for (Object key : this.loggerMap.keySet()) {
            String name = String.valueOf(key);
            if (name.equals("")) {
                name = "<default>";
            }
            this.legend.add(Legend.getIcon((Color)this.loggerMap.get(key)), name);
        }
        this.frame = DasApplication.getDefaultApplication().createMainFrame("GraphicalLogHandler");
        JPanel appPanel = new JPanel(new BorderLayout());
        appPanel.add((Component)canvas, "Center");
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        JCheckBox jcb = new JCheckBox(this.getUpdatingAction());
        jcb.setSelected(this.updating);
        this.startUpdateThread();
        controlPanel.add(jcb);
        JButton x = new JButton(this.getUpdateAction());
        controlPanel.add(x);
        appPanel.add((Component)controlPanel, "South");
        this.frame.getContentPane().add(appPanel);
        this.frame.setVisible(true);
        this.frame.pack();
        this.frame.setDefaultCloseOperation(2);
    }

    private Action getUpdatingAction() {
        return new AbstractAction("Updating"){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox source = (JCheckBox)e.getSource();
                GraphicalLogHandler.this.updating = source.isSelected();
                if (GraphicalLogHandler.this.updating) {
                    GraphicalLogHandler.this.startUpdateThread();
                }
            }
        };
    }

    private Action getUpdateAction() {
        return new AbstractAction("Update"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphicalLogHandler.this.update();
            }
        };
    }

    public void setYAxisType(int type) {
        this.yaxisDimension = type;
    }

    public int getYAxisType() {
        return this.yaxisDimension;
    }

    private void update() {
        long endMillis = System.currentTimeMillis() - this.time0 + 2000L;
        if (endMillis < 10000L) {
            endMillis = 10000L;
        }
        Datum end = Units.seconds.createDatum((double)endMillis / 1000.0);
        DatumRange range = new DatumRange(end.subtract(this.xaxis.getDatumRange().width()), end);
        this.xaxis.setDatumRange(range);
    }

    private void startUpdateThread() {
        if (this.updateThread == null) {
            this.updateThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!GraphicalLogHandler.this.updating) continue;
                        GraphicalLogHandler.this.update();
                    }
                }
            }, "graphicalHandlerUpdateThread");
            this.updateThread.start();
        }
    }

    private boolean checkMyMessages(StackTraceElement[] st) {
        String myName = this.getClass().getName();
        boolean result = false;
        for (int i = 1; i < st.length; ++i) {
            if (st[i].getClassName().equals(myName)) {
                result = true;
            }
            if (!st[i].getClassName().contains("DasLogger")) continue;
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord rec) {
        String yAxisName;
        StackTraceElement[] st = new Throwable().getStackTrace();
        if (this.checkMyMessages(st)) {
            return;
        }
        if (Thread.currentThread().getName().equals("graphicalHandlerUpdateThread")) {
            return;
        }
        if (DasApplication.getDefaultApplication().isHeadless()) {
            return;
        }
        if (this.renderer == null && System.currentTimeMillis() - this.time0 > this.sleepInitiallyTime) {
            this.getRenderer();
        }
        if (this.yaxisDimension == -199) {
            yAxisName = Thread.currentThread().getName();
        } else if (this.yaxisDimension == -198) {
            yAxisName = rec.getSourceClassName();
        } else if (this.yaxisDimension == -197) {
            yAxisName = rec.getLoggerName();
        } else {
            throw new IllegalArgumentException("bad yAxisName");
        }
        Integer yValue = this.yaxisMapClass.get(rec.getSourceClassName());
        if (yValue == null) {
            yValue = this.yaxisMapClass.size();
            this.yaxisMapClass.put(yAxisName, yValue);
        }
        if ((yValue = this.yaxisMapThread.get(rec.getSourceClassName())) == null) {
            yValue = this.yaxisMapThread.size();
            this.yaxisMapThread.put(yAxisName, yValue);
        }
        if ((yValue = this.yaxisMapLogger.get(rec.getLoggerName())) == null) {
            yValue = this.yaxisMapLogger.size();
            this.yaxisMapLogger.put(yAxisName, yValue);
        }
        GraphicalLogHandler graphicalLogHandler = this;
        synchronized (graphicalLogHandler) {
            Long time = rec.getMillis() - this.time0;
            int index = Collections.binarySearch(this.times, time);
            if (index < 0) {
                index = -1 - index;
            } else {
                int fudge = 0;
                while (index >= 0) {
                    time = rec.getMillis() - this.time0 + (long)(++fudge);
                    index = Collections.binarySearch(this.times, time);
                }
                index = -1 - index;
            }
            this.records.add(index, rec);
            this.yAxisValuesClass.add(index, this.yaxisMapClass.get(rec.getSourceClassName()));
            this.yAxisValuesThread.add(index, this.yaxisMapThread.get(rec.getSourceClassName()));
            this.yAxisValuesLogger.add(index, this.yaxisMapLogger.get(rec.getLoggerName()));
            this.times.add(index, time);
        }
    }

    @Override
    public void flush() {
        if (this.renderer == null) {
            this.getRenderer();
        }
        this.renderer.update();
    }

    @Override
    public void close() {
    }

    private synchronized void setObjectLocator(ObjectLocator o) {
        this.objectLocator = o;
    }

    private synchronized ObjectLocator getObjectLocator() {
        return this.objectLocator;
    }

    Renderer getRenderer() {
        if (this.renderer == null) {
            this.renderer = new LogRenderer();
            this.createCanvas();
        }
        return this.renderer;
    }

    public MouseModule getMouseModule() {
        DasPlot parent = this.renderer.getParent();
        LookupDragRenderer dr = new LookupDragRenderer(parent);
        MouseModule mouseModule = new MouseModule(parent, dr, "DataSetMonitor");
        return mouseModule;
    }

    public MouseModule getShowLogMouseModule(DasPlot plot2) {
        BoxSelectorMouseModule result = new BoxSelectorMouseModule(plot2, plot2.getXAxis(), plot2.getYAxis(), plot2.getRenderer(0), new BoxRenderer(plot2), "View Messages");
        result.setDragEvents(false);
        result.setReleaseEvents(true);
        result.addBoxSelectionListener(new BoxSelectionListener(){

            @Override
            public void boxSelected(BoxSelectionEvent e) {
                StringBuilder buf = new StringBuilder(1000);
                DenseConsoleFormatter f = new DenseConsoleFormatter();
                DatumRange threadsRange = e.getYRange();
                DatumRange timeRange = e.getXRange();
                List yAxisValues = GraphicalLogHandler.this.yaxisDimension == -198 ? GraphicalLogHandler.this.yAxisValuesClass : (GraphicalLogHandler.this.yaxisDimension == -199 ? GraphicalLogHandler.this.yAxisValuesThread : GraphicalLogHandler.this.yAxisValuesLogger);
                int messageCount = 0;
                for (int i = 0; i < GraphicalLogHandler.this.records.size(); ++i) {
                    double time = ((Long)GraphicalLogHandler.this.times.get(i)).doubleValue();
                    if (!timeRange.contains(Units.milliseconds.createDatum(time)) || !threadsRange.contains(Units.dimensionless.createDatum((Number)yAxisValues.get(i)))) continue;
                    buf.append(f.format((LogRecord)GraphicalLogHandler.this.records.get(i)));
                    ++messageCount;
                }
                JDialog dialog = new JDialog((Frame)GraphicalLogHandler.this.frame, "Log messages");
                JTextArea pane = new JTextArea();
                pane.insert(buf.toString(), 0);
                pane.insert("" + messageCount + " messages: \n\n", 0);
                JScrollPane spane = new JScrollPane(pane);
                spane.setPreferredSize(new Dimension(800, 600));
                dialog.getContentPane().add(spane);
                dialog.pack();
                dialog.setVisible(true);
            }
        });
        return result;
    }

    public static void main(String[] args) {
        GraphicalLogHandler p = new GraphicalLogHandler();
        DasLogger.getLogger(DasLogger.DATA_TRANSFER_LOG).addHandler(p);
        DasLogger.getLogger(DasLogger.DATA_TRANSFER_LOG).warning("warning");
        DasLogger.getLogger(DasLogger.DATA_TRANSFER_LOG).info("info");
        JButton b = new JButton(new AbstractAction("pushme"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DasLogger.getLogger(DasLogger.GRAPHICS_LOG).warning("*giggle*");
            }
        });
        JFrame f = new JFrame();
        f.getContentPane().add(b);
        f.pack();
        f.setVisible(true);
    }

    private class LookupDragRenderer
    extends LabelDragRenderer {
        private static final String LABEL_NOT_AVAILABLE = "n/a";
        DasAxis xaxis;
        DasAxis yaxis;

        LookupDragRenderer(DasPlot parent) {
            super(parent);
            this.xaxis = parent.getXAxis();
            this.yaxis = parent.getYAxis();
        }

        @Override
        public Rectangle[] renderDrag(Graphics g, Point p1, Point p2) {
            Rectangle[] myDirtyBounds;
            String label;
            LogRecord select = (LogRecord)GraphicalLogHandler.this.getObjectLocator().closestObject(p2);
            int iclosest = GraphicalLogHandler.this.records.indexOf(select);
            List yAxisValues = GraphicalLogHandler.this.yaxisDimension == -198 ? GraphicalLogHandler.this.yAxisValuesClass : (GraphicalLogHandler.this.yaxisDimension == -199 ? GraphicalLogHandler.this.yAxisValuesThread : GraphicalLogHandler.this.yAxisValuesLogger);
            if (select == null) {
                label = LABEL_NOT_AVAILABLE;
                myDirtyBounds = new Rectangle[]{new Rectangle(0, 0, 0, 0), new Rectangle(0, 0, 0, 0)};
            } else {
                label = select.getLoggerName() + ":" + select.getLevel() + ":!c" + select.getMessage();
                int ix = (int)this.xaxis.transform(Units.milliseconds.createDatum(((Long)GraphicalLogHandler.this.times.get(iclosest)).longValue()));
                int iy = (int)this.yaxis.transform(Units.dimensionless.createDatum(((Integer)yAxisValues.get(iclosest)).intValue()));
                g.drawOval(ix - 5, iy - 5, 10, 10);
                GrannyTextRenderer gtr = new GrannyTextRenderer();
                gtr.setString(g, label);
                gtr.draw(g, 5.0f, (float)g.getFontMetrics().getHeight());
                Rectangle gtrBounds = gtr.getBounds();
                gtrBounds.translate(5, g.getFontMetrics().getHeight());
                myDirtyBounds = new Rectangle[]{new Rectangle(ix - 5, iy - 5, 11, 11), gtrBounds};
            }
            super.setLabel(label);
            Rectangle[] dirtyBounds = super.renderDrag(g, p1, p2);
            if (dirtyBounds.length > 0) {
                return new Rectangle[]{dirtyBounds[0], myDirtyBounds[0], myDirtyBounds[1]};
            }
            return new Rectangle[]{myDirtyBounds[0], myDirtyBounds[1]};
        }
    }

    public class LogRenderer
    extends Renderer {
        String searchRegex = "";

        public String getSearchRegex() {
            return this.searchRegex;
        }

        public void setSearchRegex(String regex) {
            this.searchRegex = regex;
            super.update();
        }

        @Override
        public void render(Graphics2D g1, DasAxis xAxis, DasAxis yAxis) {
            LogRecord record;
            int i;
            int lastIndex;
            List yAxisValues;
            HashMap<String, Integer> yaxisMap;
            Graphics2D g = g1;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int ix0 = (int)xAxis.transform(xAxis.getDataMinimum());
            g.setColor(Color.lightGray);
            if (GraphicalLogHandler.this.yaxisDimension == -198) {
                yaxisMap = GraphicalLogHandler.this.yaxisMapClass;
                yAxisValues = GraphicalLogHandler.this.yAxisValuesClass;
            } else if (GraphicalLogHandler.this.yaxisDimension == -199) {
                yaxisMap = GraphicalLogHandler.this.yaxisMapThread;
                yAxisValues = GraphicalLogHandler.this.yAxisValuesThread;
            } else {
                yaxisMap = GraphicalLogHandler.this.yaxisMapLogger;
                yAxisValues = GraphicalLogHandler.this.yAxisValuesLogger;
            }
            for (Map.Entry<String, Integer> e : yaxisMap.entrySet()) {
                String name = e.getKey();
                Integer ithread = e.getValue();
                int iy = (int)yAxis.transform(Units.dimensionless.createDatum(ithread.intValue()));
                g.drawString(String.valueOf(name), ix0 + 2, iy);
            }
            ObjectLocator objectLocator = new ObjectLocator();
            long minMilli = (long)xAxis.getDataMinimum().doubleValue(Units.milliseconds);
            long maxMilli = (long)xAxis.getDataMaximum().doubleValue(Units.milliseconds);
            int firstIndex = Collections.binarySearch(GraphicalLogHandler.this.times, minMilli);
            if (firstIndex < 0) {
                firstIndex = -1 - firstIndex;
            }
            lastIndex = (lastIndex = Collections.binarySearch(GraphicalLogHandler.this.times, maxMilli)) < 0 ? -1 - lastIndex : ++lastIndex;
            int lastX = -999;
            int lastY = -999;
            int collisionCount = 0;
            DasPlot parent = this.getParent();
            if (!this.searchRegex.equals("")) {
                for (i = firstIndex; i < lastIndex; ++i) {
                    record = (LogRecord)GraphicalLogHandler.this.records.get(i);
                    if (!record.getMessage().matches(this.searchRegex)) continue;
                    int ix = (int)xAxis.transform(Units.milliseconds.createDatum(((Long)GraphicalLogHandler.this.times.get(i)).longValue()));
                    g.setColor(Color.lightGray);
                    g.fillRect(ix - 2, parent.getY(), 5, parent.getHeight());
                    objectLocator.addObject((Shape)new Rectangle(ix - 2, parent.getY(), 5, parent.getHeight()), (Object)record);
                }
            }
            for (i = firstIndex; i < lastIndex; ++i) {
                Color color;
                record = (LogRecord)GraphicalLogHandler.this.records.get(i);
                int ithread = (Integer)yAxisValues.get(i);
                int iy = (int)yAxis.transform(Units.dimensionless.createDatum(ithread));
                int ix = (int)xAxis.transform(Units.milliseconds.createDatum(((Long)GraphicalLogHandler.this.times.get(i)).longValue()));
                if (ix == lastX && iy == lastY) {
                    ++collisionCount;
                } else {
                    lastX = ix;
                    lastY = iy;
                    collisionCount = 0;
                }
                if (!this.searchRegex.isEmpty() && record.getMessage().matches(this.searchRegex)) {
                    g.setColor(Color.lightGray);
                    g.fillRect(ix - 2, 0, 5, 100);
                }
                if ((color = (Color)GraphicalLogHandler.this.loggerMap.get(record.getLoggerName())) == null) {
                    String key = record.getLoggerName();
                    GraphicalLogHandler.this.loggerMap.put(key, Color.ORANGE);
                    GraphicalLogHandler.this.legend.add(Legend.getIcon((Color)GraphicalLogHandler.this.loggerMap.get(key)), String.valueOf(key));
                    GraphicalLogHandler.this.legend.repaint();
                }
                g.setColor(color);
                int height = record.getLevel().intValue() / 100;
                g.fillRect(ix - 2, iy - height - 2 * collisionCount, 5, height);
                objectLocator.addObject((Shape)new Rectangle(ix - 2, iy - height - 2 * collisionCount, 5, height), (Object)record);
            }
            GraphicalLogHandler.this.setObjectLocator(objectLocator);
        }
    }
}

