/*
 * Decompiled with CFR 0.152.
 */
package test.graph;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;

public class GeneralPathSpeedTest
extends JPanel {
    int n = 1200000;
    int jj = 100;
    GeneralPath gp;
    double[] data;
    double dmin;
    double dmax;
    int resetCount;
    int rc = this.resetCount = 10;

    private void updateData() {
        this.data = new double[this.n];
        this.dmin = Double.POSITIVE_INFINITY;
        this.dmax = Double.NEGATIVE_INFINITY;
        double d = 0.0;
        for (int i = 0; i < this.n; ++i) {
            d = (Math.random() - 0.5) * 5.0 + d;
            if (d > this.dmax) {
                this.dmax = d;
            }
            if (d < this.dmin) {
                this.dmin = d;
            }
            this.data[i] = d;
        }
    }

    private void updatePath() {
        long t0 = System.currentTimeMillis();
        this.updateData();
        System.err.println("Time to updateData: " + (System.currentTimeMillis() - t0));
        t0 = System.currentTimeMillis();
        this.gp = new GeneralPath(0, this.n * 110 / 100);
        this.gp.moveTo(0.0, 480.0 * (this.data[0] - this.dmin) / (this.dmax - this.dmin));
        for (int i = 0; i < this.n; ++i) {
            this.gp.lineTo((double)i * 640.0 / (double)this.n, 480.0 * (this.data[i] - this.dmin) / (this.dmax - this.dmin));
        }
        System.err.println("Time to updatePath: " + (System.currentTimeMillis() - t0));
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(640, 480);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(640, 480);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g.clearRect(0, 0, 640, 480);
        long t0 = System.currentTimeMillis();
        g2.draw(this.gp);
        System.err.println(System.currentTimeMillis() - t0);
        Timer t = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralPathSpeedTest.this.repaint();
            }
        });
        t.setRepeats(false);
        t.restart();
        if (--this.rc == 0) {
            this.updatePath();
            this.rc = this.resetCount;
        }
    }

    public static void main(String[] ss) {
        GeneralPathSpeedTest gpst = new GeneralPathSpeedTest();
        long t0 = System.currentTimeMillis();
        gpst.updatePath();
        System.err.println("Time to updatePath: " + (System.currentTimeMillis() - t0));
        JOptionPane.showMessageDialog(null, gpst);
    }
}

