/*
 * Decompiled with CFR 0.152.
 */
package test.graph;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.GraphUtil;
import org.das2.graph.SpectrogramRenderer;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.QDataSet;

public class SpectrumTest {
    private static final int T0 = 381888000;
    private static final int DELTAT = 300;
    private static final Units TIME_UNITS = Units.t2000;
    private static final int SPECHEIGHT = 3;
    private static final Double[] a = new Double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0};
    private static final int E0 = 100;
    private static final int DELTAE = 10;
    private static final Units E_UNITS = Units.eV;
    private static final Units Z_UNITS = Units.hertz;
    private static List<Double[]> m = new ArrayList<Double[]>();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MySpectrogramData qd = new MySpectrogramData();
                JFrame top = new JFrame("Spectrogram Test");
                DasCanvas canvas = new DasCanvas(400, 400);
                DasRow row = new DasRow(canvas, 0.1, 0.9);
                DasColumn column = DasColumn.create(canvas, null, "7em", "100%-10em");
                DasPlot plot = SpectrumTest.makePlot((QDataSet)qd);
                canvas.add(plot, row, column);
                top.add(canvas);
                top.setDefaultCloseOperation(3);
                top.validate();
                top.pack();
                top.setVisible(true);
            }
        });
    }

    private static DasPlot makePlot(QDataSet qds) {
        DasAxis xaxis = new DasAxis(new DatumRange(3.81888E8, (double)(381888000 + a.length * 300), (Units)Units.t2000), 2);
        xaxis.setLabel("Time");
        DasAxis yaxis = new DasAxis(new DatumRange(100.0, 130.0, Units.eV), 3);
        yaxis.setLabel("E");
        DasPlot plot = new DasPlot(xaxis, yaxis);
        DasAxis zaxis = GraphUtil.guessZAxis(qds);
        DasColorBar colorBar = new DasColorBar(zaxis.getDataMinimum(), zaxis.getDataMaximum(), false);
        colorBar.setLabel("Color");
        SpectrogramRenderer r = new SpectrogramRenderer(null, colorBar);
        r.setRebinner(SpectrogramRenderer.RebinnerEnum.binAverage);
        r.setDataSet(qds);
        plot.addRenderer(r);
        return plot;
    }

    static {
        for (int irow = 0; irow < 3; ++irow) {
            Double[] temp = new Double[a.length];
            for (int icol = 0; icol < a.length; ++icol) {
                temp[icol] = a[icol] * (double)irow;
            }
            m.add(temp);
        }
    }

    public static class MySpectrogramData
    extends AbstractDataSet {
        public MySpectrogramData() {
            MyTimestamps timestamps = new MyTimestamps();
            this.putProperty("DEPEND_0", (Object)timestamps);
            this.putProperty("UNITS", Z_UNITS);
            this.putProperty("LABEL", "Spectrum");
            double[] ecenters = new double[3];
            for (int i = 0; i < ecenters.length; ++i) {
                ecenters[i] = 100 + i * 10;
            }
            DDataSet dcenters = DDataSet.wrap((double[])ecenters, (Units)E_UNITS);
            this.putProperty("DEPEND_1", dcenters);
        }

        public int rank() {
            return 2;
        }

        public int length() {
            return a.length;
        }

        public int length(int spectrogramComponentIndex) {
            return 3;
        }

        public double value(int i, int spectrogramComponentIndex) {
            return ((Double[])m.get(spectrogramComponentIndex))[i];
        }

        private static class MyTimestamps
        extends AbstractDataSet {
            private MyTimestamps() {
                this.putProperty("UNITS", TIME_UNITS);
                this.putProperty("LABEL", "Time");
                this.putProperty("MONOTONIC", true);
            }

            public int rank() {
                return 1;
            }

            public int length() {
                return a.length;
            }

            public double value(int i) {
                return 381888000 + i * 300;
            }
        }
    }
}

