/*
 * Decompiled with CFR 0.152.
 */
package test.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasPlot;
import org.das2.graph.GraphUtil;

public class TimeAxisDemo {
    JPanel contentPane;
    protected DasPlot plot;

    private synchronized JPanel getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
        }
        return this.contentPane;
    }

    public JFrame showFrame() {
        JFrame frame = new JFrame("Time Axis Demo");
        frame.getContentPane().add(this.getContentPane());
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        return frame;
    }

    public TimeAxisDemo() {
        try {
            int width = 500;
            int height = 100;
            this.getContentPane().setLayout(new BorderLayout());
            DasCanvas canvas = new DasCanvas(width, height);
            this.getContentPane().add((Component)canvas, "Center");
            DatumRange xrange = DatumRangeUtil.parseTimeRange((String)"2023-08-01/P1M");
            DatumRange yrange = DatumRange.newDatumRange((double)0.1, (double)100.0, (Units)Units.dimensionless);
            this.plot = GraphUtil.newDasPlot(canvas, xrange, yrange);
            this.plot.getXAxis().setUseDomainDivider(true);
            this.plot.getYAxis().setUseDomainDivider(true);
        }
        catch (ParseException ex) {
            Logger.getLogger(TimeAxisDemo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        new TimeAxisDemo().showFrame();
    }
}

