/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.aggregator;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.aggregator.AggregatingDataSource;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.DefaultTimeSeriesBrowse;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.fsm.FileStorageModel;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.LocalFileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class AggregatingDataSourceFactory
implements DataSourceFactory {
    public static final String PROB_NO_TIMERANGE_PROVIDED = "no timerange provided";
    public static final String PROB_PARSE_ERROR_IN_TIMERANGE = "parse error in timeRange";
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.agg");
    private DataSourceFactory delegateFactory = null;

    public static String getRepresentativeFile(URI uri, ProgressMonitor monitor) throws IOException {
        String ff;
        String surl = DataSetURI.fromUri(uri);
        FileStorageModel fsm = AggregatingDataSourceFactory.getFileStorageModel(surl);
        URISplit split = URISplit.parse(surl);
        LinkedHashMap<String, String> parms = URISplit.parseParams(split.params);
        DatumRange rangeConstraint = null;
        String stimeRange = (String)parms.get("timerange");
        if (stimeRange != null) {
            try {
                rangeConstraint = DatumRangeUtil.parseTimeRange((String)stimeRange);
            }
            catch (ParseException ex) {
                logger.log(Level.INFO, "unable to used timerange, can''t parse: {0}", stimeRange);
            }
        }
        if ((ff = fsm.getRepresentativeFile(monitor, null, rangeConstraint)) == null) {
            return null;
        }
        int i = AggregatingDataSourceFactory.splitIndex(surl);
        return surl.substring(0, i) + ff;
    }

    @Override
    public DataSource getDataSource(URI uri) throws Exception {
        String suri = DataSetURI.fromUri(uri);
        if (suri.contains("&timerange") && !suri.contains("?")) {
            throw new IllegalArgumentException("data URI contains &timerange but no question mark.");
        }
        if (this.delegateFactory == null) {
            this.delegateFactory = AggregatingDataSourceFactory.getDelegateDataSourceFactory(suri);
        }
        if (this.delegateFactory == null) {
            throw new IllegalArgumentException("Unable to identify data source for " + suri);
        }
        AggregatingDataSource ads = new AggregatingDataSource(uri, this.delegateFactory);
        String surl = DataSetURI.fromUri(uri);
        FileStorageModel fsm = AggregatingDataSourceFactory.getFileStorageModel(surl);
        ads.setFsm(fsm);
        URISplit split = URISplit.parse(surl);
        LinkedHashMap<String, String> parms = URISplit.parseParams(split.params);
        String stimeRange = (String)parms.get("timerange");
        if (stimeRange != null) {
            stimeRange = stimeRange.replaceAll("\\+", " ");
            ads.setViewRange(DatumRangeUtil.parseTimeRange((String)stimeRange));
            parms.remove("timerange");
        }
        if (parms.size() > 0) {
            ads.setParams(URISplit.formatParams(parms));
        }
        return ads;
    }

    public static int splitIndex(String surl) {
        surl = surl.replaceAll("\\*", "\\$x");
        return FileStorageModel.splitIndex((String)surl);
    }

    public static FileStorageModel getFileStorageModel(String suri) throws IOException {
        suri = suri.replaceAll("\\*", "\\$x");
        URISplit split = URISplit.parse(suri);
        String surl = split.surl;
        int i = surl.indexOf(63);
        String sansArgs = i == -1 ? surl : surl.substring(0, i);
        i = AggregatingDataSourceFactory.splitIndex(sansArgs);
        if (i == -1) {
            i = sansArgs.lastIndexOf("/");
        }
        FileSystem fs = FileSystem.create((URI)DataSetURI.toUri(sansArgs.substring(0, i)));
        if (sansArgs.charAt(i) == '/') {
            ++i;
        }
        String spec = sansArgs.substring(i).replaceAll("\\%", "\\$");
        FileStorageModel fsm = FileStorageModel.create((FileSystem)fs, (String)spec);
        return fsm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRepresentativeFile(FileStorageModel fsm, String surl, ProgressMonitor mon) throws IOException {
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        try {
            String delegateFile;
            URISplit split = URISplit.parse(surl);
            LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
            String stimeRange = (String)params.get("timerange");
            if (stimeRange != null) {
                String[] names;
                DatumRange tdr = null;
                try {
                    tdr = DatumRangeUtil.parseTimeRange((String)stimeRange);
                }
                catch (ParseException ex) {
                    logger.finer("unable to parse timerange, just use default delegate");
                }
                delegateFile = tdr != null ? ((names = fsm.getBestNamesFor(tdr, mon.getSubtaskMonitor("get best names"))).length > 0 ? names[0] : fsm.getRepresentativeFile(mon.getSubtaskMonitor("get delegate"))) : fsm.getRepresentativeFile(mon.getSubtaskMonitor("get delegate"));
            } else {
                delegateFile = fsm.getRepresentativeFile(mon.getSubtaskMonitor("get delegate"));
            }
            String string = delegateFile;
            return string;
        }
        finally {
            mon.finished();
        }
    }

    private static CompletionContext getDelegateDataSourceCompletionContext(CompletionContext cc) throws IOException {
        String surl = cc.surl;
        int carotPos = cc.surlpos;
        int urlLen = 0;
        FileStorageModel fsm = AggregatingDataSourceFactory.getFileStorageModel(surl = surl.replaceAll("%25", "%"));
        String delegateFile = AggregatingDataSourceFactory.getRepresentativeFile(fsm, surl, null);
        if (delegateFile == null) {
            throw new FileNotFoundException("unable to find any files matching\n" + surl);
        }
        URISplit split = URISplit.parse(surl);
        String encodedDelegateFile = delegateFile.replaceAll(":", "%3A");
        String delegateFfile = fsm.getFileSystem() instanceof LocalFileSystem ? new File(((LocalFileSystem)fsm.getFileSystem()).getLocalRoot(), URISplit.uriEncode(encodedDelegateFile)).toString() : fsm.getFileSystem().getRootURI().resolve(URISplit.uriEncode(encodedDelegateFile)).toString();
        carotPos -= (urlLen += split.file.length()) - delegateFfile.length();
        split.file = delegateFfile;
        int i = surl.lastIndexOf("timerange=", cc.surlpos);
        if (i != -1) {
            int i1 = surl.indexOf(38, i);
            carotPos -= i1 - i;
        }
        LinkedHashMap<String, String> parms = URISplit.parseParams(split.params);
        parms.remove("timerange");
        split.params = URISplit.formatParams(parms);
        String delegateUrl = URISplit.format(split);
        CompletionContext delegatecc = new CompletionContext();
        delegatecc.surl = delegateUrl;
        delegatecc.surlpos = carotPos;
        delegatecc.context = cc.context;
        String decodedDelegateFile = delegateFfile.replaceAll("%3A", ":");
        delegatecc.resourceURI = DataSetURI.toUri(decodedDelegateFile);
        return delegatecc;
    }

    public static String getDelegateDataSourceFactoryUri(String suri, ProgressMonitor mon) throws IOException, IllegalArgumentException {
        URISplit split = URISplit.parse(suri);
        LinkedHashMap<String, String> parms = URISplit.parseParams(split.params);
        String timeRange = (String)parms.remove("timerange");
        if (timeRange != null) {
            timeRange = timeRange.replaceAll("\\+", " ");
        }
        parms.remove("reduce");
        split.params = URISplit.formatParams(parms);
        FileStorageModel fsm = AggregatingDataSourceFactory.getFileStorageModel(DataSetURI.fromUri(split.resourceUri));
        String file = null;
        if (timeRange != null && !timeRange.equals("")) {
            try {
                DatumRange timeRangeDatum = DatumRangeUtil.parseTimeRange((String)timeRange);
                String[] names = fsm.getBestNamesFor(timeRangeDatum, (ProgressMonitor)new NullProgressMonitor());
                FileSystem fs = fsm.getFileSystem();
                for (String name : names) {
                    if (fs.getFileObject(name).getSize() <= 0L) continue;
                    file = name;
                    break;
                }
                if (file == null && names.length > 0) {
                    file = names[0];
                }
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        if (file == null) {
            file = AggregatingDataSourceFactory.getRepresentativeFile(fsm, suri, mon);
        }
        if (file == null) {
            throw new IllegalArgumentException("unable to find any files in " + fsm);
        }
        split.resourceUri = fsm.getFileSystem() instanceof LocalFileSystem ? fsm.getFileSystem().getFileObject(file).getFile().toURI() : fsm.getFileSystem().getRootURI().resolve(file.replaceAll(":", "%3A"));
        String scompUrl = DataSetURI.fromUri(split.resourceUri);
        if (split.params.length() > 0) {
            scompUrl = scompUrl + "?" + split.params;
        }
        split.file = DataSetURI.fromUri(split.resourceUri);
        split.surl = scompUrl;
        return URISplit.format(split);
    }

    public static DataSourceFactory getDelegateDataSourceFactory(String surl) throws IOException, IllegalArgumentException, URISyntaxException {
        String delegateSurl = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri(surl, (ProgressMonitor)new NullProgressMonitor());
        URISplit split = URISplit.parse(surl);
        URISplit delegateSplit = URISplit.parse(delegateSurl);
        delegateSplit.vapScheme = split.vapScheme;
        URI uri = DataSetURI.toUri(URISplit.format(delegateSplit));
        return DataSetURI.getDataSourceFactory(uri, (ProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        if (this.delegateFactory == null) {
            this.delegateFactory = AggregatingDataSourceFactory.getDelegateDataSourceFactory(cc.surl);
        }
        DataSourceFactory f = this.delegateFactory;
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        CompletionContext delegatecc = AggregatingDataSourceFactory.getDelegateDataSourceCompletionContext(cc);
        logger.log(Level.FINE, "got delegate cc: {0}", delegatecc);
        List<CompletionContext> delegateCompletions = f.getCompletions(delegatecc, mon);
        result.addAll(delegateCompletions);
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "timerange="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "avail="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "reduce="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "filenameProvidesContext="));
        } else if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String paramName = CompletionContext.get(CompletionContext.CONTEXT_PARAMETER_NAME, cc);
            if (paramName.equals("timerange")) {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<timerange>"));
            } else if (paramName.equals("avail")) {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "T"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "F"));
            } else if (paramName.equals("reduce")) {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "T"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "F"));
            } else if (paramName.equals("filenameProvidesContext")) {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "T"));
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "F"));
            }
        }
        return result;
    }

    protected static boolean hasTimeFields(String surl) {
        if (surl.contains("%Y") || surl.contains("%25Y")) {
            logger.warning("URIs should no longer contain percents (%s).");
            return true;
        }
        int ipercy = surl.lastIndexOf("%Y");
        if (ipercy == -1) {
            ipercy = surl.lastIndexOf("$Y");
        }
        if (ipercy == -1) {
            ipercy = surl.lastIndexOf("$y");
        }
        if (ipercy == -1) {
            ipercy = surl.lastIndexOf("$(o");
        }
        if (ipercy == -1) {
            ipercy = surl.lastIndexOf("$(periodic");
        }
        return ipercy != -1;
    }

    @Override
    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        URISplit split = URISplit.parse(surl);
        LinkedHashMap<String, String> map = URISplit.parseParams(split.params);
        try {
            if (AggregatingDataSourceFactory.hasTimeFields(surl) && DefaultTimeSeriesBrowse.reject(map, problems)) {
                return true;
            }
            String delegateSurl = AggregatingDataSourceFactory.getDelegateDataSourceFactoryUri(surl, mon);
            String avail = (String)map.get("avail");
            if (avail == null || !avail.equals("T")) {
                boolean delegateRejects;
                if (this.delegateFactory == null) {
                    this.delegateFactory = AggregatingDataSourceFactory.getDelegateDataSourceFactory(surl);
                    if (this.delegateFactory == null) {
                        return true;
                    }
                }
                if ((delegateRejects = this.delegateFactory.reject(delegateSurl, problems, mon)) && problems.size() == 1 && problems.get(0).equals(PROB_NO_TIMERANGE_PROVIDED)) {
                    delegateRejects = false;
                }
                return delegateRejects;
            }
            return false;
        }
        catch (IOException | URISyntaxException e) {
            problems.add(e.getMessage());
            logger.log(Level.SEVERE, surl, e);
            return false;
        }
        catch (IllegalArgumentException e) {
            problems.add(e.getMessage());
            logger.log(Level.SEVERE, surl, e);
            return true;
        }
    }

    public void setDelegateDataSourceFactory(DataSourceFactory delegateFactory) {
        this.delegateFactory = delegateFactory;
    }

    @Override
    public <T> T getCapability(Class<T> clazz) {
        if (clazz == TimeSeriesBrowse.class) {
            return (T)new DefaultTimeSeriesBrowse();
        }
        return null;
    }

    @Override
    public boolean supportsDiscovery() {
        return false;
    }

    @Override
    public boolean isFileResource() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Combination of Files From a Supported Data Source";
    }
}

