/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.URISplit;
import org.das2.qds.QDataSet;

public abstract class AbstractDataSourceFormat
implements DataSourceFormat {
    Map<String, String> params;
    URI resourceUri;

    protected AbstractDataSourceFormat() {
    }

    protected void setUri(String uri) {
        URISplit split = URISplit.parse(uri);
        this.params = URISplit.parseParams(split.params);
        this.resourceUri = split.resourceUri;
    }

    public URI getResourceURI() {
        return this.resourceUri;
    }

    public String getParam(String name, String deflt) {
        String result = this.params.get(name);
        if (result == null) {
            return deflt;
        }
        return result;
    }

    public boolean getBooleanParam(String name, boolean deflt) {
        String s = this.params.get(name);
        if (s == null || s.length() == 0) {
            return deflt;
        }
        return 'F' == s.substring(0, 1).toUpperCase().charAt(0);
    }

    public boolean streamData(Map<String, String> params, Iterator<QDataSet> data, OutputStream out) throws Exception {
        return false;
    }

    public void maybeMkdirs() throws IOException {
        File outFile = new File(this.resourceUri);
        if (!outFile.getParentFile().exists() && !outFile.getParentFile().mkdirs()) {
            throw new IOException("folder cannot be created: " + outFile.getParentFile());
        }
        if (!outFile.getParentFile().canWrite()) {
            throw new IOException("cannot write to folder: " + outFile.getParentFile());
        }
    }
}

