/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.Updating;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.LocalFileSystem;

public class FilePollUpdating
implements Updating {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.updating");
    URI pollURI;
    FileSystem fs;
    FileObject fo;
    long dirHash;
    long pollCyclePeriodSeconds;
    private static final int LIMIT_SHORT_CYCLE_PERIOD_SECONDS = 1;
    private static final int LIMIT_SHORT_REMOTE_CYCLE_PERIOD_SECONDS = 10;
    boolean dirty = false;
    private static Map<Thread, URI> myThreads = new HashMap<Thread, URI>();
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public FilePollUpdating(URI uri, long pollCyclePeriodSeconds) throws FileSystem.FileSystemOfflineException, UnknownHostException, FileNotFoundException {
        this.pollURI = uri;
        URISplit split = URISplit.parse(uri);
        this.fs = FileSystem.create((String)split.path);
        this.fo = this.fs.getFileObject(split.file.substring(split.path.length()));
        if (this.fs instanceof LocalFileSystem) {
            if (pollCyclePeriodSeconds < 1L) {
                logger.log(Level.FINE, "pollCyclePeriodSeconds too low, for local files it must be at least {0} seconds", 1);
                pollCyclePeriodSeconds = 1L;
            }
        } else if (pollCyclePeriodSeconds < 10L) {
            logger.log(Level.FINE, "pollCyclePeriodSeconds too low, for remote files it must be at least {0} seconds", 10);
            pollCyclePeriodSeconds = 10L;
        }
        this.pollCyclePeriodSeconds = pollCyclePeriodSeconds;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
        if (!this.pcs.hasListeners(null)) {
            this.stopPolling();
        }
    }

    private long dirHash() {
        Date lm = this.fo.lastModified();
        long sz = this.fo.getSize();
        long hash = (long)(1 + 17 * lm.hashCode()) + 31L * sz;
        return hash;
    }

    public void startPolling() throws FileSystem.FileSystemOfflineException {
        this.dirHash = this.dirHash();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                logger.log(Level.FINE, "start polling {0}", FilePollUpdating.this.pollURI);
                while (FilePollUpdating.this.dirHash != 0L) {
                    logger.log(Level.FINEST, "polling...");
                    try {
                        Thread.sleep(FilePollUpdating.this.pollCyclePeriodSeconds * 1000L);
                    }
                    catch (InterruptedException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    long dirHash1 = FilePollUpdating.this.dirHash();
                    if (FilePollUpdating.this.dirHash != 0L && dirHash1 != FilePollUpdating.this.dirHash) {
                        FilePollUpdating.this.dirty = true;
                        FilePollUpdating.this.dirHash = dirHash1;
                    }
                    if (!FilePollUpdating.this.dirty || FilePollUpdating.this.dirHash != dirHash1) continue;
                    FilePollUpdating.this.pcs.firePropertyChange("dataSet", null, null);
                    FilePollUpdating.this.dirty = false;
                }
                myThreads.remove(Thread.currentThread());
            }
        };
        if (myThreads.size() < 1000) {
            Thread t = new Thread(run, "FilePollUpdating");
            myThreads.put(t, this.pollURI);
            t.start();
        } else {
            logger.warning("thread limit reached, FillPollUpdating fails.");
        }
    }

    public void stopPolling() {
        logger.log(Level.FINE, "stop polling {0}", this.pollURI);
        this.dirHash = 0L;
    }

    public static void main(String[] args) throws Exception {
        URI uri = URI.create("http://www-pw.physics.uiowa.edu/~jbf/autoplot/users/mark/filePollUpdate/foo.cdf");
        FilePollUpdating a = new FilePollUpdating(uri, 1L);
        a.startPolling();
        a.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                logger.log(Level.WARNING, "{0}  {1}", new Object[]{evt.getNewValue(), Thread.currentThread().getName()});
            }
        });
        Thread.sleep(6000L);
        a.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                logger.log(Level.WARNING, "{0}  {1}  *** ", new Object[]{evt.getNewValue(), Thread.currentThread().getName()});
            }
        });
    }
}

