/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.datasource.ui;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSourceFactory;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class ParamsTextArea
extends JTextArea {
    private static final Logger logger = org.das2.datum.LoggerManager.getLogger((String)"apdss.gui");
    DataSourceFactory dsf = null;
    List<String> excludeParams = new ArrayList<String>();
    JPopupMenu popup;

    public ParamsTextArea() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ParamsTextArea.this.showPopup(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ParamsTextArea.this.showPopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    ParamsTextArea.this.showPopup(e);
                }
            }
        });
    }

    public void showPopup(MouseEvent e) {
        int pos = this.viewToModel(e.getPoint());
        this.setCaretPosition(pos);
        this.showPopup(e.getX(), e.getY());
    }

    public void showPopup(int x, int y) {
        try {
            final int pos = this.getCaretPosition();
            int row = this.getLineOfOffset(pos);
            int linePos = this.getLineStartOffset(row);
            int col = pos - linePos;
            String line = this.getText(linePos, col);
            this.popup = new JPopupMenu();
            CompletionContext cc = new CompletionContext();
            if (line.trim().endsWith("=")) {
                cc.context = CompletionContext.CONTEXT_PARAMETER_VALUE;
                cc.surl = cc.completable = "?" + line;
                cc.completablepos = cc.completable.length();
            } else {
                cc.context = CompletionContext.CONTEXT_PARAMETER_NAME;
                cc.completable = "?" + line;
            }
            List<CompletionContext> ccs = this.dsf.getCompletions(cc, (ProgressMonitor)new NullProgressMonitor());
            for (int i = 0; i < ccs.size(); ++i) {
                final CompletionContext acc = ccs.get(i);
                JMenuItem mi = new JMenuItem(new AbstractAction(acc.label){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent((ActionEvent)e);
                        ParamsTextArea.this.insert(acc.completable, pos);
                    }
                });
                mi.setToolTipText(acc.doc);
                this.popup.add(mi);
            }
            this.popup.show(this, x, y);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public Map<String, String> getParams() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String readerParams = this.getText();
        String[] ss = readerParams.split("\n");
        for (int i = 0; i < ss.length; ++i) {
            String s = ss[i].trim();
            if (s.length() == 0) continue;
            String[] ss2 = s.split("=", -2);
            if (ss2.length == 1) {
                map.put(ss2[0], "");
                continue;
            }
            map.put(ss2[0], ss2[1]);
        }
        return map;
    }

    public void setParams(Map<String, String> params) {
        StringBuilder paramsStr = new StringBuilder();
        for (Map.Entry<String, String> e : params.entrySet()) {
            paramsStr.append(e.getKey()).append("=").append(e.getValue()).append("\n");
        }
        this.setText(paramsStr.toString());
    }

    public void setFactory(DataSourceFactory factory, List<String> excludeParams) {
        this.dsf = factory;
    }
}

