/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.metatree;

import java.lang.reflect.Array;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.MetadataModel;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.LatexToGranny;

public class IstpMetadataModel
extends MetadataModel {
    private static Logger logger = Logger.getLogger("apdss");
    public static final String USER_PROP_VIRTUAL_FUNCTION = "FUNCTION";
    public static final String USER_PROP_VIRTUAL_COMPONENT_ = "COMPONENT_";
    public static final Object VALUE_MIN = "MIN";
    public static final Object VALUE_MAX = "MAX";

    private static double doubleValue(Object o, Units units, Object minmax) {
        return IstpMetadataModel.doubleValue(o, units, Double.NaN, minmax);
    }

    public static double doubleValue(Object o, Units units, double deflt, Object minmax) {
        if (o == null) {
            return deflt;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            String s = (String)o;
            if (s.startsWith("CDF_PARSE_EPOCH(")) {
                try {
                    return units.parse(s.substring(16, s.length() - 1)).doubleValue(units);
                }
                catch (ParseException ex) {
                    logger.log(Level.FINE, "unable to parse {0}", o);
                    return deflt;
                }
            }
            try {
                return units.parse(DataSourceUtil.unquote((String)o)).doubleValue(units);
            }
            catch (ParseException ex) {
                try {
                    return Double.parseDouble((String)o);
                }
                catch (NumberFormatException ex2) {
                    logger.log(Level.FINE, "unable to parse {0}", o);
                    return deflt;
                }
            }
        }
        Class<?> c = o.getClass();
        if (c.isArray()) {
            if (units == Units.cdfEpoch && Array.getLength(o) == 2) {
                double cdfEpoch = Array.getDouble(o, 0) * 1000.0 + Array.getDouble(o, 1) / 1.0E9;
                Units.cdfEpoch.createDatum(cdfEpoch);
                return cdfEpoch;
            }
            double v = Array.getDouble(o, 0);
            int n = Array.getLength(o);
            for (int i = 1; i < n; ++i) {
                if (minmax == VALUE_MAX) {
                    v = Math.max(v, Array.getDouble(o, i));
                    continue;
                }
                if (minmax == VALUE_MIN) {
                    v = Math.min(v, Array.getDouble(o, i));
                    continue;
                }
                throw new IllegalArgumentException("object is array: " + o + ", and minmax is not set");
            }
            return v;
        }
        throw new RuntimeException("Unsupported Data Type: " + o.getClass().getName());
    }

    private static Number[] getValidRangeDs(Map attrs, Units units) {
        Number min = (Number)attrs.get("VALIDMIN");
        Number max = (Number)attrs.get("VALIDMAX");
        if (UnitsUtil.isTimeLocation((Units)units)) {
            DatumRange vrange = new DatumRange(3.15569952E13, 2.840126112E14, (Units)Units.cdfEpoch);
            if (vrange.min().doubleValue(units) > min.doubleValue()) {
                min = vrange.min().doubleValue(units);
            }
            if (vrange.max().doubleValue(units) < max.doubleValue()) {
                max = vrange.max().doubleValue(units);
            }
            if (vrange.min().doubleValue(units) > max.doubleValue()) {
                max = vrange.max().doubleValue(units);
            }
        }
        if (UnitsUtil.isNominalMeasurement((Units)units)) {
            logger.fine("valid range not used for ordinal units");
            return null;
        }
        return new Number[]{min, max};
    }

    public static DatumRange getValidRange(Map attrs, Units units) {
        double max = IstpMetadataModel.doubleValue(attrs.get("VALIDMAX"), units, Double.MAX_VALUE, VALUE_MAX);
        double min = IstpMetadataModel.doubleValue(attrs.get("VALIDMIN"), units, -1.0E29, VALUE_MIN);
        if (units.isFill(min)) {
            min /= 100.0;
        }
        if (UnitsUtil.isTimeLocation((Units)units)) {
            DatumRange vrange = new DatumRange(3.15569952E13, 2.840126112E14, (Units)Units.cdfEpoch);
            if (vrange.min().doubleValue(units) > min) {
                min = vrange.min().doubleValue(units);
            }
            if (vrange.max().doubleValue(units) < max) {
                max = vrange.max().doubleValue(units);
            }
            if (vrange.min().doubleValue(units) > max) {
                max = vrange.max().doubleValue(units);
            }
        }
        if (UnitsUtil.isNominalMeasurement((Units)units)) {
            logger.fine("valid range not used for ordinal units");
            return null;
        }
        if (min < max) {
            return DatumRange.newDatumRange((double)min, (double)max, (Units)units);
        }
        String n = (String)attrs.get("NAME");
        if (n != null) {
            logger.log(Level.WARNING, "VALIDMIN and VALIDMAX has min value greater than max value: {0} > {1} for {2}", new Object[]{min, max, n});
        } else {
            logger.log(Level.WARNING, "VALIDMIN and VALIDMAX has min value greater than max value: {0} > {1}", new Object[]{min, max});
        }
        return null;
    }

    private static DatumRange getRange(Map attrs, Units units) {
        double min;
        double max;
        if (attrs.containsKey("SCALEMIN") && attrs.containsKey("SCALEMAX")) {
            max = IstpMetadataModel.doubleValue(attrs.get("SCALEMAX"), units, VALUE_MAX);
            min = IstpMetadataModel.doubleValue(attrs.get("SCALEMIN"), units, VALUE_MIN);
        } else if (attrs.containsKey("SCALEMAX")) {
            max = IstpMetadataModel.doubleValue(attrs.get("SCALEMAX"), units, VALUE_MAX);
            min = 0.0;
        } else if (attrs.containsKey("SCALEMIN") && "log".equalsIgnoreCase((String)attrs.get("SCALETYP"))) {
            min = IstpMetadataModel.doubleValue(attrs.get("SCALEMIN"), units, VALUE_MIN);
            if (min <= 0.0) {
                return null;
            }
            double possibleMax = IstpMetadataModel.doubleValue(attrs.get("VALIDMAX"), units, VALUE_MAX);
            max = possibleMax / min > 10.0 && possibleMax / min < 1000.0 ? possibleMax : min * 1000.0;
        } else {
            logger.finer("SCALEMIN and SCALEMAX are missing");
            return null;
        }
        if (UnitsUtil.isRatioMeasurement((Units)units) && units.isFill(min)) {
            min /= 100.0;
        }
        if (max < min) {
            max = Double.MAX_VALUE;
        }
        if (UnitsUtil.isTimeLocation((Units)units)) {
            DatumRange vrange = new DatumRange(3.15569952E13, 2.840126112E14, (Units)Units.cdfEpoch);
            if (vrange.min().doubleValue(units) > min) {
                min = vrange.min().doubleValue(units);
            }
            if (vrange.max().doubleValue(units) < max) {
                max = vrange.max().doubleValue(units);
            }
            if (vrange.min().doubleValue(units) > max) {
                max = vrange.max().doubleValue(units);
            }
        }
        if (UnitsUtil.isNominalMeasurement((Units)units)) {
            logger.fine("range not used for ordinal units");
            return null;
        }
        if (min < max) {
            return DatumRange.newDatumRange((double)min, (double)max, (Units)units);
        }
        if (Double.isFinite(min) && Double.isFinite(max)) {
            logger.log(Level.WARNING, "SCALEMIN and SCALEMAX has min value greater than max value: {0} > {1}", new Object[]{min, max});
        } else {
            logger.log(Level.FINE, "SCALEMIN and SCALEMAX are NaN and NaN");
        }
        return null;
    }

    private static String getScaleType(Map attrs) {
        String type = null;
        if (attrs.containsKey("SCALETYP") && attrs.get("SCALETYP") instanceof String) {
            type = String.valueOf(attrs.get("SCALETYP")).toLowerCase();
        }
        return type;
    }

    @Override
    public Map<String, Object> properties(Map<String, Object> meta) {
        return this.properties(meta, true);
    }

    private Map<String, Object> properties(Map<String, Object> meta, boolean doRecurse) {
        boolean isEpoch;
        Object olablaxis;
        Object ofv;
        double dv;
        int i;
        double d;
        String siConversion;
        int i2;
        Map attrs;
        if (meta == null) {
            logger.fine("null attributes, not expected to be seen");
            attrs = Collections.emptyMap();
        } else {
            attrs = new HashMap<String, Object>(meta);
        }
        String name = String.valueOf(attrs.get("FIELDNAM"));
        LinkedHashMap<String, String> user = new LinkedHashMap<String, String>();
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        String title = "";
        String s = (String)attrs.get("Source_name");
        if (s != null && (i2 = s.indexOf(62)) > -1) {
            title = title + s.substring(0, i2).trim();
        }
        if ((s = (String)attrs.get("Descriptor")) != null && (i2 = s.indexOf(62)) > -1) {
            if (title.length() > 0) {
                title = title + "/";
            }
            title = title + s.substring(0, i2).trim();
        }
        if (title.trim().length() > 0) {
            title = title + "  ";
        }
        if ((s = (String)attrs.get("CATDESC")) != null) {
            if (LatexToGranny.isLatex((String)s)) {
                s = LatexToGranny.latexToGranny((String)s);
            }
            title = title + s.trim();
        }
        if (title.trim().length() > 0) {
            properties.put("TITLE", title.trim());
        }
        if ((s = (String)attrs.get("VAR_NOTES")) != null) {
            properties.put("DESCRIPTION", s);
        }
        if (attrs.containsKey("DISPLAY_TYPE")) {
            String stype;
            String type = (String)attrs.get("DISPLAY_TYPE");
            int i3 = type.indexOf(62);
            String string = stype = i3 == -1 ? type : type.substring(0, i3);
            if (!stype.equals(stype.toLowerCase())) {
                logger.log(Level.FINE, "DISPLAY_TYPE should be lower case ({0})", type);
            }
            if (stype.equalsIgnoreCase("spectrogram")) {
                type = "spectrogram";
            } else if (stype.equalsIgnoreCase("time_series") || type.equalsIgnoreCase("stack_plot")) {
                type = "time_series";
            }
            properties.put("RENDER_TYPE", type);
        }
        if (attrs.containsKey("VIRTUAL")) {
            String v = (String)attrs.get("VIRTUAL");
            String function = (String)attrs.get(USER_PROP_VIRTUAL_FUNCTION);
            user.put(USER_PROP_VIRTUAL_FUNCTION, function);
            for (int i4 = 0; i4 < 4 && attrs.get(USER_PROP_VIRTUAL_COMPONENT_ + i4) != null; ++i4) {
                user.put(USER_PROP_VIRTUAL_COMPONENT_ + i4, (String)attrs.get(USER_PROP_VIRTUAL_COMPONENT_ + i4));
            }
        }
        Units units = null;
        String sunits = "";
        if (attrs.containsKey("UNITS")) {
            sunits = String.valueOf(attrs.get("UNITS"));
            if (LatexToGranny.isLatex((String)sunits)) {
                sunits = LatexToGranny.latexToGranny((String)sunits);
            }
        } else {
            logger.log(Level.FINE, "UNITS are missing for {0}", name);
        }
        if (sunits.equals("") && attrs.containsKey("UNIT_PTR_VALUE")) {
            QDataSet ss = (QDataSet)attrs.get("UNIT_PTR_VALUE");
            if (ss.rank() == 1) {
                double s0 = ss.value(0);
                boolean canUse = true;
                for (int i5 = 1; i5 < ss.length(); ++i5) {
                    double s1 = ss.value(1);
                    if (s1 == s0) continue;
                    logger.fine("unable to use units because of implementation");
                    canUse = false;
                }
                if (canUse) {
                    Units eu = SemanticOps.getUnits((QDataSet)ss);
                    sunits = eu.createDatum(s0).toString();
                }
            } else {
                logger.fine("unable to use units because of rank");
            }
        }
        if (LatexToGranny.isLatex((String)(sunits = sunits.trim()))) {
            sunits = LatexToGranny.latexToGranny((String)sunits);
        }
        if ((siConversion = (String)attrs.get("SI_conversion")) != null && siConversion.endsWith("seconds") && (d = Double.parseDouble(siConversion.substring(0, i = siConversion.indexOf(">")))) == 1.0E-9) {
            units = Units.cdfTT2000;
            sunits = units.toString();
        }
        if (units == null) {
            try {
                units = Units.lookupUnits((String)DataSourceUtil.unquote(sunits));
            }
            catch (IllegalArgumentException e) {
                units = Units.dimensionless;
            }
        }
        boolean isMillis = false;
        Object ovalidMax = attrs.get("VALIDMAX");
        Object ovalidMin = attrs.get("VALIDMIN");
        if (ovalidMax != null && ovalidMin != null && ovalidMax instanceof Number && ovalidMin instanceof Number && units == Units.milliseconds) {
            double validMax = ((Number)ovalidMax).doubleValue();
            double validMin = ((Number)ovalidMin).doubleValue();
            boolean bl = isMillis = validMin < validMax && validMin < 1.0E8 && validMax < 1.0E12;
        }
        if (!Double.isNaN(dv = IstpMetadataModel.doubleValue(ofv = attrs.get("FILLVAL"), units, Double.NaN, VALUE_MIN))) {
            properties.put("FILL_VALUE", dv);
        }
        if ((olablaxis = attrs.get("LABLAXIS")) != null && !(olablaxis instanceof String)) {
            logger.log(Level.WARNING, "LABLAXIS should be type String: {0}", olablaxis);
        }
        String label = olablaxis == null ? null : String.valueOf(attrs.get("LABLAXIS"));
        boolean bl = isEpoch = units == Units.milliseconds && !isMillis || "Epoch".equals(attrs.get("NAME")) || "Epoch".equalsIgnoreCase(DataSourceUtil.unquote(String.valueOf(attrs.get("LABLAXIS"))));
        if (isEpoch) {
            if (ofv != null && ofv instanceof Long) {
                units = Units.cdfTT2000;
                properties.put("FILL_VALUE", ofv);
            } else if (!UnitsUtil.isTimeLocation((Units)units)) {
                units = units == Units.nanoseconds || units == Units.ns ? Units.cdfTT2000 : Units.cdfEpoch;
            }
        } else {
            Object oslice2;
            String sslice2;
            String sslice1;
            Object oslice1 = attrs.get("slice1");
            if (oslice1 != null && !(oslice1 instanceof String)) {
                logger.warning("internal error, slice1 should be string");
            }
            if ((sslice1 = (String)oslice1) != null) {
                QDataSet lablDs;
                int islice = Integer.parseInt(sslice1);
                Object o = attrs.get("slice1_labels");
                if (!(o instanceof QDataSet)) {
                    if (o != null) {
                        logger.log(Level.WARNING, "slice1_labels property of {0} should be a QDataSet", name);
                    }
                } else if (attrs.get("DEPEND_2") == null && (lablDs = (QDataSet)attrs.get("slice1_labels")) != null) {
                    label = lablDs.slice(islice).svalue();
                }
            }
            if ((sslice2 = (String)(oslice2 = attrs.get("slice2"))) != null) {
                QDataSet lablDs;
                int islice = Integer.parseInt(sslice2);
                Object o = attrs.get("slice2_labels");
                if (!(o instanceof QDataSet)) {
                    if (o != null) {
                        logger.log(Level.WARNING, "slice2_labels property of {0} should be a QDataSet", name);
                    }
                } else if (attrs.get("DEPEND_3") == null && (lablDs = (QDataSet)attrs.get("slice2_labels")) != null) {
                    label = lablDs.slice(islice).svalue();
                }
            }
            if (label != null && LatexToGranny.isLatex((String)label)) {
                label = LatexToGranny.latexToGranny((String)label);
            }
            if (label == null) {
                label = sunits;
            } else if (!sunits.equals("")) {
                label = label.trim();
                label = label + " (%{UNITS})";
            }
            properties.put("LABEL", label);
        }
        properties.put("UNITS", units);
        if (UnitsUtil.isTimeLocation((Units)units) && !doRecurse && properties.containsKey("LABEL")) {
            properties.remove("LABEL");
            properties.remove("TITLE");
        }
        try {
            DatumRange range = IstpMetadataModel.getRange(attrs, units);
            if (!attrs.containsKey("COMPONENT_0")) {
                Number fillVal;
                if (range != null) {
                    properties.put("TYPICAL_MIN", range.min().doubleValue(units));
                }
                if (range != null) {
                    properties.put("TYPICAL_MAX", range.max().doubleValue(units));
                }
                if ((range = IstpMetadataModel.getValidRange(attrs, units)) != null) {
                    properties.put("VALID_MIN", range.min().doubleValue(units));
                    properties.put("VALID_MAX", range.max().doubleValue(units));
                }
                if (ofv != null && ofv instanceof Number) {
                    fillVal = (Number)ofv;
                    double fillVald = fillVal.doubleValue();
                    if (range != null && fillVald >= range.min().doubleValue(units) && fillVald <= range.max().doubleValue(units)) {
                        properties.put("FILL_VALUE", fillVal);
                    }
                } else if (ofv != null && ofv.getClass().isArray()) {
                    fillVal = (Number)Array.get(ofv, 0);
                    int n = Array.getLength(ofv);
                    for (int i6 = 1; i6 < n; ++i6) {
                        if (Array.get(ofv, i6).equals(fillVal)) continue;
                        fillVal = Double.NaN;
                    }
                    double fillVald = fillVal.doubleValue();
                    if (range != null && fillVald >= range.min().doubleValue(units) && fillVald <= range.max().doubleValue(units)) {
                        properties.put("FILL_VALUE", fillVal);
                    }
                }
            }
            properties.put("SCALE_TYPE", IstpMetadataModel.getScaleType(attrs));
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        if (doRecurse) {
            for (int i7 = 0; i7 < 4; ++i7) {
                String key = "DEPEND_" + i7;
                Object o = attrs.get(key);
                if (o == null || !(o instanceof Map)) continue;
                Map props = (Map)o;
                for (int j = 0; j < 4; ++j) {
                    if (!props.containsKey("DEPEND_" + j)) continue;
                    props.remove("DEPEND_" + j);
                }
                properties.put(key, this.properties(props, false));
            }
        }
        if (!user.isEmpty()) {
            properties.put("USER_PROPERTIES", user);
        }
        return properties;
    }

    @Override
    public String getLabel() {
        return "ISTP-CDF";
    }

    public static MutablePropertyDataSet maybeReduceRank2(MutablePropertyDataSet depDs) {
        QDataSet wds = SemanticOps.weightsDataSet((QDataSet)depDs);
        int j = -1;
        int i0 = 0;
        ArrayDataSet resulta = ArrayDataSet.copy((QDataSet)depDs.slice(0));
        for (j = i0; j < wds.length(0); ++j) {
            ArrayDataSet test = ArrayDataSet.copy((QDataSet)DataSetOps.slice1((QDataSet)depDs, (int)j));
            test.putProperty("BIN_PLUS", null);
            test.putProperty("BIN_MINUS", null);
            test.putProperty("DELTA_PLUS", null);
            test.putProperty("DELTA_MINUS", null);
            QDataSet ex = Ops.extent((QDataSet)test);
            if (ex.value(0) != ex.value(1)) {
                return null;
            }
            resulta.putValue(j, ex.value(0));
        }
        return resulta;
    }
}

