/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.wgetfs;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.wgetfs.WGetFileSystemFactory;
import org.autoplot.wgetfs.WGetWebProtocol;
import org.das2.datum.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.HtmlUtil;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.ProgressMonitor;

public class WGetFileSystem
extends WebFileSystem {
    private static final Logger logger = LoggerManager.getLogger((String)"das2.filesystem.wget");

    public WGetFileSystem(URI root, File localRoot) {
        super(root, localRoot);
        if (WGetFileSystemFactory.exe == null) {
            throw new IllegalArgumentException("This must be constructed with the factory.");
        }
        try {
            this.protocol = new WGetWebProtocol(root.toURL());
        }
        catch (MalformedURLException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public static WGetFileSystem createWGetFileSystem(URI root) {
        return new WGetFileSystem(root, WGetFileSystem.localRoot((URI)root));
    }

    private long interpretLong(String s) {
        if (s.endsWith("K")) {
            double mant = Long.parseLong(s.substring(0, s.length() - 1));
            return (long)(mant * 1000.0);
        }
        if (s.endsWith("k")) {
            double mant = Long.parseLong(s.substring(0, s.length() - 1));
            return (long)(mant * 1000.0);
        }
        if (s.endsWith("M")) {
            double mant = Double.parseDouble(s.substring(0, s.length() - 1));
            return (long)(mant * 1000000.0);
        }
        long mant = Long.parseLong(s);
        return mant;
    }

    private void interpretProgress(String line, String filename, ProgressMonitor monitor) {
        if (WGetFileSystemFactory.useCurl) {
            if (!monitor.isStarted()) {
                String[] ss = line.split("\\s+");
                if (ss.length == 13) {
                    try {
                        long l = this.interpretLong(ss[2]);
                        if (l > 0L && !ss[11].startsWith("--")) {
                            monitor.setTaskSize(l);
                            monitor.setProgressMessage("curl " + filename);
                            monitor.started();
                        }
                    }
                    catch (NumberFormatException l) {}
                }
            } else {
                String[] ss = line.split("\\s+");
                if (ss.length == 13) {
                    monitor.setTaskProgress(this.interpretLong(ss[4]));
                }
            }
        } else if (!monitor.isStarted()) {
            if (line.startsWith("Length:")) {
                int term = line.indexOf(32, 8);
                monitor.setTaskSize(this.interpretLong(line.substring(8, term)));
                monitor.setProgressMessage("wget " + filename);
                monitor.started();
            }
        } else {
            Pattern prog = Pattern.compile("\\s*(([0-9]+)([MK])?)");
            Matcher m = prog.matcher(line);
            if (m.find() && m.start() == 0 && monitor.isStarted()) {
                monitor.setTaskProgress(this.interpretLong(m.group(1)));
            }
        }
    }

    protected Map<String, String> downloadFile(String filename, File f, File partfile, ProgressMonitor monitor) throws IOException {
        String[] cmd = WGetFileSystemFactory.useCurl ? new String[]{WGetFileSystemFactory.exe, "-o", partfile.toString(), this.getRootURL().toString() + filename} : new String[]{WGetFileSystemFactory.exe, "-O", partfile.toString(), this.getRootURL().toString() + filename};
        logger.log(Level.FINE, "cmd: {0} {1} {2} {3}", new Object[]{cmd[0], cmd[1], cmd[2], cmd[3]});
        ProcessBuilder pb = new ProcessBuilder(Arrays.asList(cmd));
        Process p = pb.start();
        try (BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));){
            String line = err.readLine();
            while (line != null) {
                this.interpretProgress(line, filename, monitor);
                Thread.sleep(200L);
                line = err.readLine();
                if (!monitor.isCancelled()) continue;
                p.destroy();
                if (partfile.exists() && !partfile.delete()) {
                    logger.log(Level.WARNING, "unable to delete file: {0}", partfile);
                }
                throw new InterruptedException("user cancel");
            }
            p.waitFor();
            if (p.exitValue() != 0) {
                if (!partfile.delete()) {
                    logger.log(Level.WARNING, "unable to delete file: {0}", partfile);
                }
                throw new IOException(cmd[0] + " returned with exit code " + p.exitValue());
            }
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
        finally {
            monitor.finished();
        }
        if (!partfile.renameTo(f)) {
            logger.log(Level.WARNING, "unable to rename file {0} to {1}", new Object[]{partfile, f});
        }
        return Collections.EMPTY_MAP;
    }

    public boolean isDirectory(String filename) throws IOException {
        File f = new File(this.localRoot, filename);
        if (f.exists()) {
            return f.isDirectory();
        }
        if (filename.endsWith("/")) {
            return true;
        }
        File parentFile = f.getParentFile();
        String parent = this.getLocalName(parentFile);
        if (!parent.endsWith("/")) {
            parent = parent + "/";
        }
        String[] list = this.listDirectory(parent);
        String lookFor = filename.startsWith("/") ? filename.substring(1) + "/" : filename + "/";
        for (String list1 : list) {
            if (!list1.equals(lookFor)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] listDirectory(String directory) throws IOException {
        Map<String, FileSystem.DirectoryEntry> result;
        block48: {
            directory = WGetFileSystem.toCanonicalFolderName((String)directory);
            if (EventQueue.isDispatchThread()) {
                logger.warning("listDirectory called on event thread");
            }
            if (this.isListingCached(directory)) {
                logger.log(Level.FINE, "using cached listing for {0}", directory);
                File listing = this.listingFile(directory);
                URL[] list = null;
                try {
                    URL[] uRLArray = null;
                    try (FileInputStream fin = new FileInputStream(listing);){
                        list = HtmlUtil.getDirectoryListing((URL)this.getURL(directory), (InputStream)fin);
                    }
                    catch (Throwable object) {
                        uRLArray = object;
                        throw object;
                    }
                }
                catch (CancelledOperationException ex) {
                    throw new IllegalArgumentException(ex);
                }
                assert (list != null);
                Map<String, FileSystem.DirectoryEntry> result2 = new LinkedHashMap(list.length);
                int n = directory.length();
                for (URL url : list) {
                    FileSystem.DirectoryEntry de1 = new FileSystem.DirectoryEntry();
                    de1.modified = Long.MAX_VALUE;
                    de1.name = this.getLocalName(url).substring(n);
                    de1.type = (char)102;
                    de1.size = Long.MAX_VALUE;
                    result2.put(de1.name, de1);
                }
                result2 = this.addRoCacheEntries(directory, result2);
                this.cacheListing(directory, result2.values().toArray(new FileSystem.DirectoryEntry[result2.size()]));
                return FileSystem.getListing(result2);
            }
            if (this.isOffline()) {
                File f = new File(this.localRoot, directory);
                if (!f.exists()) {
                    throw new FileSystem.FileSystemOfflineException("unable to list " + f + " when offline");
                }
                String[] listing = f.list();
                return listing;
            }
            File listingFile = this.listingFile(directory);
            String[] cmd = WGetFileSystemFactory.useCurl ? new String[]{WGetFileSystemFactory.exe, "-o", listingFile.toString(), this.getRootURL().toString() + directory} : new String[]{WGetFileSystemFactory.exe, "-O", listingFile.toString(), this.getRootURL().toString() + directory};
            logger.log(Level.FINE, "cmd: {0} {1} {2} {3}", new Object[]{cmd[0], cmd[1], cmd[2], cmd[3]});
            ProcessBuilder pb = new ProcessBuilder(Arrays.asList(cmd));
            Process p = pb.start();
            try {
                p.waitFor();
                if (p.exitValue() != 0) {
                    if (!listingFile.delete()) {
                        logger.log(Level.WARNING, "unable to delete listing file: {0}", listingFile);
                    }
                    throw new IOException("wget returned with exit code " + p.exitValue());
                }
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            result = new LinkedHashMap();
            try (FileInputStream in = new FileInputStream(this.listingFile(directory));){
                if (WGetFileSystemFactory.useCurl && this.getRootURL().getProtocol().equals("ftp")) {
                    try (BufferedReader bin = new BufferedReader(new InputStreamReader(in));){
                        String line = bin.readLine();
                        while (line != null) {
                            String[] ss = line.split("\\s+");
                            if (ss.length > 8) {
                                boolean dir = line.charAt(0) == 'd';
                                FileSystem.DirectoryEntry de1 = new FileSystem.DirectoryEntry();
                                de1.modified = Long.MAX_VALUE;
                                String name = ss[8];
                                if (name.startsWith("/")) {
                                    name = name.substring(1);
                                }
                                de1.name = directory + name + (dir ? "/" : "");
                                de1.type = (char)(dir ? 100 : 102);
                                de1.size = Long.MAX_VALUE;
                                result.put(de1.name, de1);
                            } else {
                                System.err.println("here line 268");
                            }
                            line = bin.readLine();
                        }
                        break block48;
                    }
                }
                URL[] list = HtmlUtil.getDirectoryListing((URL)this.getURL(directory), (InputStream)in);
                int n = directory.length();
                for (URL url : list) {
                    FileSystem.DirectoryEntry de1 = new FileSystem.DirectoryEntry();
                    de1.modified = Long.MAX_VALUE;
                    de1.name = this.getLocalName(url).substring(n);
                    de1.type = (char)102;
                    de1.size = Long.MAX_VALUE;
                    result.put(de1.name, de1);
                }
            }
        }
        result = this.addRoCacheEntries(directory, result);
        this.cacheListing(directory, result.values().toArray(new FileSystem.DirectoryEntry[result.size()]));
        return FileSystem.getListing(result);
    }
}

