/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class DasProgressMonitorInputStream
extends FilterInputStream {
    private static final Logger logger = LoggerManager.getLogger("das2.system.monitor");
    private final ProgressMonitor monitor;
    private boolean started = false;
    private int bytesRead = 0;
    private final long birthTimeMilli;
    private long deathTimeMilli;
    private DecimalFormat transferRateFormat;
    boolean enableProgressPosition = true;
    private long streamLength = 1000000L;
    private long taskSize = this.streamLength / 1000L;
    private final List<Runnable> runWhenClosedRunnables;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public DasProgressMonitorInputStream(InputStream in, ProgressMonitor monitor) {
        super(in);
        this.monitor = monitor;
        this.birthTimeMilli = System.currentTimeMillis();
        this.deathTimeMilli = -1L;
        this.runWhenClosedRunnables = new ArrayList<Runnable>();
    }

    private void reportTransmitSpeed() {
        if (this.transferRateFormat == null) {
            this.transferRateFormat = new DecimalFormat();
            this.transferRateFormat.setMaximumFractionDigits(2);
            this.transferRateFormat.setMinimumFractionDigits(2);
        }
        String s = this.transferRateFormat.format(this.calcTransmitSpeed() / 1024.0);
        this.monitor.setProgressMessage("(" + s + "kB/s)");
        logger.log(Level.FINER, "transmit speed {0}", s);
        if (this.enableProgressPosition) {
            this.monitor.setTaskProgress(this.bytesRead / 1000);
        }
    }

    private double calcTransmitSpeed() {
        long totalBytesRead = this.bytesRead;
        long timeElapsed = this.deathTimeMilli > -1L ? this.deathTimeMilli - this.birthTimeMilli : System.currentTimeMillis() - this.birthTimeMilli;
        if (timeElapsed == 0L) {
            return Double.POSITIVE_INFINITY;
        }
        return 1000.0 * (double)totalBytesRead / (double)timeElapsed;
    }

    @Override
    public int read() throws IOException {
        this.checkCancelled();
        int result = super.read();
        if (this.monitor != null) {
            if (!this.started) {
                this.started = true;
                this.monitor.setTaskSize(this.taskSize);
                this.monitor.started();
            }
            if (this.bytesRead == -1) {
                if (!this.monitor.isFinished()) {
                    this.monitor.finished();
                }
            } else {
                ++this.bytesRead;
                this.checkCancelled();
                this.reportTransmitSpeed();
            }
        }
        return result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkCancelled();
        int result = super.read(b);
        if (this.monitor != null) {
            if (!this.started) {
                this.started = true;
                this.monitor.setTaskSize(this.taskSize);
                this.monitor.started();
            }
            if (this.bytesRead == -1) {
                if (!this.monitor.isFinished()) {
                    this.monitor.finished();
                }
            } else {
                this.bytesRead += result;
                this.checkCancelled();
                this.reportTransmitSpeed();
            }
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkCancelled();
        int result = super.read(b, off, len);
        if (this.monitor != null) {
            if (!this.started) {
                this.started = true;
                this.monitor.setTaskSize(this.taskSize);
                this.monitor.started();
            }
            if (this.bytesRead == -1) {
                if (!this.monitor.isFinished()) {
                    this.monitor.finished();
                }
            } else {
                this.bytesRead += result;
                this.checkCancelled();
                this.reportTransmitSpeed();
            }
        }
        return result;
    }

    private void checkCancelled() throws IOException {
        if (this.monitor != null && this.monitor.isCancelled()) {
            this.close();
            throw new InterruptedIOException("Operation cancelled");
        }
    }

    public void addRunWhenClosedRunnable(Runnable run) {
        this.runWhenClosedRunnables.add(run);
    }

    @Override
    public void close() throws IOException {
        logger.fine("close monitor");
        super.close();
        if (this.deathTimeMilli > -1L) {
            logger.fine("close called twice.");
        }
        boolean doRunWhenClosedRunnables = this.deathTimeMilli == -1L;
        this.deathTimeMilli = System.currentTimeMillis();
        if (this.monitor != null) {
            if (!this.monitor.isFinished()) {
                this.monitor.finished();
            }
            this.started = false;
        }
        if (doRunWhenClosedRunnables) {
            for (Runnable run : this.runWhenClosedRunnables) {
                try {
                    run.run();
                }
                catch (RuntimeException ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
        }
    }

    public void setEnableProgressPosition(boolean value) {
        this.enableProgressPosition = value;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public long getStreamLength() {
        return this.streamLength;
    }

    public void setStreamLength(long streamLength) {
        long oldTaskSize = this.streamLength;
        this.streamLength = streamLength;
        this.taskSize = streamLength < 1000L ? -1L : streamLength / 1000L;
        this.propertyChangeSupport.firePropertyChange("streamLength", oldTaskSize, streamLength);
    }
}

