/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;

public abstract class DnDSupport {
    private Component component;
    private DnDSupport parent;
    private int ops;
    private GestureRecognizer gestureRecognizer;

    protected DnDSupport(Component component, int ops, DnDSupport parent) {
        this.component = component;
        this.parent = parent;
        this.ops = ops;
        component.setDropTarget(new DropTarget(component, ops, new DropHandler()));
    }

    public void setParent(DnDSupport parent) {
        this.parent = parent;
    }

    protected abstract int canAccept(DataFlavor[] var1, int var2, int var3, int var4);

    protected abstract boolean importData(Transferable var1, int var2, int var3, int var4);

    protected abstract void done();

    protected abstract void exportDone(Transferable var1, int var2);

    protected abstract Transferable getTransferable(int var1, int var2, int var3);

    private int canAcceptInternal(DataFlavor[] flavors, int x, int y, int action) {
        int result = this.canAccept(flavors, x, y, action);
        if (result == -1 && this.parent != null) {
            return this.parent.canAcceptInternal(flavors, x + this.component.getX(), y + this.component.getY(), action);
        }
        return result;
    }

    private boolean importDataInternal(Transferable t, int x, int y, int action) {
        if (this.canAccept(t.getTransferDataFlavors(), x, y, action) != -1) {
            return this.importData(t, x, y, action);
        }
        if (this.parent != null) {
            return this.parent.importDataInternal(t, x + this.component.getX(), y + this.component.getY(), action);
        }
        return false;
    }

    private void doneInternal() {
        this.done();
        if (this.parent != null) {
            this.parent.doneInternal();
        }
    }

    public void startDrag(int x, int y, int action, MouseEvent evt) {
        if (this.gestureRecognizer == null) {
            this.gestureRecognizer = new GestureRecognizer(this.component, new DragHandler());
        }
        this.gestureRecognizer.startDrag(x, y, action, evt);
    }

    private class DragHandler
    implements DragGestureListener,
    DragSourceListener {
        private DragHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            Point p = dge.getDragOrigin();
            int action = dge.getDragAction();
            Transferable t = DnDSupport.this.getTransferable(p.x, p.y, action);
            if (t != null) {
                dge.startDrag(new Cursor(12), t, this);
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            DragSourceContext dsc = dsde.getDragSourceContext();
            if (dsde.getDropSuccess()) {
                DnDSupport.this.exportDone(dsc.getTransferable(), dsde.getDropAction());
            } else {
                DnDSupport.this.exportDone(null, 0);
            }
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }
    }

    private class GestureRecognizer
    extends DragGestureRecognizer {
        GestureRecognizer(Component component, DragHandler handler) {
            super(DragSource.getDefaultDragSource(), component, DnDSupport.this.ops, handler);
        }

        void startDrag(int x, int y, int action, MouseEvent evt) {
            this.appendEvent(evt);
            this.fireDragGestureRecognized(action, new Point(x, y));
        }

        @Override
        protected void registerListeners() {
        }

        @Override
        protected void unregisterListeners() {
        }
    }

    private class DropHandler
    implements DropTargetListener {
        private DropHandler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            Point location = dtde.getLocation();
            int action = DnDSupport.this.canAcceptInternal(dtde.getCurrentDataFlavors(), location.x, location.y, dtde.getDropAction());
            if (action == -1) {
                dtde.rejectDrag();
            } else {
                dtde.acceptDrag(action);
            }
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            DnDSupport.this.doneInternal();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            Point location = dtde.getLocation();
            int action = DnDSupport.this.canAcceptInternal(dtde.getCurrentDataFlavors(), location.x, location.y, dtde.getDropAction());
            if (action == -1) {
                dtde.rejectDrag();
            } else {
                dtde.acceptDrag(action);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Point location = dtde.getLocation();
            int action = DnDSupport.this.canAcceptInternal(dtde.getCurrentDataFlavors(), location.x, location.y, dtde.getDropAction());
            if (action == -1) {
                dtde.rejectDrop();
            } else {
                dtde.acceptDrop(action);
                boolean success = DnDSupport.this.importDataInternal(dtde.getTransferable(), location.x, location.y, dtde.getDropAction());
                dtde.dropComplete(success);
            }
            DnDSupport.this.doneInternal();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }
    }
}

