/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.filechooser.FileFilter;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.ZipFiles;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class FileSystemUtil {
    private static final Logger logger = LoggerManager.getLogger("das2.filesystem");
    private static final int BUFFER_SIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpToFile(InputStream in, File f) throws FileNotFoundException, IOException {
        FileChannel oc;
        ReadableByteChannel ic;
        block4: {
            ic = Channels.newChannel(in);
            oc = null;
            try {
                oc = new FileOutputStream(f).getChannel();
                if (ic instanceof FileChannel) {
                    FileChannel fic = (FileChannel)ic;
                    fic.transferTo(0L, fic.size(), oc);
                    break block4;
                }
                ByteBuffer buf = ByteBuffer.allocateDirect(16384);
                while (ic.read(buf) >= 0 || buf.position() != 0) {
                    buf.flip();
                    oc.write(buf);
                    buf.compact();
                }
            }
            catch (Throwable throwable) {
                FileSystemUtil.closeResources(oc, ic);
                throw throwable;
            }
        }
        FileSystemUtil.closeResources(oc, ic);
    }

    private static void closeResources(Channel chout, Channel chin) throws IOException {
        if (chout != null && chout.isOpen()) {
            chout.close();
        }
        if (chin != null && chin.isOpen()) {
            chin.close();
        }
    }

    public static void unzip(File fz, File file) throws IOException {
        FileSystemUtil.gunzip(fz, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gunzip(File fz, File file) throws IOException {
        GZIPInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new GZIPInputStream(new FileInputStream(fz));
            out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    public static void zip(File fz, File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("dir should be a directory");
        }
        new ZipFiles().zipDirectory(dir, fz.getAbsolutePath());
    }

    public static void unzipFile(File zipFilePath, File destDir) throws IOException {
        if (!destDir.exists() && !destDir.mkdirs()) {
            throw new IOException("Unable to make directories: " + destDir);
        }
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));){
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                String filePath = destDir.getAbsolutePath() + File.separator + entry.getName();
                if (!entry.isDirectory()) {
                    try {
                        FileSystemUtil.extractFile(zipIn, filePath);
                    }
                    catch (FileNotFoundException ex) {
                        logger.log(Level.WARNING, "file not found: {0}", entry);
                    }
                } else {
                    File dir = new File(filePath);
                    if (!dir.exists() && !dir.mkdir()) {
                        logger.log(Level.WARNING, "failed attempt to make directory: {0}", filePath);
                    }
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));){
            int read;
            byte[] bytesIn = new byte[4096];
            while ((read = zipIn.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }

    public static void deleteAllFiles(File dir, String regex) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("first argument must be a directory");
        }
        File[] ff = dir.listFiles();
        if (ff == null) {
            throw new IllegalArgumentException("null returned from listFiles, which shouldn't happen.");
        }
        for (File f : ff) {
            if (f.isDirectory()) {
                FileSystemUtil.deleteAllFiles(f, regex);
                continue;
            }
            if (!f.isFile() || !f.getName().matches(regex) || f.delete()) continue;
            logger.log(Level.WARNING, "failed to delete: {0}", f);
        }
    }

    public static void copyStream(InputStream is, OutputStream out, ProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        byte[] buffer = new byte[2048];
        int bytesRead = is.read(buffer, 0, 2048);
        long totalBytesRead = bytesRead;
        while (bytesRead > -1) {
            if (monitor.isCancelled()) {
                throw new InterruptedIOException();
            }
            monitor.setTaskProgress(totalBytesRead);
            out.write(buffer, 0, bytesRead);
            bytesRead = is.read(buffer, 0, 2048);
            totalBytesRead += (long)bytesRead;
            logger.finest("transferring data");
        }
    }

    public static URI isCacheable(URI ruri) {
        if (ruri.getQuery() == null && ruri.getPath().length() > 1 && !ruri.getPath().endsWith("/")) {
            String s = ruri.toString();
            int i = s.lastIndexOf("/");
            String folder = s.substring(0, i);
            try {
                return new URL(folder).toURI();
            }
            catch (URISyntaxException ex) {
                logger.log(Level.SEVERE, "couldn't create URI from parent URL", ex);
                return null;
            }
            catch (MalformedURLException ex) {
                logger.log(Level.SEVERE, "url caused malformed URL exception when creating parent URL: ", ex);
                return null;
            }
        }
        return null;
    }

    public static URI getParentUri(URI ruri) {
        if (ruri.getQuery() == null && ruri.getPath().length() > 1) {
            int i;
            String s = ruri.toString();
            if (s.charAt((i = s.length()) - 1) == '/') {
                --i;
            }
            i = s.lastIndexOf("/", i - 1);
            String folder = s.substring(0, i);
            try {
                return new URL(folder).toURI();
            }
            catch (URISyntaxException ex) {
                logger.log(Level.SEVERE, "couldn't create URI from parent URL", ex);
                return null;
            }
            catch (MalformedURLException ex) {
                logger.log(Level.SEVERE, "url caused malformed URL exception when creating parent URL: ", ex);
                return null;
            }
        }
        return null;
    }

    public static void maybeMkdirs(File file) throws IOException {
        if (file.exists()) {
            return;
        }
        if (!file.mkdirs() && !file.exists()) {
            logger.log(Level.SEVERE, "Unable to mkdirs {0}", file);
            throw new IOException("Unable to mkdirs " + file);
        }
    }

    public static String uriEncode(String surl) {
        String scheme;
        int i = surl.indexOf(":/");
        if (i == -1) {
            scheme = null;
        } else if (i < 6) {
            scheme = surl.substring(0, i);
            surl = surl.substring(i + 1);
        } else {
            scheme = null;
        }
        surl = surl.replaceAll("%", "%25");
        surl = surl.replaceAll(" ", "%20");
        surl = surl.replaceAll(":", "%3A");
        surl = surl.replaceAll("<", "%3C");
        surl = surl.replaceAll(">", "%3E");
        surl = surl.replaceAll("\\[", "%5B");
        surl = surl.replaceAll("\\]", "%5D");
        if (scheme != null) {
            return scheme + ":" + surl;
        }
        return surl;
    }

    public static String uriDecode(String s) {
        String surl = s;
        surl = surl.replaceAll("%20", " ");
        surl = surl.replaceAll("%3C", "<");
        surl = surl.replaceAll("%3E", ">");
        surl = surl.replaceAll("%5B", "\\[");
        surl = surl.replaceAll("%5D", "\\]");
        surl = surl.replaceAll("%25", "%");
        return surl;
    }

    public static String fromUri(URI uri) {
        String query;
        String surl = uri.toString();
        int i = surl.indexOf("?");
        String string = query = i == -1 ? "" : surl.substring(i);
        if (i != -1) {
            return FileSystemUtil.uriDecode(surl.substring(0, i)) + query;
        }
        return FileSystemUtil.uriDecode(surl);
    }

    public static URI toUri(String s) {
        try {
            return new URI(FileSystemUtil.uriEncode(s));
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static File createTempFile(File localFile, int timeoutSeconds) {
        File f = FileSystem.settings().getLocalCacheDir();
        f = new File(f, "temp");
        f = new File(f, localFile.toString());
        return f;
    }

    public static FileFilter getFileNameExtensionFilter(final String description, final String ext) {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                String s = f.getName();
                return f.isDirectory() || s.endsWith(ext);
            }

            @Override
            public String getDescription() {
                return description;
            }
        };
    }

    public static File downloadResourceAsFile(URI uri, ProgressMonitor monitor) throws IOException {
        String suri = uri.toString();
        String[] ss = FileSystem.splitUrl(suri);
        FileSystem fs = FileSystem.create(ss[2]);
        FileObject fo = fs.getFileObject(ss[3].substring(ss[2].length()));
        File result = fo.getFile(monitor);
        return result;
    }
}

