/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;

public class GitCommand {
    Logger logger = LoggerManager.getLogger("das2.filesystem.git");
    File pwd = null;

    public GitCommand(File pwd) {
        this.pwd = pwd;
    }

    public GitResponse pull() throws IOException, InterruptedException {
        String exe = "git pull";
        this.logger.log(Level.FINE, "running command {0}", exe);
        ProcessBuilder pb = new ProcessBuilder(exe.split(" "));
        pb.directory(this.pwd);
        File log = File.createTempFile("editor.pull.", ".txt");
        pb.redirectErrorStream(true);
        pb.redirectOutput(ProcessBuilder.Redirect.to(log));
        Process p = pb.start();
        p.waitFor();
        String msg = FileUtil.readFileToString(log);
        GitResponse result = new GitResponse();
        result.exitCode = p.exitValue();
        result.response = msg;
        result.errorResponse = null;
        return result;
    }

    public GitResponse push() throws IOException, InterruptedException {
        String exe = "git push";
        this.logger.log(Level.FINE, "running command {0}", exe);
        ProcessBuilder pb = new ProcessBuilder(exe.split(" "));
        pb.directory(this.pwd);
        File log = File.createTempFile("editor.push.", ".txt");
        pb.redirectErrorStream(true);
        pb.redirectOutput(ProcessBuilder.Redirect.to(log));
        Process p = pb.start();
        p.waitFor();
        String msg = FileUtil.readFileToString(log);
        GitResponse result = new GitResponse();
        result.exitCode = p.exitValue();
        result.response = msg;
        result.errorResponse = null;
        return result;
    }

    public GitResponse diff(File f) throws IOException, InterruptedException {
        String exe = "git diff " + f.getPath();
        this.logger.log(Level.FINE, "running command {0}", exe);
        ProcessBuilder pb = new ProcessBuilder(exe.split(" "));
        pb.directory(this.pwd);
        File log = File.createTempFile("editor.diff.", ".txt");
        pb.redirectErrorStream(true);
        pb.redirectOutput(ProcessBuilder.Redirect.to(log));
        Process p = pb.start();
        p.waitFor();
        String msg = FileUtil.readFileToString(log);
        GitResponse response = new GitResponse();
        response.exitCode = p.exitValue();
        if (response.exitCode == 0) {
            response.response = msg;
        } else {
            response.errorResponse = msg;
        }
        return response;
    }

    public GitResponse commit(File script, String msg) throws IOException, InterruptedException {
        String name = script.getName();
        this.logger.log(Level.INFO, "pwd: {0}", script.getParentFile());
        ProcessBuilder pb = new ProcessBuilder("git", "commit", "-m", msg, name);
        pb.directory(script.getParentFile());
        this.logger.log(Level.FINE, "running command {0}", String.join((CharSequence)" ", pb.command()));
        pb.directory(this.pwd);
        File log = File.createTempFile("editor.commit.", ".txt");
        pb.redirectErrorStream(true);
        pb.redirectOutput(ProcessBuilder.Redirect.to(log));
        Process p = pb.start();
        p.waitFor();
        String logmsg = FileUtil.readFileToString(log);
        this.logger.info(logmsg);
        GitResponse response = new GitResponse();
        response.exitCode = p.exitValue();
        if (response.exitCode == 0) {
            response.response = logmsg;
        } else {
            response.errorResponse = logmsg;
        }
        return response;
    }

    public static class GitResponse {
        int exitCode;
        String response;
        String errorResponse;

        public int getExitCode() {
            return this.exitCode;
        }

        public String getResponse() {
            return this.response;
        }

        public String getErrorResponse() {
            return this.errorResponse;
        }
    }
}

