/*
 * Decompiled with CFR 0.152.
 */
package org.das2.util.filesystem;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemUtil;

public class SubFileSystem
extends FileSystem {
    FileSystem parent;
    String dir;

    private static String trimFront(String dir) {
        int i;
        for (i = 0; i < dir.length() && dir.charAt(i) == '/'; ++i) {
        }
        return i < dir.length() ? dir.substring(i) : "";
    }

    protected SubFileSystem(FileSystem parent, String dir) throws MalformedURLException, URISyntaxException {
        super(FileSystemUtil.toUri(parent.getRootURI().toString() + SubFileSystem.trimFront(dir)));
        this.parent = parent;
        this.dir = dir;
    }

    @Override
    public FileObject getFileObject(String filename) {
        return this.parent.getFileObject(this.dir + filename);
    }

    @Override
    public boolean isDirectory(String filename) throws IOException {
        return this.parent.isDirectory(this.dir + filename);
    }

    @Override
    public String[] listDirectory(String directory) throws IOException {
        return this.parent.listDirectory(this.dir + directory);
    }

    @Override
    public String[] listDirectory(String directory, String regex) throws IOException {
        return this.parent.listDirectory(this.dir + directory, regex);
    }

    @Override
    public File getLocalRoot() {
        return new File(this.parent.getLocalRoot(), this.dir);
    }

    public String toString() {
        return "subfs " + this.parent.toString() + " " + this.dir;
    }

    protected FileSystem getParent() {
        return this.parent;
    }

    @Override
    public FileSystem createFileSystem(String directory) throws URISyntaxException {
        if (directory.startsWith("/")) {
            directory = directory.substring(1);
        }
        try {
            return new SubFileSystem(this.parent, this.dir + directory);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }
}

