/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.binarydatasource;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.autoplot.datasource.DataSourceFormatEditorPanel;
import org.autoplot.datasource.URISplit;
import org.jdesktop.layout.GroupLayout;

public class BinaryDataSourceFormatEditorPanel
extends JPanel
implements DataSourceFormatEditorPanel {
    String file;
    private JComboBox endianComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JCheckBox justDataCB;
    private JComboBox typeComboBox;

    public BinaryDataSourceFormatEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.typeComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.endianComboBox = new JComboBox();
        this.justDataCB = new JCheckBox();
        this.jLabel1.setText("Type:");
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"double", "float", "int", "short", "byte"}));
        this.jLabel2.setText("Byte Order / Endianness:");
        this.endianComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"big", "little", " "}));
        this.justDataCB.setText("Just Data, don't format timetags and other dependencies");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.typeComboBox, -2, 123, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.endianComboBox, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.justDataCB).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.typeComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.endianComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.justDataCB).addContainerGap(204, Short.MAX_VALUE)));
    }

    public JPanel getPanel() {
        return this;
    }

    private String getParam(Map<String, String> args, String name, String defl) {
        String s = args.get(name);
        if (s == null) {
            return defl;
        }
        return s;
    }

    public void setURI(String uri) {
        URISplit split = URISplit.parse((String)uri);
        LinkedHashMap args = URISplit.parseParams((String)split.params);
        String s = this.getParam(args, "type", "double");
        this.typeComboBox.setSelectedItem(s);
        s = this.getParam(args, "byteOrder", "little");
        this.endianComboBox.setSelectedItem(s);
        s = (String)args.get("doDep");
        if (s != null && s.length() > 0 && 'F' == s.substring(0, 1).toUpperCase().charAt(0)) {
            this.justDataCB.setSelected(true);
        }
        this.file = split.file;
    }

    public String getURI() {
        String result = this.file;
        HashMap<String, String> args = new HashMap<String, String>();
        String s = (String)this.typeComboBox.getSelectedItem();
        if (!s.equals("double")) {
            args.put("type", s);
        }
        if (!(s = (String)this.endianComboBox.getSelectedItem()).equals("little")) {
            args.put("byteOrder", s);
        }
        if (this.justDataCB.isSelected()) {
            args.put("doDep", "F");
        }
        String params = URISplit.formatParams(args);
        if (result == null) {
            result = "file:///";
        }
        URISplit ss = URISplit.parse((String)result);
        if (params.length() > 0) {
            ss.params = params;
        }
        return URISplit.format((URISplit)ss);
    }
}

