/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pds;

import gov.nasa.pds.ppi.label.PDSException;
import gov.nasa.pds.ppi.label.PDSLabel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.autoplot.datasource.DataSetURI;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;

public class ShowLabelAsXml {
    public static void main(String[] args) throws MalformedURLException, IOException, PDSException, TransformerException {
        PDSLabel label = new PDSLabel();
        String lbl = "https://pds-ppi.igpp.ucla.edu/data/JNO-J_SW-JAD-3-CALIBRATED-V1.0/DATA/2023/2023004/ELECTRONS/JAD_L30_LRS_ELC_ANY_CNT_2023004_V04.LBL";
        File f = DataSetURI.getFile((URL)new URL(lbl), (ProgressMonitor)new NullProgressMonitor());
        if (!label.parse(f.toPath())) {
            throw new IllegalArgumentException("unable to use file " + lbl);
        }
        Document doc = label.getDocument();
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        String output = writer.getBuffer().toString().replaceAll("\n|\r", "");
        System.err.println("output to " + new File(".").getAbsolutePath());
        try (FileWriter fw = new FileWriter(f.getName() + ".xml");){
            fw.append(output);
        }
    }
}

