/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.ArrayAttribute;
import gov.nasa.gsfc.spdf.cdfj.ByteArray;
import gov.nasa.gsfc.spdf.cdfj.CDFDataType;
import gov.nasa.gsfc.spdf.cdfj.CDFTimeType;
import gov.nasa.gsfc.spdf.cdfj.CPR;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.DoubleArray;
import gov.nasa.gsfc.spdf.cdfj.FloatArray;
import gov.nasa.gsfc.spdf.cdfj.IntArray;
import gov.nasa.gsfc.spdf.cdfj.LongArray;
import gov.nasa.gsfc.spdf.cdfj.ShortArray;
import gov.nasa.gsfc.spdf.cdfj.StringArray;
import gov.nasa.gsfc.spdf.cdfj.SupportedTypes;
import gov.nasa.gsfc.spdf.cdfj.VDR;
import gov.nasa.gsfc.spdf.cdfj.VXR;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;

public class DataContainer {
    VDR vdr;
    VXR vxr;
    Vector<Integer> firstRecords = new Vector();
    Vector<Integer> lastRecords = new Vector();
    Vector<ByteBuffer> bufs = new Vector();
    Vector<Integer> points = new Vector();
    protected long position;
    static final int VVR_PREAMBLE = 12;
    static final int CVVR_PREAMBLE = 24;
    final boolean rowMajority;
    final int CXR_MAX_ENTRIES = 6;
    CPR cpr;
    DataContainer timeContainer;
    Vector<Integer> _firstRecords;
    Vector<Integer> _lastRecords;
    Vector<ByteBuffer> _bufs;
    Boolean phantom = null;
    Boolean _doNotCompress = null;
    boolean doNotCompress = false;
    long[] locs;
    VXR[] vxrs;

    public DataContainer(VDR vdr) {
        this(vdr, true);
    }

    public DataContainer(VDR vdr, boolean rowMajority) {
        this.vdr = vdr;
        this.vxr = new VXR();
        this.rowMajority = rowMajority;
    }

    public VDR getVDR() {
        return this.vdr;
    }

    public VXR getVXR() {
        return this.vxr;
    }

    void setTimeContainer(DataContainer dc) {
        this.timeContainer = dc;
    }

    void addPhantomEntry() {
        if (this.phantom != null) {
            return;
        }
        this.firstRecords.add(-1);
        this.lastRecords.add(-1);
        this.bufs.add(null);
        this.phantom = Boolean.TRUE;
    }

    public void addData(Object data, int[] recordRange, boolean oned) throws Throwable {
        this.addData(data, recordRange, oned, false);
    }

    /*
     * WARNING - void declaration
     */
    void addData(Object data, int[] recordRange, boolean oned, boolean relax) throws Throwable {
        Object[] values;
        int first;
        ByteBuffer buf = null;
        if (ByteBuffer.class.isAssignableFrom(data.getClass())) {
            buf = (ByteBuffer)data;
            if (DataTypes.size[this.vdr.dataType] > 1 && buf.order() != ByteOrder.LITTLE_ENDIAN) {
                throw new Throwable("For data types of size > 1, supplied buffer must be in LITTLE_ENDIAN order");
            }
            if (this.vdr.isCompressed()) {
                if (recordRange == null) {
                    throw new Throwable("Record range must be specified since " + this.vdr.getName() + "is to be stored as compressed.");
                }
                if (this._doNotCompress == null) {
                    this.doNotCompress = recordRange.length == 2;
                    this._doNotCompress = this.doNotCompress;
                } else if (this.doNotCompress && recordRange.length > 2 || !this.doNotCompress && recordRange.length == 2) {
                    String t = "compressed";
                    if (!this.doNotCompress) {
                        t = "uncompressed";
                    }
                    throw new Throwable("Changing compression mode of input. Previous = " + t + ".");
                }
            }
        } else if (!data.getClass().isArray()) {
            throw new Throwable("supplied object not an array");
        }
        int n = first = recordRange == null ? 0 : recordRange[0];
        if (this.lastRecords.size() > 0) {
            int _last = -1;
            _last = this.timeContainer != null ? this.timeContainer.getLastRecord(this.lastRecords.size() - 1) : this.getLastRecord();
            if (recordRange == null) {
                first = _last + 1;
                int expected = this.getLastRecord() + 1;
                if (first - expected > 0 && this.vdr.sRecords == 0) {
                    System.out.println("Gap: " + expected + " - " + first + " for " + this.vdr.getName());
                    throw new Throwable(" SparseRecordOption must be set. There are  missing records between files for " + this.vdr.getName());
                }
            } else {
                if (recordRange[0] <= _last) {
                    throw new Throwable("first record " + recordRange[0] + " must follow the last seen record " + _last);
                }
                if (recordRange[0] > _last + 1 && this.vdr.sRecords == 0) {
                    throw new Throwable("Specified start of the range " + recordRange[0] + " does not follow last record " + _last + " immediately. SparseRecordOption must be set if the CDF is missing records");
                }
            }
        } else if (first != 0 && this.vdr.sRecords == 0) {
            throw new Throwable("SparseRecordOption must be set if the CDF is missing records");
        }
        boolean done = false;
        int npt = 0;
        int last = -1;
        if (!done && buf != null) {
            if (recordRange == null) {
                npt = buf.remaining() / DataTypes.size[this.vdr.dataType];
                last = first + (npt /= this.vdr.itemsPerPoint) - 1;
            } else {
                last = recordRange[1];
                npt = last - first + 1;
            }
            this.firstRecords.add(first);
            this.lastRecords.add(last);
            this.bufs.add(buf);
            this.points.add(npt);
            return;
        }
        ArrayAttribute aa = new ArrayAttribute(data);
        if (!oned) {
            npt = Array.getLength(data);
            if (recordRange != null && npt != recordRange[1] - recordRange[0] + 1) {
                throw new Throwable("array size not consistent with given record range");
            }
            Vector<Object> vdim = null;
            if (this.vdr.dataType == 32) {
                vdim = new Vector();
                vdim.add(2);
            } else {
                vdim = this.vdr.efdim;
            }
            if (vdim.size() > 0) {
                int[] nArray = new int[1 + vdim.size()];
                nArray[0] = npt;
                for (int i = 0; i < vdim.size(); ++i) {
                    nArray[i + 1] = (Integer)vdim.get(i);
                }
                if (!Arrays.equals(aa.getDimensions(), nArray)) {
                    StringBuffer sbe = new StringBuffer();
                    for (int i = 0; i < nArray.length; ++i) {
                        sbe.append("," + nArray[i]);
                    }
                    StringBuffer sbf = new StringBuffer("");
                    int[] fdim = aa.getDimensions();
                    for (int i = 0; i < fdim.length; ++i) {
                        sbf.append("," + fdim[i]);
                    }
                    throw new Throwable("Dimension mismatch, expected: " + sbe + " found " + sbf + ".");
                }
            }
            last = first + npt - 1;
            buf = this.addJavaArray(data, this.vdr.dataType, relax);
            if (buf != null) {
                done = true;
            }
        }
        if (!done && (this.vdr.dataType == 1 || relax && this.vdr.dataType == 11 || this.vdr.dataType > 50 && aa.getType() == Byte.TYPE)) {
            values = (byte[])data;
            npt = values.length / this.vdr.itemsPerPoint;
            if (recordRange != null && npt != recordRange[1] - recordRange[0] + 1) {
                throw new Throwable("array size not consistent with given record range");
            }
            buf = ByteBuffer.wrap(values);
            last = first + npt - 1;
            done = true;
        }
        if (!done && (this.vdr.dataType == 2 || relax && this.vdr.dataType == 12)) {
            values = (short[])data;
            npt = values.length / this.vdr.itemsPerPoint;
            if (recordRange != null && npt != recordRange[1] - recordRange[0] + 1) {
                throw new Throwable("array size not consistent with given record range");
            }
            last = first + npt - 1;
            buf = ByteBuffer.allocateDirect(2 * values.length);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                buf.asShortBuffer().put((short[])values);
            } else {
                void var12_15;
                boolean bl = false;
                while (var12_15 < values.length) {
                    buf.putShort(values[var12_15]);
                    ++var12_15;
                }
                buf.position(0);
            }
            done = true;
        }
        if (!done && (this.vdr.dataType == 4 || relax && this.vdr.dataType == 14)) {
            values = (int[])data;
            npt = values.length / this.vdr.itemsPerPoint;
            if (recordRange != null && npt != recordRange[1] - recordRange[0] + 1) {
                throw new Throwable("array size not consistent with given record range");
            }
            last = first + npt - 1;
            buf = ByteBuffer.allocateDirect(4 * values.length);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                buf.asIntBuffer().put((int[])values);
            } else {
                void var12_17;
                boolean bl = false;
                while (var12_17 < values.length) {
                    buf.putInt(values[var12_17]);
                    ++var12_17;
                }
                buf.position(0);
            }
            done = true;
        }
        if (!(done || this.vdr.dataType != 21 && this.vdr.dataType != 44)) {
            values = (float[])data;
            npt = values.length / this.vdr.itemsPerPoint;
            if (recordRange != null && npt != recordRange[1] - recordRange[0] + 1) {
                throw new Throwable("array size not consistent with given record range");
            }
            last = first + npt - 1;
            buf = ByteBuffer.allocateDirect(4 * values.length);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                buf.asFloatBuffer().put((float[])values);
            } else {
                void var12_19;
                boolean bl = false;
                while (var12_19 < values.length) {
                    buf.putFloat(values[var12_19]);
                    ++var12_19;
                }
                buf.position(0);
            }
            done = true;
        }
        if (!(done || this.vdr.dataType != 22 && this.vdr.dataType != 45 && this.vdr.dataType != 31 && this.vdr.dataType != 32)) {
            values = (double[])data;
            npt = values.length / this.vdr.itemsPerPoint;
            if (recordRange != null && npt != recordRange[1] - recordRange[0] + 1) {
                throw new Throwable("array size not consistent with given record range");
            }
            last = first + npt - 1;
            buf = ByteBuffer.allocateDirect(8 * values.length);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                buf.asDoubleBuffer().put((double[])values);
            } else {
                void var12_21;
                boolean bl = false;
                while (var12_21 < values.length) {
                    buf.putDouble(values[var12_21]);
                    ++var12_21;
                }
                buf.position(0);
            }
            done = true;
        }
        if (!(done || this.vdr.dataType != 33 && this.vdr.dataType != 8)) {
            values = (long[])data;
            npt = values.length / this.vdr.itemsPerPoint;
            if (recordRange != null && npt != recordRange[1] - recordRange[0] + 1) {
                throw new Throwable("array size not consistent with given record range");
            }
            last = first + npt - 1;
            buf = ByteBuffer.allocateDirect(8 * values.length);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                buf.asLongBuffer().put((long[])values);
            } else {
                void var12_23;
                boolean bl = false;
                while (var12_23 < values.length) {
                    buf.putLong(values[var12_23]);
                    ++var12_23;
                }
                buf.position(0);
            }
            done = true;
        }
        if (!done && this.vdr.dataType > 50) {
            values = (String[])data;
            npt = values.length * this.vdr.numElems / this.vdr.itemsPerPoint;
            if (recordRange != null && npt != recordRange[1] - recordRange[0] + 1) {
                throw new Throwable("array size not consistent with given record range");
            }
            last = first + npt - 1;
            buf = ByteBuffer.allocateDirect(this.vdr.numElems * values.length);
            for (byte value : values) {
                int len = value.length();
                if (len > this.vdr.numElems) {
                    throw new Throwable("String " + (String)value + " is longer than the length of variable.");
                }
                byte[] _bar = value.getBytes();
                buf.put(_bar);
                for (int f = 0; f < this.vdr.numElems - _bar.length; ++f) {
                    buf.put((byte)32);
                }
            }
            buf.position(0);
            done = true;
        }
        if (!done) {
            if (relax) {
                throw new Throwable("Unsupported data type.");
            }
            if (this.vdr.dataType > 10 && this.vdr.dataType < 20) {
                throw new Throwable("Possible incompatibility for unsigned. Use relax = true to force acceptance");
            }
        }
        if (this.phantom == Boolean.TRUE) {
            this.firstRecords.clear();
            this.lastRecords.clear();
            this.bufs.clear();
            this.phantom = Boolean.FALSE;
        }
        this.firstRecords.add(first);
        this.lastRecords.add(last);
        this.bufs.add(buf);
        this.points.add(npt);
    }

    public int getSize() {
        int nbuf;
        int last;
        int size = this.vdr.getSize();
        if (this.vdr.isCompressed()) {
            this.cpr = new CPR();
            this.cpr.position = this.position + (long)size;
            this.vdr.setCPROffset(this.cpr.position);
            size += this.cpr.getSize();
        }
        if (this.bufs.size() > 0) {
            last = -1;
            for (int nbuf2 = this.bufs.size() - 1; nbuf2 >= 0; --nbuf2) {
                if (this.bufs.get(nbuf2) == null) continue;
                last = this.lastRecords.get(nbuf2);
                break;
            }
            if (last < 0) {
                return size;
            }
        } else {
            return size;
        }
        this.vdr.setMaxRec(last);
        this.vdr.setVXRHead(this.position + (long)size);
        this._firstRecords = new Vector();
        this._lastRecords = new Vector();
        this._bufs = new Vector();
        if (this.timeContainer == null) {
            for (nbuf = 0; nbuf < this.bufs.size(); ++nbuf) {
                if (this.bufs.get(nbuf) == null) continue;
                this._firstRecords.add(this.firstRecords.get(nbuf));
                this._lastRecords.add(this.lastRecords.get(nbuf));
                this._bufs.add(this.bufs.get(nbuf));
            }
        } else {
            for (nbuf = 0; nbuf < this.bufs.size(); ++nbuf) {
                if (this.bufs.get(nbuf) == null) continue;
                int _first = this.firstRecords.get(nbuf);
                if (_first < this.timeContainer.firstRecords.get(nbuf)) {
                    _first = this.timeContainer.firstRecords.get(nbuf);
                }
                this._firstRecords.add(_first);
                this._lastRecords.add(_first + this.lastRecords.get(nbuf) - this.firstRecords.get(nbuf));
                this._bufs.add(this.bufs.get(nbuf));
            }
        }
        int vxrsNeeded = this._bufs.size() / 6;
        int lastVXREntries = this._bufs.size() - vxrsNeeded * 6;
        if (lastVXREntries > 0) {
            ++vxrsNeeded;
        } else {
            lastVXREntries = 6;
        }
        this.vxrs = new VXR[vxrsNeeded];
        this.locs = new long[this._bufs.size()];
        int nbuf3 = 0;
        long _position = -1L;
        for (int v = 0; v < this.vxrs.length; ++v) {
            int len;
            int e;
            _position = this.position + (long)size;
            this.vxrs[v] = new VXR();
            int entries = 6;
            if (v == this.vxrs.length - 1) {
                entries = lastVXREntries;
            }
            this.vxrs[v].numEntries = entries;
            size += this.vxrs[v].getSize();
            if (!this.vdr.isCompressed()) {
                for (e = 0; e < entries; ++e) {
                    this.locs[nbuf3] = this.position + (long)size;
                    len = 12 + this._bufs.get(nbuf3).limit();
                    size += len;
                    ++nbuf3;
                }
            } else {
                this.vdr.setBlockingFactor(this.getBlockingFactor());
                if (this.doNotCompress) {
                    for (e = 0; e < entries; ++e) {
                        this.locs[nbuf3] = this.position + (long)size;
                        len = 24 + this._bufs.get(nbuf3).limit();
                        size += len;
                        ++nbuf3;
                    }
                    return size;
                }
                for (e = 0; e < entries; ++e) {
                    this.locs[nbuf3] = this.position + (long)size;
                    ByteBuffer b = this._bufs.get(nbuf3);
                    byte[] uncompressed = null;
                    if (b.hasArray()) {
                        uncompressed = b.array();
                    } else {
                        uncompressed = new byte[b.remaining()];
                        b.get(uncompressed);
                        this._bufs.setElementAt(null, nbuf3);
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(uncompressed.length);
                    try {
                        GZIPOutputStream gzos = new GZIPOutputStream(baos);
                        gzos.write(uncompressed, 0, uncompressed.length);
                        gzos.finish();
                        baos.flush();
                        b = ByteBuffer.wrap(baos.toByteArray());
                        this._bufs.setElementAt(b, nbuf3);
                        int len2 = 24 + b.limit();
                        size += len2;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    ++nbuf3;
                }
            }
            if (v == this.vxrs.length - 1) continue;
            this.vxrs[v].setVXRNext(this.position + (long)size);
        }
        if (this.vxrs.length > 1) {
            this.vdr.setVXRTail(_position);
        }
        return size;
    }

    public ByteBuffer update(ByteBuffer buf) {
        buf.position((int)this.position);
        buf.put(this.vdr.get());
        if (this.vdr.isCompressed()) {
            buf.put(this.cpr.get());
        }
        if (this._bufs == null) {
            return buf;
        }
        int nbuf = 0;
        if (this._bufs.size() > 0) {
            for (VXR vxr1 : this.vxrs) {
                int n;
                int e;
                buf.put(vxr1.get());
                for (e = 0; e < vxr1.numEntries; ++e) {
                    n = this._firstRecords.get(nbuf + e);
                    buf.putInt(n);
                }
                for (e = 0; e < vxr1.numEntries; ++e) {
                    n = this._lastRecords.get(nbuf + e);
                    buf.putInt(n);
                }
                for (e = 0; e < vxr1.numEntries; ++e) {
                    buf.putLong(this.locs[nbuf + e]);
                }
                if (!this.vdr.isCompressed()) {
                    for (e = 0; e < vxr1.numEntries; ++e) {
                        buf.putLong(12 + this._bufs.get(nbuf + e).limit());
                        buf.putInt(7);
                        buf.put(this._bufs.get(nbuf + e));
                    }
                } else {
                    for (e = 0; e < vxr1.numEntries; ++e) {
                        ByteBuffer b = this._bufs.get(nbuf + e);
                        buf.putLong(24 + b.limit());
                        buf.putInt(13);
                        buf.putInt(0);
                        buf.putLong(b.limit());
                        buf.put(b);
                    }
                }
                nbuf += vxr1.numEntries;
            }
        }
        return buf;
    }

    int getBlockingFactor() {
        int n = -1;
        for (int i = 0; i < this.points.size(); ++i) {
            int p = this.points.get(i);
            if (p <= n) continue;
            n = p;
        }
        return n;
    }

    public ByteBuffer addJavaArray(Object data, int dataType, boolean relax) throws Throwable {
        boolean ok;
        ArrayAttribute aa = new ArrayAttribute(data);
        Class<?> cl = aa.getType();
        CDFDataType ctype = SupportedTypes.cdfType(dataType);
        if (ctype == null) {
            throw new Throwable("Internal error.");
        }
        if (cl == Long.TYPE) {
            LongArray la = new LongArray(data, this.rowMajority);
            boolean bl = ok = ctype == CDFDataType.INT8 || ctype == CDFDataType.TT2000;
            if (ok) {
                return la.buffer();
            }
            if (ctype == CDFDataType.UINT4) {
                return la.buffer(Integer.TYPE);
            }
        }
        if (cl == Double.TYPE) {
            DoubleArray da = new DoubleArray(data, this.rowMajority);
            boolean bl = ok = ctype == CDFDataType.DOUBLE || ctype == CDFDataType.EPOCH || ctype == CDFDataType.EPOCH16;
            if (ok) {
                return da.buffer();
            }
            if (ctype == CDFDataType.FLOAT) {
                return da.buffer(Float.TYPE);
            }
        }
        if (cl == Float.TYPE) {
            FloatArray fa = new FloatArray(data, this.rowMajority);
            if (ctype == CDFDataType.FLOAT) {
                return fa.buffer();
            }
        }
        if (cl == Integer.TYPE) {
            IntArray ia = new IntArray(data, this.rowMajority);
            if (ctype == CDFDataType.INT4) {
                return ia.buffer();
            }
            if (ctype == CDFDataType.UINT2) {
                return ia.buffer(Short.TYPE);
            }
            if (relax && ctype == CDFDataType.UINT4) {
                return ia.buffer();
            }
        }
        if (cl == Short.TYPE) {
            ShortArray sa = new ShortArray(data, this.rowMajority);
            if (ctype == CDFDataType.INT2) {
                return sa.buffer();
            }
            if (ctype == CDFDataType.UINT1) {
                return sa.buffer(Byte.TYPE);
            }
            if (relax & ctype == CDFDataType.UINT2) {
                return sa.buffer();
            }
        }
        if (cl == Byte.TYPE) {
            ByteArray ba = new ByteArray(data, this.rowMajority);
            if (ctype == CDFDataType.INT1) {
                return ba.buffer();
            }
            if (relax & ctype == CDFDataType.UINT1) {
                return ba.buffer();
            }
        }
        if (cl == String.class) {
            StringArray st = new StringArray(data, this.rowMajority);
            if (ctype == CDFDataType.CHAR) {
                return st.buffer(this.vdr.numElems);
            }
        }
        return null;
    }

    int getLastRecord() {
        return this.getLastRecord(this.lastRecords.size() - 1);
    }

    int getLastRecord(int start) {
        int n = start;
        if (n < 0) {
            return -1;
        }
        while (n >= 0) {
            int l = this.lastRecords.get(n);
            if (l >= 0) {
                return l;
            }
            --n;
        }
        return -1;
    }

    boolean timeOrderOK(Object nextTime) {
        int last = this.bufs.size() - 1;
        if (last < 0) {
            return true;
        }
        ByteBuffer buf = null;
        while ((buf = this.bufs.get(last)) == null && last != 0) {
            --last;
        }
        if (buf == null) {
            return true;
        }
        if (CDFTimeType.TT2000.getValue() == this.vdr.dataType) {
            return ((long[])nextTime)[0] > buf.getLong(buf.limit());
        }
        if (CDFTimeType.EPOCH16.getValue() == this.vdr.dataType) {
            double[] next = (double[])nextTime;
            double[] e16 = new double[]{buf.getDouble(buf.limit() - 16), buf.getDouble(buf.limit() - 8)};
            if (next[0] > e16[0]) {
                return true;
            }
            if (next[0] < e16[0]) {
                return false;
            }
            return next[1] > e16[1];
        }
        double[] next = (double[])nextTime;
        return next[0] > buf.getDouble(buf.limit() - 8);
    }

    public void update(FileChannel channel) throws IOException {
        channel.position(this.position);
        channel.write(this.vdr.get());
        if (this.vdr.isCompressed()) {
            channel.write(this.cpr.get());
        }
        if (this._bufs == null) {
            return;
        }
        int nbuf = 0;
        ByteBuffer longbuf = ByteBuffer.allocate(8);
        ByteBuffer intbuf = ByteBuffer.allocate(4);
        if (this._bufs.size() > 0) {
            for (VXR vxr1 : this.vxrs) {
                int n;
                int e;
                channel.write(vxr1.get());
                for (e = 0; e < vxr1.numEntries; ++e) {
                    n = this._firstRecords.get(nbuf + e);
                    this.writeInt(channel, intbuf, n);
                }
                for (e = 0; e < vxr1.numEntries; ++e) {
                    n = this._lastRecords.get(nbuf + e);
                    this.writeInt(channel, intbuf, n);
                }
                for (e = 0; e < vxr1.numEntries; ++e) {
                    this.writeLong(channel, longbuf, this.locs[nbuf + e]);
                }
                if (!this.vdr.isCompressed()) {
                    for (e = 0; e < vxr1.numEntries; ++e) {
                        this.writeLong(channel, longbuf, 12 + this._bufs.get(nbuf + e).limit());
                        this.writeInt(channel, intbuf, 7);
                        channel.write(this._bufs.get(nbuf + e));
                    }
                } else {
                    for (e = 0; e < vxr1.numEntries; ++e) {
                        ByteBuffer b = this._bufs.get(nbuf + e);
                        this.writeLong(channel, longbuf, 24 + b.limit());
                        this.writeInt(channel, intbuf, 13);
                        this.writeInt(channel, intbuf, 0);
                        this.writeLong(channel, longbuf, b.limit());
                        channel.write(b);
                    }
                }
                nbuf += vxr1.numEntries;
            }
        }
    }

    void writeInt(FileChannel ch, ByteBuffer buf, int value) throws IOException {
        buf.position(0);
        buf.putInt(value);
        buf.position(0);
        ch.write(buf);
    }

    void writeLong(FileChannel ch, ByteBuffer buf, long value) throws IOException {
        buf.position(0);
        buf.putLong(value);
        buf.position(0);
        ch.write(buf);
    }
}

