/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdf;

import gov.nasa.gsfc.spdf.cdfj.CDFReader;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.cdf.CdfDataSource;
import org.autoplot.cdf.CdfJavaDataSourceEditorPanel;
import org.autoplot.cdf.CdfUtil;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.URISplit;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class CdfJavaDataSourceFactory
extends AbstractDataSourceFactory
implements DataSourceFactory {
    private static final Logger logger = Logger.getLogger("apdss.cdf");

    public DataSource getDataSource(URI uri) throws Exception {
        return new CdfDataSource(uri);
    }

    public String editPanel(String surl) throws Exception {
        return surl;
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        if (cc.context.equals(CompletionContext.CONTEXT_PARAMETER_NAME)) {
            logger.log(Level.FINE, "getCompletions {0}", cc.resourceURI);
            File cdfFile = DataSetURI.getFile((URI)cc.resourceURI, (ProgressMonitor)mon);
            String fileName = cdfFile.toString();
            logger.log(Level.FINEST, "opening cdf file {0}", fileName);
            CDFReader cdf = CdfDataSource.getCdfFile(fileName);
            logger.finest("inspect cdf for plottable parameters");
            Map<String, String> result = CdfUtil.getPlottable(cdf, false, 4);
            logger.finest("close cdf");
            ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
            for (Map.Entry<String, String> e : result.entrySet()) {
                String key = e.getKey();
                CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, key, (DataSourceFactory)this, "arg_0", e.getValue(), null, true);
                ccresult.add(cc1);
            }
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "interpMeta=", "control interpretation of metadata"));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "replaceLabels=", "use DEPEND data to label channels"));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "doDep=", "control dependencies between variables"));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "where=", "only return variables where the condition is true"));
            ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "loadErrors=", "load errors as well."));
            ccresult.addAll(super.getCompletions(cc, (ProgressMonitor)new NullProgressMonitor()));
            return ccresult;
        }
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String parmname = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc);
            if (parmname.equals("id")) {
                String file = CompletionContext.get((Object)CompletionContext.CONTEXT_FILE, (CompletionContext)cc);
                File cdfFile = DataSetURI.getFile((URL)DataSetURI.getURL((String)file), (ProgressMonitor)mon);
                DataSetURI.checkLength((File)cdfFile);
                String fileName = cdfFile.toString();
                CDFReader cdf = CdfDataSource.getCdfFile(fileName);
                Map<String, String> result = CdfUtil.getPlottable(cdf, false, 4);
                ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
                for (Map.Entry<String, String> ent : result.entrySet()) {
                    String key = ent.getKey();
                    CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, key, (DataSourceFactory)this, null, key, ent.getValue(), true);
                    ccresult.add(cc1);
                }
                return ccresult;
            }
            if (parmname.equals("interpMeta")) {
                return Arrays.asList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "yes", "use metadata (default)"), new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "no", "inhibit use of metadata"));
            }
            if (parmname.equals("doDep")) {
                return Arrays.asList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "yes", "use dependency tags (default)"), new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "no", "inhibit use of dependency tags"));
            }
            if (parmname.equals("replaceLabels")) {
                return Arrays.asList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "T", "use DEPEND data for labels"), new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "F", "normal behavior uses LABL_PTR (default)"));
            }
            if (parmname.equals("loadErrors")) {
                return Arrays.asList(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "T", "use DELTA_MINUS_VAR and DELTA_PLUS_VAR for errors"), new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "F", "do not show errors, even if available (default)"));
            }
            if (parmname.equals("where")) {
                ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
                if (cc.completable.contains(".")) {
                    int i = cc.completable.lastIndexOf(".");
                    String s = cc.completable.substring(0, i);
                    if (s.length() > 0) {
                        ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s + ".eq(0)"));
                        ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s + ".ne(0)"));
                        ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s + ".gt(0)"));
                        ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s + ".lt(0)"));
                        ccresult.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, s + ".within(0+to+10)"));
                    }
                } else {
                    String file = CompletionContext.get((Object)CompletionContext.CONTEXT_FILE, (CompletionContext)cc);
                    File cdfFile = DataSetURI.getFile((URL)DataSetURI.getURL((String)file), (ProgressMonitor)mon);
                    DataSetURI.checkLength((File)cdfFile);
                    String fileName = cdfFile.toString();
                    CDFReader cdf = CdfDataSource.getCdfFile(fileName);
                    Map<String, String> result = CdfUtil.getPlottable(cdf, false, 2);
                    for (Map.Entry<String, String> e : result.entrySet()) {
                        String key = e.getKey();
                        CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, key + ".eq(0)", (DataSourceFactory)this, null, key + ".eq(0)", e.getValue(), true);
                        ccresult.add(cc1);
                    }
                }
                return ccresult;
            }
            if (parmname.equals("X")) {
                String file = CompletionContext.get((Object)CompletionContext.CONTEXT_FILE, (CompletionContext)cc);
                File cdfFile = DataSetURI.getFile((URL)DataSetURI.getURL((String)file), (ProgressMonitor)mon);
                DataSetURI.checkLength((File)cdfFile);
                String fileName = cdfFile.toString();
                CDFReader cdf = CdfDataSource.getCdfFile(fileName);
                LinkedHashMap pp = URISplit.parseParams((String)cc.params);
                String param0 = (String)pp.get("arg_0");
                LinkedHashMap<String, CdfUtil.CdfVariableDescription> cdfParameterInfo = CdfUtil.getPlottable(cdf, null);
                LinkedHashMap<String, CdfUtil.CdfVariableDescription> compatible = CdfJavaDataSourceEditorPanel.getCompatible(cdfParameterInfo, param0, param0.trim().length() > 0 ? "X_PARAMETER" : "");
                ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
                for (Map.Entry<String, CdfUtil.CdfVariableDescription> ent : compatible.entrySet()) {
                    String key = ent.getKey();
                    CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, key, (DataSourceFactory)this, null, key, ent.getValue().description, true);
                    ccresult.add(cc1);
                }
                return ccresult;
            }
            if (parmname.equals("Y")) {
                String file = CompletionContext.get((Object)CompletionContext.CONTEXT_FILE, (CompletionContext)cc);
                File cdfFile = DataSetURI.getFile((URL)DataSetURI.getURL((String)file), (ProgressMonitor)mon);
                DataSetURI.checkLength((File)cdfFile);
                String fileName = cdfFile.toString();
                LinkedHashMap pp = URISplit.parseParams((String)cc.params);
                String param0 = (String)pp.get("arg_0");
                CDFReader cdf = CdfDataSource.getCdfFile(fileName);
                LinkedHashMap<String, CdfUtil.CdfVariableDescription> cdfParameterInfo = CdfUtil.getPlottable(cdf, null);
                LinkedHashMap<String, CdfUtil.CdfVariableDescription> compatible = CdfJavaDataSourceEditorPanel.getCompatible(cdfParameterInfo, param0, param0.trim().length() > 0 ? "Y_PARAMETER" : "");
                ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
                for (Map.Entry<String, CdfUtil.CdfVariableDescription> ent : compatible.entrySet()) {
                    String key = ent.getKey();
                    CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, key, (DataSourceFactory)this, null, key, ent.getValue().description, true);
                    ccresult.add(cc1);
                }
                return ccresult;
            }
            return super.getCompletions(cc, mon);
        }
        return Collections.emptyList();
    }

    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        try {
            File file;
            if (!surl.contains("?") || surl.indexOf("?") == surl.length() - 1) {
                return true;
            }
            URISplit split = URISplit.parse((String)surl);
            LinkedHashMap args = URISplit.parseParams((String)split.params);
            String param = (String)args.get("arg_0");
            if (param == null && (param = (String)args.get("id")) == null) {
                return true;
            }
            String slice1 = (String)args.get("slice1");
            if (slice1 != null) {
                try {
                    Integer.parseInt(slice1);
                }
                catch (NumberFormatException ex) {
                    problems.add("misformatted slice");
                    return true;
                }
            }
            if (!(file = DataSetURI.getFile((URI)split.resourceUri, (ProgressMonitor)mon)).isFile()) {
                return true;
            }
            CDFReader cdf = CdfDataSource.getCdfFile(file.getPath());
            Map<String, String> result = CdfUtil.getPlottable(cdf, false, 4);
            int i = param.indexOf("[");
            if (i > -1) {
                param = param.substring(0, i);
            }
            if (param.contains(";")) {
                String[] ss = param.split(";", -2);
                boolean reject = false;
                for (String s : ss) {
                    if (result.containsKey(s)) continue;
                    reject = true;
                }
                return reject;
            }
            return !result.containsKey(param);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, surl, ex);
            return false;
        }
    }

    public String getDescription() {
        return "NASA Common Data Format files";
    }
}

