/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.imagedatasource;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.imagedatasource.ImageDataSource;
import org.das2.util.ImageUtil;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONObject;

public class ImageDataSourceFactory
extends AbstractDataSourceFactory
implements DataSourceFactory {
    public DataSource getDataSource(URI uri) throws Exception {
        return new ImageDataSource(uri);
    }

    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "channel=", "channel to extract"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "rotate=", "rotate image clockwise in degrees.  Image size is not affected"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "blur=", "apply boxcar blur square kernel"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "fog=", "apply overlapping white translucent fog percent opaque"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "xaxis=", "apply a linear transform to label each column of the image [valmin,pixmin,valmax,pixmax]"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "yaxis=", "apply a linear transform to label each row of the image [valmin,pixmin,valmax,pixmax]"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "plotInfo=", "read the rich png metadata to get axes.  https://autoplot.org/richPng"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "plotInfoFile=", "load rich png metadata from JSON file.  https://autoplot.org/richPng"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "clip=", "clip to the plot bounds inferred by plotInfo, xaxis and yaxis switches."));
        } else if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String paramName;
            switch (paramName = CompletionContext.get((Object)CompletionContext.CONTEXT_PARAMETER_NAME, (CompletionContext)cc)) {
                case "channel": {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "red"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "green"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "blue"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "alpha"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "greyscale"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "hue"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "saturation"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "value"));
                    break;
                }
                case "rotate": {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "0", "rotate image clockwise in degrees"));
                    break;
                }
                case "blur": {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "5", "apply boxcar blur square kernel"));
                    break;
                }
                case "fog": {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "100", "apply fog with this opacity percent, based on 0,0 color"));
                    break;
                }
                case "xaxis": {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "[<valmin>,<pixmin>,<valmax>,<pixmax>]", "add labels for each bin"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "[<valmin>,<pixmin>,<valmax>,<pixmax>,log]", "add labels for each bin"));
                    break;
                }
                case "yaxis": {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "[<valmin>,<pixmin>,<valmax>,<pixmax>]", "add labels for each bin"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "[<valmin>,<pixmin>,<valmax>,<pixmax>,log]", "add labels for each bin"));
                    break;
                }
                case "plotInfo": {
                    File imageFile = DataSetURI.getFile((URI)cc.resourceURI, (ProgressMonitor)mon);
                    String json = ImageUtil.getJSONMetadata((File)imageFile);
                    if (json == null) break;
                    JSONObject jo = new JSONObject(json);
                    JSONArray plots = jo.getJSONArray("plots");
                    for (int i = 0; i < plots.length(); ++i) {
                        JSONObject plot = plots.getJSONObject(i);
                        result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, String.valueOf(i), String.valueOf(i) + ": " + plot.getString("title"), "read the rich png metadata to get axes for the plot"));
                    }
                    break;
                }
                case "plotInfoFile": {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<jsonFile>", "file, relative to image, containing richPNG metadata"));
                    break;
                }
                case "clip": {
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "T", "clip to the axes in plotInfo or xaxis and yaxis"));
                    result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "F", "don't clip"));
                    break;
                }
            }
        }
        return result;
    }

    public String getDescription() {
        return "Image Formats";
    }
}

