/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d;

import ProGAL.geom2d.Circle;
import ProGAL.geom2d.Point;
import ProGAL.math.Matrix;

public class ApolloniusSolver {
    public static Circle solveApollonius(Circle c1, Circle c2, Circle c3, int s1, int s2, int s3) {
        Point[] centers = new Point[]{c1.center, c2.center, c3.center};
        double[] radii = new double[]{c1.radius, c2.radius, c3.radius};
        int[] s = new int[]{s1, s2, s3};
        return ApolloniusSolver.solveApollonius(centers, radii, s);
    }

    private static Circle solveApollonius(Point[] centers, double[] radii, int[] s) {
        Matrix A = new Matrix(2, 4);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                A.set(i, j, 2.0 * (centers[i + 1].get(j) - centers[0].get(j)));
            }
            A.set(i, 2, 2.0 * ((double)s[0] * radii[0] - (double)s[i + 1] * radii[i + 1]));
            double sum = 0.0;
            for (int j = 0; j < 2; ++j) {
                sum += centers[i + 1].get(j) * centers[i + 1].get(j) - centers[0].get(j) * centers[0].get(j);
            }
            A.set(i, 3, sum += radii[0] * radii[0] - radii[i + 1] * radii[i + 1]);
        }
        A.reduceThis();
        double M = A.get(0, 3);
        double N = -A.get(0, 2);
        double P = A.get(1, 3);
        double Q = -A.get(1, 2);
        double a = N * N + Q * Q - 1.0;
        double b = 2.0 * ((M - centers[0].get(0)) * N + (P - centers[0].get(1)) * Q + (double)s[0] * radii[0]);
        double c = (M - centers[0].get(0)) * (M - centers[0].get(0)) + (P - centers[0].get(1)) * (P - centers[0].get(1)) - radii[0] * radii[0];
        double r_s = (-b + Math.signum(a) * Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
        double x_s = M + N * r_s;
        double y_s = P + Q * r_s;
        return new Circle(new Point(x_s, y_s), r_s);
    }
}

