/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom2d;

import ProGAL.dataStructures.SortToolPoint2dAroundPoint;
import ProGAL.dataStructures.Sorter;
import ProGAL.dataStructures.SorterQuick;
import ProGAL.geom2d.LineSegment;
import ProGAL.geom2d.Point;
import ProGAL.geom2d.PointSet;
import ProGAL.geom2d.Polygon;
import ProGAL.geom2d.Vector;

public class ConvexPolygon
extends Polygon {
    private static final long serialVersionUID = 1L;

    public ConvexPolygon() {
    }

    public ConvexPolygon(Polygon pol) {
        int i = pol.leftExtremePointIndx();
        int n = pol.size();
        int k = (i + n - 1) % n;
        this.add(pol.get(k));
        this.add(pol.get(i));
        this.add(pol.get((i + 1) % n));
        int j = (i + 2) % n;
        while (j != k) {
            Point p = (Point)pol.get(j);
            if (this.contains(p)) {
                ++j;
            } else {
                while (!Point.rightTurn(p, (Point)this.get(this.size() - 1), (Point)this.get(this.size() - 2))) {
                    this.deleteLast();
                }
            }
            this.add(p);
            j = (j + 1) % n;
        }
    }

    public ConvexPolygon(Point p0, Point p1, Point p2) {
        super(p0, p1, p2);
    }

    public ConvexPolygon(PointSet points, ConvexHullAlgorithm algorithm) {
        switch (algorithm) {
            case JarvisMarch: {
                Point p;
                Point r = p = points.leftExtremePoint();
                do {
                    r = points.getNextExtremePoint(r);
                    this.add(r);
                } while (r != p);
                break;
            }
            case GrahamsScan: {
                SorterQuick sort = new SorterQuick();
                ((Sorter)sort).Sort(points, new SortToolPoint2dAroundPoint(points.getCentroid()), false);
                Polygon pol = new Polygon(points);
                int indx = pol.leftExtremePointIndx();
                int k1 = (indx + pol.size() - 1) % pol.size();
                int k2 = indx;
                int k3 = (indx + 1) % pol.size();
                boolean back = true;
                while (k2 != indx || back) {
                    if (Point.leftTurn((Point)pol.get(k1), (Point)pol.get(k2), (Point)pol.get(k3))) {
                        k1 = k2;
                        k2 = k3;
                        k3 = (k2 + 1) % pol.size();
                        back = false;
                        continue;
                    }
                    pol.remove(k2);
                    if (k2 < indx) {
                        --indx;
                    }
                    k1 = k1 == 0 ? pol.size() - 1 : (k1 == pol.size() ? (k1 -= 2) : --k1);
                    k2 = (k1 + 1) % pol.size();
                    k3 = (k2 + 1) % pol.size();
                    back = true;
                }
                for (Point q : pol) {
                    this.add(q);
                }
                break;
            }
        }
    }

    @Override
    public boolean contains(Point p) {
        for (int i = 0; i < this.size() - 1; ++i) {
            if (!Point.rightTurn((Point)this.get(i), (Point)this.get(i + 1), p)) continue;
            return false;
        }
        return Point.leftTurn((Point)this.get(this.size() - 1), (Point)this.get(0), p);
    }

    public LineSegment getDiameter() {
        int j;
        int i;
        int n = this.size();
        int iStart = i = this.leftExtremePointIndx();
        int iNext = i + 1 == n ? 0 : i + 1;
        Vector vi = new Vector((Point)this.get(i), (Point)this.get(iNext));
        int jStart = j = this.rightExtremePointIndx();
        int jNext = j + 1 == n ? 0 : j + 1;
        Vector vj = new Vector((Point)this.get(jNext), (Point)this.get(j));
        LineSegment seg = new LineSegment((Point)this.get(i), (Point)this.get(j));
        LineSegment diameter = seg.clone();
        double diamLength = seg.getSquaredLength();
        do {
            if (Vector.rightTurn(vi, vj)) {
                j = jNext;
                jNext = j + 1 == n ? 0 : j + 1;
                vj = new Vector((Point)this.get(jNext), (Point)this.get(j));
                seg.setB((Point)this.get(j));
            } else {
                i = iNext;
                iNext = i + 1 == n ? 0 : i + 1;
                vi = new Vector((Point)this.get(i), (Point)this.get(iNext));
                seg.setA((Point)this.get(i));
            }
            double lng = seg.getSquaredLength();
            if (!(lng > diamLength)) continue;
            diameter = seg.clone();
            diamLength = lng;
        } while (i != jStart || j != iStart);
        return diameter;
    }

    public double[][] beamDetector() {
        int n = this.size();
        double[][] bp = new double[n][n];
        int[][] p = new int[n][n];
        for (int k = 0; k < n; ++k) {
            bp[k][(k + 1) % n] = 0.0;
            p[k][(k + 1) % n] = k;
        }
        for (int l = 2; l < n; ++l) {
            for (int i = 0; i < n; ++i) {
                int j = (i + l) % n;
                LineSegment seg = new LineSegment((Point)this.get(i), (Point)this.get(j));
                bp[i][j] = 9.99999999E7;
                int k = i;
                while (k != j) {
                    double length = bp[i][k = (k + 1) % n] + bp[k][j] + ((Point)this.get(k)).getDistance(seg);
                    if (!(bp[i][j] > length)) continue;
                    p[i][j] = k;
                    bp[i][j] = length;
                }
            }
        }
        return bp;
    }

    public int farthestVertex(int p, int r) {
        int n = this.size();
        LineSegment seg = new LineSegment((Point)this.get(p), (Point)this.get(r));
        double dist = 0.0;
        int q = -1;
        int i = (p + 1) % n;
        while (i != r) {
            double d = ((Point)this.get(i)).getSquaredDistance(seg);
            if (d > dist) {
                dist = d;
                q = i;
            }
            i = (i + 1) % n;
        }
        return q;
    }

    public static enum ConvexHullAlgorithm {
        JarvisMarch,
        GrahamsScan;

    }
}

