/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.kineticDelaunay;

import ProGAL.dataStructures.Heap;
import ProGAL.dataStructures.SortTool;
import ProGAL.geom3d.Circle;
import ProGAL.geom3d.Line;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.Vector;
import ProGAL.geom3d.kineticDelaunay.Edge;
import ProGAL.geom3d.kineticDelaunay.EdgePoints;
import ProGAL.geom3d.kineticDelaunay.KineticToolbox;
import ProGAL.geom3d.kineticDelaunay.Tet;
import ProGAL.geom3d.kineticDelaunay.Tri;
import ProGAL.geom3d.kineticDelaunay.TrianglePoints;
import ProGAL.geom3d.kineticDelaunay.Vertex;
import ProGAL.geom3d.volumes.Sphere;
import ProGAL.geom3d.volumes.Tetrahedron;
import ProGAL.geom3d.volumes.Torus;
import ProGAL.math.Constants;
import ProGAL.math.Functions;
import ProGAL.math.Matrix;
import ProGAL.math.Trigonometry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class KineticAlphaComplex {
    private List<Vertex> vertices = new ArrayList<Vertex>();
    private Set<Tet> tets = new HashSet<Tet>();
    private Map<TrianglePoints, Tri> mapTris = new HashMap<TrianglePoints, Tri>();
    private Map<EdgePoints, Edge> mapEdges = new HashMap<EdgePoints, Edge>();
    private Set<Edge> alphaEdges = new HashSet<Edge>();
    private Set<Tri> alphaTris = new HashSet<Tri>();
    private Set<Tet> alphaTets = new HashSet<Tet>();
    private final double alphaVal;
    public int nrFlips = 0;
    private boolean clashFirst = false;
    private boolean clash = false;
    private List<Double> clashes = new ArrayList<Double>();
    private double shortestEdge = Double.POSITIVE_INFINITY;
    public double error = 0.0;
    public double maxError = 0.0;
    public int nrErrors = 0;
    public double numericalTime = 0.0;
    public double analyticalTime = 0.0;
    public double flipTime = 0.0;
    private Tet lastTet;
    private Double[] angles = new Double[4];
    private double angleTotal = 0.0;
    private double angleLimit = Constants.TAU;
    private Vector rotationAxis;
    private Set<Integer> rotIndx = new HashSet<Integer>();
    private Heap heap = new Heap(this.vertices.size(), (SortTool)new SortToolHeapItems());
    private boolean testingPrint = false;

    public KineticAlphaComplex(List<Point> points, double alpha) {
        Tetrahedron bigT = Tetrahedron.regularTetrahedron();
        bigT.blowUp(1000.0);
        this.lastTet = new Tet(bigT);
        for (int i = 0; i < 4; ++i) {
            this.vertices.add(this.lastTet.getCorner(i));
        }
        for (Point p : points) {
            this.insertPoint(p);
        }
        this.alphaVal = alpha;
        for (Tet tet : this.tets) {
            for (int i = 0; i < 4; ++i) {
                tet.getCorner(i).setTet(tet);
            }
        }
        this.initializeAlphaComplex();
    }

    private void addToHeap(Double[] angles, Tet t, Tet nt) {
        this.heap.insert(new HeapItem(angles, t, nt, null, null));
    }

    private void addToHeap(Double[] angles, Tet t) {
        HeapItem newItem = new HeapItem(angles, t, null, null, null);
        this.heap.insert(newItem);
    }

    private void addToHeap(Double[] angles, Tri t) {
        this.heap.insert(new HeapItem(angles, null, null, t, null));
    }

    private void addToHeap(Double[] angles, Edge e) {
        this.heap.insert(new HeapItem(angles, null, null, null, e));
    }

    public int getNrVertices() {
        return this.vertices.size() - 4;
    }

    public Vector getRotationAxis() {
        return this.rotationAxis;
    }

    public Tet[] getTetrahedra(Vertex v, Tet tet) {
        int indxV = tet.indexOf(v);
        Tet[] nTet = new Tet[3];
        for (int i = 0; i < 3; ++i) {
            nTet[i] = tet.neighbors[(indxV + i + 1) / 3];
        }
        return nTet;
    }

    public Tet getTetrahedron(Vertex v) {
        for (Tet tet : this.tets) {
            if (!tet.hasVertex(v)) continue;
            return tet;
        }
        return null;
    }

    private void insertPoint(Point p) {
        Vertex v = new Vertex(p);
        this.vertices.add(v);
        Tet c = this.walk(p);
        LinkedList<Tet> newTets = new LinkedList<Tet>();
        HashSet<Tet> processed = new HashSet<Tet>();
        processed.add(null);
        Stack<Tet> fringe = new Stack<Tet>();
        fringe.add(c);
        while (!fringe.isEmpty()) {
            c = (Tet)fringe.pop();
            if (processed.contains(c)) continue;
            for (int f = 0; f < 4; ++f) {
                Tet neigh = c.neighbors[f];
                if (neigh == null || !neigh.insideCircumsphere(p)) {
                    Vertex[] corners = new Vertex[4];
                    corners[3] = v;
                    for (int i = 1; i < 4; ++i) {
                        corners[i - 1] = c.getCorner((f + i) % 4);
                    }
                    Tet newTet = new Tet(corners);
                    newTet.neighbors[3] = neigh;
                    if (neigh != null) {
                        neigh.neighbors[neigh.apex((Tet)c)] = newTet;
                    }
                    newTets.add(newTet);
                    continue;
                }
                if (processed.contains(neigh)) continue;
                fringe.add(neigh);
            }
            processed.add(c);
            this.tets.remove(c);
        }
        this.lastTet = (Tet)newTets.get(0);
        this.restoreNeighborhood(newTets);
        this.tets.addAll(newTets);
    }

    private void initializeRadiusEvents() {
        for (Tet T : this.tets) {
            this.angles = this.getRoot(T.getCorner(0), T.getCorner(1), T.getCorner(2), T.getCorner(3), T.getCount());
            if (this.angles != null && this.angles[0] < this.angleLimit) {
                this.addToHeap(this.angles, T);
            }
            for (Tri t : T.getListOfTris()) {
                this.angles = this.getRoot(t.getCorner(0), t.getCorner(1), t.getCorner(2), t.getCount());
                if (this.angles == null || !(this.angles[0] < this.angleLimit)) continue;
                this.addToHeap(this.angles, t);
            }
            for (Edge e : T.getEdges()) {
                this.angles = this.getRoot(e.getCorner(0), e.getCorner(1), e.getCount());
                if (this.angles == null || !(this.angles[0] < this.angleLimit)) continue;
                this.addToHeap(this.angles, e);
            }
        }
    }

    private boolean isGabriel(Edge e) {
        Sphere s = new Sphere(Point.getMidpoint(e.getCorner(0), e.getCorner(1)), e.getCircumRadius());
        for (Point point : this.vertices) {
            if (e.hasVertex(new Vertex(point)) || !s.contains(point)) continue;
            return false;
        }
        return true;
    }

    private boolean isGabriel(Tri t) {
        Sphere s = new Sphere(new Circle((Point)t.getCorner(0), (Point)t.getCorner(1), t.getCorner(2)).getCenter(), t.getCircumRadius());
        for (Point point : this.vertices) {
            if (t.hasVertex(new Vertex(point)) || !s.contains(point)) continue;
            return false;
        }
        return true;
    }

    private void initializeAlphaComplex() {
        for (Tet t : this.tets) {
            Double[] angles;
            Edge tmp;
            if (!t.isAlive()) continue;
            Vertex v0 = t.getCorner(0);
            Vertex v1 = t.getCorner(1);
            Vertex v2 = t.getCorner(2);
            Vertex v3 = t.getCorner(3);
            int count = t.getCount();
            int idxR0 = -1;
            int idxR1 = -1;
            int idxS0 = -1;
            int idxS1 = -1;
            int idxS2 = -1;
            int idxS3 = -1;
            if (count == 8 || count == 7) {
                idxR0 = 3;
                idxS0 = 0;
                idxS1 = 1;
                idxS2 = 2;
            } else if (count == 4 || count == 11) {
                idxR0 = 2;
                idxS0 = 0;
                idxS1 = 1;
                idxS2 = 3;
            } else if (count == 2 || count == 13) {
                idxR0 = 1;
                idxS0 = 0;
                idxS1 = 2;
                idxS2 = 3;
            } else if (count == 1 || count == 14) {
                idxR0 = 0;
                idxS0 = 1;
                idxS1 = 2;
                idxS2 = 3;
            } else if (count == 3) {
                idxR0 = 0;
                idxR1 = 1;
                idxS0 = 2;
                idxS1 = 3;
            } else if (count == 6) {
                idxR0 = 1;
                idxR1 = 2;
                idxS0 = 0;
                idxS1 = 3;
            } else if (count == 12) {
                idxR0 = 2;
                idxR1 = 3;
                idxS0 = 0;
                idxS1 = 1;
            } else if (count == 9) {
                idxR0 = 0;
                idxR1 = 3;
                idxS0 = 1;
                idxS1 = 2;
            } else if (count == 5) {
                idxR0 = 0;
                idxR1 = 2;
                idxS0 = 1;
                idxS1 = 3;
            } else if (count == 0 || count == 15) {
                idxS0 = 0;
                idxS1 = 1;
                idxS2 = 2;
                idxS3 = 3;
            } else if (count == 10) {
                idxR0 = 1;
                idxR1 = 3;
                idxS0 = 0;
                idxS1 = 2;
            }
            if (count == 0 || count == 15) {
                this.noRotate(t, t.getCorner(idxS0), t.getCorner(idxS1), t.getCorner(idxS2), t.getCorner(idxS3));
            }
            if (count == 1 || count == 2 || count == 4 || count == 8 || count == 7 || count == 11 || count == 13 || count == 14) {
                this.oneRotate(t, t.getCorner(idxS0), t.getCorner(idxS1), t.getCorner(idxS2), t.getCorner(idxR0));
            }
            if (count == 3 || count == 6 || count == 12 || count == 9 || count == 5 || count == 10) {
                this.twoRotate(t, t.getCorner(idxS0), t.getCorner(idxS1), t.getCorner(idxR0), t.getCorner(idxR1));
            }
            if (!this.mapEdges.containsKey(new EdgePoints(v0, v1))) {
                tmp = new Edge(v0, v1);
                if (tmp.getLength() < this.shortestEdge) {
                    this.shortestEdge = tmp.getLength();
                }
                this.mapEdges.put(new EdgePoints(v0, v1), tmp);
                t.setEdge(tmp);
                if (tmp.isAlpha(this.alphaVal)) {
                    tmp.setAlph(true);
                    if (this.isGabriel(tmp)) {
                        this.alphaEdges.add(tmp);
                    }
                }
                if ((angles = this.getRoot(v0, v1, tmp.getCount())) != null && angles[0] < this.angleLimit) {
                    this.addToHeap(angles, tmp);
                }
            } else {
                t.setEdge(this.mapEdges.get(new EdgePoints(v0, v1)));
            }
            if (!this.mapEdges.containsKey(new EdgePoints(v0, v2))) {
                tmp = new Edge(v0, v2);
                if (tmp.getLength() < this.shortestEdge) {
                    this.shortestEdge = tmp.getLength();
                }
                this.mapEdges.put(new EdgePoints(v0, v2), tmp);
                t.setEdge(tmp);
                if (tmp.isAlpha(this.alphaVal)) {
                    tmp.setAlph(true);
                    if (this.isGabriel(tmp)) {
                        this.alphaEdges.add(tmp);
                    }
                }
                if ((angles = this.getRoot(v0, v2, tmp.getCount())) != null && angles[0] < this.angleLimit) {
                    this.addToHeap(angles, tmp);
                }
            } else {
                t.setEdge(this.mapEdges.get(new EdgePoints(v0, v2)));
            }
            if (!this.mapEdges.containsKey(new EdgePoints(v0, v3))) {
                tmp = new Edge(v0, v3);
                if (tmp.getLength() < this.shortestEdge) {
                    this.shortestEdge = tmp.getLength();
                }
                this.mapEdges.put(new EdgePoints(v0, v3), tmp);
                t.setEdge(tmp);
                if (tmp.isAlpha(this.alphaVal)) {
                    tmp.setAlph(true);
                    if (this.isGabriel(tmp)) {
                        this.alphaEdges.add(tmp);
                    }
                }
                if ((angles = this.getRoot(v0, v3, tmp.getCount())) != null && angles[0] < this.angleLimit) {
                    this.addToHeap(angles, tmp);
                }
            } else {
                t.setEdge(this.mapEdges.get(new EdgePoints(v0, v3)));
            }
            if (!this.mapEdges.containsKey(new EdgePoints(v1, v2))) {
                tmp = new Edge(v1, v2);
                if (tmp.getLength() < this.shortestEdge) {
                    this.shortestEdge = tmp.getLength();
                }
                this.mapEdges.put(new EdgePoints(v1, v2), tmp);
                t.setEdge(tmp);
                if (tmp.isAlpha(this.alphaVal)) {
                    tmp.setAlph(true);
                    if (this.isGabriel(tmp)) {
                        this.alphaEdges.add(tmp);
                    }
                }
                if ((angles = this.getRoot(v1, v2, tmp.getCount())) != null && angles[0] < this.angleLimit) {
                    this.addToHeap(angles, tmp);
                }
            } else {
                t.setEdge(this.mapEdges.get(new EdgePoints(v1, v2)));
            }
            if (!this.mapEdges.containsKey(new EdgePoints(v1, v3))) {
                tmp = new Edge(v1, v3);
                if (tmp.getLength() < this.shortestEdge) {
                    this.shortestEdge = tmp.getLength();
                }
                this.mapEdges.put(new EdgePoints(v1, v3), tmp);
                t.setEdge(tmp);
                if (tmp.isAlpha(this.alphaVal)) {
                    tmp.setAlph(true);
                    if (this.isGabriel(tmp)) {
                        this.alphaEdges.add(tmp);
                    }
                }
                if ((angles = this.getRoot(v1, v3, tmp.getCount())) != null && angles[0] < this.angleLimit) {
                    this.addToHeap(angles, tmp);
                }
            } else {
                t.setEdge(this.mapEdges.get(new EdgePoints(v1, v3)));
            }
            if (!this.mapEdges.containsKey(new EdgePoints(v2, v3))) {
                tmp = new Edge(v2, v3);
                if (tmp.getLength() < this.shortestEdge) {
                    this.shortestEdge = tmp.getLength();
                }
                this.mapEdges.put(new EdgePoints(v2, v3), tmp);
                t.setEdge(tmp);
                if (tmp.isAlpha(this.alphaVal)) {
                    tmp.setAlph(true);
                    if (this.isGabriel(tmp)) {
                        this.alphaEdges.add(tmp);
                    }
                }
                if ((angles = this.getRoot(v2, v3, tmp.getCount())) == null || !(angles[0] < this.angleLimit)) continue;
                this.addToHeap(angles, tmp);
                continue;
            }
            t.setEdge(this.mapEdges.get(new EdgePoints(v2, v3)));
        }
    }

    private void noRotate(Tet t, Vertex s0, Vertex s1, Vertex s2, Vertex s3) {
        Tri tri;
        if (t.isAlpha(this.alphaVal)) {
            this.alphaTets.add(t);
            t.setAlph(1);
        }
        if (!this.mapTris.containsKey(new TrianglePoints(s0, s1, s2))) {
            tri = new Tri(s0, s1, s2);
            this.mapTris.put(new TrianglePoints(s0, s1, s2), tri);
            t.setTri(tri, t.indexOf(s3));
            if (tri.isAlpha(this.alphaVal)) {
                tri.setAlph(1);
                if (this.isGabriel(tri)) {
                    this.alphaTris.add(tri);
                }
            }
        } else {
            tri = this.mapTris.get(new TrianglePoints(s0, s1, s2));
            t.setTri(tri, t.indexOf(s3));
        }
        if (!this.mapTris.containsKey(new TrianglePoints(s0, s1, s3))) {
            tri = new Tri(s0, s1, s3);
            this.mapTris.put(new TrianglePoints(s0, s1, s3), tri);
            t.setTri(tri, t.indexOf(s2));
            if (tri.isAlpha(this.alphaVal)) {
                tri.setAlph(1);
                if (this.isGabriel(tri)) {
                    this.alphaTris.add(tri);
                }
            }
        } else {
            tri = this.mapTris.get(new TrianglePoints(s0, s1, s3));
            t.setTri(tri, t.indexOf(s2));
        }
        if (!this.mapTris.containsKey(new TrianglePoints(s1, s2, s3))) {
            tri = new Tri(s1, s2, s3);
            this.mapTris.put(new TrianglePoints(s1, s2, s3), tri);
            t.setTri(tri, t.indexOf(s0));
            if (tri.isAlpha(this.alphaVal)) {
                tri.setAlph(1);
                if (this.isGabriel(tri)) {
                    this.alphaTris.add(tri);
                }
            }
        } else {
            tri = this.mapTris.get(new TrianglePoints(s1, s2, s3));
            t.setTri(tri, t.indexOf(s0));
        }
        if (!this.mapTris.containsKey(new TrianglePoints(s0, s2, s3))) {
            tri = new Tri(s0, s2, s3);
            this.mapTris.put(new TrianglePoints(s0, s2, s3), tri);
            t.setTri(tri, t.indexOf(s1));
            if (tri.isAlpha(this.alphaVal)) {
                tri.setAlph(1);
                if (this.isGabriel(tri)) {
                    this.alphaTris.add(tri);
                }
            }
        } else {
            tri = this.mapTris.get(new TrianglePoints(s0, s2, s3));
            t.setTri(tri, t.indexOf(s1));
        }
    }

    private void oneRotate(Tet t, Vertex s0, Vertex s1, Vertex s2, Vertex r) {
        double dist;
        Circle C;
        Point center;
        Tri tri;
        double d0 = s0.distanceSquared(s1);
        double d1 = s1.distanceSquared(s2);
        double d2 = s2.distanceSquared(s0);
        double a0 = r.distanceSquared(s0);
        double a1 = r.distanceSquared(s1);
        double a2 = r.distanceSquared(s2);
        if (t.isAlpha(this.alphaVal)) {
            this.alphaTets.add(t);
            t.setAlph(1);
        } else if (a0 < d0 && a1 < d0 && a1 < d1 && a2 < d2 && a2 < d2 && a0 < d2) {
            t.setAlph(2);
        } else {
            t.setAlph(0);
        }
        this.angles = this.getRoot(t.getCorner(0), t.getCorner(1), t.getCorner(2), t.getCorner(3), t.getCount());
        if (this.angles != null && this.angles[0] < this.angleLimit) {
            this.addToHeap(this.angles, t);
        }
        if (!this.mapTris.containsKey(new TrianglePoints(s0, s1, s2))) {
            tri = new Tri(s0, s1, s2);
            this.mapTris.put(new TrianglePoints(s0, s1, s2), tri);
            t.setTri(tri, t.indexOf_slow(r));
            if (tri.isAlpha(this.alphaVal)) {
                tri.setAlph(1);
                if (this.isGabriel(tri)) {
                    this.alphaTris.add(tri);
                }
            }
        } else {
            tri = this.mapTris.get(new TrianglePoints(s0, s1, s2));
            t.setTri(tri, t.indexOf(r));
        }
        if (!this.mapTris.containsKey(new TrianglePoints(s0, s1, r))) {
            tri = new Tri(s0, s1, r);
            this.mapTris.put(new TrianglePoints(s0, s1, r), tri);
            t.setTri(tri, t.indexOf(s2));
            if (tri.isAlpha(this.alphaVal)) {
                tri.setAlph(1);
                if (this.isGabriel(tri)) {
                    this.alphaTris.add(tri);
                }
            } else {
                center = Point.getMidpoint(s0, s1);
                C = new Circle(center, this.alphaVal, center.vectorTo(s0));
                dist = C.getDistanceSquared(r);
                if (dist < this.alphaVal * this.alphaVal + Constants.EPSILON) {
                    tri.setAlph(2);
                } else {
                    tri.setAlph(0);
                }
            }
        } else {
            tri = this.mapTris.get(new TrianglePoints(s0, s1, r));
            t.setTri(tri, t.indexOf(s2));
        }
        if (!this.mapTris.containsKey(new TrianglePoints(s0, s2, r))) {
            tri = new Tri(s0, s2, r);
            this.mapTris.put(new TrianglePoints(s0, s2, r), tri);
            t.setTri(tri, t.indexOf(s1));
            if (tri.isAlpha(this.alphaVal)) {
                tri.setAlph(1);
                if (this.isGabriel(tri)) {
                    this.alphaTris.add(tri);
                }
            } else {
                center = Point.getMidpoint(s0, s2);
                C = new Circle(center, this.alphaVal, center.vectorTo(s0));
                dist = C.getDistanceSquared(r);
                if (dist < this.alphaVal * this.alphaVal + Constants.EPSILON) {
                    tri.setAlph(2);
                } else {
                    tri.setAlph(0);
                }
            }
        } else {
            tri = this.mapTris.get(new TrianglePoints(s0, s2, r));
            t.setTri(tri, t.indexOf(s1));
        }
        if (!this.mapTris.containsKey(new TrianglePoints(s1, s2, r))) {
            tri = new Tri(s1, s2, r);
            this.mapTris.put(new TrianglePoints(s1, s2, r), tri);
            t.setTri(tri, t.indexOf(s0));
            if (tri.isAlpha(this.alphaVal)) {
                tri.setAlph(1);
                if (this.isGabriel(tri)) {
                    this.alphaTris.add(tri);
                }
            } else {
                center = Point.getMidpoint(s1, s2);
                C = new Circle(center, this.alphaVal, center.vectorTo(s1));
                dist = C.getDistanceSquared(r);
                if (dist < this.alphaVal * this.alphaVal + Constants.EPSILON) {
                    tri.setAlph(2);
                } else {
                    tri.setAlph(0);
                }
            }
        } else {
            tri = this.mapTris.get(new TrianglePoints(s1, s2, r));
            t.setTri(tri, t.indexOf(s0));
        }
    }

    private void twoRotate(Tet t, Vertex s0, Vertex s1, Vertex r0, Vertex r1) {
        double dist;
        Circle C;
        Point center;
        Tri tri;
        if (t.isAlpha(this.alphaVal)) {
            this.alphaTets.add(t);
            t.setAlph(1);
        }
        this.angles = this.getRoot(t.getCorner(0), t.getCorner(1), t.getCorner(2), t.getCorner(3), t.getCount());
        if (this.angles != null && this.angles[0] < this.angleLimit) {
            this.addToHeap(this.angles, t);
        }
        if (!this.mapTris.containsKey(new TrianglePoints(s0, s1, r0))) {
            tri = new Tri(s0, s1, r0);
            this.mapTris.put(new TrianglePoints(s0, s1, r0), tri);
            t.setTri(tri, t.indexOf_slow(r1));
            if (tri.isAlpha(this.alphaVal)) {
                tri.setAlph(1);
                if (this.isGabriel(tri)) {
                    this.alphaTris.add(tri);
                }
            } else {
                center = Point.getMidpoint(s0, s1);
                C = new Circle(center, this.alphaVal, center.vectorTo(s0));
                dist = C.getDistanceSquared(r0);
                if (dist < this.alphaVal * this.alphaVal + Constants.EPSILON) {
                    tri.setAlph(2);
                } else {
                    tri.setAlph(0);
                }
            }
        } else {
            tri = this.mapTris.get(new TrianglePoints(s0, s1, r0));
            t.setTri(tri, t.indexOf(r1));
        }
        if (!this.mapTris.containsKey(new TrianglePoints(s0, s1, r1))) {
            tri = new Tri(s0, s1, r1);
            this.mapTris.put(new TrianglePoints(s0, s1, r1), tri);
            t.setTri(tri, t.indexOf(r0));
            if (tri.isAlpha(this.alphaVal)) {
                tri.setAlph(1);
                if (this.isGabriel(tri)) {
                    this.alphaTris.add(tri);
                }
            } else {
                center = Point.getMidpoint(s0, s1);
                C = new Circle(center, this.alphaVal, center.vectorTo(s0));
                dist = C.getDistanceSquared(r1);
                if (dist < this.alphaVal * this.alphaVal + Constants.EPSILON) {
                    tri.setAlph(2);
                } else {
                    tri.setAlph(0);
                }
            }
        } else {
            tri = this.mapTris.get(new TrianglePoints(s0, s1, r1));
            t.setTri(tri, t.indexOf(r0));
        }
        if (!this.mapTris.containsKey(new TrianglePoints(s0, r0, r1))) {
            tri = new Tri(s0, r0, r1);
            this.mapTris.put(new TrianglePoints(s0, r0, r1), tri);
            t.setTri(tri, t.indexOf(s1));
            if (tri.isAlpha(this.alphaVal)) {
                tri.setAlph(1);
                if (this.isGabriel(tri)) {
                    this.alphaTris.add(tri);
                }
            } else {
                center = Point.getMidpoint(r0, r1);
                C = new Circle(center, this.alphaVal, center.vectorTo(r0));
                dist = C.getDistanceSquared(s0);
                if (dist < this.alphaVal * this.alphaVal + Constants.EPSILON) {
                    tri.setAlph(2);
                } else {
                    tri.setAlph(0);
                }
            }
        } else {
            tri = this.mapTris.get(new TrianglePoints(s0, r0, r1));
            t.setTri(tri, t.indexOf(s1));
        }
        if (!this.mapTris.containsKey(new TrianglePoints(s1, r0, r1))) {
            tri = new Tri(s1, r0, r1);
            this.mapTris.put(new TrianglePoints(s1, r0, r1), tri);
            t.setTri(tri, t.indexOf(s0));
            if (tri.isAlpha(this.alphaVal)) {
                tri.setAlph(1);
                if (this.isGabriel(tri)) {
                    this.alphaTris.add(tri);
                }
            } else {
                center = Point.getMidpoint(r0, r1);
                C = new Circle(center, this.alphaVal, center.vectorTo(s1));
                dist = C.getDistanceSquared(s1);
                if (dist < this.alphaVal * this.alphaVal + Constants.EPSILON) {
                    tri.setAlph(2);
                } else {
                    tri.setAlph(0);
                }
            }
        } else {
            tri = this.mapTris.get(new TrianglePoints(s1, r0, r1));
            t.setTri(tri, t.indexOf(s0));
        }
    }

    private void restoreNeighborhood(List<Tet> newCells) {
        for (Tet c1 : newCells) {
            block1: for (Tet c2 : newCells) {
                if (c1 == c2) break;
                int i = 0;
                int j = 0;
                int I = -1;
                int J = -1;
                while (i <= 3 && j <= 3) {
                    if (c1.getCorner(i) == c2.getCorner(j)) {
                        ++i;
                        ++j;
                        continue;
                    }
                    if (i < 3 && c1.getCorner(i + 1) == c2.getCorner(j)) {
                        if (I >= 0) continue block1;
                        I = i++;
                        continue;
                    }
                    if (J >= 0) continue block1;
                    J = j++;
                }
                c1.neighbors[I] = c2;
                c2.neighbors[J] = c1;
            }
        }
    }

    private void setRotationAxis(Line l) {
        Vector translate = new Vector(-l.getP().get(0), -l.getP().get(1), -l.getP().get(2));
        for (Point point : this.vertices) {
            point.addThis(translate);
        }
        Vector dir = l.getDir();
        this.rotationAxis = new Vector(0.0, 0.0, 1.0);
        if (!dir.isParallel(this.rotationAxis)) {
            Vector vector = dir.cross(this.rotationAxis);
            vector.normalizeThis();
            double angle = dir.angle(this.rotationAxis);
            Matrix rotMatrix = Matrix.createRotationMatrix(angle, vector);
            for (Point point : this.vertices) {
                rotMatrix.multiplyIn(point);
            }
        }
    }

    private Tet walk(Point p) {
        Tet t = this.lastTet;
        while (true) {
            for (int f = 0; f < 4; ++f) {
                if (t.insideFace(f, p)) continue;
                this.lastTet = t = t.neighbors[f];
            }
            break;
        }
        return t;
    }

    private double angleCW(Vector v1, Vector v2) {
        double ret = Math.atan2(v1.y(), v1.x()) - Math.atan2(v2.y(), v2.x());
        if (ret < 0.0) {
            ret = Constants.TAU + ret;
            return ret;
        }
        if (ret > 0.0) {
            return ret;
        }
        return ret;
    }

    private double angleCCW(Vector v1, Vector v2) {
        double ret = Math.atan2(v1.y(), v1.x()) - Math.atan2(v2.y(), v2.x());
        if (ret < 0.0) {
            ret = -1.0 * ret;
            return ret;
        }
        if (ret > 0.0) {
            ret = Constants.TAU - ret;
            return ret;
        }
        return ret;
    }

    private Double[] getRootSR(Vertex A, Vertex B, int dir) {
        Double[] angles = new Double[4];
        Sphere S = new Sphere(A, 2.0 * this.alphaVal);
        Circle C = new Circle(new Point(0.0, 0.0, B.getCoord(2)), B.distanceXY(), this.rotationAxis);
        Point[] intersectionPoints = S.getIntersections(C);
        if (intersectionPoints != null && intersectionPoints.length > 1) {
            int i = 0;
            for (Point p : intersectionPoints) {
                Point z = new Point(0.0, 0.0, B.getCoord(2));
                angles[i] = dir == 1 ? Double.valueOf(this.angleTotal + this.angleCCW(z.vectorTo(p), z.vectorTo(B))) : Double.valueOf(this.angleTotal + this.angleCW(z.vectorTo(p), z.vectorTo(B)));
                ++i;
            }
        }
        return this.getRotAngle(angles, 0);
    }

    private Double[] getRootSSR(Vertex A, Vertex B, Vertex C, int dir) {
        Double[] angles = new Double[4];
        if (A.distanceSquared(B) >= 4.0 * this.alphaVal * this.alphaVal) {
            return null;
        }
        Point torusCenter = Point.getMidpoint(A, B);
        double R = Math.sqrt(Math.abs(this.alphaVal * this.alphaVal - A.distanceSquared(torusCenter)));
        Vector torusNormal = A.vectorTo(torusCenter).normalize();
        Torus torus = new Torus(torusCenter, torusNormal, R, this.alphaVal);
        double circleRadius = C.distanceXY();
        Circle circle = new Circle(new Point(0.0, 0.0, C.getCoord(2)), circleRadius, this.rotationAxis);
        Point[] intersections = torus.getIntersectionCircle(circle);
        int i = 0;
        if (intersections != null) {
            for (Point p : intersections) {
                if (p == null) break;
                Point z = new Point(0.0, 0.0, C.getCoord(2));
                angles[i] = dir == 1 ? Double.valueOf(this.angleTotal + this.angleCCW(z.vectorTo(p), z.vectorTo(C))) : Double.valueOf(this.angleTotal + this.angleCW(z.vectorTo(p), z.vectorTo(C)));
                ++i;
            }
        }
        return this.getRotAngle(angles, 0);
    }

    private Double[] getRootSSSR(Vertex A, Vertex B, Vertex C, Vertex D, int dir) {
        Sphere S1;
        Point[] intersectionPoints2;
        int i;
        Double[] angles = new Double[4];
        Circle c = new Circle((Point)A, (Point)B, C);
        Point midpoint = c.getCenter();
        double cMinusa = this.alphaVal * this.alphaVal - A.distanceSquared(midpoint);
        if (cMinusa < 0.0) {
            return null;
        }
        double distToCenter = Math.sqrt(Math.abs(cMinusa));
        Vector vecToCenter = c.getNormal().clone();
        vecToCenter.scaleToLengthThis(distToCenter);
        Point center0 = midpoint.clone().addThis(vecToCenter);
        Point center1 = midpoint.clone().addThis(vecToCenter.multiply(-1.0));
        Circle rotationC = new Circle(new Point(0.0, 0.0, D.getCoord(2)), D.distanceXY(), this.rotationAxis);
        Sphere S0 = new Sphere(center0, this.alphaVal);
        Point[] intersectionPoints1 = S0.getIntersections(rotationC);
        if (intersectionPoints1 != null) {
            i = 0;
            for (Point p : intersectionPoints1) {
                Point z = new Point(0.0, 0.0, D.getCoord(2));
                angles[i] = dir == 1 ? Double.valueOf(this.angleTotal + this.angleCCW(z.vectorTo(p), z.vectorTo(D))) : Double.valueOf(this.angleTotal + this.angleCW(z.vectorTo(p), z.vectorTo(D)));
                ++i;
            }
        } else {
            i = 0;
        }
        if ((intersectionPoints2 = (S1 = new Sphere(center1, this.alphaVal)).getIntersections(rotationC)) != null) {
            for (Point p : intersectionPoints2) {
                Point z = new Point(0.0, 0.0, D.getCoord(2));
                angles[i] = dir == 1 ? Double.valueOf(this.angleTotal + this.angleCCW(z.vectorTo(p), z.vectorTo(D))) : Double.valueOf(this.angleTotal + this.angleCW(z.vectorTo(p), z.vectorTo(D)));
                ++i;
            }
        }
        return this.getRotAngle(angles, 0);
    }

    private Double[] getRootSSRR(Vertex A, Vertex B, Vertex C, Vertex D, int dir) {
        double precision = 0.05;
        Double[] angles = new Double[4];
        int numOfAngles = 0;
        double offRadius = new Sphere(A, B, C, D).getRadius() - this.alphaVal;
        double sign = Math.signum(offRadius);
        double angleSoFar = Math.floor(Math.toDegrees(this.angleTotal));
        for (double i = precision; i <= Math.ceil(Math.toDegrees(this.angleLimit) - angleSoFar); i += precision) {
            double radius;
            Point Cnew = C.clone();
            Point Dnew = D.clone();
            if (dir == 0) {
                Cnew.rotationCW(this.rotationAxis, Math.toRadians(i));
                Dnew.rotationCW(this.rotationAxis, Math.toRadians(i));
            }
            if (Math.signum(offRadius = (radius = new Sphere(A, B, Cnew, Dnew).getRadius()) - this.alphaVal) == sign) continue;
            sign = Math.signum(offRadius);
            Double angle = this.findAngle(i - precision, i, A, B, C, D, 0);
            if (angle == null) {
                return null;
            }
            angles[numOfAngles] = Math.toRadians(angle) + this.angleTotal;
            ++numOfAngles;
        }
        if (numOfAngles == 0) {
            return null;
        }
        return angles;
    }

    private Double findAngle(double start, double end, Vertex A, Vertex B, Vertex C, Vertex D, int dir) {
        double radius;
        Point Cnew = C.clone();
        Point Dnew = D.clone();
        if (dir == 0) {
            Cnew.rotationCW(this.rotationAxis, Math.toRadians(start));
            Dnew.rotationCW(this.rotationAxis, Math.toRadians(start));
        }
        if (Math.abs((radius = new Sphere(A, B, Cnew, Dnew).getRadius()) - this.alphaVal) < Math.pow(10.0, -9.0)) {
            return start;
        }
        double sign = Math.signum(radius - this.alphaVal);
        double newStart = start;
        double newEnd = end;
        double angle = 0.0;
        for (int i = 0; i < 99; ++i) {
            angle = (newEnd + newStart) / 2.0;
            Cnew = C.clone();
            Dnew = D.clone();
            if (dir == 0) {
                Cnew.rotationCW(this.rotationAxis, Math.toRadians(angle));
                Dnew.rotationCW(this.rotationAxis, Math.toRadians(angle));
            }
            if (Math.abs((radius = new Sphere(A, B, Cnew, Dnew).getRadius()) - this.alphaVal) < Math.pow(10.0, -9.0)) {
                return angle;
            }
            double newSign = Math.signum(radius - this.alphaVal);
            if (newSign != sign) {
                newEnd = angle;
                continue;
            }
            newStart = angle;
        }
        System.out.println("All 99 iterations used!!!! ");
        return angle;
    }

    private Double[] getRootSSSSR(Vertex A, Vertex B, Vertex C, Vertex D, Vertex E, int dir) {
        double aa = A.getSquaredPolarRadius();
        double bb = B.getSquaredPolarRadius();
        double cc = C.getSquaredPolarRadius();
        double dd = D.getSquaredPolarRadius();
        double ee = E.getSquaredPolarRadius();
        double e = Math.sqrt(E.x() * E.x() + E.y() * E.y());
        double[][] m = new double[][]{{A.x(), A.y(), A.z(), aa, 1.0}, {B.x(), B.y(), B.z(), bb, 1.0}, {C.x(), C.y(), C.z(), cc, 1.0}, {D.x(), D.y(), D.z(), dd, 1.0}, {0.0, 0.0, 0.0, 0.0, 0.0}};
        Matrix M = new Matrix(m);
        double det40 = M.minor(4, 0).determinant();
        double det41 = M.minor(4, 1).determinant();
        double det42 = M.minor(4, 2).determinant();
        double det43 = M.minor(4, 3).determinant();
        double det44 = M.minor(4, 4).determinant();
        double coefSin = -e * (E.getSinAngle() * det40 + E.getCosAngle() * det41);
        double coefCos = e * (E.getCosAngle() * det40 - E.getSinAngle() * det41);
        double coef = E.z() * det42 - ee * det43 + det44;
        this.angles = Trigonometry.solveAsinXPlusBcosXplusC(coefSin, coefCos, coef);
        return this.getRotAngle(this.angles, dir);
    }

    private Double[] getRootSSSRR(Vertex A, Vertex B, Vertex C, Vertex D, Vertex E, int dir) {
        double aa = A.getSquaredPolarRadius();
        double bb = B.getSquaredPolarRadius();
        double cc = C.getSquaredPolarRadius();
        double dd = D.getSquaredPolarRadius();
        double d = Math.sqrt(D.x() * D.x() + D.y() * D.y());
        double ee = E.getSquaredPolarRadius();
        double e = Math.sqrt(E.x() * E.x() + E.y() * E.y());
        double dSin = D.getSinAngle();
        double dCos = D.getCosAngle();
        double eSin = E.getSinAngle();
        double eCos = E.getCosAngle();
        double aa_bb = aa - bb;
        double bb_cc = bb - cc;
        double cc_aa = cc - aa;
        double M12 = A.z() * bb_cc + C.z() * aa_bb + B.z() * cc_aa;
        double M13 = A.y() * bb_cc + C.y() * aa_bb + B.y() * cc_aa;
        double M14 = A.y() * (B.z() - C.z()) + C.y() * (A.z() - B.z()) + B.y() * (C.z() - A.z());
        double M15 = A.y() * (B.z() * cc - C.z() * bb) + C.y() * (A.z() * bb - B.z() * aa) + B.y() * (C.z() * aa - A.z() * cc);
        double M23 = A.x() * bb_cc + C.x() * aa_bb + B.x() * cc_aa;
        double M24 = A.x() * (B.z() - C.z()) + C.x() * (A.z() - B.z()) + B.x() * (C.z() - A.z());
        double M25 = A.x() * (B.z() * cc - C.z() * bb) + C.x() * (A.z() * bb - B.z() * aa) + B.x() * (C.z() * aa - A.z() * cc);
        double M34 = A.x() * (B.y() - C.y()) + C.x() * (A.y() - B.y()) + B.x() * (C.y() - A.y());
        double M35 = A.x() * (B.y() * cc - C.y() * bb) + C.x() * (A.y() * bb - B.y() * aa) + B.x() * (C.y() * aa - A.y() * cc);
        double M45 = A.x() * (B.y() * C.z() - C.y() * B.z()) + C.x() * (A.y() * B.z() - B.y() * A.z()) + B.x() * (C.y() * A.z() - A.y() * C.z());
        double coefSin = M13 * (E.z() * d * dSin - e * D.z() * eSin) + M14 * (e * dd * eSin - ee * d * dSin) + M15 * (d * dSin - e * eSin) + M23 * (E.z() * d * dCos - e * D.z() * eCos) + M24 * (e * dd * eCos - ee * d * dCos) + M25 * (d * dCos - e * eCos);
        double coefCos = M13 * (e * D.z() * eCos - E.z() * d * dCos) + M14 * (ee * d * dCos - e * dd * eCos) + M15 * (e * eCos - d * dCos) + M23 * (E.z() * d * dSin - e * D.z() * eSin) + M24 * (e * dd * eSin - ee * d * dSin) + M25 * (d * dSin - e * eSin);
        double coef = d * e * M12 * (eSin * dCos - eCos * dSin) + M34 * (ee * D.z() - E.z() * dd) + M35 * (E.z() - D.z()) + M45 * (dd - ee);
        this.angles = Trigonometry.solveAsinXPlusBcosXplusC(coefSin, coefCos, coef);
        return this.getRotAngle(this.angles, dir);
    }

    private Double[] getRotAngle(Double[] angles, int dir) {
        if (angles == null || angles[1] == null && angles[3] == null) {
            return null;
        }
        Double[] oldAngles = new Double[4];
        int i = 0;
        for (Double angle : angles) {
            if (angle == null) continue;
            oldAngles[i] = angle;
            ++i;
        }
        Object[] newAngles = new Double[i];
        int j = 0;
        for (Double angle : oldAngles) {
            if (angle == null) break;
            if (dir == 1) {
                angle = Constants.TAU - angle + this.angleTotal;
            }
            if (angle < this.angleTotal + Constants.EPSILON) {
                angle = this.angleLimit;
            }
            newAngles[j] = angle;
            ++j;
        }
        Arrays.sort(newAngles);
        return newAngles;
    }

    private Double[] getRoot(Vertex v0, Vertex v1, int count) {
        if (count == 0 || count == 3) {
            return null;
        }
        if (count == 1) {
            return this.getRootSR(v1, v0, 0);
        }
        return this.getRootSR(v0, v1, 0);
    }

    private Double[] getRoot(Vertex v0, Vertex v1, Vertex v2, int count) {
        if (count == 0 || count == 7) {
            return null;
        }
        if (count <= 3) {
            if (count == 1) {
                return this.getRootSSR(v1, v2, v0, 0);
            }
            if (count == 2) {
                return this.getRootSSR(v0, v2, v1, 0);
            }
            return this.getRootSSR(v0, v1, v2, 1);
        }
        if (count <= 5) {
            if (count == 4) {
                return this.getRootSSR(v0, v1, v2, 0);
            }
            return this.getRootSSR(v0, v2, v1, 1);
        }
        return this.getRootSSR(v1, v2, v0, 1);
    }

    private Double[] getRoot(Vertex v0, Vertex v1, Vertex v2, Vertex v3, int count) {
        if (count == 0 || count == 15) {
            return null;
        }
        if (count <= 7) {
            if (count <= 3) {
                if (count == 1) {
                    return this.getRootSSSR(v1, v2, v3, v0, 0);
                }
                if (count == 2) {
                    return this.getRootSSSR(v0, v2, v3, v1, 0);
                }
                long start = System.nanoTime();
                Double[] a = this.getRootSSRR(v2, v3, v0, v1, 0);
                this.numericalTime += (double)(System.nanoTime() - start) / 1000000.0;
                return a;
            }
            if (count <= 5) {
                if (count == 4) {
                    return this.getRootSSSR(v0, v1, v3, v2, 0);
                }
                long start = System.nanoTime();
                Double[] a = this.getRootSSRR(v1, v3, v0, v2, 0);
                this.numericalTime += (double)(System.nanoTime() - start) / 1000000.0;
                return a;
            }
            if (count == 6) {
                long start = System.nanoTime();
                Double[] a = this.getRootSSRR(v0, v3, v1, v2, 0);
                this.numericalTime += (double)(System.nanoTime() - start) / 1000000.0;
                return a;
            }
            return this.getRootSSSR(v0, v1, v2, v3, 1);
        }
        if (count <= 11) {
            if (count <= 9) {
                if (count == 8) {
                    return this.getRootSSSR(v0, v1, v2, v3, 0);
                }
                long start = System.nanoTime();
                Double[] a = this.getRootSSRR(v1, v2, v0, v3, 0);
                this.numericalTime += (double)(System.nanoTime() - start) / 1000000.0;
                return a;
            }
            if (count == 10) {
                long start = System.nanoTime();
                Double[] a = this.getRootSSRR(v0, v2, v1, v3, 0);
                this.numericalTime += (double)(System.nanoTime() - start) / 1000000.0;
                return a;
            }
            return this.getRootSSSR(v0, v1, v3, v2, 1);
        }
        if (count <= 13) {
            if (count == 12) {
                long start = System.nanoTime();
                Double[] a = this.getRootSSRR(v0, v1, v2, v3, 0);
                this.numericalTime += (double)(System.nanoTime() - start) / 1000000.0;
                return a;
            }
            return this.getRootSSSR(v0, v2, v3, v1, 1);
        }
        return this.getRootSSSR(v1, v2, v3, v0, 1);
    }

    private Double[] getRoot(Tet t, Tet oppT) {
        int count = t.getCount();
        Vertex oppV = oppT.getCorner(oppT.apex(t));
        if (oppV.getType() == Vertex.VertexType.R) {
            count += 16;
        }
        return this.getRoot(t, oppV, count);
    }

    private Double[] getRoot(Tet t, Vertex oppV, int count) {
        if (count == 0 || count == 31) {
            return null;
        }
        if (count <= 15) {
            if (count <= 7) {
                if (count <= 3) {
                    if (count == 1) {
                        return this.getRootSSSSR(t.getCorner(1), t.getCorner(2), t.getCorner(3), oppV, t.getCorner(0), 0);
                    }
                    if (count == 2) {
                        return this.getRootSSSSR(t.getCorner(0), t.getCorner(2), t.getCorner(3), oppV, t.getCorner(1), 0);
                    }
                    return this.getRootSSSRR(t.getCorner(2), t.getCorner(3), oppV, t.getCorner(0), t.getCorner(1), 0);
                }
                if (count <= 5) {
                    if (count == 4) {
                        return this.getRootSSSSR(t.getCorner(0), t.getCorner(1), t.getCorner(3), oppV, t.getCorner(2), 0);
                    }
                    return this.getRootSSSRR(t.getCorner(1), t.getCorner(3), oppV, t.getCorner(0), t.getCorner(2), 0);
                }
                if (count == 6) {
                    return this.getRootSSSRR(t.getCorner(0), t.getCorner(3), oppV, t.getCorner(1), t.getCorner(2), 0);
                }
                return this.getRootSSSRR(t.getCorner(0), t.getCorner(1), t.getCorner(2), t.getCorner(3), oppV, 1);
            }
            if (count <= 11) {
                if (count <= 9) {
                    if (count == 8) {
                        return this.getRootSSSSR(t.getCorner(0), t.getCorner(1), t.getCorner(2), oppV, t.getCorner(3), 0);
                    }
                    return this.getRootSSSRR(t.getCorner(1), t.getCorner(2), oppV, t.getCorner(0), t.getCorner(3), 0);
                }
                if (count == 10) {
                    return this.getRootSSSRR(t.getCorner(0), t.getCorner(2), oppV, t.getCorner(1), t.getCorner(3), 0);
                }
                return this.getRootSSSRR(t.getCorner(0), t.getCorner(1), t.getCorner(3), t.getCorner(2), oppV, 1);
            }
            if (count <= 13) {
                if (count == 12) {
                    return this.getRootSSSRR(t.getCorner(0), t.getCorner(1), oppV, t.getCorner(2), t.getCorner(3), 0);
                }
                return this.getRootSSSRR(t.getCorner(0), t.getCorner(2), t.getCorner(3), t.getCorner(1), oppV, 1);
            }
            if (count == 14) {
                return this.getRootSSSRR(t.getCorner(1), t.getCorner(2), t.getCorner(3), t.getCorner(0), oppV, 1);
            }
            return this.getRootSSSSR(t.getCorner(0), t.getCorner(1), t.getCorner(2), t.getCorner(3), oppV, 1);
        }
        if (count <= 23) {
            if (count <= 19) {
                if (count <= 17) {
                    if (count == 16) {
                        return this.getRootSSSSR(t.getCorner(0), t.getCorner(1), t.getCorner(2), t.getCorner(3), oppV, 0);
                    }
                    return this.getRootSSSRR(t.getCorner(1), t.getCorner(2), t.getCorner(3), t.getCorner(0), oppV, 0);
                }
                if (count == 18) {
                    return this.getRootSSSRR(t.getCorner(0), t.getCorner(2), t.getCorner(3), t.getCorner(1), oppV, 0);
                }
                return this.getRootSSSRR(t.getCorner(0), t.getCorner(1), oppV, t.getCorner(2), t.getCorner(3), 1);
            }
            if (count <= 21) {
                if (count == 20) {
                    return this.getRootSSSRR(t.getCorner(0), t.getCorner(1), t.getCorner(3), t.getCorner(2), oppV, 0);
                }
                return this.getRootSSSRR(t.getCorner(1), t.getCorner(3), oppV, t.getCorner(0), t.getCorner(2), 0);
            }
            if (count == 22) {
                return this.getRootSSSRR(t.getCorner(1), t.getCorner(2), oppV, t.getCorner(0), t.getCorner(3), 1);
            }
            return this.getRootSSSSR(t.getCorner(0), t.getCorner(1), t.getCorner(2), oppV, t.getCorner(3), 1);
        }
        if (count <= 27) {
            if (count <= 25) {
                if (count == 24) {
                    return this.getRootSSSRR(t.getCorner(0), t.getCorner(1), t.getCorner(2), t.getCorner(3), oppV, 0);
                }
                return this.getRootSSSRR(t.getCorner(0), t.getCorner(3), oppV, t.getCorner(1), t.getCorner(2), 1);
            }
            if (count == 26) {
                return this.getRootSSSRR(t.getCorner(1), t.getCorner(3), oppV, t.getCorner(0), t.getCorner(2), 1);
            }
            return this.getRootSSSSR(t.getCorner(0), t.getCorner(1), t.getCorner(3), oppV, t.getCorner(2), 1);
        }
        if (count <= 29) {
            if (count == 28) {
                return this.getRootSSSRR(t.getCorner(2), t.getCorner(3), oppV, t.getCorner(0), t.getCorner(1), 1);
            }
            return this.getRootSSSSR(t.getCorner(0), t.getCorner(2), t.getCorner(3), oppV, t.getCorner(1), 1);
        }
        return this.getRootSSSSR(t.getCorner(1), t.getCorner(2), t.getCorner(3), oppV, t.getCorner(0), 1);
    }

    public void initializeRotation(Set<Integer> pIndices, Line axis) {
        this.heap.clear();
        this.setRotVertices(pIndices);
        this.setRotationAxis(axis);
        for (Vertex v : this.vertices) {
            if (this.testingPrint) {
                System.out.print(v.getId() + ": " + v.toString(2));
            }
            if (v.distanceSquared() < Constants.EPSILON) {
                v.setSquaredPolarRadius(0.0);
                v.setPolarRadius(0.0);
                v.setPolarAngle(0.0);
                if (this.testingPrint) {
                    System.out.println(", polar angle: 0.0");
                }
                v.setCosAngle(1.0);
                v.setSinAngle(0.0);
                v.setType(Vertex.VertexType.S);
                this.rotIndx.remove(v.getId());
                continue;
            }
            v.setSquaredPolarRadius(v.distanceSquared());
            v.setPolarRadius(v.distance());
            v.setPolarAngle(v.polarAngleXY());
            if (this.testingPrint) {
                System.out.println(", initial polar angle: " + Functions.toDeg(v.getPolarAngle()));
            }
            v.setCosAngle(v.polarAngleCosXY());
            v.setSinAngle(v.polarAngleSinXY());
        }
        int count = 0;
        int count4 = 0;
        Tet nt = null;
        for (Tet t : this.tets) {
            count4 = t.getCount();
            for (int i = 0; i < 4; ++i) {
                nt = t.neighbors[i];
                if (nt == null) continue;
                Vertex oppV = nt.getCorner(nt.apex(t));
                if (t.getCorner(t.apex(nt)).getId() >= oppV.getId()) continue;
                count = count4;
                if (oppV.getType() == Vertex.VertexType.R) {
                    count += 16;
                }
                this.angles = this.getRoot(t, oppV, count);
                if (this.angles == null || !(this.angles[0] < this.angleLimit)) continue;
                this.addToHeap(this.angles, t, nt);
                if (!this.testingPrint) continue;
                System.out.println(t + " " + nt + " " + Functions.toDeg(this.angles[0]) + " " + Functions.toDeg(this.angles[1]));
            }
        }
        this.initializeRadiusEvents();
    }

    private Tet[] flip23(Tet t0, Tet t1) {
        Tet nti;
        int i;
        int count;
        Tri commonTri;
        Vertex vns1;
        long start = System.nanoTime();
        ++this.nrFlips;
        Vertex vns0 = t0.getCorner(t0.apex(t1));
        Edge commonEdge = new Edge(vns0, vns1 = t1.getCorner(t1.apex(t0)));
        if (commonEdge.isAlpha(this.alphaVal)) {
            commonEdge.setAlph(true);
            this.alphaEdges.add(commonEdge);
        }
        this.angles = this.getRoot(commonEdge.getCorner(0), commonEdge.getCorner(1), commonEdge.getCount());
        if (this.angles != null && this.angles[0] < this.angleLimit) {
            this.addToHeap(this.angles, commonEdge);
        }
        if ((commonTri = t0.getTri(vns0)).getAlph() == 1) {
            this.alphaTris.remove(commonTri);
        }
        commonTri.setAlive(false);
        Vertex[] vs = new Vertex[3];
        int k = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            if (t0.getCorner(i2) == vns0) continue;
            vs[k++] = t0.getCorner(i2);
        }
        Tet[] nt = new Tet[3];
        Tet nt0 = new Tet(vns0, vns1, vs[0], vs[1]);
        nt0.setEdge(commonEdge);
        nt[0] = nt0;
        Tet nt1 = new Tet(vns0, vns1, vs[1], vs[2]);
        nt1.setEdge(commonEdge);
        nt[1] = nt1;
        Tet nt2 = new Tet(vns0, vns1, vs[2], vs[0]);
        nt2.setEdge(commonEdge);
        nt[2] = nt2;
        for (int i3 = 0; i3 < 3; ++i3) {
            Tet t = nt[i3];
            Tri tri = new Tri(vns0, vns1, vs[i3]);
            t.setTri(tri, t.indexOf(vs[(i3 + 1) % 3]));
            Tet n = nt[(i3 + 2) % 3];
            n.setTri(tri, n.indexOf(vs[(i3 + 2) % 3]));
            count = tri.getCount();
            Vertex S0 = tri.getCorner(0);
            Vertex S1 = tri.getCorner(1);
            Vertex R0 = tri.getCorner(2);
            if (count == 0 || count == 7) {
                if (!tri.isAlpha(this.alphaVal)) continue;
                this.alphaTris.add(tri);
                tri.setAlph(1);
                continue;
            }
            if (count == 1 || count == 6) {
                R0 = tri.getCorner(0);
                S0 = tri.getCorner(1);
                S1 = tri.getCorner(2);
            }
            if (count == 2 || count == 5) {
                R0 = tri.getCorner(1);
                S0 = tri.getCorner(0);
                S1 = tri.getCorner(2);
            }
            if (count == 4 || count == 3) {
                R0 = tri.getCorner(2);
                S0 = tri.getCorner(0);
                S1 = tri.getCorner(1);
            }
            if (tri.isAlpha(this.alphaVal)) {
                this.alphaTris.add(tri);
                tri.setAlph(1);
            } else {
                Point center = Point.getMidpoint(S0, S1);
                Circle C = new Circle(center, this.alphaVal, center.vectorTo(S0).normalize());
                double dist = C.getDistanceSquared(R0);
                if (dist < this.alphaVal * this.alphaVal + Constants.EPSILON) {
                    tri.setAlph(2);
                } else {
                    tri.setAlph(0);
                }
            }
            this.angles = this.getRoot(tri.getCorner(0), tri.getCorner(1), tri.getCorner(2), tri.getCount());
            if (this.angles == null || !(this.angles[0] < this.angleLimit)) continue;
            this.addToHeap(this.angles, tri);
        }
        for (Edge e : t0.getEdges()) {
            if (e.equals(new Edge(vns0, vs[0]))) {
                nt0.setEdge(e);
                nt2.setEdge(e);
                continue;
            }
            if (e.equals(new Edge(vns0, vs[1]))) {
                nt0.setEdge(e);
                nt1.setEdge(e);
                continue;
            }
            if (e.equals(new Edge(vns0, vs[2]))) {
                nt2.setEdge(e);
                nt1.setEdge(e);
                continue;
            }
            if (e.equals(new Edge(vs[0], vs[1]))) {
                nt0.setEdge(e);
                continue;
            }
            if (e.equals(new Edge(vs[1], vs[2]))) {
                nt1.setEdge(e);
                continue;
            }
            if (!e.equals(new Edge(vs[0], vs[2]))) continue;
            nt2.setEdge(e);
        }
        for (Edge e : t1.getEdges()) {
            if (e.equals(new Edge(vns1, vs[0]))) {
                nt0.setEdge(e);
                nt2.setEdge(e);
                continue;
            }
            if (e.equals(new Edge(vns1, vs[1]))) {
                nt0.setEdge(e);
                nt1.setEdge(e);
                continue;
            }
            if (!e.equals(new Edge(vns1, vs[2]))) continue;
            nt2.setEdge(e);
            nt1.setEdge(e);
        }
        nt0.setEdge(commonEdge);
        nt1.setEdge(commonEdge);
        nt2.setEdge(commonEdge);
        for (Tet t : nt) {
            count = t.getCount();
            int idxR = -1;
            int idxS0 = -1;
            int idxS1 = -1;
            int idxS2 = -1;
            if (count == 0 || count == 15) {
                if (!t.isAlpha(this.alphaVal)) continue;
                t.setAlph(1);
                this.alphaTets.add(t);
                continue;
            }
            if (t.isAlpha(this.alphaVal)) {
                t.setAlph(1);
                this.alphaTets.add(t);
            } else if (t.nrRotating() == 1) {
                if (count == 8 || count == 7) {
                    idxR = 3;
                    idxS0 = 0;
                    idxS1 = 1;
                    idxS2 = 2;
                }
                if (count == 4 || count == 11) {
                    idxR = 2;
                    idxS0 = 0;
                    idxS1 = 1;
                    idxS2 = 3;
                }
                if (count == 2 || count == 13) {
                    idxR = 1;
                    idxS0 = 0;
                    idxS1 = 3;
                    idxS2 = 2;
                }
                if (count == 1 || count == 14) {
                    idxR = 0;
                    idxS0 = 3;
                    idxS1 = 1;
                    idxS2 = 2;
                }
                Vertex r = t.getCorner(idxR);
                Vertex s0 = t.getCorner(idxS0);
                Vertex s1 = t.getCorner(idxS1);
                Vertex s2 = t.getCorner(idxS2);
                double d0 = s0.distanceSquared(s1);
                double d1 = s1.distanceSquared(s2);
                double d2 = s2.distanceSquared(s0);
                double a0 = r.distanceSquared(s0);
                double a1 = r.distanceSquared(s1);
                double a2 = r.distanceSquared(s2);
                if (a0 < d0 && a1 < d0 && a1 < d1 && a2 < d2 && a2 < d2 && a0 < d2) {
                    t.setAlph(2);
                } else {
                    t.setAlph(0);
                }
            }
            this.angles = this.getRoot(t.getCorner(0), t.getCorner(1), t.getCorner(2), t.getCorner(3), count);
            if (this.angles == null || !(this.angles[0] < this.angleLimit)) continue;
            this.addToHeap(this.angles, t);
        }
        this.alphaTets.remove(t0);
        this.alphaTets.remove(t1);
        vns0.setTet(nt0);
        vns1.setTet(nt0);
        vs[0].setTet(nt0);
        vs[1].setTet(nt0);
        vs[2].setTet(nt1);
        nt0.neighbors[nt0.indexOf((Vertex)vs[0])] = !nt1.hasVertex(vs[0]) ? nt1 : nt2;
        nt0.neighbors[nt0.indexOf((Vertex)vs[1])] = !nt1.hasVertex(vs[1]) ? nt1 : nt2;
        Tet t = t1.neighbors[t1.indexOf(vs[2])];
        Tri tri = t1.getTri(t1.indexOf(vs[2]));
        nt0.neighbors[nt0.indexOf((Vertex)vns0)] = t;
        nt0.setTri(tri, nt0.indexOf(vns0));
        if (t != null) {
            t.neighbors[t.apex((Tet)t1)] = nt0;
        }
        t = t0.neighbors[t0.indexOf(vs[2])];
        tri = t0.getTri(t0.indexOf(vs[2]));
        nt0.setTri(tri, nt0.indexOf(vns1));
        nt0.neighbors[nt0.indexOf((Vertex)vns1)] = t;
        if (t != null) {
            t.neighbors[t.apex((Tet)t0)] = nt0;
        }
        nt1.neighbors[nt1.indexOf((Vertex)vs[1])] = !nt0.hasVertex(vs[1]) ? nt0 : nt2;
        nt1.neighbors[nt1.indexOf((Vertex)vs[2])] = !nt0.hasVertex(vs[2]) ? nt0 : nt2;
        t = t1.neighbors[t1.indexOf(vs[0])];
        tri = t1.getTri(t1.indexOf(vs[0]));
        nt1.setTri(tri, nt1.indexOf(vns0));
        nt1.neighbors[nt1.indexOf((Vertex)vns0)] = t;
        if (t != null) {
            t.neighbors[t.apex((Tet)t1)] = nt1;
        }
        t = t0.neighbors[t0.indexOf(vs[0])];
        tri = t0.getTri(t0.indexOf(vs[0]));
        nt1.setTri(tri, nt1.indexOf(vns1));
        nt1.neighbors[nt1.indexOf((Vertex)vns1)] = t;
        if (t != null) {
            t.neighbors[t.apex((Tet)t0)] = nt1;
        }
        nt2.neighbors[nt2.indexOf((Vertex)vs[2])] = !nt0.hasVertex(vs[2]) ? nt0 : nt1;
        nt2.neighbors[nt2.indexOf((Vertex)vs[0])] = !nt0.hasVertex(vs[0]) ? nt0 : nt1;
        t = t1.neighbors[t1.indexOf(vs[1])];
        tri = t1.getTri(t1.indexOf(vs[1]));
        nt2.setTri(tri, nt2.indexOf(vns0));
        nt2.neighbors[nt2.indexOf((Vertex)vns0)] = t;
        if (t != null) {
            t.neighbors[t.apex((Tet)t1)] = nt2;
        }
        t = t0.neighbors[t0.indexOf(vs[1])];
        tri = t0.getTri(t0.indexOf(vs[1]));
        nt2.setTri(tri, nt2.indexOf(vns1));
        nt2.neighbors[nt2.indexOf((Vertex)vns1)] = t;
        if (t != null) {
            t.neighbors[t.apex((Tet)t0)] = nt2;
        }
        this.tets.remove(t0);
        t0.setAlive(false);
        this.tets.remove(t1);
        t1.setAlive(false);
        Tet[] newTets = new Tet[]{nt0, nt1, nt2};
        this.tets.add(nt0);
        this.tets.add(nt1);
        this.tets.add(nt2);
        this.angles = this.getRoot(nt0, nt1);
        if (this.angles != null && this.angles[0] < this.angleLimit) {
            this.addToHeap(this.angles, nt0, nt1);
            if (this.testingPrint) {
                System.out.println(nt0 + " " + nt1 + " " + Functions.toDeg(this.angles[0]) + " " + Functions.toDeg(this.angles[1]));
            }
        }
        this.angles = this.getRoot(nt0, nt2);
        if (this.angles != null && this.angles[0] < this.angleLimit) {
            this.addToHeap(this.angles, nt0, nt2);
            if (this.testingPrint) {
                System.out.println(nt0 + " " + nt2 + " " + Functions.toDeg(this.angles[0]) + " " + Functions.toDeg(this.angles[1]));
            }
        }
        this.angles = this.getRoot(nt1, nt2);
        if (this.angles != null && this.angles[0] < this.angleLimit) {
            this.addToHeap(this.angles, nt1, nt2);
            if (this.testingPrint) {
                System.out.println(nt1 + " " + nt2 + " " + Functions.toDeg(this.angles[0]) + " " + Functions.toDeg(this.angles[1]));
            }
        }
        for (i = 0; i < 4; ++i) {
            nti = nt0.neighbors[i];
            if (nti == null || nti == nt1 || nti == nt2) continue;
            this.angles = this.getRoot(nt0, nti);
            if (this.angles == null || !(this.angles[0] < this.angleLimit)) continue;
            this.addToHeap(this.angles, nt0, nti);
            if (!this.testingPrint) continue;
            System.out.println(nt0 + " " + nti + " " + Functions.toDeg(this.angles[0]) + " " + Functions.toDeg(this.angles[1]));
        }
        for (i = 0; i < 4; ++i) {
            nti = nt1.neighbors[i];
            if (nti == null || nti == nt0 || nti == nt2) continue;
            this.angles = this.getRoot(nt1, nti);
            if (this.angles == null || !(this.angles[0] < this.angleLimit)) continue;
            this.addToHeap(this.angles, nt1, nti);
            if (!this.testingPrint) continue;
            System.out.println(nt1 + " " + nti + " " + Functions.toDeg(this.angles[0]) + " " + Functions.toDeg(this.angles[1]));
        }
        for (i = 0; i < 4; ++i) {
            nti = nt2.neighbors[i];
            if (nti == null || nti == nt0 || nti == nt1) continue;
            this.angles = this.getRoot(nt2, nti);
            if (this.angles == null || !(this.angles[0] < this.angleLimit)) continue;
            this.addToHeap(this.angles, nt2, nti);
            if (!this.testingPrint) continue;
            System.out.println(nt2 + " " + nti + " " + Functions.toDeg(this.angles[0]) + " " + Functions.toDeg(this.angles[1]));
        }
        this.flipTime += (double)(System.nanoTime() - start) / 1000000.0;
        return newTets;
    }

    private Tet[] flip32(Tet t0, Tet t1, Tet t2) {
        int i;
        int idx;
        int i2;
        Tri tri0;
        long start = System.nanoTime();
        ++this.nrFlips;
        Vertex[] vns = new Vertex[]{t0.getCorner(t0.apex(t1)), t1.getCorner(t1.apex(t2)), t2.getCorner(t2.apex(t0))};
        boolean foundEdge = false;
        for (Edge e : t0.getEdges()) {
            if (!t1.hasEdge(e) || !t2.hasEdge(e)) continue;
            foundEdge = true;
            e.setAlive(false);
            if (!e.getAlph()) break;
            e.setAlph(false);
            this.alphaEdges.remove(e);
            break;
        }
        if (!foundEdge) {
            System.out.println("Did not find common edge of edges ");
            for (Edge e : t0.getEdges()) {
                System.out.println("   " + e.toString());
            }
            System.out.println();
            for (Edge e : t1.getEdges()) {
                System.out.println("   " + e.toString());
            }
            System.out.println();
            for (Edge e : t2.getEdges()) {
                System.out.println("   " + e.toString());
            }
        }
        if ((tri0 = t0.getTri(vns[0])).getAlph() == 1) {
            this.alphaTris.remove(tri0);
        }
        tri0.setAlive(false);
        Tri tri1 = t1.getTri(vns[1]);
        if (tri1.getAlph() == 1) {
            this.alphaTris.remove(tri1);
        }
        tri1.setAlive(false);
        Tri tri2 = t2.getTri(vns[2]);
        if (tri2.getAlph() == 1) {
            this.alphaTris.remove(tri2);
        }
        tri2.setAlive(false);
        Vertex[] vs = new Vertex[2];
        int nrSharedFound = 0;
        for (int i3 = 0; i3 < 4 && nrSharedFound < 2; ++i3) {
            Vertex v = t0.getCorner(i3);
            if (!t1.hasVertex(v) || !t2.hasVertex(v)) continue;
            vs[nrSharedFound++] = v;
        }
        Tet nt0 = new Tet(vns[0], vns[1], vns[2], vs[0]);
        Tet nt1 = new Tet(vns[0], vns[1], vns[2], vs[1]);
        Tet[] nt = new Tet[]{nt0, nt1};
        Tri tri = new Tri(vns[0], vns[1], vns[2]);
        nt0.setTri(tri, nt0.indexOf(vs[0]));
        nt1.setTri(tri, nt1.indexOf(vs[1]));
        int count = tri.getCount();
        Vertex S0 = tri.getCorner(0);
        Vertex S1 = tri.getCorner(1);
        Vertex R0 = tri.getCorner(2);
        if (count == 0 || count == 7) {
            if (tri.isAlpha(this.alphaVal)) {
                this.alphaTris.add(tri);
                tri.setAlph(1);
            }
        } else {
            if (count == 1 || count == 6) {
                R0 = tri.getCorner(0);
                S0 = tri.getCorner(1);
                S1 = tri.getCorner(2);
            }
            if (count == 2 || count == 5) {
                R0 = tri.getCorner(1);
                S0 = tri.getCorner(0);
                S1 = tri.getCorner(2);
            }
            if (count == 4 || count == 3) {
                R0 = tri.getCorner(2);
                S0 = tri.getCorner(1);
                S1 = tri.getCorner(0);
            }
            if (tri.isAlpha(this.alphaVal)) {
                this.alphaTris.add(tri);
                tri.setAlph(1);
            } else {
                Point center = Point.getMidpoint(S0, S1);
                Circle C = new Circle(center, this.alphaVal, center.vectorTo(S0).normalize());
                double dist = C.getDistanceSquared(R0);
                if (dist < this.alphaVal * this.alphaVal + Constants.EPSILON) {
                    tri.setAlph(2);
                } else {
                    tri.setAlph(0);
                }
            }
            this.angles = this.getRoot(tri.getCorner(0), tri.getCorner(1), tri.getCorner(2), tri.getCount());
            if (this.angles != null && this.angles[0] < this.angleLimit) {
                this.addToHeap(this.angles, tri);
            }
        }
        for (Edge e : t0.getEdges()) {
            if (e.equals(new Edge(vs[0], vns[0]))) {
                nt0.setEdge(e);
                continue;
            }
            if (e.equals(new Edge(vs[0], vns[1]))) {
                nt0.setEdge(e);
                continue;
            }
            if (e.equals(new Edge(vs[1], vns[0]))) {
                nt1.setEdge(e);
                continue;
            }
            if (e.equals(new Edge(vs[1], vns[1]))) {
                nt1.setEdge(e);
                continue;
            }
            if (!e.equals(new Edge(vns[1], vns[0]))) continue;
            nt1.setEdge(e);
            nt0.setEdge(e);
        }
        for (Edge e : t1.getEdges()) {
            if (e.equals(new Edge(vs[0], vns[2]))) {
                nt0.setEdge(e);
                continue;
            }
            if (e.equals(new Edge(vs[0], vns[1]))) {
                nt0.setEdge(e);
                continue;
            }
            if (e.equals(new Edge(vs[1], vns[2]))) {
                nt1.setEdge(e);
                continue;
            }
            if (e.equals(new Edge(vs[1], vns[1]))) {
                nt1.setEdge(e);
                continue;
            }
            if (!e.equals(new Edge(vns[1], vns[2]))) continue;
            nt1.setEdge(e);
            nt0.setEdge(e);
        }
        for (Edge e : t2.getEdges()) {
            if (e.equals(new Edge(vs[0], vns[2]))) {
                nt0.setEdge(e);
                continue;
            }
            if (e.equals(new Edge(vs[0], vns[0]))) {
                nt0.setEdge(e);
                continue;
            }
            if (e.equals(new Edge(vs[1], vns[2]))) {
                nt1.setEdge(e);
                continue;
            }
            if (e.equals(new Edge(vs[1], vns[0]))) {
                nt1.setEdge(e);
                continue;
            }
            if (!e.equals(new Edge(vns[0], vns[2]))) continue;
            nt1.setEdge(e);
            nt0.setEdge(e);
        }
        for (Tet t : nt) {
            count = t.getCount();
            int idxR = -1;
            int idxS0 = -1;
            int idxS1 = -1;
            int idxS2 = -1;
            if (count == 0 || count == 15) {
                if (!t.isAlpha(this.alphaVal)) continue;
                t.setAlph(1);
                this.alphaTets.add(t);
                continue;
            }
            if (t.isAlpha(this.alphaVal)) {
                t.setAlph(1);
                this.alphaTets.add(t);
            } else if (t.nrRotating() == 1) {
                if (count == 8 || count == 7) {
                    idxR = 3;
                    idxS0 = 0;
                    idxS1 = 1;
                    idxS2 = 2;
                }
                if (count == 4 || count == 11) {
                    idxR = 2;
                    idxS0 = 0;
                    idxS1 = 1;
                    idxS2 = 3;
                }
                if (count == 2 || count == 13) {
                    idxR = 1;
                    idxS0 = 0;
                    idxS1 = 3;
                    idxS2 = 2;
                }
                if (count == 1 || count == 14) {
                    idxR = 0;
                    idxS0 = 3;
                    idxS1 = 1;
                    idxS2 = 2;
                }
                Vertex r = t.getCorner(idxR);
                Vertex s0 = t.getCorner(idxS0);
                Vertex s1 = t.getCorner(idxS1);
                Vertex s2 = t.getCorner(idxS2);
                double d0 = s0.distanceSquared(s1);
                double d1 = s1.distanceSquared(s2);
                double d2 = s2.distanceSquared(s0);
                double a0 = r.distanceSquared(s0);
                double a1 = r.distanceSquared(s1);
                double a2 = r.distanceSquared(s2);
                if (a0 < d0 && a1 < d0 && a1 < d1 && a2 < d2 && a2 < d2 && a0 < d2) {
                    t.setAlph(2);
                } else {
                    t.setAlph(0);
                }
            }
            this.angles = this.getRoot(t.getCorner(0), t.getCorner(1), t.getCorner(2), t.getCorner(3), count);
            if (this.angles == null || !(this.angles[0] < this.angleLimit)) continue;
            this.addToHeap(this.angles, t);
        }
        this.alphaTets.remove(t0);
        this.alphaTets.remove(t1);
        this.alphaTets.remove(t2);
        vs[0].setTet(nt0);
        vs[1].setTet(nt1);
        vns[0].setTet(nt0);
        vns[1].setTet(nt0);
        vns[2].setTet(nt0);
        nt0.neighbors[nt0.indexOf_slow((Vertex)vs[0])] = nt1;
        nt1.neighbors[nt1.indexOf_slow((Vertex)vs[1])] = nt0;
        Tet tn0 = t2;
        if (!t0.hasVertex(vns[0])) {
            tn0 = t0;
        } else if (!t1.hasVertex(vns[0])) {
            tn0 = t1;
        }
        Tet tn1 = t2;
        if (!t0.hasVertex(vns[1])) {
            tn1 = t0;
        } else if (!t1.hasVertex(vns[1])) {
            tn1 = t1;
        }
        Tet tn2 = t2;
        if (!t0.hasVertex(vns[2])) {
            tn2 = t0;
        } else if (!t1.hasVertex(vns[2])) {
            tn2 = t1;
        }
        for (i2 = 0; i2 < 4; ++i2) {
            Tet n0 = tn0.neighbors[i2];
            Tri triangle = tn0.getTri(i2);
            if (n0 == null) {
                if (tn0.getCorner(i2) == vs[1]) {
                    nt0.setTri(triangle, nt0.indexOf_slow(vns[0]));
                    continue;
                }
                nt1.setTri(triangle, nt1.indexOf_slow(vns[0]));
                continue;
            }
            if (n0 == tn1 || n0 == tn2) continue;
            idx = n0.apex(tn0);
            if (n0.hasVertex(vs[0])) {
                n0.neighbors[idx] = nt0;
                triangle = n0.getTri(idx);
                nt0.setTri(triangle, nt0.indexOf_slow(vns[0]));
                nt0.neighbors[nt0.indexOf_slow((Vertex)vns[0])] = n0;
                continue;
            }
            n0.neighbors[idx] = nt1;
            triangle = n0.getTri(idx);
            nt1.setTri(triangle, nt1.indexOf_slow(vns[0]));
            nt1.neighbors[nt1.indexOf_slow((Vertex)vns[0])] = n0;
        }
        for (i2 = 0; i2 < 4; ++i2) {
            Tet n1 = tn1.neighbors[i2];
            Tri triangle = tn1.getTri(i2);
            if (n1 == null) {
                if (tn1.getCorner(i2) == vs[1]) {
                    nt0.setTri(triangle, nt0.indexOf_slow(vns[1]));
                    continue;
                }
                nt1.setTri(triangle, nt1.indexOf_slow(vns[1]));
                continue;
            }
            if (n1 == tn0 || n1 == tn2) continue;
            idx = n1.apex(tn1);
            if (n1.hasVertex(vs[0])) {
                n1.neighbors[idx] = nt0;
                triangle = n1.getTri(idx);
                nt0.setTri(triangle, nt0.indexOf_slow(vns[1]));
                nt0.neighbors[nt0.indexOf_slow((Vertex)vns[1])] = n1;
                continue;
            }
            n1.neighbors[idx] = nt1;
            triangle = n1.getTri(idx);
            nt1.setTri(triangle, nt1.indexOf_slow(vns[1]));
            nt1.neighbors[nt1.indexOf_slow((Vertex)vns[1])] = n1;
        }
        for (i2 = 0; i2 < 4; ++i2) {
            Tet n2 = tn2.neighbors[i2];
            Tri triangle = tn2.getTri(i2);
            if (n2 == null) {
                if (tn2.getCorner(i2) == vs[1]) {
                    nt0.setTri(triangle, nt0.indexOf_slow(vns[2]));
                    continue;
                }
                nt1.setTri(triangle, nt1.indexOf_slow(vns[2]));
                continue;
            }
            if (n2 == tn0 || n2 == tn1) continue;
            idx = n2.apex(tn2);
            if (n2.hasVertex(vs[0])) {
                n2.neighbors[idx] = nt0;
                triangle = n2.getTri(idx);
                nt0.setTri(triangle, nt0.indexOf_slow(vns[2]));
                nt0.neighbors[nt0.indexOf_slow((Vertex)vns[2])] = n2;
                continue;
            }
            n2.neighbors[idx] = nt1;
            triangle = n2.getTri(idx);
            nt1.setTri(triangle, nt1.indexOf_slow(vns[2]));
            nt1.neighbors[nt1.indexOf_slow((Vertex)vns[2])] = n2;
        }
        this.tets.remove(t0);
        t0.setAlive(false);
        this.tets.remove(t1);
        t1.setAlive(false);
        this.tets.remove(t2);
        t2.setAlive(false);
        Tet[] newTets = new Tet[]{nt0, nt1};
        this.tets.add(nt0);
        this.tets.add(nt1);
        this.angles = this.getRoot(nt0, nt1);
        if (this.angles != null && this.angles[0] < this.angleLimit) {
            this.addToHeap(this.angles, nt0, nt1);
            if (this.testingPrint) {
                System.out.println(nt0 + " " + nt1 + " " + Functions.toDeg(this.angles[0]) + " " + Functions.toDeg(this.angles[1]));
            }
        }
        for (i = 0; i < 4; ++i) {
            Tet nti = nt0.neighbors[i];
            if (nti == null || nti == nt1) continue;
            this.angles = this.getRoot(nt0, nti);
            if (this.angles == null || !(this.angles[0] < this.angleLimit)) continue;
            this.addToHeap(this.angles, nt0, nti);
            if (!this.testingPrint) continue;
            System.out.println(nt0 + " " + nti + " " + Functions.toDeg(this.angles[0]) + " " + Functions.toDeg(this.angles[1]));
        }
        for (i = 0; i < 4; ++i) {
            Tet nti = nt1.neighbors[i];
            if (nti == null || nti == nt0) continue;
            this.angles = this.getRoot(nt1, nti);
            if (this.angles == null || !(this.angles[0] < this.angleLimit)) continue;
            this.addToHeap(this.angles, nt1, nti);
            if (!this.testingPrint) continue;
            System.out.println(nt1 + " " + nti + " " + Functions.toDeg(this.angles[0]) + " " + Functions.toDeg(this.angles[1]));
        }
        this.flipTime += (double)(System.nanoTime() - start) / 1000000.0;
        return newTets;
    }

    public boolean isDelaunay() {
        boolean cont = true;
        for (Tet t : this.tets) {
            if (t.isBig()) continue;
            t.setCircumSphere();
            if (t.circumSphere.isEmpty(this.vertices, Constants.EPSILON)) continue;
            System.out.print(t + " is not empty: ");
            t.circumSphere.contains(this.vertices, Constants.EPSILON);
            cont = false;
        }
        return cont;
    }

    private void rotatePoints(double angle) {
        int steps = 1;
        double angleStep = angle / (double)steps;
        for (int k = 0; k < steps; ++k) {
            for (Integer i : this.rotIndx) {
                Vertex v = this.vertices.get(i);
                v.rotationCW(this.rotationAxis, angleStep);
            }
        }
    }

    public void rotateTo(double rotateTo) {
        HeapItem angleCheck;
        if (rotateTo > this.angleLimit) {
            throw new RuntimeException("Angle is bigger than limit=360");
        }
        int nrFlips = 0;
        this.clash = this.clashFirst = this.alphaEdges.isEmpty();
        while (!this.heap.isEmpty() && this.angleTotal < rotateTo && !((angleCheck = (HeapItem)this.heap.peek()).angles[0] > rotateTo)) {
            int idxS1;
            int idxS0;
            int count;
            double rotAngle;
            HeapItem heapItem = (HeapItem)this.heap.extract();
            Tet t = heapItem.getT();
            Tri tri = heapItem.getTri();
            if (t != null) {
                Tet nt = heapItem.getNT();
                if (nt != null) {
                    if (this.testingPrint) {
                        System.out.print(t.toString());
                        if (!t.isAlive()) {
                            System.out.print("");
                        }
                        System.out.print(nt.toString());
                        if (!nt.isAlive()) {
                            System.out.print("");
                        }
                    }
                    this.angles = heapItem.getAngles();
                    rotAngle = this.angles[0];
                    if (rotAngle > rotateTo) break;
                    if (!t.isAlive() || !nt.isAlive()) continue;
                    this.angleTotal = rotAngle;
                    if (!t.isConvex(nt)) {
                        Tet tt = KineticToolbox.getThirdTet(t, nt);
                        if (tt != null) {
                            if (this.testingPrint) {
                                System.out.print(tt.toString());
                                if (!tt.isAlive()) {
                                    System.out.print("___");
                                }
                                System.out.print(" rotated to angle = " + Functions.toDeg(heapItem.getAngles()[0]));
                                System.out.println();
                            }
                            this.flip32(t, nt, tt);
                            if (this.testingPrint) {
                                System.out.println(++nrFlips + ". flip.");
                            }
                        } else {
                            System.out.println(" not convex but tt = null");
                        }
                    } else {
                        if (this.testingPrint) {
                            System.out.print(" rotated to angle = " + Functions.toDeg(heapItem.getAngles()[0]));
                            System.out.println();
                        }
                        this.flip23(t, nt);
                        if (this.testingPrint) {
                            System.out.println(++nrFlips + ". flip.");
                        }
                    }
                    if (this.clash != this.alphaEdges.isEmpty()) {
                        this.clash = this.alphaEdges.isEmpty();
                        this.clashes.add(Math.toDegrees(this.angleTotal));
                    }
                    if (this.clash == this.alphaEdges.isEmpty()) continue;
                    this.clash = this.alphaEdges.isEmpty();
                    this.clashes.add(Math.toDegrees(this.angleTotal));
                    continue;
                }
                this.angles = heapItem.getAngles();
                rotAngle = this.angles[0];
                if (!t.isAlive() || !(rotAngle < this.angleLimit)) continue;
                if (t.nrRotating() == 1) {
                    this.rotatePoints(rotAngle - this.angleTotal);
                    this.angleTotal = rotAngle;
                    int alph = t.getAlph();
                    count = t.getCount();
                    int idxR = -1;
                    idxS0 = -1;
                    idxS1 = -1;
                    int idxS2 = -1;
                    if (count == 8 || count == 7) {
                        idxR = 3;
                        idxS0 = 0;
                        idxS1 = 1;
                        idxS2 = 2;
                    } else if (count == 4 || count == 11) {
                        idxR = 2;
                        idxS0 = 0;
                        idxS1 = 1;
                        idxS2 = 3;
                    } else if (count == 2 || count == 13) {
                        idxR = 1;
                        idxS0 = 0;
                        idxS1 = 3;
                        idxS2 = 2;
                    } else if (count == 1 || count == 14) {
                        idxR = 0;
                        idxS0 = 3;
                        idxS1 = 1;
                        idxS2 = 2;
                    }
                    Vertex r = t.getCorner(idxR);
                    Vertex s0 = t.getCorner(idxS0);
                    Vertex s1 = t.getCorner(idxS1);
                    Vertex s2 = t.getCorner(idxS2);
                    Circle circum = new Circle((Point)s0, (Point)s1, s2);
                    int onBoundary = 0;
                    boolean insideBoth = false;
                    Vector vec = r.vectorTo(circum.getCenter());
                    Vector centerToRotate = vec.cross(circum.getNormal());
                    boolean orthogonal = centerToRotate.isZeroVector();
                    if (orthogonal && r.distance(circum.getCenter()) > circum.getRadius() - Constants.EPSILON && r.distance(circum.getCenter()) < circum.getRadius() + Constants.EPSILON) {
                        onBoundary = 1;
                    }
                    if (r.distance(circum.getCenter()) > circum.getRadius() - Constants.EPSILON && r.distance(circum.getCenter()) < circum.getRadius() + Constants.EPSILON) {
                        insideBoth = true;
                    }
                    if (alph == 0) {
                        if (onBoundary != 0) {
                            t.setAlph(2);
                        } else {
                            t.setAlph(1);
                            this.alphaTets.add(t);
                        }
                    } else if (alph == 1) {
                        if (onBoundary != 0) {
                            t.setAlph(1);
                        } else if (insideBoth) {
                            t.setAlph(2);
                            this.alphaTets.remove(t);
                        } else {
                            t.setAlph(0);
                            this.alphaTets.remove(t);
                        }
                    } else if (onBoundary != 0) {
                        t.setAlph(0);
                    } else {
                        t.setAlph(1);
                        this.alphaTets.add(t);
                    }
                    Double[] tmp = new Double[4];
                    int i = -1;
                    for (Double angle : this.angles) {
                        if (i == -1) {
                            ++i;
                            continue;
                        }
                        if (angle == null) break;
                        tmp[i] = angle;
                        ++i;
                    }
                    if (i > 0) {
                        Double[] newangles = new Double[i];
                        for (int j = 0; j < i; ++j) {
                            newangles[j] = tmp[j];
                        }
                        this.addToHeap(newangles, t);
                    }
                } else {
                    this.rotatePoints(rotAngle - this.angleTotal);
                    this.angleTotal = rotAngle;
                    if (t.getAlph() == 1) {
                        t.setAlph(0);
                        this.alphaTets.remove(t);
                    } else {
                        t.setAlph(1);
                        this.alphaTets.add(t);
                    }
                    Double[] tmp = new Double[4];
                    int i = -1;
                    for (Double angle : this.angles) {
                        if (i == -1) {
                            ++i;
                            continue;
                        }
                        if (angle == null) break;
                        tmp[i] = angle;
                        ++i;
                    }
                    if (i > 0) {
                        Double[] newangles = new Double[i];
                        for (int j = 0; j < i; ++j) {
                            newangles[j] = tmp[j];
                        }
                        this.addToHeap(newangles, t);
                    }
                }
                if (this.clash == this.alphaEdges.isEmpty()) continue;
                this.clash = this.alphaEdges.isEmpty();
                this.clashes.add(Math.toDegrees(this.angleTotal));
                continue;
            }
            if (tri != null) {
                this.angles = heapItem.getAngles();
                rotAngle = this.angles[0];
                if (!tri.isAlive() || !(rotAngle < this.angleLimit)) continue;
                this.rotatePoints(rotAngle - this.angleTotal);
                this.angleTotal = rotAngle;
                int alph = tri.getAlph();
                count = tri.getCount();
                int idxR = -1;
                idxS0 = -1;
                idxS1 = -1;
                if (count == 1 || count == 6) {
                    idxR = 0;
                    idxS0 = 2;
                    idxS1 = 1;
                } else if (count == 2 || count == 5) {
                    idxR = 1;
                    idxS0 = 0;
                    idxS1 = 2;
                } else if (count == 4 || count == 3) {
                    idxR = 2;
                    idxS0 = 0;
                    idxS1 = 1;
                }
                Vertex r = tri.getCorner(idxR);
                Vertex s0 = tri.getCorner(idxS0);
                Vertex s1 = tri.getCorner(idxS1);
                if (alph == 1) {
                    this.alphaTris.remove(tri);
                    Point c = Point.getMidpoint(s0, s1);
                    if (c.distanceSquared(r) < c.distanceSquared(s0)) {
                        tri.setAlph(2);
                    } else {
                        tri.setAlph(0);
                    }
                } else if (alph == 0) {
                    this.alphaTris.add(tri);
                    tri.setAlph(1);
                } else {
                    this.alphaTris.add(tri);
                    tri.setAlph(1);
                }
                Double[] tmp = new Double[4];
                int i = -1;
                for (Double angle : this.angles) {
                    if (i == -1) {
                        ++i;
                        continue;
                    }
                    if (angle == null) break;
                    tmp[i] = angle;
                    ++i;
                }
                if (i > 0) {
                    Double[] newangles = new Double[i];
                    for (int j = 0; j < i; ++j) {
                        newangles[j] = tmp[j];
                    }
                    this.addToHeap(newangles, tri);
                }
                if (this.clash == this.alphaEdges.isEmpty()) continue;
                this.clash = this.alphaEdges.isEmpty();
                this.clashes.add(Math.toDegrees(this.angleTotal));
                continue;
            }
            Edge edg = heapItem.getEdg();
            this.angles = heapItem.getAngles();
            rotAngle = this.angles[0];
            if (!edg.isAlive() || edg == null || !(rotAngle < this.angleLimit)) continue;
            this.rotatePoints(rotAngle - this.angleTotal);
            this.angleTotal = rotAngle;
            if (edg.getAlph()) {
                edg.setAlph(false);
                this.alphaEdges.remove(edg);
            } else {
                edg.setAlph(true);
                this.alphaEdges.add(edg);
            }
            Double[] newangles = new Double[4];
            if (this.angles[1] != null) {
                newangles[0] = this.angles[1];
                this.addToHeap(newangles, edg);
            }
            if (this.clash == this.alphaEdges.isEmpty()) continue;
            this.clash = this.alphaEdges.isEmpty();
            this.clashes.add(Math.toDegrees(this.angleTotal));
        }
    }

    private void setRotVertices(Set<Integer> rotList) {
        this.rotIndx = rotList;
        for (Vertex v : this.vertices) {
            v.setType(Vertex.VertexType.S);
        }
        Iterator<Comparable<Vertex>> iterator = this.rotIndx.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.vertices.get(i).setType(Vertex.VertexType.R);
        }
    }

    public Set<Tet> getTetrahedra() {
        return this.tets;
    }

    public Set<Tet> getAlphaTetrahedra() {
        return this.alphaTets;
    }

    public double getAlpha() {
        return this.alphaVal;
    }

    private class SortToolHeapItems
    implements SortTool {
        private SortToolHeapItems() {
        }

        @Override
        public int compare(Object x1, Object x2) {
            if (x1 instanceof HeapItem && x2 instanceof HeapItem) {
                double d2;
                double d1 = ((HeapItem)x1).getAngles()[0];
                if (d1 < (d2 = ((HeapItem)x2).getAngles()[0].doubleValue())) {
                    return -1;
                }
                if (d1 > d2) {
                    return 1;
                }
                return 0;
            }
            throw SortTool.err1;
        }
    }

    private class HeapItem {
        private Double[] angles;
        private Tet t = null;
        private Tet nt = null;
        private Tri tri = null;
        private Edge edg = null;

        private HeapItem(Double[] angles, Tet t, Tet nt, Tri tri, Edge e) {
            this.angles = angles;
            this.t = t;
            this.tri = tri;
            this.nt = nt;
            this.edg = e;
        }

        private Double[] getAngles() {
            return this.angles;
        }

        private Tet getT() {
            return this.t;
        }

        private Tet getNT() {
            return this.nt;
        }

        private Tri getTri() {
            return this.tri;
        }

        private Edge getEdg() {
            return this.edg;
        }
    }
}

