/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.geom3d.volumes;

import ProGAL.geom3d.Plane;
import ProGAL.geom3d.Point;
import ProGAL.geom3d.Simplex;
import ProGAL.geom3d.Triangle;
import ProGAL.geom3d.Vector;
import ProGAL.geom3d.volumes.Sphere;
import ProGAL.geom3d.volumes.Volume;

public class Tetrahedron
implements Simplex,
Volume {
    protected Point[] corners = new Point[4];

    public Tetrahedron(Point p1, Point p2, Point p3, Point p4) {
        this.corners[0] = p1;
        this.corners[1] = p2;
        this.corners[2] = p3;
        this.corners[3] = p4;
    }

    public Tetrahedron(Point[] corners) {
        this.corners = corners;
    }

    public static Tetrahedron regularTetrahedron() {
        return new Tetrahedron(new Point(1.0, 0.0, 0.0), new Point(-0.3333333333333333, Math.sqrt(8.0) / 3.0, 0.0), new Point(-0.3333333333333333, -Math.sqrt(2.0) / 3.0, Math.sqrt(0.6666666666666666)), new Point(-0.3333333333333333, -Math.sqrt(2.0) / 3.0, -Math.sqrt(0.6666666666666666)));
    }

    public Point getCorner(int c) {
        if (c < 0 || c > 3) {
            throw new IllegalArgumentException();
        }
        return this.corners[c];
    }

    public Point[] getCorners() {
        return this.corners;
    }

    public void translate(Vector v) {
        for (Point p : this.corners) {
            p.translateThis(v.x(), v.y(), v.z());
        }
    }

    public void translate(Point q) {
        for (Point p : this.corners) {
            p.translateThis(q.x(), q.y(), q.z());
        }
    }

    public void translate(double x, double y, double z) {
        for (Point p : this.corners) {
            p.translateThis(x, y, z);
        }
    }

    public void blowUp(double t) {
        Point center = this.circumCenter();
        this.translate(-center.x(), -center.y(), -center.z());
        for (Point p : this.corners) {
            p.scaleThis(t);
        }
        this.translate(center);
    }

    @Override
    public Point getPoint(int c) {
        if (c < 0 || c > 3) {
            throw new IllegalArgumentException();
        }
        return this.corners[c];
    }

    @Override
    public int getDimension() {
        return 3;
    }

    public void setPoint(int c, Point point) {
        if (c < 0 || c > 3) {
            throw new IllegalArgumentException();
        }
        this.corners[c] = point;
    }

    @Override
    public boolean overlaps(Volume vol) {
        return false;
    }

    @Override
    public double getVolume() {
        Vector a = this.corners[3].vectorTo(this.corners[0]);
        Vector b = this.corners[3].vectorTo(this.corners[1]);
        Vector c = this.corners[3].vectorTo(this.corners[2]);
        return Math.abs(a.dot(b.crossThis(c))) / 6.0;
    }

    public Triangle getCommonTriangle(Tetrahedron t) {
        Point[] common = new Point[4];
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!this.corners[i].equals(t.corners[j])) continue;
                common[count++] = this.corners[i];
                j = 4;
            }
        }
        if (count != 3) {
            return null;
        }
        return new Triangle(common[0], common[1], common[2]);
    }

    public double getInradius() {
        Vector a = this.corners[3].vectorTo(this.corners[0]);
        Vector b = this.corners[3].vectorTo(this.corners[1]);
        Vector c = this.corners[3].vectorTo(this.corners[2]);
        Vector bXc = b.cross(c);
        double sixV = Math.abs(a.dot(bXc));
        Vector cXa = c.crossThis(a);
        Vector aXb = a.crossThis(b);
        double denom = bXc.length() + cXa.length() + aXb.length() + bXc.addThis(cXa).addThis(aXb).length();
        return sixV / denom;
    }

    public double circumRadius() {
        Vector a = this.corners[3].vectorTo(this.corners[0]);
        Vector b = this.corners[3].vectorTo(this.corners[1]);
        Vector c = this.corners[3].vectorTo(this.corners[2]);
        Vector O = b.cross(c).multiplyThis(a.dot(a));
        O.addThis(c.cross(a).multiplyThis(b.dot(b)));
        O.addThis(a.cross(b).multiplyThis(c.dot(c)));
        O.multiplyThis(1.0 / (2.0 * a.dot(b.crossThis(c))));
        return O.length();
    }

    public Point circumCenter() {
        Vector a = this.corners[3].vectorTo(this.corners[0]);
        Vector b = this.corners[3].vectorTo(this.corners[1]);
        Vector c = this.corners[3].vectorTo(this.corners[2]);
        Vector O = b.cross(c).multiplyThis(a.dot(a));
        O.addThis(c.cross(a).multiplyThis(b.dot(b)));
        O.addThis(a.cross(b).multiplyThis(c.dot(c)));
        O.multiplyThis(1.0 / (2.0 * a.dot(b.crossThis(c))));
        return this.corners[3].add(O);
    }

    public Sphere circumSphere() {
        Vector a = this.corners[3].vectorTo(this.corners[0]);
        Vector b = this.corners[3].vectorTo(this.corners[1]);
        Vector c = this.corners[3].vectorTo(this.corners[2]);
        Vector O = b.cross(c).multiplyThis(a.dot(a));
        O.addThis(c.cross(a).multiplyThis(b.dot(b)));
        O.addThis(a.cross(b).multiplyThis(c.dot(c)));
        O.multiplyThis(1.0 / (2.0 * a.dot(b.crossThis(c))));
        return new Sphere(this.corners[3].add(O), O.length());
    }

    public Point incenter() {
        Vector a = this.corners[3].vectorTo(this.corners[0]);
        Vector b = this.corners[3].vectorTo(this.corners[1]);
        Vector c = this.corners[3].vectorTo(this.corners[2]);
        Vector bXc = b.cross(c);
        Vector cXa = c.cross(a);
        Vector aXb = a.cross(b);
        double bXcLength = bXc.length();
        double cXaLength = cXa.length();
        double aXbLength = aXb.length();
        double dLength = bXc.addThis(cXa).addThis(aXb).length();
        Vector O = a.multiplyThis(bXcLength);
        O.addThis(b.multiplyThis(cXaLength));
        O.addThis(c.multiplyThis(aXbLength));
        O.divideThis(bXcLength + cXaLength + aXbLength + dLength);
        return this.corners[3].add(O);
    }

    @Override
    public Point getCenter() {
        Vector v = this.corners[0].vectorTo(this.corners[1]);
        v.addThis(this.corners[0].vectorTo(this.corners[2]));
        v.addThis(this.corners[0].vectorTo(this.corners[3]));
        return this.corners[0].add(v.multiplyThis(0.25));
    }

    public boolean isInside(Point p) {
        Plane pl012 = new Plane(this.getCorner(0), this.getCorner(1), this.getCorner(2));
        Plane pl013 = new Plane(this.getCorner(0), this.getCorner(1), this.getCorner(3));
        Plane pl023 = new Plane(this.getCorner(0), this.getCorner(2), this.getCorner(3));
        Plane pl123 = new Plane(this.getCorner(1), this.getCorner(2), this.getCorner(3));
        return pl012.above(p) == 1 && pl013.above(p) == 1 && pl023.above(p) == 1 && pl123.above(p) == 1 || pl012.below(p) == 1 && pl013.below(p) == 1 && pl023.below(p) == 1 && pl123.below(p) == 1;
    }

    public boolean isAcute() {
        return Point.getCosDihedralAngle(this.corners[0], this.corners[1], this.corners[2], this.corners[3]) > 0.0 && Point.getCosDihedralAngle(this.corners[0], this.corners[1], this.corners[3], this.corners[2]) > 0.0 && Point.getCosDihedralAngle(this.corners[0], this.corners[2], this.corners[3], this.corners[1]) > 0.0 && Point.getCosDihedralAngle(this.corners[2], this.corners[0], this.corners[1], this.corners[3]) > 0.0 && Point.getCosDihedralAngle(this.corners[1], this.corners[0], this.corners[2], this.corners[3]) > 0.0 && Point.getCosDihedralAngle(this.corners[1], this.corners[0], this.corners[3], this.corners[2]) > 0.0;
    }

    @Override
    public Volume clone() {
        return new Tetrahedron(this.corners[0].clone(), this.corners[1].clone(), this.corners[2].clone(), this.corners[3].clone());
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int dec) {
        return String.format("Tetrahedron[%s,%s,%s,%s]", this.corners[0].toString(dec), this.corners[1].toString(dec), this.corners[2].toString(dec), this.corners[3].toString(dec));
    }

    public void toConsole() {
        System.out.println(this.toString());
    }

    public void toConsole(int dec) {
        System.out.println(this.toString(dec));
    }

    public static void main(String[] args) {
        Point p2 = new Point(1.0, 1.0, 0.0);
        Point p1 = new Point(1.0, 0.0, 0.0);
        Point p3 = new Point(2.0, 2.0, 3.0);
        Point p4 = new Point(3.0, 4.0, 2.0);
        Tetrahedron tetr = new Tetrahedron(p2, p1, p3, p4);
        Point p5 = new Point(0.0, 0.0, 3.0);
        if (tetr.isInside(p5)) {
            System.out.println("inside");
        } else {
            System.out.println("outside");
        }
    }
}

