/*
 * Decompiled with CFR 0.152.
 */
package ProGAL.math;

import ProGAL.Function;
import ProGAL.math.Constants;

public class RootFinding {
    public static Double bisection(Function f, double a, double b, double tol, int nMax) {
        double fb;
        double fa = f.getValue(a);
        if (fa * (fb = f.getValue(b)) >= 0.0) {
            System.out.println("Bisection method failed - root is not bracketed.");
            return null;
        }
        double signA = Math.signum(fa);
        double c = 0.0;
        int n = 0;
        while (++n <= nMax) {
            c = (a + b) / 2.0;
            double fc = f.getValue(c);
            System.out.println(n + ". c = " + c + ", fc = " + fc);
            if (Math.abs(fc) < Constants.EPSILON || (b - a) / 2.0 < tol) {
                return c;
            }
            if (Math.signum(fc) == signA) {
                a = c;
                continue;
            }
            b = c;
        }
        System.out.println("Bisection method failed - max number of iterations.");
        return c;
    }

    public static Double secant(Function f, double x, double x1, double tol, int nMax) {
        int n = 0;
        double x2 = 0.0;
        double fx1 = f.getValue(x1);
        double fx = f.getValue(x);
        while (++n <= nMax) {
            if (Math.abs(fx1) < Constants.EPSILON || Math.abs(x1 - x) < tol) {
                return x;
            }
            x2 = x1 - fx1 * (x1 - x) / (fx1 - fx);
            x = x1;
            fx = fx1;
            x1 = x2;
            fx1 = f.getValue(x1);
        }
        System.out.println("Bisection method failed - max number of iterations.");
        return x;
    }

    public static Double newton(Function f, double x, double x1, double tol, int nMax) {
        Function d = f.getDerivative();
        int n = 0;
        double fx = f.getValue(x);
        while (++n <= nMax) {
            if (Math.abs(fx) < Constants.EPSILON || Math.abs(x1 - x) < tol) {
                return x;
            }
            double dx = fx / d.getValue(x);
            x1 = x;
            fx = f.getValue(x -= dx);
        }
        System.out.println("Newton method failed - max number of iterations.");
        return x;
    }

    public static Double inverseQuadraticInterpolation(Function f, double x, double x1, double x2, double tol, int nMax) {
        int n = 0;
        double fx = f.getValue(x);
        double fx1 = f.getValue(x1);
        double fx2 = f.getValue(x2);
        while (++n <= nMax) {
            if (Math.abs(fx) < Constants.EPSILON || Math.abs(x1 - x) < tol) {
                return x;
            }
            double x0 = x2 * fx1 * fx / ((fx2 - fx1) * (fx2 - fx)) + x1 * fx2 * fx / ((fx1 - fx2) * (fx1 - fx)) + x * fx2 * fx1 / ((fx - fx2) * (fx - fx1));
            x2 = x1;
            fx2 = fx1;
            x1 = x;
            fx1 = fx;
            x = x0;
            fx = f.getValue(x);
        }
        System.out.println("Inverse Quadratic Interpolation method failed - max number of iterations.");
        return x;
    }

    public static Double dekker(Function f, double a, double b, double tol, int nMax) {
        double fb;
        double fa = f.getValue(a);
        if (fa * (fb = f.getValue(b)) >= 0.0) {
            System.out.println("Dekker method failed - root is not bracketed.");
            return null;
        }
        int n = 0;
        while (++n <= nMax) {
            if (Math.abs(fa) < Math.abs(fb)) {
                double temp = a;
                a = b;
                b = temp;
                temp = fa;
                fa = fb;
                fb = temp;
            }
            double bOld = b;
            double fbOld = fb;
            b = Math.abs(fb - fa) > Constants.EPSILON ? (b -= fb * (b - a) / (fb - fa)) : (a + b) / 2.0;
            fb = f.getValue(b);
            System.out.println(n + ". b = " + b + ", fb = " + fb);
            if (Math.abs(fb) < Constants.EPSILON || Math.abs((b - a) / 2.0) < tol) {
                return b;
            }
            if (!(fa * fb >= 0.0)) continue;
            a = bOld;
            fa = fbOld;
        }
        System.out.println("Dekker method failed - max number of iterations.");
        return b;
    }

    public static Double brent(Function f, double a, double b, double tol, double delta, int nMax) {
        double c;
        double fa = f.getValue(a);
        double fb = f.getValue(b);
        double fc = fa;
        if (fa * fb >= 0.0) {
            System.out.println("Brent method failed - root is not bracketed.");
            return null;
        }
        double d = c = a;
        boolean mflag = true;
        int n = 0;
        while (++n <= nMax) {
            double s;
            double temp;
            if (Math.abs(fa) < Math.abs(fb)) {
                temp = a;
                a = b;
                b = temp;
                temp = fa;
                fa = fb;
                fb = temp;
            }
            if ((s = Math.abs(fc - fa) > Constants.EPSILON && Math.abs(fc - fb) > Constants.EPSILON ? a * fb * fc / ((fa - fb) * (fa - fc)) + b * fa * fc / ((fb - fa) * (fb - fc)) + c * fa * fb / ((fc - fa) * (fc - fb)) : b - fb * (b - a) / (fb - fa)) <= (3.0 * a + b) / 4.0 || s >= b || mflag && (Math.abs(s - b) >= Math.abs(b - c) / 2.0 || Math.abs(b - c) < delta) || !mflag && (Math.abs(s - b) >= Math.abs(c - d) / 2.0 || Math.abs(c - d) < delta)) {
                s = (a + b) / 2.0;
                mflag = true;
            } else {
                mflag = false;
            }
            double fs = f.getValue(s);
            d = c;
            c = b;
            if (fa * fs < 0.0) {
                b = s;
                fb = fs;
            } else {
                a = s;
                fa = fs;
            }
            if (Math.abs(fa) < Math.abs(fb)) {
                temp = a;
                a = b;
                b = temp;
                temp = fa;
                fa = fb;
                fb = temp;
            }
            System.out.println(n + ". b = " + b + ", fb = " + fb);
            if (!(Math.abs(fb) < Constants.EPSILON) && !(Math.abs((b - a) / 2.0) < tol)) continue;
            return b;
        }
        System.out.println("Brent method failed - max number of iterations.");
        return c;
    }

    public static void main(String[] args) {
        double[] c = new double[]{-2.0, -1.0, 0.0, 1.0};
        Function f = new Function(c);
        double root = RootFinding.brent(f, 1.0, 2.0, 1.0E-6, 1.0E-5, 25);
        System.out.println("Root at " + root + " with value " + f.getValue(root));
    }
}

