/*
 * Decompiled with CFR 0.152.
 */
package org.das2.qds.util;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.datum.Datum;
import org.das2.datum.DatumVector;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.BundleBuilder;
import org.das2.util.LoggerManager;

public class DataSetBuilder {
    private static final Logger logger = LoggerManager.getLogger((String)"qdataset.util.dsb");
    int rank;
    ArrayList<DDataSet> finished;
    DDataSet current;
    int recCount;
    int dim1;
    int dim2;
    int dim3;
    int recElements;
    int index;
    int offset;
    int length;
    HashMap<String, Object> properties;
    private HashMap<String, String> unresolvedPropertyTypes;
    private HashMap<String, String> unresolvedPropertyValues;
    Units u = null;
    Units[] us = null;
    String[] labels = null;
    String[] names = null;
    boolean isBundle = false;
    public static final String UNRESOLVED_PROP_QDATASET = "qdataset";
    private double fillValue = -1.0E31;
    private boolean fillValueUsed = false;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected double validMin = Double.NEGATIVE_INFINITY;
    public static final String PROP_VALIDMIN = "validMin";
    protected double validMax = Double.POSITIVE_INFINITY;
    public static final String PROP_VALIDMAX = "validMax";
    private DataSetResolver dataSetResolver = null;

    public DataSetBuilder(int rank) {
        this(rank, 0, 1, 1);
        if (rank != 0) {
            throw new IllegalArgumentException("rank must be 0 for one-arg DataSetBuilder call");
        }
    }

    public DataSetBuilder(int rank, int guessRecCount) {
        this(rank, guessRecCount, 1, 1);
        if (rank > 1) {
            throw new IllegalArgumentException(String.format("rank %d dataset when dim1 not specified.", rank));
        }
        if (rank != 1) {
            throw new IllegalArgumentException("rank must be 1 for two-arg DataSetBuilder call");
        }
    }

    public DataSetBuilder(int rank, int guessRecCount, int dim1) {
        this(rank, guessRecCount, dim1, 1);
        if (rank > 2) {
            throw new IllegalArgumentException(String.format("rank %d dataset when dim2 not specified.", rank));
        }
        if (rank != 2) {
            throw new IllegalArgumentException("rank must be 2 for three-arg DataSetBuilder call");
        }
    }

    public DataSetBuilder(int rank, int guessRecCount, int dim1, int dim2) {
        if (guessRecCount < 4) {
            logger.fine("guessRecCount cannot be less than four.");
            guessRecCount = 4;
        }
        this.rank = rank;
        this.recCount = guessRecCount;
        this.dim1 = dim1;
        this.dim2 = dim2;
        this.recElements = dim1 * dim2;
        this.newCurrent();
        this.index = 0;
        this.properties = new HashMap();
        this.unresolvedPropertyValues = new HashMap();
        this.unresolvedPropertyTypes = new HashMap();
    }

    public DataSetBuilder(int rank, int guessRecCount, int dim1, int dim2, int dim3) {
        if (guessRecCount < 4) {
            logger.fine("guessRecCount cannot be less than four.");
            guessRecCount = 4;
        }
        this.rank = rank;
        this.recCount = guessRecCount;
        this.dim1 = dim1;
        this.dim2 = dim2;
        this.dim3 = dim3;
        this.recElements = dim1 * dim2 * dim3;
        this.newCurrent();
        this.index = 0;
        this.properties = new HashMap();
    }

    private void checkStreamIndex(int index0) throws IllegalArgumentException {
        if (index0 > -1 && index0 != this.index + this.offset) {
            if (index0 == this.index + this.offset + 1) {
                this.nextRecord();
            } else {
                throw new IllegalArgumentException("index0 must only increment by one");
            }
        }
        this.length = this.index + this.offset + 1;
    }

    private void newCurrent() {
        logger.log(Level.FINE, "creating rank {0} receiver for next {1} records", new Object[]{this.rank, this.recCount});
        switch (this.rank) {
            case 1: {
                this.current = DDataSet.createRank1(this.recCount);
                break;
            }
            case 2: {
                this.current = DDataSet.createRank2(this.recCount, this.dim1);
                break;
            }
            case 3: {
                this.current = DDataSet.createRank3(this.recCount, this.dim1, this.dim2);
                break;
            }
            case 4: {
                this.current = DDataSet.createRank4(this.recCount, this.dim1, this.dim2, this.dim3);
                break;
            }
        }
    }

    public double getValue(int index0) {
        if (index0 == -1) {
            if (this.index == 0) {
                throw new IllegalArgumentException("nothing written to builder yet");
            }
            return this.current.value(this.index - 1);
        }
        throw new IllegalArgumentException("index must be -1");
    }

    public void putValue(int index0, double d) {
        this.checkStreamIndex(index0);
        this.current.putValue(this.index, d);
    }

    public void putValue(int index0, int index1, double d) {
        this.checkStreamIndex(index0);
        this.current.putValue(this.index, index1, d);
    }

    public void putValue(int index0, int index1, int index2, double d) {
        this.checkStreamIndex(index0);
        this.current.putValue(this.index, index1, index2, d);
    }

    public void putValue(int index0, int index1, int index2, int index3, double d) {
        this.checkStreamIndex(index0);
        this.current.putValue(this.index, index1, index2, index3, d);
    }

    public void putValue(int index0, Datum d) {
        this.checkStreamIndex(index0);
        if (this.rank != 1) {
            throw new IllegalArgumentException("rank 1 putValue used with rank " + this.rank + " dataset");
        }
        if (this.u == null) {
            this.u = d.getUnits();
        }
        this.current.putValue(this.index, this.u.createDatum(d).doubleValue(this.u));
    }

    public void putValue(int index0, int index1, Datum d) {
        this.checkStreamIndex(index0);
        if (this.rank != 2) {
            throw new IllegalArgumentException("rank 2 putValue used with rank " + this.rank + " dataset");
        }
        if (this.us == null || this.us[index1] == null) {
            this.setUnits(index1, d.getUnits());
        }
        this.current.putValue(this.index, index1, this.us[index1].createDatum(d).doubleValue(this.us[index1]));
    }

    public void putValue(int index0, int index1, int index2, Datum d) {
        this.checkStreamIndex(index0);
        if (this.rank != 3) {
            throw new IllegalArgumentException("rank 3 putValue used with rank " + this.rank + " dataset");
        }
        if (this.u == null) {
            this.u = d.getUnits();
        }
        this.current.putValue(this.index, index1, index2, this.u.createDatum(d).doubleValue(this.u));
    }

    public void putValue(int index0, int index1, int index2, int index3, Datum d) {
        this.checkStreamIndex(index0);
        if (this.rank != 4) {
            throw new IllegalArgumentException("rank 4 putValue used with rank " + this.rank + " dataset");
        }
        if (this.u == null) {
            this.u = d.getUnits();
        }
        this.current.putValue(this.index, index1, index2, index3, this.u.createDatum(d).doubleValue(this.u));
    }

    public void putValue(int index0, QDataSet d) {
        this.checkStreamIndex(index0);
        if (this.u == null) {
            this.u = SemanticOps.getUnits(d);
        }
        if (d.rank() != 0) {
            throw new IllegalArgumentException("data must be rank 0");
        }
        if (this.rank != 1) {
            throw new IllegalArgumentException("rank 1 putValue used with rank " + this.rank + " dataset");
        }
        double v = d.value();
        Units lu = SemanticOps.getUnits(d);
        if (lu != this.u) {
            v = this.u instanceof EnumerationUnits ? ((EnumerationUnits)this.u).createDatum((Object)d.svalue()).doubleValue(this.u) : lu.convertDoubleTo(this.us[this.index], v);
        }
        this.current.putValue(this.index, v);
    }

    public void putValue(int index0, int index1, QDataSet d) {
        String name;
        String label;
        this.checkStreamIndex(index0);
        Units lu = SemanticOps.getUnits(d);
        if (this.us == null || this.us[index1] == null) {
            this.setUnits(index1, lu);
        }
        if (d.rank() != 0) {
            throw new IllegalArgumentException("data must be rank 0");
        }
        if (this.rank != 2) {
            throw new IllegalArgumentException("rank 2 putValue used with rank " + this.rank + " dataset");
        }
        double v = d.value();
        if (lu != this.us[index1]) {
            v = lu.convertDoubleTo(this.us[index1], v);
        }
        if ((label = (String)d.property("LABEL")) != null && (this.labels == null || this.labels[index1] == null)) {
            this.setLabel(index1, label);
        }
        if ((name = (String)d.property("NAME")) != null && (this.names == null || this.names[index1] == null)) {
            this.setName(index1, name);
        }
        this.current.putValue(this.index, index1, v);
    }

    public void putValue(int index0, int index1, int index2, QDataSet d) {
        this.checkStreamIndex(index0);
        if (this.u == null) {
            this.u = SemanticOps.getUnits(d);
        }
        if (d.rank() != 0) {
            throw new IllegalArgumentException("data must be rank 0");
        }
        if (this.rank != 3) {
            throw new IllegalArgumentException("rank 3 putValue used with rank " + this.rank + " dataset");
        }
        double v = d.value();
        Units lu = SemanticOps.getUnits(d);
        if (lu != this.u) {
            v = lu.convertDoubleTo(this.u, v);
        }
        this.current.putValue(this.index, index1, index2, v);
    }

    public void putValue(int index0, int index1, int index2, int index3, QDataSet d) {
        this.checkStreamIndex(index0);
        if (this.u == null) {
            this.u = SemanticOps.getUnits(d);
        }
        if (d.rank() != 0) {
            throw new IllegalArgumentException("data must be rank 0");
        }
        if (this.rank != 4) {
            throw new IllegalArgumentException("rank 4 putValue used with rank " + this.rank + " dataset");
        }
        double v = d.value();
        Units lu = SemanticOps.getUnits(d);
        if (lu != this.u) {
            v = lu.convertDoubleTo(this.u, v);
        }
        this.current.putValue(this.index, index1, index2, index3, v);
    }

    public void putValue(int index0, String s) throws ParseException {
        this.checkStreamIndex(index0);
        if (this.u == null) {
            Units units;
            QDataSet ds1 = Ops.dataset(s);
            this.u = units = SemanticOps.getUnits(ds1);
        }
        if (this.u instanceof EnumerationUnits) {
            this.current.putValue(this.index, ((EnumerationUnits)this.u).createDatum((Object)s).doubleValue(this.u));
        } else {
            this.current.putValue(this.index, this.u.parse(s).doubleValue(this.u));
        }
    }

    public void putValue(int index0, int index1, String s) throws ParseException {
        this.checkStreamIndex(index0);
        if (this.us == null || this.us[index1] == null) {
            QDataSet ds1 = Ops.dataset(s);
            Units units = SemanticOps.getUnits(ds1);
            this.setUnits(index1, units);
        }
        if (this.us[index1] instanceof EnumerationUnits) {
            this.current.putValue(this.index, index1, ((EnumerationUnits)this.us[index1]).createDatum((Object)s).doubleValue(this.us[index1]));
        } else {
            this.current.putValue(this.index, index1, this.us[index1].parse(s).doubleValue(this.us[index1]));
        }
    }

    public void putValues(int index0, QDataSet values, int count) {
        DDataSet ddvalues = values instanceof DDataSet ? (DDataSet)values : (DDataSet)ArrayDataSet.copy(Double.TYPE, values);
        this.checkStreamIndex(index0);
        DDataSet.copyElements(ddvalues, 0, this.current, this.index, count, false);
    }

    public void nextRecord() {
        ++this.index;
        if (this.index == this.current.length()) {
            if (this.finished == null) {
                this.finished = new ArrayList(4);
            }
            this.finished.add(this.current);
            this.offset += this.current.length();
            this.index -= this.current.length();
            this.newCurrent();
        }
    }

    public void nextRecord(double[] values) {
        if (values.length > this.dim1) {
            throw new IllegalArgumentException("Too many values provided: got " + values.length + ", expected " + this.dim1);
        }
        if (this.rank != 2) {
            throw new IllegalArgumentException("nextRecord called with array but builder is not rank 2");
        }
        for (int i = 0; i < values.length; ++i) {
            double v1 = values[i];
            this.putValue(-1, i, v1);
        }
        this.nextRecord();
    }

    public void nextRecords(QDataSet ds) {
        for (int i = 0; i < ds.length(); ++i) {
            QDataSet ds1 = ds.slice(i);
            this.nextRecord(ds1);
        }
    }

    public void nextRecord(Object ... values) {
        if (values.length > this.dim1) {
            throw new IllegalArgumentException("Too many values provided: got " + values.length + ", expected " + this.dim1);
        }
        for (int i = 0; i < values.length; ++i) {
            Object v1 = values[i];
            if (v1 instanceof Number) {
                this.putValue(-1, i, ((Number)v1).doubleValue());
                continue;
            }
            if (v1 instanceof String) {
                try {
                    this.putValue(-1, i, (String)v1);
                    continue;
                }
                catch (ParseException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            if (v1 instanceof Datum) {
                this.putValue(-1, i, (Datum)v1);
                continue;
            }
            if (v1 instanceof QDataSet) {
                this.putValue(-1, i, (QDataSet)v1);
                continue;
            }
            if (v1 instanceof Color) {
                this.putValue(-1, i, ((Color)v1).getRGB());
                continue;
            }
            String cls = v1 == null ? "null" : v1.getClass().toString();
            throw new IllegalArgumentException("expected String, Datum, QDataSet, Color, or Number, got: " + cls);
        }
        this.nextRecord();
    }

    public void nextRecord(DatumVector v) {
        int n = v.getLength();
        if (this.u == null) {
            this.u = v.getUnits();
        }
        for (int i = 0; i < n; ++i) {
            this.putValue(-1, i, v.doubleValue(i, this.u));
        }
        this.nextRecord();
    }

    public void nextRecord(QDataSet v) {
        if (this.rank() == 3 && v.rank() == 2) {
            for (int i = 0; i < v.length(); ++i) {
                for (int j = 0; j < v.length(0); ++j) {
                    this.putValue(-1, i, j, v.value(i, j));
                }
            }
            this.nextRecord();
            return;
        }
        if (this.rank() > 2) {
            throw new IllegalArgumentException("builder must be rank 1, it is rank " + this.rank);
        }
        if (v.rank() > 1) {
            throw new IllegalArgumentException("argument must be rank 0 or rank 1");
        }
        if (v.rank() == 0) {
            this.putValue(-1, v);
        } else {
            for (int i = 0; i < v.length(); ++i) {
                this.putValue(-1, i, v.slice(i));
            }
        }
        this.nextRecord();
    }

    public void nextRecord(double v) {
        if (this.rank() != 1) {
            throw new IllegalArgumentException("builder must be rank 1, it is rank " + this.rank);
        }
        this.putValue(-1, v);
        this.nextRecord();
    }

    public void nextRecord(String s) {
        if (this.rank() != 1) {
            throw new IllegalArgumentException("builder must be rank 1, it is rank " + this.rank);
        }
        try {
            this.putValue(-1, s);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
        this.nextRecord();
    }

    public void nextRecord(Datum v) {
        if (this.rank() != 1) {
            throw new IllegalArgumentException("builder must be rank 1, it is rank " + this.rank);
        }
        this.putValue(-1, v);
        this.nextRecord();
    }

    public int getLength() {
        return this.length;
    }

    public int getRecordElements() {
        return this.recElements;
    }

    /*
     * WARNING - void declaration
     */
    public DDataSet getDataSet() {
        DDataSet result;
        switch (this.rank) {
            case 1: {
                result = DDataSet.createRank1(this.length);
                break;
            }
            case 2: {
                result = DDataSet.createRank2(this.length, this.dim1);
                break;
            }
            case 3: {
                result = DDataSet.createRank3(this.length, this.dim1, this.dim2);
                break;
            }
            case 4: {
                result = DDataSet.createRank4(this.length, this.dim1, this.dim2, this.dim3);
                break;
            }
            default: {
                throw new RuntimeException("bad rank");
            }
        }
        int dsindex = 0;
        if (this.finished != null) {
            for (DDataSet dDataSet : this.finished) {
                DDataSet.copyElements(dDataSet, 0, result, dsindex, dDataSet.length());
                dsindex += dDataSet.length();
            }
            DDataSet.copyElements(this.current, 0, result, dsindex, this.length - dsindex);
        } else if (this.index < this.recCount / 2) {
            DDataSet.copyElements(this.current, 0, result, 0, this.length);
        } else {
            result = (DDataSet)ArrayDataSet.copy(Double.TYPE, this.current);
        }
        result.putLength(this.length);
        if (this.u != null) {
            result.putProperty("UNITS", this.u);
        }
        if (this.us != null) {
            if (this.isBundle) {
                void var4_6;
                BundleBuilder bb = new BundleBuilder(this.dim1);
                if (this.us[0] != null && Units.us2000.isConvertibleTo(this.us[0]) && this.names[0] == null) {
                    this.names[0] = "UTC";
                }
                boolean bl = false;
                while (var4_6 < this.dim1) {
                    if (this.us[var4_6] != null) {
                        bb.putProperty("UNITS", (int)var4_6, this.us[var4_6]);
                    }
                    if (this.labels[var4_6] != null) {
                        bb.putProperty("LABEL", (int)var4_6, this.labels[var4_6]);
                    }
                    if (this.names[var4_6] != null) {
                        bb.putProperty("NAME", (int)var4_6, this.names[var4_6]);
                    }
                    ++var4_6;
                }
                if (this.us[0] != null && Units.us2000.isConvertibleTo(this.us[0]) && this.names[0] != null) {
                    void var4_8;
                    boolean bl2 = true;
                    while (var4_8 < this.dim1) {
                        bb.putProperty("DEPENDNAME_0", (int)var4_8, this.names[0]);
                        ++var4_8;
                    }
                }
                if (this.rank == 2) {
                    result.putProperty("BUNDLE_1", bb.getDataSet());
                }
            } else {
                result.putProperty("UNITS", this.us[0]);
            }
        }
        if (this.fillValueUsed) {
            result.putProperty("FILL_VALUE", this.fillValue);
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith("BUNDLE_") && this.dataSetResolver != null) {
                Object okey = entry.getValue();
                if (okey instanceof String) {
                    okey = this.dataSetResolver.resolve((String)this.properties.get(key));
                } else if (okey == null) {
                    logger.log(Level.WARNING, "unable to resolve key: {0}", key);
                }
                result.putProperty(key, okey);
                continue;
            }
            if (key.startsWith("WEIGHTS") || key.startsWith("DEPEND_") || key.startsWith("DELTA_") || key.startsWith("BIN_")) {
                Object ods = entry.getValue();
                if (ods == null || !(ods instanceof QDataSet)) continue;
                result.putProperty(key, ods);
                continue;
            }
            result.putProperty(key, entry.getValue());
        }
        for (Map.Entry entry : this.unresolvedPropertyTypes.entrySet()) {
            String svalue;
            QDataSet value;
            String type = (String)entry.getValue();
            if (!type.equals(UNRESOLVED_PROP_QDATASET) || (value = this.dataSetResolver.resolve(svalue = this.unresolvedPropertyValues.get(entry.getKey()))) == null) continue;
            result.putProperty((String)entry.getKey(), value);
        }
        return result;
    }

    public void putProperty(String string, Object o) {
        if (string.equals("UNITS")) {
            this.u = (Units)o;
        }
        this.properties.put(string, o);
    }

    public void putUnresolvedProperty(String type, String pname, String svalue) {
        this.unresolvedPropertyTypes.put(pname, type);
        this.unresolvedPropertyValues.put(pname, svalue);
    }

    public void resolveProperty(String svalue, Object value) {
        for (Map.Entry<String, String> e : this.unresolvedPropertyValues.entrySet()) {
            if (!e.getValue().equals(svalue)) continue;
            this.properties.put(e.getKey(), value);
        }
    }

    public void setUnits(Units u) {
        this.u = u;
    }

    private void maybeInitializeBundle() {
        if (!this.isBundle) {
            int j;
            logger.fine("initializeBundle");
            this.us = new Units[this.dim1];
            for (j = 0; j < this.dim1; ++j) {
                this.us[j] = null;
            }
            this.labels = new String[this.dim1];
            for (j = 0; j < this.dim1; ++j) {
                this.labels[j] = null;
            }
            this.names = new String[this.dim1];
            for (j = 0; j < this.dim1; ++j) {
                this.names[j] = null;
            }
            this.isBundle = true;
        }
    }

    public void setUnits(int i, Units u) {
        this.maybeInitializeBundle();
        this.us[i] = u;
    }

    public Units getUnits(int i) {
        return this.us[i];
    }

    public void setLabel(int i, String label) {
        this.maybeInitializeBundle();
        this.labels[i] = label;
    }

    public void setName(int i, String name) {
        this.maybeInitializeBundle();
        this.names[i] = name;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public double getFillValue() {
        this.fillValueUsed = true;
        return this.fillValue;
    }

    public void setFillValue(double fillValue) {
        this.fillValueUsed = true;
        double oldFillValue = this.fillValue;
        this.fillValue = fillValue;
        if (!Double.isNaN(fillValue)) {
            this.properties.put("FILL_VALUE", fillValue);
        }
        this.propertyChangeSupport.firePropertyChange("fillValue", oldFillValue, fillValue);
    }

    public double getValidMin() {
        return this.validMin;
    }

    public void setValidMin(double validMin) {
        double oldValidMin = this.validMin;
        this.validMin = validMin;
        if (validMin > Double.NEGATIVE_INFINITY) {
            this.properties.put("VALID_MIN", validMin);
        }
        this.propertyChangeSupport.firePropertyChange(PROP_VALIDMIN, oldValidMin, validMin);
    }

    public double getValidMax() {
        return this.validMax;
    }

    public void setValidMax(double validMax) {
        double oldValidMax = this.validMax;
        this.validMax = validMax;
        if (validMax < Double.POSITIVE_INFINITY) {
            this.properties.put("VALID_MAX", validMax);
        }
        this.propertyChangeSupport.firePropertyChange(PROP_VALIDMAX, oldValidMax, validMax);
    }

    public int getRecCount() {
        return this.index + this.offset;
    }

    public String toString() {
        String dims = null;
        switch (this.rank) {
            case 1: {
                dims = ":";
                break;
            }
            case 2: {
                dims = ":," + this.dim1;
                break;
            }
            case 3: {
                dims = ":," + this.dim1 + "," + this.dim2;
                break;
            }
            case 4: {
                dims = ":," + this.dim1 + "," + this.dim2 + "," + this.dim3;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported rank");
            }
        }
        return "DataSetBuilder rank=" + this.rank + " dims=[" + dims + "] reccount=" + (this.index + this.offset);
    }

    public int rank() {
        return this.rank;
    }

    public void setDataSetResolver(DataSetResolver dataSetResolver) {
        this.dataSetResolver = dataSetResolver;
    }

    public static interface DataSetResolver {
        public QDataSet resolve(String var1);
    }
}

