/*
 * Decompiled with CFR 0.152.
 */
package ucar.jpeg.jj2000.j2k.wavelet;

import ucar.jpeg.jj2000.j2k.image.Coord;
import ucar.jpeg.jj2000.j2k.wavelet.WaveletFilter;

public abstract class Subband {
    public static final int WT_ORIENT_LL = 0;
    public static final int WT_ORIENT_HL = 1;
    public static final int WT_ORIENT_LH = 2;
    public static final int WT_ORIENT_HH = 3;
    public boolean isNode;
    public int orientation;
    public int level;
    public int resLvl;
    public Coord numCb = null;
    public int anGainExp;
    public int sbandIdx = 0;
    public int ulcx;
    public int ulcy;
    public int ulx;
    public int uly;
    public int w;
    public int h;
    public int nomCBlkW;
    public int nomCBlkH;

    public abstract Subband getParent();

    public abstract Subband getLL();

    public abstract Subband getHL();

    public abstract Subband getLH();

    public abstract Subband getHH();

    protected abstract Subband split(WaveletFilter var1, WaveletFilter var2);

    protected void initChilds() {
        Subband subb_LL = this.getLL();
        Subband subb_HL = this.getHL();
        Subband subb_LH = this.getLH();
        Subband subb_HH = this.getHH();
        subb_LL.level = this.level + 1;
        subb_LL.ulcx = this.ulcx + 1 >> 1;
        subb_LL.ulcy = this.ulcy + 1 >> 1;
        subb_LL.ulx = this.ulx;
        subb_LL.uly = this.uly;
        subb_LL.w = (this.ulcx + this.w + 1 >> 1) - subb_LL.ulcx;
        subb_LL.h = (this.ulcy + this.h + 1 >> 1) - subb_LL.ulcy;
        subb_LL.resLvl = this.orientation == 0 ? this.resLvl - 1 : this.resLvl;
        subb_LL.anGainExp = this.anGainExp;
        subb_LL.sbandIdx = this.sbandIdx << 2;
        subb_HL.orientation = 1;
        subb_HL.level = subb_LL.level;
        subb_HL.ulcx = this.ulcx >> 1;
        subb_HL.ulcy = subb_LL.ulcy;
        subb_HL.ulx = this.ulx + subb_LL.w;
        subb_HL.uly = this.uly;
        subb_HL.w = (this.ulcx + this.w >> 1) - subb_HL.ulcx;
        subb_HL.h = subb_LL.h;
        subb_HL.resLvl = this.resLvl;
        subb_HL.anGainExp = this.anGainExp + 1;
        subb_HL.sbandIdx = (this.sbandIdx << 2) + 1;
        subb_LH.orientation = 2;
        subb_LH.level = subb_LL.level;
        subb_LH.ulcx = subb_LL.ulcx;
        subb_LH.ulcy = this.ulcy >> 1;
        subb_LH.ulx = this.ulx;
        subb_LH.uly = this.uly + subb_LL.h;
        subb_LH.w = subb_LL.w;
        subb_LH.h = (this.ulcy + this.h >> 1) - subb_LH.ulcy;
        subb_LH.resLvl = this.resLvl;
        subb_LH.anGainExp = this.anGainExp + 1;
        subb_LH.sbandIdx = (this.sbandIdx << 2) + 2;
        subb_HH.orientation = 3;
        subb_HH.level = subb_LL.level;
        subb_HH.ulcx = subb_HL.ulcx;
        subb_HH.ulcy = subb_LH.ulcy;
        subb_HH.ulx = subb_HL.ulx;
        subb_HH.uly = subb_LH.uly;
        subb_HH.w = subb_HL.w;
        subb_HH.h = subb_LH.h;
        subb_HH.resLvl = this.resLvl;
        subb_HH.anGainExp = this.anGainExp + 2;
        subb_HH.sbandIdx = (this.sbandIdx << 2) + 3;
    }

    public Subband() {
    }

    public Subband(int w, int h2, int ulcx, int ulcy, int lvls, WaveletFilter[] hfilters, WaveletFilter[] vfilters) {
        this.w = w;
        this.h = h2;
        this.ulcx = ulcx;
        this.ulcy = ulcy;
        this.resLvl = lvls;
        Subband cur = this;
        for (int i = 0; i < lvls; ++i) {
            int hi = cur.resLvl <= hfilters.length ? cur.resLvl - 1 : hfilters.length - 1;
            int vi = cur.resLvl <= vfilters.length ? cur.resLvl - 1 : vfilters.length - 1;
            cur = cur.split(hfilters[hi], vfilters[vi]);
        }
    }

    public Subband nextSubband() {
        if (this.isNode) {
            throw new IllegalArgumentException();
        }
        switch (this.orientation) {
            case 0: {
                Subband sb = this.getParent();
                if (sb == null || sb.resLvl != this.resLvl) {
                    return null;
                }
                return sb.getHL();
            }
            case 1: {
                return this.getParent().getLH();
            }
            case 2: {
                return this.getParent().getHH();
            }
            case 3: {
                Subband sb = this;
                while (sb.orientation == 3) {
                    sb = sb.getParent();
                }
                switch (sb.orientation) {
                    case 0: {
                        sb = sb.getParent();
                        if (sb == null || sb.resLvl != this.resLvl) {
                            return null;
                        }
                        sb = sb.getHL();
                        break;
                    }
                    case 1: {
                        sb = sb.getParent().getLH();
                        break;
                    }
                    case 2: {
                        sb = sb.getParent().getHH();
                        break;
                    }
                    default: {
                        throw new Error("You have found a bug in JJ2000");
                    }
                }
                while (sb.isNode) {
                    sb = sb.getLL();
                }
                return sb;
            }
        }
        throw new Error("You have found a bug in JJ2000");
    }

    public Subband getNextResLevel() {
        if (this.level == 0) {
            return null;
        }
        Subband sb = this;
        do {
            if ((sb = sb.getParent()) != null) continue;
            return null;
        } while (sb.resLvl == this.resLvl);
        sb = sb.getHL();
        while (sb.isNode) {
            sb = sb.getLL();
        }
        return sb;
    }

    public Subband getSubbandByIdx(int rl, int sbi) {
        Subband sb = this;
        if (rl > sb.resLvl || rl < 0) {
            throw new IllegalArgumentException("Resolution level index out of range");
        }
        if (rl == sb.resLvl && sbi == sb.sbandIdx) {
            return sb;
        }
        if (sb.sbandIdx != 0) {
            sb = sb.getParent();
        }
        while (sb.resLvl > rl) {
            sb = sb.getLL();
        }
        while (sb.resLvl < rl) {
            sb = sb.getParent();
        }
        switch (sbi) {
            default: {
                return sb;
            }
            case 1: {
                return sb.getHL();
            }
            case 2: {
                return sb.getLH();
            }
            case 3: 
        }
        return sb.getHH();
    }

    public Subband getSubband(int x, int y) {
        if (x < this.ulx || y < this.uly || x >= this.ulx + this.w || y >= this.uly + this.h) {
            throw new IllegalArgumentException();
        }
        Subband cur = this;
        while (cur.isNode) {
            Subband hhs = cur.getHH();
            if (x < hhs.ulx) {
                if (y < hhs.uly) {
                    cur = cur.getLL();
                    continue;
                }
                cur = cur.getLH();
                continue;
            }
            if (y < hhs.uly) {
                cur = cur.getHL();
                continue;
            }
            cur = cur.getHH();
        }
        return cur;
    }

    public String toString() {
        String string = "w=" + this.w + ",h=" + this.h + ",ulx=" + this.ulx + ",uly=" + this.uly + ",ulcx=" + this.ulcx + ",ulcy=" + this.ulcy + ",idx=" + this.sbandIdx + ",orient=" + this.orientation + ",node=" + this.isNode + ",level=" + this.level + ",resLvl=" + this.resLvl + ",nomCBlkW=" + this.nomCBlkW + ",nomCBlkH=" + this.nomCBlkH + ",numCb=" + this.numCb;
        return string;
    }

    public abstract WaveletFilter getHorWFilter();

    public abstract WaveletFilter getVerWFilter();
}

