/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.hapi;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.autoplot.datasource.DataSourceFormatEditorPanel;
import org.autoplot.datasource.URISplit;

public class HapiDataSourceFormatEditorPanel
extends JPanel
implements DataSourceFormatEditorPanel {
    private JTextField hapiRootTextField;
    private JTextField idTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;

    public HapiDataSourceFormatEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.idTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.hapiRootTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel1.setText("id, an identifier for the data source:");
        this.idTextField.setText("data");
        this.jLabel2.setText("HAPI root:");
        this.hapiRootTextField.setText("/home/jbf/hapi2.hapi");
        this.jLabel3.setText("<html>Export data to the Autoplot-based HAPI server configured at the given root.  Note the .hapi extension will be converted to /hapi.  It should also be noted that these files are for reference only, and will not support HAPI without additional human effort.");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 0, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addGap(0, 274, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hapiRootTextField).addComponent(this.idTextField))))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -2, 66, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.hapiRootTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.idTextField, -2, -1, -2).addContainerGap(78, Short.MAX_VALUE)));
    }

    public JPanel getPanel() {
        return this;
    }

    public void setURI(String uri) {
        URISplit split = URISplit.parse((String)uri);
        LinkedHashMap params = URISplit.parseParams((String)split.params);
        File hapiDir = new File(split.resourceUri);
        this.hapiRootTextField.setText(hapiDir.toString());
        String id = (String)params.get("id");
        if (id == null) {
            id = "data";
        }
        this.idTextField.setText(id);
    }

    public String getURI() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("id", this.idTextField.getText());
        String params = URISplit.formatParams(args);
        URISplit ss = URISplit.parse((String)("file://" + this.hapiRootTextField.getText()));
        if (params.length() > 0) {
            ss.params = params;
        }
        return URISplit.format((URISplit)ss);
    }
}

