/*
 * Decompiled with CFR 0.152.
 */
package dods.servlet;

import dods.dap.DAS;
import dods.dap.DODSException;
import dods.dap.Server.CEEvaluator;
import dods.dap.Server.ServerDDS;
import dods.dap.parser.ParseException;
import dods.servlet.BadURLException;
import dods.servlet.GuardedDataset;
import dods.servlet.ReqState;
import dods.servlet.dodsASCII;
import dods.servlet.dodsDIR;
import dods.servlet.dodsHTML;
import dods.servlet.dodsINFO;
import dods.util.Debug;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class DODSServlet
extends HttpServlet {
    private boolean track = false;
    private Object syncLock = new Object();
    private int HitCounter = 0;
    private ArrayList prArr = null;

    public abstract String getServerVersion();

    protected abstract GuardedDataset getDataset(ReqState var1) throws DODSException, IOException, ParseException;

    public void init() throws ServletException {
        super.init();
        String debugOn = this.getInitParameter("DebugOn");
        if (debugOn != null) {
            System.out.println("** DebugOn **");
            StringTokenizer toker = new StringTokenizer(debugOn);
            while (toker.hasMoreTokens()) {
                Debug.set(toker.nextToken(), true);
            }
        }
    }

    public void parseExceptionHandler(ParseException pe, HttpServletResponse response) {
        System.out.println(pe);
        pe.printStackTrace();
        try {
            BufferedOutputStream eOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-Description", "dods_error");
            response.setHeader("Content-Encoding", "");
            String msg = pe.getMessage().replace('\"', '\'');
            DODSException de2 = new DODSException(5, msg);
            de2.print(eOut);
        }
        catch (IOException ioe) {
            System.out.println("Cannot respond to client! IO Error: " + ioe.getMessage());
        }
    }

    public void dodsExceptionHandler(DODSException de, HttpServletResponse response) {
        System.out.println(de);
        de.printStackTrace();
        try {
            BufferedOutputStream eOut = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-Description", "dods_error");
            response.setHeader("Content-Encoding", "");
            de.print(eOut);
            de.print(System.out);
        }
        catch (IOException ioe) {
            System.out.println("Cannot respond to client! IO Error: " + ioe.getMessage());
        }
    }

    public void anyExceptionHandler(Throwable e, HttpServletResponse response, ReqState rs) {
        try {
            DataOutputStream dos = new DataOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-Description", "dods_error");
            response.setHeader("Content-Encoding", "");
            dos.writeUTF("DODServlet ERROR: " + e.getMessage());
            System.out.println("DODServlet ERROR (anyExceptionHandler): " + e);
            System.out.println(rs);
            if (this.track) {
                RequestDebug reqD = (RequestDebug)rs.getUserObject();
                System.out.println("  request number: " + reqD.reqno + " thread: " + reqD.threadDesc);
            }
            e.printStackTrace();
        }
        catch (IOException ioe) {
            System.out.println("Cannot respond to client! IO Error: " + ioe.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DAS getDAS(ReqState rs) throws DODSException, ParseException {
        DataInputStream is = null;
        DAS myDAS = new DAS();
        boolean gotIt = false;
        try {
            try {
                is = this.openCachedDAS(rs);
                myDAS.parse(is);
                gotIt = true;
            }
            catch (FileNotFoundException fnfe) {
                gotIt = false;
                Object var7_6 = null;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException ioe) {
                    throw new DODSException(0, ioe.getMessage());
                }
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {}
            catch (IOException ioe) {
                throw new DODSException(0, ioe.getMessage());
            }
            if (is == null) throw throwable;
            is.close();
            throw throwable;
        }
        try {}
        catch (IOException ioe) {
            throw new DODSException(0, ioe.getMessage());
        }
        if (is != null) {
            is.close();
        }
        if (!gotIt) return myDAS;
        if (Debug.isSet("showResponse")) {
            System.out.println("Successfully opened and parsed DAS cache: " + rs.getDataSet());
            return myDAS;
        }
        if (!Debug.isSet("showResponse")) return myDAS;
        System.out.println("No DAS present for dataset: " + rs.getDataSet());
        return myDAS;
    }

    public void sendDODSError(HttpServletRequest request, HttpServletResponse response, String clientMsg, String serverMsg) throws IOException, ServletException {
        response.setContentType("text/plain");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods_error");
        ServletOutputStream Out = response.getOutputStream();
        DODSException de = new DODSException(0, clientMsg);
        de.print((OutputStream)Out);
        response.setStatus(200);
        System.out.println(serverMsg);
    }

    public DataInputStream openCachedDDS(ReqState rs) throws DODSException {
        String cacheDir = rs.getDDSCache();
        try {
            File fin = new File(cacheDir + rs.getDataSet());
            FileInputStream fp_in = new FileInputStream(fin);
            DataInputStream dds_source = new DataInputStream(fp_in);
            return dds_source;
        }
        catch (FileNotFoundException fnfe) {
            throw new DODSException(5, fnfe.getMessage());
        }
    }

    public DataInputStream openCachedDAS(ReqState rs) throws FileNotFoundException {
        String cacheDir = rs.getDASCache();
        File fin = new File(cacheDir + rs.getDataSet());
        FileInputStream fp_in = new FileInputStream(fin);
        DataInputStream das_source = new DataInputStream(fp_in);
        return das_source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDAS(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("Sending DAS for dataset: " + rs.getDataSet());
        }
        response.setContentType("text/plain");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods_das");
        BufferedOutputStream Out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            if (Debug.isSet("showResponse")) {
                System.out.println("Got the GuardedDataset...");
            }
            DAS myDAS = ds.getDAS();
            myDAS.print(Out);
            response.setStatus(200);
        }
        catch (DODSException de) {
            this.dodsExceptionHandler(de, response);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDDS(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("Sending DDS for dataset: " + rs.getDataSet());
        }
        response.setContentType("text/plain");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods_dds");
        BufferedOutputStream Out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            ServerDDS myDDS = ds.getDDS();
            if (rs.getConstraintExpression().equals("")) {
                myDDS.print(Out);
                ((OutputStream)Out).flush();
            } else {
                CEEvaluator ce = new CEEvaluator(myDDS);
                ce.parseConstraint(rs.getConstraintExpression());
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(Out));
                myDDS.printConstrained(pw);
                pw.flush();
            }
            response.setStatus(200);
        }
        catch (DODSException de) {
            this.dodsExceptionHandler(de, response);
        }
        catch (IOException pe) {
            this.anyExceptionHandler(pe, response, rs);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetDODS(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        FilterOutputStream bOut;
        if (Debug.isSet("showResponse")) {
            System.out.println("Sending DODS Data For: " + rs.getDataSet());
        }
        response.setContentType("application/octet-stream");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods_data");
        ServletOutputStream sOut = response.getOutputStream();
        if (rs.getAcceptsCompressed()) {
            response.setHeader("Content-Encoding", "deflate");
            bOut = new DeflaterOutputStream((OutputStream)sOut);
        } else {
            bOut = new BufferedOutputStream((OutputStream)sOut);
        }
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            ServerDDS myDDS = ds.getDDS();
            CEEvaluator ce = new CEEvaluator(myDDS);
            ce.parseConstraint(rs.getConstraintExpression());
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(bOut));
            myDDS.printConstrained(pw);
            pw.flush();
            ((OutputStream)bOut).write("\nData:\n".getBytes());
            ((OutputStream)bOut).flush();
            DataOutputStream sink = new DataOutputStream(bOut);
            ce.send(myDDS.getName(), sink, ds);
            sink.flush();
            if (rs.getAcceptsCompressed()) {
                ((DeflaterOutputStream)bOut).finish();
            }
            response.setStatus(200);
        }
        catch (DODSException de) {
            this.dodsExceptionHandler(de, response);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    public void doGetDIR(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setContentType("text/html");
        response.setHeader("Content-Description", "dods_directory");
        try {
            dodsDIR di = new dodsDIR();
            di.sendDIR(request, response, rs);
            response.setStatus(200);
        }
        catch (DODSException de) {
            this.dodsExceptionHandler(de, response);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
    }

    public void doGetVER(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("Sending Version Tag.");
        }
        response.setContentType("text/plain");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods_version");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        pw.println("Server Version: " + this.getServerVersion());
        pw.flush();
        response.setStatus(200);
    }

    public void doGetHELP(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("Sending Help Page.");
        }
        response.setContentType("text/html");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "dods_help");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        this.printHelpPage(pw);
        pw.flush();
        response.setStatus(200);
    }

    public void badURL(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("Sending Bad URL Page.");
        }
        response.setContentType("text/html");
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setHeader("Content-Description", "BadURL");
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        this.printBadURLPage(pw);
        this.printHelpPage(pw);
        pw.flush();
        response.setStatus(200);
    }

    public void doGetASC(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        if (Debug.isSet("showResponse")) {
            System.out.println("Sending ASC Data For: " + rs.getDataSet());
        }
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setContentType("text/plain");
        response.setHeader("Content-Description", "dods_ascii");
        try {
            dodsASCII di = new dodsASCII();
            di.sendASCII(request, response, rs);
            response.setStatus(200);
        }
        catch (DODSException de) {
            this.dodsExceptionHandler(de, response);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetINFO(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        PrintStream pw = new PrintStream((OutputStream)response.getOutputStream());
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setContentType("text/html");
        response.setHeader("Content-Description", "dods_description");
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            dodsINFO di = new dodsINFO();
            di.sendINFO(pw, ds, rs);
            response.setStatus(200);
        }
        catch (DODSException de) {
            this.dodsExceptionHandler(de, response);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetHTML(HttpServletRequest request, HttpServletResponse response, ReqState rs) throws IOException, ServletException {
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setContentType("text/html");
        response.setHeader("Content-Description", "dods_form");
        GuardedDataset ds = null;
        try {
            ds = this.getDataset(rs);
            ServerDDS myDDS = ds.getDDS();
            DAS das = ds.getDAS();
            dodsHTML di = new dodsHTML();
            di.sendDataRequestForm(request, response, rs.getDataSet(), myDDS, das);
            response.setStatus(200);
        }
        catch (DODSException de) {
            this.dodsExceptionHandler(de, response);
        }
        catch (IOException pe) {
            this.anyExceptionHandler(pe, response, rs);
        }
        catch (ParseException pe) {
            this.parseExceptionHandler(pe, response);
        }
        finally {
            if (ds != null) {
                ds.release();
            }
        }
    }

    public void doGetCatalog(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setContentType("text/xml");
        response.setHeader("Content-Description", "dods_catalog");
        PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());
        this.printCatalog(pw);
        pw.flush();
        response.setStatus(200);
    }

    protected void printCatalog(PrintWriter os) throws IOException {
        os.println("Catalog not available for this server");
        os.println("Server version = " + this.getServerVersion());
    }

    public void doGetStatus(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setHeader("XDODS-Server", this.getServerVersion());
        response.setContentType("text/html");
        response.setHeader("Content-Description", "dods_status");
        PrintWriter pw = new PrintWriter((OutputStream)response.getOutputStream());
        pw.println("<title>Server Status</title>");
        pw.println("<body><ul>");
        this.printStatus(pw);
        pw.println("</ul></body>");
        pw.flush();
        response.setStatus(200);
    }

    protected void printStatus(PrintWriter os) throws IOException {
        os.println("<h2>Server version = " + this.getServerVersion() + "</h2>");
        os.println("<h2>Number of Requests Received = " + this.HitCounter + "</h2>");
        if (this.track) {
            int n = this.prArr.size();
            int pending = 0;
            String preqs = "";
            for (int i = 0; i < n; ++i) {
                ReqState rs = (ReqState)this.prArr.get(i);
                RequestDebug reqD = (RequestDebug)rs.getUserObject();
                if (rs == null || reqD.done) continue;
                preqs = preqs + "<pre>-----------------------\n";
                preqs = preqs + "Request[" + reqD.reqno + "](" + reqD.threadDesc + ") is pending.\n";
                preqs = preqs + rs.toString();
                preqs = preqs + "</pre>";
                ++pending;
            }
            os.println("<h2>" + pending + " Pending Request(s)</h2>");
            os.println(preqs);
        }
    }

    public void probeRequest(HttpServletRequest request) {
        String s;
        System.out.println("####################### PROBE ##################################");
        System.out.println("The HttpServletRequest object is actually a: " + request.getClass().getName());
        System.out.println("");
        System.out.println("HttpServletRequest Interface:");
        System.out.println("    getAuthType:           " + request.getAuthType());
        System.out.println("    getMethod:             " + request.getMethod());
        System.out.println("    getPathInfo:           " + request.getPathInfo());
        System.out.println("    getPathTranslated:     " + request.getPathTranslated());
        System.out.println("    getQueryString:        " + request.getQueryString());
        System.out.println("    getRemoteUser:         " + request.getRemoteUser());
        System.out.println("    getRequestedSessionId: " + request.getRequestedSessionId());
        System.out.println("    getRequestURI:         " + request.getRequestURI());
        System.out.println("    getServletPath:        " + request.getServletPath());
        System.out.println("    isRequestedSessionIdFromCookie: " + request.isRequestedSessionIdFromCookie());
        System.out.println("    isRequestedSessionIdValid:      " + request.isRequestedSessionIdValid());
        System.out.println("    isRequestedSessionIdFromURL:    " + request.isRequestedSessionIdFromURL());
        System.out.println("");
        int i = 0;
        Enumeration e = request.getHeaderNames();
        System.out.println("    Header Names:");
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            System.out.print("        Header[" + ++i + "]: " + s);
            System.out.println(": " + request.getHeader(s));
        }
        System.out.println("");
        System.out.println("ServletRequest Interface:");
        System.out.println("    getCharacterEncoding:  " + request.getCharacterEncoding());
        System.out.println("    getContentType:        " + request.getContentType());
        System.out.println("    getContentLength:      " + request.getContentLength());
        System.out.println("    getProtocol:           " + request.getProtocol());
        System.out.println("    getScheme:             " + request.getScheme());
        System.out.println("    getServerName:         " + request.getServerName());
        System.out.println("    getServerPort:         " + request.getServerPort());
        System.out.println("    getRemoteAddr:         " + request.getRemoteAddr());
        System.out.println("    getRemoteHost:         " + request.getRemoteHost());
        System.out.println(".............................");
        System.out.println("");
        i = 0;
        e = request.getAttributeNames();
        System.out.println("    Attribute Names:");
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            System.out.print("        Attribute[" + ++i + "]: " + s);
            System.out.println(" Type: " + request.getAttribute(s));
        }
        System.out.println(".............................");
        System.out.println("");
        i = 0;
        e = request.getParameterNames();
        System.out.println("    Parameter Names:");
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            System.out.print("        Parameter[" + ++i + "]: " + s);
            System.out.println(" Value: " + request.getParameter(s));
        }
        System.out.println("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
        System.out.println(" . . . . . . . . . Servlet Infomation API  . . . . . . . . . . . . . .");
        System.out.println("");
        System.out.println("Servlet Context:");
        System.out.println("");
        ServletContext scntxt = this.getServletContext();
        i = 0;
        e = scntxt.getAttributeNames();
        System.out.println("    Attribute Names:");
        while (e.hasMoreElements()) {
            String s2 = (String)e.nextElement();
            System.out.print("        Attribute[" + ++i + "]: " + s2);
            System.out.println(" Type: " + scntxt.getAttribute(s2));
        }
        System.out.println("    ServletContext.getMajorVersion(): " + scntxt.getMajorVersion());
        System.out.println("    ServletContext.getMinorVersion(): " + scntxt.getMinorVersion());
        System.out.println(".............................");
        System.out.println("Servlet Config:");
        System.out.println("");
        ServletConfig scnfg = this.getServletConfig();
        i = 0;
        e = scnfg.getInitParameterNames();
        System.out.println("    InitParameters:");
        while (e.hasMoreElements()) {
            String p = (String)e.nextElement();
            System.out.print("        InitParameter[" + i + "]: " + p);
            System.out.println(" Value: " + scnfg.getInitParameter(p));
            ++i;
        }
        System.out.println(".............................");
        System.out.println("HttpUtils:");
        System.out.println("");
        System.out.println("getRequestURL: " + request.getRequestURL().toString());
        System.out.println("");
        System.out.println("######################## END PROBE ###############################");
        System.out.println("");
    }

    private String prepCE(String ce) {
        if (ce == null) {
            ce = "";
        } else if (!ce.equals("")) {
            int index = ce.indexOf("%");
            if (index == -1) {
                return ce;
            }
            if (index > ce.length() - 3) {
                return null;
            }
            while (index >= 0) {
                String specChar = ce.substring(index + 1, index + 3);
                char val = (char)Byte.parseByte(specChar, 16);
                if ((index = (ce = ce.substring(0, index) + String.valueOf(val) + ce.substring(index + 3, ce.length())).indexOf("%")) <= ce.length() - 3) continue;
                return null;
            }
        }
        return ce;
    }

    protected boolean isTheClientCompressed(HttpServletRequest request) {
        boolean isTiny = false;
        String Encoding = request.getHeader("Accept-Encoding");
        isTiny = Encoding != null ? Encoding.equalsIgnoreCase("deflate") : false;
        return isTiny;
    }

    protected ReqState processDodsURL(HttpServletRequest request) throws BadURLException {
        ReqState rs = null;
        rs = new ReqState(request, this.getServletConfig(), this.getServerName());
        return rs;
    }

    public String getServerName() {
        String servletName = ((Object)((Object)this)).getClass().getName();
        return servletName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ReqState rs = null;
        RequestDebug reqD = null;
        try {
            if (Debug.isSet("probeRequest")) {
                this.probeRequest(request);
            }
            rs = this.getRequestState(request);
            Object object = this.syncLock;
            synchronized (object) {
                long reqno = this.HitCounter++;
                if (this.track) {
                    reqD = new RequestDebug(reqno, Thread.currentThread().toString());
                    rs.setUserObject(reqD);
                    if (this.prArr == null) {
                        this.prArr = new ArrayList(10000);
                    }
                    this.prArr.add((int)reqno, rs);
                }
                if (Debug.isSet("showRequest")) {
                    System.out.println("-------------------------------------------");
                    System.out.println("Server: " + this.getServerName() + "   Request #" + reqno);
                    System.out.println(rs.toString());
                }
            }
            if (rs != null) {
                String dataSet = rs.getDataSet();
                String requestSuffix = rs.getRequestSuffix();
                if (dataSet == null) {
                    this.doGetDIR(request, response, rs);
                } else if (dataSet.equals("/")) {
                    this.doGetDIR(request, response, rs);
                } else if (dataSet.equals("")) {
                    this.doGetDIR(request, response, rs);
                } else if (dataSet.equalsIgnoreCase("/version") || dataSet.equalsIgnoreCase("/version/")) {
                    this.doGetVER(request, response);
                } else if (dataSet.equalsIgnoreCase("/help") || dataSet.equalsIgnoreCase("/help/")) {
                    this.doGetHELP(request, response);
                } else if (dataSet.equalsIgnoreCase("/" + requestSuffix)) {
                    this.doGetHELP(request, response);
                } else if (requestSuffix.equalsIgnoreCase("dds")) {
                    this.doGetDDS(request, response, rs);
                } else if (requestSuffix.equalsIgnoreCase("das")) {
                    this.doGetDAS(request, response, rs);
                } else if (requestSuffix.equalsIgnoreCase("dods")) {
                    this.doGetDODS(request, response, rs);
                } else if (requestSuffix.equalsIgnoreCase("asc") || requestSuffix.equalsIgnoreCase("ascii")) {
                    this.doGetASC(request, response, rs);
                } else if (requestSuffix.equalsIgnoreCase("info")) {
                    this.doGetINFO(request, response, rs);
                } else if (requestSuffix.equalsIgnoreCase("html") || requestSuffix.equalsIgnoreCase("htm")) {
                    this.doGetHTML(request, response, rs);
                } else if (requestSuffix.equalsIgnoreCase("ver") || requestSuffix.equalsIgnoreCase("version")) {
                    this.doGetVER(request, response);
                } else if (requestSuffix.equalsIgnoreCase("help")) {
                    this.doGetHELP(request, response);
                } else if (requestSuffix.equalsIgnoreCase("xml") && dataSet.equalsIgnoreCase("catalog")) {
                    this.doGetCatalog(request, response);
                } else if (dataSet.equalsIgnoreCase("status")) {
                    this.doGetStatus(request, response);
                } else if (requestSuffix.equals("")) {
                    this.badURL(request, response);
                } else {
                    this.badURL(request, response);
                }
            } else {
                this.badURL(request, response);
            }
            if (reqD != null) {
                reqD.done = true;
            }
        }
        catch (Throwable e) {
            this.anyExceptionHandler(e, response, rs);
        }
    }

    private ReqState getRequestState(HttpServletRequest request) {
        ReqState rs = null;
        try {
            rs = new ReqState(request, this.getServletConfig(), this.getServerName());
        }
        catch (BadURLException bue) {
            rs = null;
        }
        return rs;
    }

    private void printHelpPage(PrintWriter pw) {
        pw.println("<h3>DODS Server Help</h3>");
        pw.println("To access most of the features of this DODS server, append");
        pw.println("one of the following a five suffixes to a URL: .das, .dds, .dods., .info,");
        pw.println(".ver or .help. Using these suffixes, you can ask this server for:<dl>");
        pw.println("<dt> das  <dd> attribute object");
        pw.println("<dt> dds  <dd> data type object");
        pw.println("<dt> dods <dd> data object");
        pw.println("<dt> info <dd> info object (attributes, types and other information)");
        pw.println("<dt> html <dd> html form for this dataset");
        pw.println("<dt> ver  <dd> return the version number of the server");
        pw.println("<dt> help <dd> help information (this text)</dl>");
        pw.println("</dl>");
        pw.println("For example, to request the DAS object from the FNOC1 dataset at URI/GSO (a");
        pw.println("test dataset) you would appand `.das' to the URL:");
        pw.println("http://dods.gso.uri.edu/cgi-bin/nph-nc/data/fnoc1.nc.das.");
        pw.println("<p><b>Note</b>: Many DODS clients supply these extensions for you so you don't");
        pw.println("need to append them (for example when using interfaces supplied by us or");
        pw.println("software re-linked with a DODS client-library). Generally, you only need to");
        pw.println("add these if you are typing a URL directly into a WWW browser.");
        pw.println("<p><b>Note</b>: If you would like version information for this server but");
        pw.println("don't know a specific data file or data set name, use `/version' for the");
        pw.println("filename. For example: http://dods.gso.uri.edu/cgi-bin/nph-nc/version will");
        pw.println("return the version number for the netCDF server used in the first example. ");
        pw.println("<p><b>Suggestion</b>: If you're typing this URL into a WWW browser and");
        pw.println("would like information about the dataset, use the `.info' extension.");
        pw.println("<p>If you'd like to see a data values, use the `.html' extension and submit a");
        pw.println("query using the customized form.");
    }

    private void printBadURLPage(PrintWriter pw) {
        pw.println("<h3>Error in URL</h3>");
        pw.println("The URL extension did not match any that are known by this");
        pw.println("server. Below is a list of the five extensions that are be recognized by");
        pw.println("all DODS servers. If you think that the server is broken (that the URL you");
        pw.println("submitted should have worked), then please contact the");
        pw.println("DODS user support coordinator at: support@unidata.ucar.edu<p>");
    }

    private class RequestDebug {
        long reqno;
        String threadDesc;
        boolean done = false;

        RequestDebug(long reqno, String threadDesc) {
            this.reqno = reqno;
            this.threadDesc = threadDesc;
        }
    }
}

