
/*
 * BinaryDataSourceFormatEditorPanel.java
 *
 * Created on Jul 18, 2011, 4:43:42 PM
 */
package org.autoplot.binarydatasource;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import org.autoplot.datasource.URISplit;
import java.lang.Short; // because of Short object in this package.
import org.autoplot.datasource.DataSourceFormatEditorPanel;

/**
 * Format to flat binary tables.
 * @author jbf
 */
public class BinaryDataSourceFormatEditorPanel extends javax.swing.JPanel implements DataSourceFormatEditorPanel {

    /** Creates new form BinaryDataSourceFormatEditorPanel */
    public BinaryDataSourceFormatEditorPanel() {
        initComponents();
    }

    String file;

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        typeComboBox = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        endianComboBox = new javax.swing.JComboBox();
        justDataCB = new javax.swing.JCheckBox();

        jLabel1.setText("Type:");

        typeComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "double", "float", "int", "short", "byte" }));

        jLabel2.setText("Byte Order / Endianness:");

        endianComboBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "big", "little", " " }));

        justDataCB.setText("Just Data, don't format timetags and other dependencies");

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(jLabel1)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(typeComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 123, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createSequentialGroup()
                        .add(jLabel2)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(endianComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(justDataCB)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(typeComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel2)
                    .add(endianComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(justDataCB)
                .addContainerGap(204, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox endianComboBox;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JCheckBox justDataCB;
    private javax.swing.JComboBox typeComboBox;
    // End of variables declaration//GEN-END:variables

    @Override
    public JPanel getPanel() {
        return this;
    }

    private String getParam( Map<String,String> args, String name, String defl ) {
        String s= args.get(name);
        if ( s==null ) {
            return defl;
        } else {
            return s;
        }
    }
    
    @Override
    public void setURI(String uri) {
        URISplit split= URISplit.parse(uri);
        Map<String,String> args= URISplit.parseParams(split.params);

        String s;
        s= getParam( args,"type","double");
        typeComboBox.setSelectedItem(s);

        s= getParam( args, "byteOrder", "little" );
        endianComboBox.setSelectedItem(s);

        s= args.get("doDep");
        if ( s!=null && s.length()>0 && 'F'==s.substring(0,1).toUpperCase().charAt(0) ) {
            justDataCB.setSelected(true);
        }
        
        file= split.file;
    }

    @Override
    public String getURI() {
        String result= file;
        Map<String,String> args= new HashMap();

        String s;
        s= (String) typeComboBox.getSelectedItem();
        if ( !s.equals("double") ) args.put( "type", s );

        s= (String) endianComboBox.getSelectedItem();
        if ( !s.equals("little") ) args.put( "byteOrder", s );

        if ( justDataCB.isSelected() ) {
            args.put( "doDep", "F" );
        }
        
        String params= URISplit.formatParams(args);
        if ( result==null ) result= "file:///";
        URISplit ss= URISplit.parse(result);

        if ( params.length()>0 ) {
            ss.params= params;
        }
        return URISplit.format( ss );

    }

}
