/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class ADR {
    public static final int ADR_RECORD_TYPE_ID = 4;
    public static final int ADR_RECORD_SIZE_FIELD_OFFSET = 0;
    public static final int ADR_RECORD_SIZE_FIELD_LENGTH = 8;
    public static final int ADR_RECORD_TYPE_OFFSET = 8;
    public static final int ADR_RECORD_TYPE_FIELD_LENGTH = 4;
    public static final int ADR_ADR_NEXT_FIELD_OFFSET = 12;
    public static final int ADR_ADR_NEXT_FIELD_LENGTH = 8;
    public static final int ADR_AGR_EDR_HEAD_FIELD_OFFSET = 20;
    public static final int ADR_AGR_EDR_HEAD_FIELD_LENGTH = 8;
    public static final int AADR_SCOPE_FIELD_OFFSET = 28;
    public static final int ADR_SCOPE_FIELD_LENGTH = 4;
    public static final int ADR_GLOBAL_SCOPE = 1;
    public static final int ADR_VARIABLE_SCOPE = 2;
    public static final int ADR_GLOBAL_SCOPE_ASSUMED = 3;
    public static final int ADR_VARIABLE_SCOPE_ASSUMED = 4;
    public static final int ADR_NUM_FIELD_OFFSET = 32;
    public static final int ADR_NUM_FIELD_LENGTH = 4;
    public static final int ADR_NGR_ENTRIES_FIELD_OFFSET = 36;
    public static final int ADR_NGR_ENTRIES_FIELD_LENGTH = 4;
    public static final int ADR_MAX_GR_ENTRY_FIELD_OFFSET = 40;
    public static final int ADR_MAX_GR_ENTRY_FIELD_LENGTH = 4;
    public static final int ADR_RFUA_FIELD_OFFSET = 44;
    public static final int ADR_RFUA_FIELD_LENGTH = 4;
    public static final int ADR_AZ_EDR_HEAD_FIELD_OFFSET = 48;
    public static final int ADR_AZ_EDR_HEAD_FIELD_LENGTH = 8;
    public static final int ADR_NZ_ENTRIES_FIELD_OFFSET = 56;
    public static final int ADR_NZ_ENTRIES_FIELD_LENGTH = 4;
    public static final int ADR_MAX_Z_ENTRIES_FIELD_OFFSET = 60;
    public static final int ADR_MAX_Z_ENTRIES_FIELD_LENGTH = 4;
    public static final int ADR_RFUE_FIELD_OFFSET = 64;
    public static final int ADR_RFUE_FIELD_LENGTH = 4;
    public static final int ADR_NAME_FIELD_OFFSET = 68;
    public static final int ADR_NAME_FIELD_LENGTH = 256;
    public static final int ADR_RECORD_SIZE = 324;
    protected String name;
    protected byte[] paddedName;
    protected int num;
    protected long position;
    long aDRNext;
    long agrEDRHead;
    long azEDRHead;
    int mAXgrEntry = -1;
    int mAXzEntry;
    int ngrEntries;
    int nzEntries;
    int rfuA = 0;
    int rfuE = -1;
    int scope;
    ByteBuffer record = ByteBuffer.allocate(324);

    public ByteBuffer get() {
        this.record.position(0);
        this.record.putLong(324L);
        this.record.putInt(4);
        this.record.putLong(this.aDRNext);
        this.record.putLong(this.agrEDRHead);
        this.record.putInt(this.scope);
        this.record.putInt(this.num);
        this.record.putInt(this.ngrEntries);
        this.record.putInt(this.mAXgrEntry);
        this.record.putInt(this.rfuA);
        this.record.putLong(this.azEDRHead);
        this.record.putInt(this.nzEntries);
        this.record.putInt(this.mAXzEntry);
        this.record.putInt(this.rfuE);
        this.record.put(this.getNameBytes(this.name));
        this.record.position(0);
        return this.record;
    }

    public byte[] getNameBytes(String s) {
        int i;
        byte[] padded = new byte[256];
        byte[] bs = s.getBytes(StandardCharsets.US_ASCII);
        for (i = 0; i < bs.length; ++i) {
            padded[i] = bs[i];
        }
        while (i < padded.length) {
            padded[i] = 0;
            ++i;
        }
        return padded;
    }

    public int getSize() {
        return this.record.limit();
    }

    public void setADRNext(long aDRNext) {
        this.aDRNext = aDRNext;
    }

    public void setAgrEDRHead(long agrEDRHead) {
        this.agrEDRHead = agrEDRHead;
    }

    public void setAzEDRHead(long azEDRHead) {
        this.azEDRHead = azEDRHead;
    }

    public void setMAXgrEntry(int mAXgrEntry) {
        this.mAXgrEntry = mAXgrEntry;
    }

    public void setMAXzEntry(int mAXzEntry) {
        this.mAXzEntry = mAXzEntry;
    }

    public void setName(String name) {
        Objects.requireNonNull(name, "name cannot be null.");
        byte[] nameAsBytes = name.getBytes(StandardCharsets.US_ASCII);
        int nameLength = nameAsBytes.length;
        if (nameLength > 256) {
            throw new IllegalArgumentException("ADR names cannot exceed 256 bytes. The supplied name, " + name + " is " + nameLength + " bytes long.");
        }
        this.name = name;
        byte[] paddedName = new byte[256];
        System.arraycopy(nameAsBytes, 0, paddedName, 0, nameLength);
        this.paddedName = paddedName;
    }

    public void setNgrEntries(int ngrEntries) {
        this.ngrEntries = ngrEntries;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public void setNzEntries(int nzEntries) {
        this.nzEntries = nzEntries;
    }

    public void setScope(int scope) {
        switch (scope) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Scope, " + scope + ", is not valid. Scope must be 1, 2, 3, or 4.");
            }
        }
        this.scope = scope;
    }
}

