/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import java.util.Vector;

public class ArrayAttribute {
    Vector<Integer> dim = new Vector();
    Class<?> cl;
    Object o;

    public ArrayAttribute(Object data) throws Throwable {
        this.cl = data.getClass();
        if (!this.cl.isArray()) {
            throw new Throwable("AArray: Object " + data + " is not an array");
        }
        this.o = data;
        while (this.cl.isArray()) {
            this.cl = this.cl.getComponentType();
            if (this.cl.isPrimitive()) {
                if (this.cl == Double.TYPE) {
                    this.dim.add(((double[])this.o).length);
                    break;
                }
                if (this.cl == Float.TYPE) {
                    this.dim.add(((float[])this.o).length);
                    break;
                }
                if (this.cl == Integer.TYPE) {
                    this.dim.add(((int[])this.o).length);
                    break;
                }
                if (this.cl == Byte.TYPE) {
                    this.dim.add(((byte[])this.o).length);
                    break;
                }
                if (this.cl == Short.TYPE) {
                    this.dim.add(((short[])this.o).length);
                    break;
                }
                if (this.cl == Long.TYPE) {
                    this.dim.add(((long[])this.o).length);
                    break;
                }
            }
            Object[] _o = (Object[])this.o;
            this.o = _o[0];
            this.dim.add(_o.length);
        }
    }

    public Class<?> getType() {
        return this.cl;
    }

    public int[] getDimensions() {
        int[] ia = new int[this.dim.size()];
        for (int i = 0; i < ia.length; ++i) {
            ia[i] = this.dim.get(i);
        }
        return ia;
    }

    public void toStringArray(String[] sa) throws Throwable {
        if (this.cl == String.class) {
            String[] sin = (String[])this.o;
            if (sa.length == sin.length) {
                for (int i = 0; i < sin.length; ++i) {
                    sa[i] = sin[i];
                }
                return;
            }
            throw new Throwable("Length of the receiver array does not match length.");
        }
        throw new Throwable("Method not appropriate for objects of type " + this.cl);
    }

    public void toLongArray(long[] la) throws Throwable {
        if (this.cl == Long.TYPE) {
            long[] lin = (long[])this.o;
            if (la.length == lin.length) {
                for (int i = 0; i < lin.length; ++i) {
                    la[i] = lin[i];
                }
                return;
            }
            throw new Throwable("Length of the receiver array does not match length.");
        }
        throw new Throwable("Method not appropriate for objects of type " + this.cl);
    }

    public void toDoubleArray(double[] da) throws Throwable {
        if (this.cl == Double.TYPE) {
            double[] din = (double[])this.o;
            if (da.length == din.length) {
                for (int i = 0; i < din.length; ++i) {
                    da[i] = din[i];
                }
                return;
            }
            throw new Throwable("Length of the receiver array does not match length.");
        }
        throw new Throwable("Method not appropriate for objects of type " + this.cl);
    }
}

