/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Vector;
import java.util.zip.GZIPInputStream;

public class ByteBufferURLReader {
    InputStream is;
    boolean eof = false;
    public int total;
    public int len = -1;
    Chunk chunk = new Chunk();
    byte[] block = this.chunk.getBlock();
    FileChannel cacheFileChannel;
    ByteBuffer buffer;

    public ByteBufferURLReader(URL url) throws IOException {
        URLConnection con = url.openConnection();
        con.connect();
        this.len = con.getContentLength();
        if (this.len >= 0) {
            this.chunk.setLength(this.len);
        }
        this.is = con.getInputStream();
        boolean gzipped = url.getPath().trim().endsWith(".gz");
        if (gzipped) {
            this.is = new GZIPInputStream(this.is);
        }
    }

    public ByteBufferURLReader(URL url, Chunk chunk) throws IOException {
        this(url);
        this.setChunk(chunk);
    }

    public ByteBufferURLReader(URL url, FileChannel fileChannel, Chunk chunk) throws IOException {
        this(url, chunk);
        this.cacheFileChannel = fileChannel;
        this.buffer = chunk.allocateBuffer();
    }

    public ByteBufferURLReader(URL url, FileChannel fileChannel) throws IOException {
        this(url);
        this.cacheFileChannel = fileChannel;
        this.buffer = this.chunk.allocateBuffer();
    }

    public void setChunk(Chunk chunk) {
        this.chunk = chunk;
        this.block = chunk.getBlock();
    }

    public ByteBuffer getBuffer() throws IOException {
        Vector<ByteBuffer> buffers = new Vector<ByteBuffer>();
        while (!this.eof) {
            if (this.cacheFileChannel == null) {
                buffers.add(this.read());
                continue;
            }
            this.transfer();
        }
        if (this.cacheFileChannel != null) {
            long pos = this.cacheFileChannel.position();
            FileChannel.MapMode mode = FileChannel.MapMode.READ_ONLY;
            return this.cacheFileChannel.map(mode, 0L, pos);
        }
        if (buffers.size() == 1) {
            ByteBuffer _buf = (ByteBuffer)buffers.get(0);
            return _buf.asReadOnlyBuffer();
        }
        int size = 0;
        for (int i = 0; i < buffers.size(); ++i) {
            ByteBuffer _buf = (ByteBuffer)buffers.get(i);
            size += _buf.remaining();
        }
        ByteBuffer ball = ByteBuffer.allocateDirect(size);
        for (int i = 0; i < buffers.size(); ++i) {
            ByteBuffer _buf = (ByteBuffer)buffers.get(i);
            ball.put(_buf);
        }
        ball.position(0);
        return ball.asReadOnlyBuffer();
    }

    public ByteBuffer read() throws IOException {
        ByteBuffer buf = this.chunk.allocateBuffer();
        this._read(buf);
        return buf;
    }

    public void transfer() throws IOException {
        this._read(this.buffer);
        this.cacheFileChannel.write(this.buffer);
    }

    private void _read(ByteBuffer buffer) throws IOException {
        int count = 0;
        buffer.position(0);
        buffer.limit(buffer.capacity());
        if (buffer.capacity() < 2 * this.block.length) {
            int n;
            for (int i = 0; i < buffer.capacity(); ++i) {
                n = this.is.read();
                if (n == -1) {
                    throw new IOException("Premature end of data");
                }
                buffer.put((byte)n);
            }
            n = this.is.read(this.block);
            if (n != -1) {
                throw new IOException("Unread data remains");
            }
            this.total = count = buffer.capacity();
            this.eof = true;
        } else {
            int n;
            while ((n = this.is.read(this.block)) != -1) {
                buffer.put(this.block, 0, n);
                this.total += n;
                if (this.len == buffer.capacity() || (count += n) < this.chunk.chunkSize) continue;
            }
            if (n == -1) {
                this.eof = true;
            }
            if (this.eof && this.len >= 0 && this.total != this.len) {
                throw new IOException("Mismatched length " + this.total + " expected: " + this.len);
            }
            buffer.limit(buffer.position());
        }
        buffer.position(0);
    }

    public boolean endOfFile() {
        return this.eof;
    }

    public static class Chunk {
        int chunkSize = 0x100000;
        int blockSize = 65536;
        int len = -1;

        public Chunk() {
        }

        public Chunk(int blockSize, int chunkSize) throws Throwable {
            if (chunkSize < blockSize) {
                throw new Throwable("Chunk size must be >= block size");
            }
            this.blockSize = blockSize;
            this.chunkSize = chunkSize;
        }

        void setLength(int length) {
            this.len = length;
        }

        ByteBuffer allocateBuffer() {
            int bufsize = this.chunkSize + this.blockSize;
            if (this.len < 0) {
                return ByteBuffer.allocateDirect(bufsize);
            }
            if (this.len > bufsize) {
                return ByteBuffer.allocateDirect(bufsize);
            }
            return ByteBuffer.allocateDirect(this.len);
        }

        byte[] getBlock() {
            return new byte[this.blockSize];
        }
    }
}

