/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDF3;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;

final class CDF3Impl
extends CDFImpl
implements CDF3,
Serializable {
    public long GDROffset;
    FileChannel fc;

    protected CDF3Impl(ByteBuffer buf, FileChannel ch) throws Throwable {
        super(buf);
        this.fc = ch;
        this.setOffsets();
        this.thisCDF = this;
        IntBuffer ibuf = buf.asIntBuffer();
        ByteBuffer _buf = super.getRecord(0L);
        ibuf.position(2);
        ibuf.get();
        ibuf.get();
        ibuf.get();
        this.GDROffset = ibuf.get();
        this.GDROffset = (this.GDROffset << 32) + (long)ibuf.get();
        this.version = ibuf.get();
        if (this.version != 3) {
            throw new Throwable("Version " + this.version + "is not accepted by this reader.");
        }
        this.release = ibuf.get();
        this.encoding = ibuf.get();
        this.byteOrder = DataTypes.getByteOrder(this.encoding);
        this.setByteOrder(this.byteOrder);
        this.flags = ibuf.get();
        ibuf.get();
        ibuf.get();
        this.increment = ibuf.get();
        int pos = (int)this.GDROffset + 8;
        buf.position(pos);
        int x = buf.getInt();
        if (x != 2) {
            throw new Throwable("Bad GDR type " + x);
        }
        this.rVDRHead = buf.getLong();
        this.zVDRHead = buf.getLong();
        this.ADRHead = buf.getLong();
        long CDFSize = buf.getLong();
        this.numberOfRVariables = buf.getInt();
        this.numberOfAttributes = buf.getInt();
        buf.getInt();
        int numberOfRDims = buf.getInt();
        this.numberOfZVariables = buf.getInt();
        buf.getInt();
        buf.getInt();
        buf.getInt();
        this.lastLeapSecondId = buf.getInt();
        this.rDimSizes = new int[numberOfRDims];
        if (numberOfRDims > 0) {
            buf.getInt();
            for (int i = 0; i < this.rDimSizes.length; ++i) {
                this.rDimSizes[i] = buf.getInt();
            }
        }
        buf.position(0);
        this.withRZ = this.numberOfRVariables > 0 && this.numberOfZVariables > 0 ? 1 : 0;
        this.variableTable = this.variables();
        this.attributeTable = this.attributes();
    }

    protected CDF3Impl(ByteBuffer buf) throws Throwable {
        this(buf, null);
    }

    void setOffsets() {
        this.offset_NEXT_VDR = 12;
        this.offset_NEXT_ADR = 12;
        this.offset_ATTR_NAME = 68;
        this.offset_SCOPE = 28;
        this.offset_AgrEDRHead = 20;
        this.offset_AzEDRHead = 48;
        this.offset_NEXT_AEDR = 12;
        this.offset_ENTRYNUM = 28;
        this.offset_ATTR_DATATYPE = 24;
        this.offset_ATTR_NUM_ELEMENTS = 32;
        this.offset_VALUE = 56;
        this.offset_VAR_NAME = 84;
        this.offset_VAR_NUM_ELEMENTS = 64;
        this.offset_NUM = 68;
        this.offset_FLAGS = 44;
        this.offset_sRecords = 48;
        this.offset_CPR_offset = 72;
        this.offset_cType = 12;
        this.offset_cParm = 24;
        this.offset_BLOCKING_FACTOR = 80;
        this.offset_VAR_DATATYPE = 20;
        this.offset_zNumDims = 340;
        this.offset_FIRST_VXR = 28;
        this.offset_NEXT_VXR = 12;
        this.offset_NENTRIES = 20;
        this.offset_NUSED = 24;
        this.offset_FIRST = 28;
        this.offset_RECORD_TYPE = 8;
        this.offset_RECORDS = 12;
        this.offset_CSIZE = 16;
        this.offset_CDATA = 24;
    }

    @Override
    public String getString(long offset) {
        ByteBuffer _buf;
        if (this.fc == null) {
            return this.getString(offset, 256);
        }
        try {
            _buf = this.getRecord(offset, 256);
        }
        catch (Throwable th) {
            th.printStackTrace();
            return null;
        }
        return this.getString(_buf, 256);
    }

    @Override
    public int lowOrderInt(ByteBuffer buf) {
        return (int)buf.getLong();
    }

    @Override
    public int lowOrderInt(ByteBuffer buf, int offset) {
        return (int)buf.getLong(offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuffer getRecord(long offset) {
        if (this.fc == null) {
            return super.getRecord(offset);
        }
        ByteBuffer lenBuf = ByteBuffer.allocate(4);
        FileChannel fileChannel = this.fc;
        synchronized (fileChannel) {
            try {
                this.fc.position(offset + 4L);
                this.fc.read(lenBuf);
                int size = lenBuf.getInt(0);
                return this.getRecord(offset, size);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }

    protected ByteBuffer getRecord(long offset, int size) throws Throwable {
        ByteBuffer bb = ByteBuffer.allocate(size);
        this.fc.position(offset);
        int got = this.fc.read(bb);
        if (got != size) {
            System.out.println("Needed " + size + " bytes. Got " + got);
            return null;
        }
        bb.position(0);
        return bb;
    }

    @Override
    public long longInt(ByteBuffer buf) {
        return buf.getLong();
    }
}

