/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.Attribute;
import gov.nasa.gsfc.spdf.cdfj.AttributeEntry;
import gov.nasa.gsfc.spdf.cdfj.BaseVarContainer;
import gov.nasa.gsfc.spdf.cdfj.ByteVarContainer;
import gov.nasa.gsfc.spdf.cdfj.CDFAHuffman;
import gov.nasa.gsfc.spdf.cdfj.CDFCore;
import gov.nasa.gsfc.spdf.cdfj.CDFFactory;
import gov.nasa.gsfc.spdf.cdfj.CDFHuffman;
import gov.nasa.gsfc.spdf.cdfj.CDFRLE;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.DoubleArray;
import gov.nasa.gsfc.spdf.cdfj.DoubleVarContainer;
import gov.nasa.gsfc.spdf.cdfj.FloatVarContainer;
import gov.nasa.gsfc.spdf.cdfj.GlobalAttribute;
import gov.nasa.gsfc.spdf.cdfj.IntVarContainer;
import gov.nasa.gsfc.spdf.cdfj.LongArray;
import gov.nasa.gsfc.spdf.cdfj.LongVarContainer;
import gov.nasa.gsfc.spdf.cdfj.ShortVarContainer;
import gov.nasa.gsfc.spdf.cdfj.StringArray;
import gov.nasa.gsfc.spdf.cdfj.StringVarContainer;
import gov.nasa.gsfc.spdf.cdfj.VDataContainer;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import gov.nasa.gsfc.spdf.cdfj.VariableDataBuffer;
import gov.nasa.gsfc.spdf.cdfj.VariableDataLocator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public abstract class CDFImpl
implements Serializable {
    public static final int GDR_RECORD = 2;
    public static final int FLAGS_MAJORITY_MASK = 1;
    public static final int ROW_MAJOR = 1;
    public static final int VXR_RECORD_TYPE = 6;
    public static final int VVR_RECORD_TYPE = 7;
    public static final int CVVR_RECORD_TYPE = 13;
    public static final int CCR_RECORD_TYPE = 10;
    public static final int CPR_RECORD_TYPE = 11;
    public static final String STRINGDELIMITER = new String("\\N ");
    int offset_NEXT_VDR;
    int offset_NEXT_ADR;
    int offset_ATTR_NAME;
    int offset_SCOPE;
    int offset_AgrEDRHead;
    int offset_AzEDRHead;
    int offset_NEXT_AEDR;
    int offset_ENTRYNUM;
    int offset_ATTR_DATATYPE;
    int offset_ATTR_NUM_ELEMENTS;
    int offset_VALUE;
    int offset_VAR_NAME;
    int offset_VAR_NUM_ELEMENTS;
    int offset_NUM;
    int offset_FLAGS;
    int offset_sRecords;
    int offset_CPR_offset;
    int offset_BLOCKING_FACTOR;
    int offset_VAR_DATATYPE;
    int offset_zNumDims;
    int offset_FIRST_VXR;
    int offset_NEXT_VXR;
    int offset_NENTRIES;
    int offset_NUSED;
    int offset_FIRST;
    int offset_RECORD_TYPE;
    int offset_RECORDS;
    int offset_CSIZE;
    int offset_CDATA;
    int offset_CVR;
    int offset_cType;
    int offset_cParm;
    int version;
    int release;
    int encoding;
    int flags;
    int increment;
    transient ByteOrder byteOrder;
    boolean bigEndian;
    long GDROffset;
    long rVDRHead;
    long zVDRHead;
    long ADRHead;
    int numberOfRVariables;
    int numberOfAttributes;
    int numberOfZVariables;
    int[] rDimSizes;
    int lastLeapSecondId;
    int withRZ;
    long CPROffset;
    long uSize;
    int compression;
    int compLevel;
    transient ByteBuffer buf;
    protected String[] varNames;
    protected Hashtable variableTable;
    private HashMap<Integer, CDFVariable> ivariableTable;
    Hashtable attributeTable;
    protected CDFCore thisCDF;
    protected CDFFactory.CDFSource source;
    protected CDFFactory.ProcessingOption processingOption;
    private static final Logger LOGGER = Logger.getLogger("cdfj.cdfimpl");

    protected CDFImpl(ByteBuffer buf) {
        this.buf = buf;
    }

    protected ByteBuffer getRecord(long offset) {
        ByteBuffer _buf = this.buf.duplicate();
        _buf.position((int)offset);
        return _buf.slice();
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public boolean rowMajority() {
        return (this.flags & 1) == 1;
    }

    protected Hashtable variables() {
        if (this.variableTable != null) {
            return this.variableTable;
        }
        LOGGER.entering("CDFImpl", "variables");
        int[] offsets = new int[]{(int)this.zVDRHead, (int)this.rVDRHead};
        String[] vtypes = new String[]{"z", "r"};
        Hashtable<String, CDFVariable> table = new Hashtable<String, CDFVariable>();
        HashMap<Integer, CDFVariable> ivariableTable = new HashMap<Integer, CDFVariable>();
        Vector<String> v = new Vector<String>();
        block0: for (int vtype = 0; vtype < 2; ++vtype) {
            long offset = offsets[vtype];
            if (offset == 0L) continue;
            ByteBuffer _buf = this.getRecord(offset);
            while (true) {
                _buf.position(this.offset_NEXT_VDR);
                long next = this.longInt(_buf);
                CDFVariable cdfv = new CDFVariable(offset, vtypes[vtype]);
                String name = cdfv.getName();
                v.add(name);
                ivariableTable.put(cdfv.rzNumber, cdfv);
                table.put(name, cdfv);
                if (next == 0L) continue block0;
                offset = next;
                _buf = this.getRecord(offset);
            }
        }
        this.varNames = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            this.varNames[i] = (String)v.elementAt(i);
        }
        this.variableTable = table;
        this.ivariableTable = ivariableTable;
        LOGGER.exiting("CDFImpl", "variables");
        return table;
    }

    public String[] getVariableNames() {
        String[] sa = new String[this.varNames.length];
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = this.varNames[i];
        }
        return sa;
    }

    public Variable getVariable(String name) {
        return (Variable)this.variableTable.get(name);
    }

    public String[] getVariableNames(String type) {
        Vector<String> vars = new Vector<String>();
        for (String varName : this.varNames) {
            String s;
            Vector v = (Vector)this.getAttribute(varName, "VAR_TYPE");
            if (v == null || v.size() == 0 || !(s = (String)v.elementAt(0)).equals(type)) continue;
            vars.add(varName);
        }
        String[] sa = new String[vars.size()];
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = (String)vars.elementAt(i);
        }
        return sa;
    }

    public String[] globalAttributeNames() {
        Vector<String> vec = new Vector<String>();
        if (this.attributeTable == null) {
            return new String[0];
        }
        Set set = this.attributeTable.keySet();
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            CDFAttribute attr = (CDFAttribute)this.attributeTable.get(iter.next());
            if (!attr.isGlobal()) continue;
            vec.add(attr.name);
        }
        String[] sa = new String[vec.size()];
        for (int i = 0; i < vec.size(); ++i) {
            sa[i] = (String)vec.elementAt(i);
        }
        return sa;
    }

    public String[] variableAttributeNames(String name) {
        CDFVariable var = (CDFVariable)this.variableTable.get(name);
        if (var == null) {
            return null;
        }
        String[] sa = new String[var.attributes.size()];
        for (int i = 0; i < sa.length; ++i) {
            AttributeEntry ae = (AttributeEntry)var.attributes.elementAt(i);
            sa[i] = ae.getAttributeName();
        }
        return sa;
    }

    public Object getAttribute(String atr) {
        if (this.attributeTable == null) {
            return null;
        }
        CDFAttribute a = (CDFAttribute)this.attributeTable.get(atr);
        if (a == null) {
            return null;
        }
        if (!a.isGlobal()) {
            return null;
        }
        if (a.gEntries.size() == 0) {
            return null;
        }
        AttributeEntry ae = (AttributeEntry)a.gEntries.elementAt(0);
        if (ae.isStringType()) {
            String[] sa = new String[a.gEntries.size()];
            for (int i = 0; i < a.gEntries.size(); ++i) {
                ae = (AttributeEntry)a.gEntries.elementAt(i);
                sa[i] = (String)ae.getValue();
            }
            return sa;
        }
        return ae.getValue();
    }

    public GlobalAttribute getGlobalAttribute(String atr) throws Throwable {
        if (this.attributeTable == null) {
            throw new Throwable("No attribute named " + atr);
        }
        final CDFAttribute a = (CDFAttribute)this.attributeTable.get(atr);
        if (a == null) {
            throw new Throwable("No attribute named " + atr);
        }
        if (!a.isGlobal()) {
            throw new Throwable("No global attribute named " + atr);
        }
        return new GlobalAttribute(){

            @Override
            public String getName() {
                return a.getName();
            }

            @Override
            public boolean isGlobal() {
                return true;
            }

            @Override
            public int getNum() {
                return a.num;
            }

            @Override
            public int getEntryCount() {
                return a.gEntries.size();
            }

            @Override
            public Object getEntry(int n) {
                if (n > a.gEntries.size()) {
                    return null;
                }
                if (n < 0) {
                    return null;
                }
                AttributeEntry ae = (AttributeEntry)a.gEntries.elementAt(n);
                return ae.getValue();
            }

            @Override
            public boolean isStringType(int n) throws Throwable {
                if (n < 0 || n > a.gEntries.size()) {
                    throw new Throwable("Invalid attribute index");
                }
                AttributeEntry ae = (AttributeEntry)a.gEntries.elementAt(n);
                return ae.isStringType();
            }

            @Override
            public boolean isLongType(int n) throws Throwable {
                if (n < 0 || n > a.gEntries.size()) {
                    throw new Throwable("Invalid attribute index");
                }
                AttributeEntry ae = (AttributeEntry)a.gEntries.elementAt(n);
                return ae.isLongType();
            }
        };
    }

    public Object getAttribute(String var, String atr) {
        CDFVariable c = (CDFVariable)this.variableTable.get(var);
        if (c == null) {
            return null;
        }
        Vector attrs = c.attributes;
        Vector<Object> values = new Vector<Object>();
        for (int i = 0; i < attrs.size(); ++i) {
            AttributeEntry ae = (AttributeEntry)attrs.elementAt(i);
            if (!ae.getAttributeName().equals(atr)) continue;
            values.add(ae.getValue());
        }
        return values;
    }

    public Vector getAttributeEntries(String atr) throws Throwable {
        if (this.attributeTable == null) {
            throw new Throwable("No attribute named " + atr);
        }
        CDFAttribute a = (CDFAttribute)this.attributeTable.get(atr);
        if (a == null) {
            throw new Throwable("No attribute named " + atr);
        }
        if (!a.isGlobal()) {
            throw new Throwable("No global attribute named " + atr);
        }
        return a.gEntries;
    }

    public Vector getAttributeEntries(String var, String atr) {
        CDFVariable c = (CDFVariable)this.variableTable.get(var);
        if (c == null) {
            return null;
        }
        Vector attrs = c.attributes;
        Vector<AttributeEntry> entries = new Vector<AttributeEntry>();
        for (int i = 0; i < attrs.size(); ++i) {
            AttributeEntry ae = (AttributeEntry)attrs.elementAt(i);
            if (!ae.getAttributeName().equals(atr)) continue;
            entries.add(ae);
        }
        return entries;
    }

    Variable getCDFVariable(String vtype, int number) {
        int xNum = vtype == "z" ? number + this.numberOfRVariables : number;
        CDFVariable var = this.ivariableTable.get(xNum);
        return var;
    }

    Variable getCDFVariable(String name) {
        CDFVariable var = (CDFVariable)this.variableTable.get(name);
        return var;
    }

    Hashtable attributes() {
        if (this.attributeTable != null) {
            return this.attributeTable;
        }
        LOGGER.entering("CDFImpl", "attributes");
        long offset = this.ADRHead;
        if (offset == 0L) {
            return null;
        }
        Hashtable<String, CDFAttribute> table = new Hashtable<String, CDFAttribute>();
        ByteBuffer _buf = this.getRecord(offset);
        while (true) {
            _buf.position(this.offset_NEXT_ADR);
            long next = this.longInt(_buf);
            CDFAttribute cdfa = new CDFAttribute(offset);
            CDFAttribute o = table.put(cdfa.getName(), cdfa);
            if (o != null) {
                System.out.println("possibly duplicate attribute " + cdfa.getName());
            }
            if (next == 0L) break;
            offset = next;
            _buf = this.getRecord(offset);
        }
        this.attributeTable = table;
        LOGGER.exiting("CDFImpl", "attributes");
        return table;
    }

    Object getPadValue(Variable var) {
        return var.getPadValue(true);
    }

    Object getFillValue(Variable var) {
        Vector fill = (Vector)this.getAttribute(var.getName(), "FILLVAL");
        int type = var.getType();
        if (fill.size() != 0) {
            if (fill.get(0).getClass().getComponentType() == Double.TYPE) {
                double dfill = ((double[])fill.get(0))[0];
                if (DataTypes.typeCategory[type] == 5) {
                    return new long[]{0L, (long)dfill};
                }
                return new double[]{0.0, dfill};
            }
            long lfill = ((long[])fill.get(0))[0];
            if (DataTypes.typeCategory[type] == 5) {
                return new long[]{0L, lfill};
            }
            return new double[]{0.0, lfill};
        }
        if (DataTypes.typeCategory[type] == 5) {
            return new long[]{Long.MIN_VALUE, 0L};
        }
        return new double[]{Double.NEGATIVE_INFINITY, 0.0};
    }

    ByteBuffer positionBuffer(Variable var, long offset, int count) {
        ByteBuffer bv;
        if (!var.isCompressed()) {
            bv = this.getValueBuffer(offset);
        } else {
            int size = var.getDataItemSize();
            bv = this.getValueBuffer(var, offset, size, count);
        }
        bv.order(this.getByteOrder());
        return bv;
    }

    public ByteBuffer getValueBuffer(long offset) {
        ByteBuffer bv = this.getRecord(offset);
        bv.position(this.offset_RECORDS);
        return bv;
    }

    public ByteBuffer getValueBuffer(Variable var, long offset, int size, int number) {
        ByteBuffer bv = this.getRecord(offset);
        if (bv.getInt(this.offset_RECORD_TYPE) == 7) {
            bv.position(this.offset_RECORDS);
            return bv;
        }
        int clen = this.lowOrderInt(bv, this.offset_CSIZE);
        byte[] work = new byte[clen];
        bv.position(this.offset_CDATA);
        bv.get(work);
        int ulen = size * number;
        byte[] udata = null;
        int compType = var.getCompressionType();
        if ((long)compType == 5L) {
            udata = new byte[ulen];
            int n = 0;
            try {
                GZIPInputStream gz = new GZIPInputStream(new ByteArrayInputStream(work));
                int off = 0;
                for (int toRead = udata.length; toRead > 0 && (n = gz.read(udata, off, toRead)) != -1; toRead -= n) {
                    off += n;
                }
            }
            catch (IOException ex) {
                System.out.println(ex.toString() + " at offset " + offset);
                System.out.println("Trying to get data as uncompressed");
                return this.getValueBuffer(offset);
            }
            if (n < 0) {
                return null;
            }
        } else if ((long)compType == 1L) {
            new CDFRLE();
            udata = CDFRLE.decompress(work, ulen);
        } else if ((long)compType == 2L) {
            udata = new CDFHuffman().decompress(work, ulen);
        } else if ((long)compType == 3L) {
            udata = new CDFAHuffman().decompress(work, ulen);
        }
        return ByteBuffer.wrap(udata);
    }

    public int[] variableDimensions(String name) {
        Variable var = (Variable)this.variableTable.get(name);
        if (var == null) {
            return null;
        }
        int[] dims = var.getDimensions();
        int[] ia = new int[dims.length];
        System.arraycopy(ia, 0, dims, 0, dims.length);
        return ia;
    }

    protected abstract long longInt(ByteBuffer var1);

    protected abstract int lowOrderInt(ByteBuffer var1);

    protected abstract int lowOrderInt(ByteBuffer var1, int var2);

    protected abstract String getString(long var1);

    protected String getString(long offset, int max) {
        return this.getString(this.getRecord(offset), max);
    }

    protected String getString(ByteBuffer _buf, int max) {
        int i;
        byte[] ba = new byte[max];
        for (i = 0; i < max; ++i) {
            ba[i] = _buf.get();
            if (ba[i] == 0) break;
        }
        return new String(ba, 0, i);
    }

    public static Object getNumberAttribute(int type, int nelement, ByteBuffer vbuf, ByteOrder byteOrder) {
        ByteBuffer vbufLocal = vbuf.duplicate();
        vbufLocal.order(byteOrder);
        int ne = nelement;
        if (type == 32) {
            ne = 2 * nelement;
        }
        long[] lvalue = null;
        double[] value = null;
        long longInt = DataTypes.longInt[type];
        boolean longType = false;
        try {
            if (type > 20 || type < 10) {
                if (DataTypes.typeCategory[type] == 5) {
                    lvalue = new long[ne];
                    longType = true;
                } else {
                    value = new double[ne];
                }
                for (int i = 0; i < ne; ++i) {
                    Number num = (Number)DataTypes.method[type].invoke((Object)vbufLocal, new Object[0]);
                    if (!longType) {
                        value[i] = num.doubleValue();
                    }
                    if (!longType) continue;
                    lvalue[i] = num.longValue();
                }
            } else {
                value = new double[ne];
                for (int i = 0; i < nelement; ++i) {
                    Number num = (Number)DataTypes.method[type].invoke((Object)vbufLocal, new Object[0]);
                    int n = num.intValue();
                    value[i] = n >= 0 ? (double)n : (double)(longInt + (long)n);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            System.out.println("getNumberAttribute: " + vbuf);
            System.out.println("type: " + type);
            ex.printStackTrace();
            return null;
        }
        if (longType) {
            return lvalue;
        }
        return value;
    }

    protected void setByteOrder(ByteOrder bo) {
        this.bigEndian = bo.equals(ByteOrder.BIG_ENDIAN);
    }

    protected void setByteOrder(boolean _bigEndian) {
        this.byteOrder = _bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.setByteOrder(this.byteOrder);
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    protected void setBuffer(ByteBuffer b) {
        this.buf = b;
    }

    protected ByteBuffer getBuffer() {
        return this.buf;
    }

    public void extractBytes(int bufOffset, byte[] ba, int offset, int len) {
        ((ByteBuffer)this.buf.duplicate().position(bufOffset)).get(ba, offset, len);
    }

    protected int getRecordOffset() {
        return this.offset_RECORDS;
    }

    protected void setSource(CDFFactory.CDFSource source) {
        this.source = source;
    }

    public CDFFactory.CDFSource getSource() {
        return this.source;
    }

    protected void setOption(CDFFactory.ProcessingOption option) {
        this.processingOption = option;
    }

    public double[] get1D(String varName) throws Throwable {
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        if (!var.isCompatible(Double.TYPE)) {
            throw new Throwable("Variable " + varName + " cannot be converted to double, or the conversion may result in loss of precision. Use get1D(" + varName + ", Boolean.TRUE) for string type. Otherwise use get1D(" + varName + ", false");
        }
        return var.asDoubleArray();
    }

    public double[] getOneD(String varName, boolean columnMajor) throws Throwable {
        CDFVariable var = (CDFVariable)this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        if (!var.isCompatible(Double.TYPE)) {
            throw new Throwable("Variable " + varName + " cannot be converted to double, or the conversion may result in loss of precision. Use getOneD(" + varName + ", Boolean.TRUE) for string type. Otherwise use get1D(" + varName + ", false");
        }
        TargetAttribute ta = new TargetAttribute(false, columnMajor);
        return var.asDoubleArray(ta, null);
    }

    public byte[] get1D(String varName, Boolean stringType) throws Throwable {
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        int type = var.getType();
        if (!DataTypes.isStringType(type)) {
            throw new Throwable("Variable " + varName + " is not a string variable");
        }
        return var.asByteArray(null);
    }

    public byte[] getOneD(String varName, Boolean stringType, boolean columnMajor) throws Throwable {
        CDFVariable var = (CDFVariable)this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        int type = var.getType();
        if (!DataTypes.isStringType(type)) {
            throw new Throwable("Variable " + varName + " is not a string variable");
        }
        return var.asByteArray(null, columnMajor);
    }

    public Object get1D(String varName, boolean preserve) throws Throwable {
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        int type = var.getType();
        if (DataTypes.isStringType(type)) {
            return var.asByteArray(null);
        }
        if (preserve && DataTypes.isLongType(type)) {
            return var.asLongArray(null);
        }
        return var.asDoubleArray();
    }

    public Object get1D(String varName, int point) throws Throwable {
        return this.get1D(varName, point, -1);
    }

    public Object get1D(String varName, int first, int last) throws Throwable {
        int[] nArray;
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        int type = var.getType();
        if (last >= 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = first;
            nArray = nArray2;
            nArray2[1] = last;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = first;
        }
        int[] range = nArray;
        if (DataTypes.isLongType(type)) {
            return var.asLongArray(range);
        }
        if (DataTypes.isStringType(type)) {
            return var.asByteArray(range);
        }
        return var.asDoubleArray(range);
    }

    public Object get(String varName) throws Throwable {
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        if (DataTypes.isStringType(var.getType())) {
            VDataContainer.CString container = var.getStringContainer(null);
            container.run();
            StringArray sa = (StringArray)container.asArray();
            return sa.array();
        }
        VDataContainer.CDouble container = var.getDoubleContainer(null, false);
        container.run();
        DoubleArray da = container.asArray();
        return da.array();
    }

    public Object getLong(String varName) throws Throwable {
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        if (!DataTypes.isLongType(var.getType())) {
            throw new Throwable("getLong method appropriate for TT2000 and INT8 types. ");
        }
        VDataContainer.CLong container = var.getLongContainer(null);
        container.run();
        LongArray la = container.asArray();
        return la.array();
    }

    public Object get(String varName, int element) throws Throwable {
        return this.get(varName, new int[]{element});
    }

    public Object get(String varName, int[] elements) throws Throwable {
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        if (DataTypes.isStringType(var.getType())) {
            throw new Throwable("Function not supported for string variables");
        }
        DoubleVarContainer dbuf = new DoubleVarContainer(this, var, null, false, ByteOrder.nativeOrder());
        dbuf.run();
        return dbuf.asArrayElement(elements);
    }

    public Object get(String varName, int index0, int index1) throws Throwable {
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        if (DataTypes.isStringType(var.getType())) {
            throw new Throwable("Function not supported for string variables");
        }
        DoubleVarContainer dbuf = new DoubleVarContainer(this, var, null, false, ByteOrder.nativeOrder());
        dbuf.run();
        return dbuf.asArrayElement(index0, index1);
    }

    public Object get(String varName, int first, int last, int element) throws Throwable {
        return this.get(varName, first, last, new int[]{element});
    }

    public Object get(String varName, int first, int last, int[] elements) throws Throwable {
        DoubleVarContainer dbuf = this.getRangeBuffer(varName, first, last);
        return dbuf.asArrayElement(elements);
    }

    public Object getPoint(String varName, int point) throws Throwable {
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        if (DataTypes.isStringType(var.getType())) {
            VDataContainer.CString container = var.getStringContainer(null);
            container.run();
            StringArray sa = (StringArray)container.asArray();
            return sa.array();
        }
        DoubleVarContainer dbuf = new DoubleVarContainer(this, var, new int[]{point}, false, ByteOrder.nativeOrder());
        dbuf.run();
        return dbuf.asArray().array();
    }

    public Object getRange(String varName, int first, int last, boolean oned) throws Throwable {
        DoubleVarContainer dbuf = this.getRangeBuffer(varName, first, last);
        if (oned) {
            return dbuf.as1DArray();
        }
        return dbuf.asArray().array();
    }

    public Object getRange(String varName, int first, int last) throws Throwable {
        return this.getRange(varName, first, last, false);
    }

    public Object getRangeOneD(String varName, int first, int last, boolean columnMajor) throws Throwable {
        DoubleVarContainer dbuf = this.getRangeBuffer(varName, first, last);
        return dbuf.asOneDArray(columnMajor);
    }

    DoubleVarContainer getRangeBuffer(String varName, int first, int last) throws Throwable {
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        if (DataTypes.isStringType(var.getType())) {
            throw new Throwable("Function not supported for string variables");
        }
        int[] range = new int[]{first, last};
        DoubleVarContainer dbuf = new DoubleVarContainer(this, var, range, false, ByteOrder.nativeOrder());
        dbuf.run();
        return dbuf;
    }

    public Object getRange(String varName, int first, int last, int element) throws Throwable {
        return this.getRange(varName, first, last, new int[]{element});
    }

    public Object getRange(String varName, int first, int last, int[] elements) throws Throwable {
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        if (DataTypes.isStringType(var.getType())) {
            throw new Throwable("Function not supported for string variables");
        }
        DoubleVarContainer dbuf = this.getRangeBuffer(varName, first, last);
        return dbuf.asArrayElement(elements);
    }

    public boolean isCompatible(String varName, Class cl) throws Throwable {
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        return var.isCompatible(cl);
    }

    public byte[] getByteArray(String varName, int[] pt) throws Throwable {
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        return var.asByteArray(pt);
    }

    public double[] getDoubleArray(String varName, int[] pt) throws Throwable {
        return this.getDoubleArray(varName, pt, true);
    }

    public double[] getDoubleArray(String varName, int[] pt, boolean preserve) throws Throwable {
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        return var.asDoubleArray(preserve, pt);
    }

    public float[] getFloatArray(String varName, int[] pt) throws Throwable {
        return this.getFloatArray(varName, pt, true);
    }

    public float[] getFloatArray(String varName, int[] pt, boolean preserve) throws Throwable {
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        return var.asFloatArray(preserve, pt);
    }

    public int[] getIntArray(String varName, int[] pt) throws Throwable {
        return this.getIntArray(varName, pt, true);
    }

    public int[] getIntArray(String varName, int[] pt, boolean preserve) throws Throwable {
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        return var.asIntArray(preserve, pt);
    }

    public long[] getLongArray(String varName, int[] pt) throws Throwable {
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        return var.asLongArray(pt);
    }

    public short[] getShortArray(String varName, int[] pt) throws Throwable {
        return this.getShortArray(varName, pt, true);
    }

    public short[] getShortArray(String varName, int[] pt, boolean preserve) throws Throwable {
        Variable var = this.getVariable(varName);
        if (var == null) {
            throw new Throwable("No such variable: " + varName);
        }
        return var.asShortArray(preserve, pt);
    }

    public static TargetAttribute targetAttributeInstance(boolean p, boolean c) {
        return new TargetAttribute(p, c);
    }

    static class TargetAttribute {
        public final boolean preserve;
        public final boolean columnMajor;

        TargetAttribute(boolean p, boolean c) {
            this.preserve = p;
            this.columnMajor = c;
        }
    }

    public class DataLocator
    implements VariableDataLocator,
    Serializable {
        private transient ByteBuffer _buf;
        private int numberOfValues;
        private boolean compressed;
        protected Vector locations = new Vector();

        protected DataLocator(ByteBuffer b, int n, boolean compr) {
            this._buf = b;
            this.numberOfValues = n;
            this.compressed = compr;
            this._buf.position(CDFImpl.this.offset_FIRST_VXR);
            long offset = CDFImpl.this.longInt(this._buf);
            ByteBuffer bx = CDFImpl.this.getRecord(offset);
            Vector v = this._getLocations(bx);
            this.registerNodes(bx, v);
        }

        public boolean isReallyCompressed() {
            return this.compressed;
        }

        @Override
        public long[][] getLocations() {
            long[][] loc = new long[this.locations.size()][3];
            for (int i = 0; i < this.locations.size(); ++i) {
                long[] ia = (long[])this.locations.elementAt(i);
                loc[i][0] = ia[0];
                loc[i][1] = ia[1];
                loc[i][2] = ia[2];
            }
            return loc;
        }

        Vector _getLocations(ByteBuffer bx) {
            Vector<long[]> locations = new Vector<long[]>();
            while (true) {
                bx.position(CDFImpl.this.offset_NEXT_VXR);
                long next = CDFImpl.this.longInt(bx);
                bx.position(CDFImpl.this.offset_NENTRIES);
                int nentries = bx.getInt();
                bx.position(CDFImpl.this.offset_NUSED);
                int nused = bx.getInt();
                bx.position(CDFImpl.this.offset_FIRST);
                ByteBuffer bf = bx.slice();
                bx.position(CDFImpl.this.offset_FIRST + nentries * 4);
                ByteBuffer bl = bx.slice();
                bx.position(CDFImpl.this.offset_FIRST + 2 * nentries * 4);
                ByteBuffer bo = bx.slice();
                for (int entry = 0; entry < nused; ++entry) {
                    long first = bf.getInt();
                    long last = bl.getInt();
                    if (last > (long)(this.numberOfValues - 1)) {
                        last = this.numberOfValues - 1;
                    }
                    long off = CDFImpl.this.longInt(bo);
                    locations.add(new long[]{first, last, off});
                }
                if (next == 0L) break;
                bx = CDFImpl.this.getRecord(next);
            }
            return locations;
        }

        void registerNodes(ByteBuffer bx, Vector v) {
            int vrtype = 7;
            if (this.compressed) {
                vrtype = 13;
            }
            for (int i = 0; i < v.size(); ++i) {
                long[] loc = (long[])v.elementAt(i);
                ByteBuffer bb = CDFImpl.this.getRecord(loc[2]);
                if (bb.getInt(CDFImpl.this.offset_RECORD_TYPE) == 6) {
                    Vector vin = this._getLocations(bb);
                    this.registerNodes(bb, vin);
                    continue;
                }
                this.locations.add(loc);
            }
        }

        public Vector getLocationsAsVector() {
            Vector<long[]> _locations = new Vector<long[]>();
            long[][] loc = this.getLocations();
            for (int i = 0; i < this.locations.size(); ++i) {
                _locations.add(loc[i]);
            }
            return _locations;
        }
    }

    public class CDFVariable
    implements Serializable,
    Variable {
        int DIMENSION_VARIES = -1;
        public Vector attributes = new Vector();
        String name;
        public int number;
        public int rzNumber;
        String vtype;
        int flags;
        int sRecords;
        int type;
        int numberOfElements;
        protected int numberOfValues;
        public int[] dimensions;
        public boolean[] varies;
        public Object padValue;
        long offset;
        boolean completed = false;
        transient ByteBuffer _buf;
        int dataItemSize;
        long cprOffset;
        int blockingFactor;
        DataLocator locator;
        public int compressionType;
        boolean recordGap = false;

        public CDFVariable(long offset, String vtype) {
            int i;
            this.offset = offset;
            this.vtype = vtype;
            this._buf = CDFImpl.this.getRecord(offset);
            this.name = CDFImpl.this.getString(offset + (long)CDFImpl.this.offset_VAR_NAME);
            this._buf.position(CDFImpl.this.offset_VAR_NUM_ELEMENTS);
            this.numberOfElements = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_NUM);
            this.number = this._buf.getInt();
            this.rzNumber = this.number + (CDFImpl.this.withRZ == 0 ? 0 : (vtype == "r" ? 0 : CDFImpl.this.numberOfRVariables));
            this._buf.position(CDFImpl.this.offset_FLAGS);
            this.flags = this._buf.getInt();
            boolean compressed = (this.flags & 4) != 0;
            this._buf.position(CDFImpl.this.offset_sRecords);
            this.sRecords = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_CPR_offset);
            this.cprOffset = CDFImpl.this.longInt(this._buf);
            this._buf.position(CDFImpl.this.offset_BLOCKING_FACTOR);
            this.blockingFactor = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_VAR_DATATYPE);
            this.type = this._buf.getInt();
            this.numberOfValues = this._buf.getInt() + 1;
            this._buf.position(CDFImpl.this.offset_zNumDims);
            if (vtype.equals("r")) {
                this.dimensions = CDFImpl.this.rDimSizes;
            }
            if (vtype.equals("z")) {
                this.dimensions = new int[this._buf.getInt()];
                for (i = 0; i < this.dimensions.length; ++i) {
                    this.dimensions[i] = this._buf.getInt();
                }
            }
            this.varies = new boolean[this.dimensions.length];
            for (i = 0; i < this.dimensions.length; ++i) {
                this.varies[i] = this._buf.getInt() == this.DIMENSION_VARIES;
            }
            if (this.type == 32) {
                this.dimensions = new int[]{2};
            }
            if (this.type == 32) {
                this.varies = new boolean[]{true};
            }
            this.dataItemSize = DataTypes.size[this.type];
            this.padValue = null;
            int padValueSize = this.getDataItemSize() / this.dataItemSize;
            Object _padValue = DataTypes.defaultPad(this.type);
            if (DataTypes.isStringType(this.type)) {
                int i2;
                byte[] ba = new byte[this.numberOfElements];
                if (this.padValueSpecified()) {
                    this._buf.get(ba);
                    for (i2 = 0; i2 < this.numberOfElements; ++i2) {
                        if (ba[i2] > 0) continue;
                        ba[i2] = 32;
                    }
                } else {
                    for (i2 = 0; i2 < this.numberOfElements; ++i2) {
                        ba[i2] = (Byte)_padValue;
                    }
                }
                _padValue = new String(ba);
                String[] sa = new String[padValueSize];
                for (int i3 = 0; i3 < padValueSize; ++i3) {
                    sa[i3] = (String)_padValue;
                }
                this.padValue = sa;
            } else {
                if (this.padValueSpecified()) {
                    _padValue = CDFImpl.getNumberAttribute(this.type, 1, this._buf, CDFImpl.this.byteOrder);
                }
                if (DataTypes.isLongType(this.type)) {
                    long[] lpad = new long[padValueSize];
                    lpad[0] = this.padValueSpecified() ? ((long[])_padValue)[0] : (Long)_padValue;
                    for (int i4 = 1; i4 < padValueSize; ++i4) {
                        lpad[i4] = lpad[0];
                    }
                    this.padValue = lpad;
                } else {
                    double[] dpad = new double[padValueSize];
                    dpad[0] = this.padValueSpecified() ? ((double[])_padValue)[0] : (Double)_padValue;
                    for (int i5 = 1; i5 < padValueSize; ++i5) {
                        dpad[i5] = dpad[0];
                    }
                    this.padValue = dpad;
                }
            }
            if (DataTypes.isStringType(this.type)) {
                this.dataItemSize *= this.numberOfElements;
            }
            if (compressed) {
                ByteBuffer _cpr = CDFImpl.this.getRecord(this.cprOffset);
                _cpr.position(CDFImpl.this.offset_cType);
                this.compressionType = _cpr.getInt();
            } else {
                this.compressionType = 0;
            }
        }

        synchronized void complete() {
            if (this.completed) {
                return;
            }
            if (this.numberOfValues > 0) {
                this.locator = new DataLocator(this._buf, this.numberOfValues, (this.flags & 4) != 0);
                this.checkContinuity();
            }
            this.completed = true;
        }

        boolean isComplete() {
            return this.completed;
        }

        void checkContinuity() {
            if (this.numberOfValues == 0) {
                return;
            }
            long[][] locations = this.locator.getLocations();
            long last = locations[0][0] - 1L;
            for (long[] location : locations) {
                if (location[0] != last + 1L) {
                    this.recordGap = true;
                    break;
                }
                last = location[1];
            }
            if (this.recordGap && this.sRecords == 0) {
                System.out.println("Variable " + this.name + " is missing records. This is not consistent with sRecords = 0");
            }
        }

        @Override
        public boolean isTypeR() {
            return this.vtype.equals("r");
        }

        @Override
        public boolean missingRecordValueIsPrevious() {
            return this.sRecords == 2;
        }

        @Override
        public boolean missingRecordValueIsPad() {
            return this.sRecords == 1;
        }

        @Override
        public boolean isMissingRecords() {
            if (!this.completed) {
                this.complete();
            }
            return this.recordGap;
        }

        @Override
        public VariableDataLocator getLocator() {
            if (!this.completed) {
                this.complete();
            }
            return this.locator;
        }

        @Override
        public VariableDataBuffer[] getDataBuffers(boolean raw) throws Throwable {
            if (!this.completed) {
                this.complete();
            }
            if (!raw && (this.flags & 4) != 0) {
                throw new Throwable("Function not supported for compressed variables ");
            }
            long[][] locations = this.locator.getLocations();
            Vector<VariableDataBuffer> dbufs = new Vector<VariableDataBuffer>();
            int size = this.getDataItemSize();
            for (long[] location : locations) {
                int first = (int)location[0];
                int last = (int)location[1];
                ByteBuffer bv = CDFImpl.this.getRecord(location[2]);
                int clen = (last - first + 1) * size;
                boolean compressed = false;
                if (!this.isCompressed()) {
                    bv.position(CDFImpl.this.offset_RECORDS);
                } else if (bv.getInt(CDFImpl.this.offset_RECORD_TYPE) == 7) {
                    bv.position(CDFImpl.this.offset_RECORDS);
                } else {
                    compressed = true;
                    bv.position(CDFImpl.this.offset_CDATA);
                    clen = CDFImpl.this.lowOrderInt(bv, CDFImpl.this.offset_CSIZE);
                }
                ByteBuffer bbuf = bv.slice();
                bbuf.order(CDFImpl.this.getByteOrder());
                bbuf.limit(clen);
                dbufs.add(new VariableDataBuffer(first, last, bbuf, compressed));
            }
            VariableDataBuffer[] vdbuf = new VariableDataBuffer[dbufs.size()];
            dbufs.toArray(vdbuf);
            return vdbuf;
        }

        @Override
        public VariableDataBuffer[] getDataBuffers() throws Throwable {
            return this.getDataBuffers(false);
        }

        @Override
        public boolean rowMajority() {
            return CDFImpl.this.rowMajority();
        }

        @Override
        public boolean recordVariance() {
            return (this.flags & 1) != 0;
        }

        public boolean padValueSpecified() {
            return (this.flags & 2) != 0;
        }

        @Override
        public boolean isCompressed() {
            if (!this.completed) {
                this.complete();
            }
            if (this.locator == null) {
                return false;
            }
            return this.locator.isReallyCompressed();
        }

        @Override
        public Object getPadValue() {
            if (this.padValue == null) {
                return null;
            }
            if (DataTypes.isStringType(this.type)) {
                return this.padValue;
            }
            return this.getPadValue(false);
        }

        @Override
        public Object getPadValue(boolean preservePrecision) {
            if (this.padValue == null) {
                return null;
            }
            if (DataTypes.isStringType(this.type)) {
                return this.padValue;
            }
            if (this.padValue.getClass().getComponentType() == Long.TYPE) {
                long[] ltemp = (long[])this.padValue;
                if (preservePrecision) {
                    long[] la = new long[ltemp.length];
                    System.arraycopy(ltemp, 0, la, 0, ltemp.length);
                    return la;
                }
                double[] dtemp = new double[ltemp.length];
                for (int i = 0; i < ltemp.length; ++i) {
                    dtemp[i] = ltemp[i];
                }
                return dtemp;
            }
            double[] dtemp = (double[])this.padValue;
            double[] da = new double[dtemp.length];
            System.arraycopy(dtemp, 0, da, 0, dtemp.length);
            return da;
        }

        @Override
        public CDFImpl getCDF() {
            return CDFImpl.this;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public int getBlockingFactor() {
            return this.blockingFactor;
        }

        @Override
        public int getCompressionType() {
            return this.compressionType;
        }

        @Override
        public int getEffectiveRank() {
            int rank = 0;
            for (int i = 0; i < this.dimensions.length; ++i) {
                if (!this.varies[i] || this.dimensions[i] == 1) continue;
                ++rank;
            }
            return rank;
        }

        @Override
        public int[] getEffectiveDimensions() {
            int rank = this.getEffectiveRank();
            if (rank == 0) {
                return new int[0];
            }
            int[] edim = new int[rank];
            int n = 0;
            for (int i = 0; i < this.dimensions.length; ++i) {
                if (!this.varies[i] || this.dimensions[i] == 1) continue;
                edim[n++] = this.dimensions[i];
            }
            return edim;
        }

        @Override
        public int getDataItemSize() {
            int size = this.dataItemSize;
            for (int i = 0; i < this.dimensions.length; ++i) {
                if (!this.varies[i]) continue;
                size *= this.dimensions[i];
            }
            return size;
        }

        @Override
        public int getNumberOfElements() {
            return this.numberOfElements;
        }

        @Override
        public int getNumberOfValues() {
            return this.numberOfValues;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public int[] getDimensions() {
            int[] ia = new int[this.dimensions.length];
            System.arraycopy(this.dimensions, 0, ia, 0, this.dimensions.length);
            return ia;
        }

        @Override
        public int[] getRecordRange() {
            if (!this.completed) {
                this.complete();
            }
            if (this.locator == null) {
                return null;
            }
            long[][] locations = this.locator.getLocations();
            return new int[]{(int)locations[0][0], (int)locations[locations.length - 1][1]};
        }

        @Override
        public boolean[] getVarys() {
            boolean[] ba = new boolean[this.varies.length];
            System.arraycopy(this.varies, 0, ba, 0, this.varies.length);
            return ba;
        }

        public ByteBuffer getBuffer() throws Throwable {
            return this.getBuffer(Double.TYPE, null, false, ByteOrder.nativeOrder());
        }

        public ByteBuffer getBuffer(int[] recordRange) throws Throwable {
            return this.getBuffer(Double.TYPE, recordRange, false, ByteOrder.nativeOrder());
        }

        @Override
        public ByteBuffer getBuffer(Class cl, int[] recordRange, boolean preserve, ByteOrder bo) throws Throwable {
            if (!this.completed) {
                this.complete();
            }
            if (cl == Byte.TYPE) {
                ByteVarContainer container = new ByteVarContainer(CDFImpl.this, this, recordRange);
                container.run();
                return container.getBuffer();
            }
            if (cl == Double.TYPE && DoubleVarContainer.isCompatible(this.type, preserve)) {
                DoubleVarContainer container = new DoubleVarContainer(CDFImpl.this, this, recordRange, preserve, bo);
                container.run();
                return container.getBuffer();
            }
            if (cl == Float.TYPE && FloatVarContainer.isCompatible(this.type, preserve)) {
                FloatVarContainer container = new FloatVarContainer(CDFImpl.this, this, recordRange, preserve, bo);
                container.run();
                return container.getBuffer();
            }
            if (cl == Integer.TYPE && IntVarContainer.isCompatible(this.type, preserve)) {
                IntVarContainer container = new IntVarContainer(CDFImpl.this, this, recordRange, preserve, bo);
                container.run();
                return container.getBuffer();
            }
            if (cl == Short.TYPE && ShortVarContainer.isCompatible(this.type, preserve)) {
                ShortVarContainer container = new ShortVarContainer(CDFImpl.this, this, recordRange, preserve, bo);
                container.run();
                return container.getBuffer();
            }
            if (cl == Long.TYPE && LongVarContainer.isCompatible(this.type, preserve)) {
                LongVarContainer container = new LongVarContainer(CDFImpl.this, this, recordRange, bo);
                container.run();
                return container.getBuffer();
            }
            throw new Throwable("Inconsistent constraints for this variable");
        }

        @Override
        public boolean isCompatible(Class cl) {
            return BaseVarContainer.isCompatible(this.getType(), true, cl);
        }

        @Override
        public boolean isCompatible(Class cl, boolean preserve) {
            return BaseVarContainer.isCompatible(this.getType(), preserve, cl);
        }

        @Override
        public VDataContainer.CByte getByteContainer(int[] pt) throws Throwable {
            if (ByteVarContainer.isCompatible(this.type, true)) {
                return new ByteVarContainer(CDFImpl.this, this, pt);
            }
            throw new Throwable("Variable " + this.getName() + " cannot return VDataContainer.CByte.");
        }

        @Override
        public byte[] asByteArray(int[] pt) throws Throwable {
            if (ByteVarContainer.isCompatible(this.type, true)) {
                ByteVarContainer container = new ByteVarContainer(CDFImpl.this, this, pt);
                container.run();
                return container.as1DArray();
            }
            throw new Throwable("Variable " + this.getName() + " cannot return byte[].");
        }

        @Override
        public byte[] asByteArray() throws Throwable {
            return this.asByteArray(null);
        }

        public byte[] asByteArray(int[] pt, boolean columnMajor) throws Throwable {
            if (ByteVarContainer.isCompatible(this.type, true)) {
                ByteVarContainer container = new ByteVarContainer(CDFImpl.this, this, pt);
                container.run();
                return container.asOneDArray(columnMajor);
            }
            throw new Throwable("Variable " + this.getName() + " cannot return byte[].");
        }

        @Override
        public VDataContainer.CString getStringContainer(int[] pt) throws Throwable {
            if (StringVarContainer.isCompatible(this.type, true)) {
                return new StringVarContainer(CDFImpl.this, this, pt);
            }
            throw new Throwable("Variable " + this.getName() + " cannot return VDataContainer.CString.");
        }

        @Override
        public VDataContainer.CFloat getFloatContainer(int[] pt, boolean preserve, ByteOrder bo) throws Throwable {
            if (FloatVarContainer.isCompatible(this.type, preserve)) {
                return new FloatVarContainer(CDFImpl.this, this, pt, preserve, ByteOrder.nativeOrder());
            }
            throw new Throwable("Variable " + this.getName() + " cannot return VDataContainer.Float.");
        }

        @Override
        public VDataContainer.CFloat getFloatContainer(int[] pt, boolean preserve) throws Throwable {
            return this.getFloatContainer(pt, preserve, ByteOrder.nativeOrder());
        }

        @Override
        public float[] asFloatArray(boolean preserve, int[] pt) throws Throwable {
            VDataContainer.CFloat container;
            try {
                container = this.getFloatContainer(pt, preserve, ByteOrder.nativeOrder());
            }
            catch (Throwable th) {
                throw new Throwable("Variable " + this.getName() + " cannot return float[].");
            }
            container.run();
            return container.as1DArray();
        }

        @Override
        public float[] asFloatArray() throws Throwable {
            return this.asFloatArray(false, null);
        }

        @Override
        public float[] asFloatArray(int[] pt) throws Throwable {
            return this.asFloatArray(false, pt);
        }

        @Override
        public VDataContainer.CDouble getDoubleContainer(int[] pt, boolean preserve, ByteOrder bo) throws Throwable {
            if (DoubleVarContainer.isCompatible(this.type, preserve)) {
                return new DoubleVarContainer(CDFImpl.this, this, pt, preserve, ByteOrder.nativeOrder());
            }
            throw new Throwable("Variable " + this.getName() + " cannot return VDataContainer.CDouble.");
        }

        @Override
        public VDataContainer.CDouble getDoubleContainer(int[] pt, boolean preserve) throws Throwable {
            return this.getDoubleContainer(pt, preserve, ByteOrder.nativeOrder());
        }

        @Override
        public double[] asDoubleArray(boolean preserve, int[] pt) throws Throwable {
            TargetAttribute ta = new TargetAttribute(preserve, false);
            return this.asDoubleArray(ta, pt);
        }

        public double[] asDoubleArray(TargetAttribute tattr, int[] pt) throws Throwable {
            VDataContainer.CDouble container;
            try {
                container = this.getDoubleContainer(pt, tattr.preserve, ByteOrder.nativeOrder());
            }
            catch (Throwable th) {
                throw new Throwable("Variable " + this.getName() + " cannot return double[].");
            }
            container.run();
            return container.asOneDArray(tattr.columnMajor);
        }

        @Override
        public double[] asDoubleArray() throws Throwable {
            return this.asDoubleArray(false, null);
        }

        @Override
        public double[] asDoubleArray(int[] pt) throws Throwable {
            return this.asDoubleArray(false, pt);
        }

        @Override
        public VDataContainer.CLong getLongContainer(int[] pt, ByteOrder bo) throws Throwable {
            if (LongVarContainer.isCompatible(this.type, true)) {
                return new LongVarContainer(CDFImpl.this, this, pt, ByteOrder.nativeOrder());
            }
            throw new Throwable("Variable " + this.getName() + " cannot return VDataContainer.CLong.");
        }

        @Override
        public VDataContainer.CLong getLongContainer(int[] pt) throws Throwable {
            return this.getLongContainer(pt, ByteOrder.nativeOrder());
        }

        long[] asLongArray(boolean preserve, int[] pt) throws Throwable {
            VDataContainer.CLong container;
            try {
                container = this.getLongContainer(pt, ByteOrder.nativeOrder());
            }
            catch (Throwable th) {
                throw new Throwable("Variable " + this.getName() + " cannot return long[].");
            }
            container.run();
            return container.as1DArray();
        }

        @Override
        public long[] asLongArray() throws Throwable {
            return this.asLongArray(false, null);
        }

        @Override
        public long[] asLongArray(int[] pt) throws Throwable {
            return this.asLongArray(false, pt);
        }

        @Override
        public VDataContainer.CInt getIntContainer(int[] pt, boolean preserve, ByteOrder bo) throws Throwable {
            if (IntVarContainer.isCompatible(this.type, preserve)) {
                return new IntVarContainer(CDFImpl.this, this, pt, preserve, ByteOrder.nativeOrder());
            }
            throw new Throwable("Variable " + this.getName() + " cannot return VDataContainer.CInt.");
        }

        @Override
        public VDataContainer.CInt getIntContainer(int[] pt, boolean preserve) throws Throwable {
            return this.getIntContainer(pt, preserve, ByteOrder.nativeOrder());
        }

        @Override
        public int[] asIntArray(boolean preserve, int[] pt) throws Throwable {
            VDataContainer.CInt container;
            try {
                container = this.getIntContainer(pt, preserve, ByteOrder.nativeOrder());
            }
            catch (Throwable th) {
                throw new Throwable("Variable " + this.getName() + " cannot return int[].");
            }
            container.run();
            return container.as1DArray();
        }

        @Override
        public int[] asIntArray() throws Throwable {
            return this.asIntArray(true, null);
        }

        @Override
        public int[] asIntArray(int[] pt) throws Throwable {
            return this.asIntArray(true, pt);
        }

        @Override
        public VDataContainer.CShort getShortContainer(int[] pt, boolean preserve, ByteOrder bo) throws Throwable {
            if (ShortVarContainer.isCompatible(this.type, preserve)) {
                return new ShortVarContainer(CDFImpl.this, this, pt, preserve, ByteOrder.nativeOrder());
            }
            throw new Throwable("Variable " + this.getName() + " cannot return VDataContainer.CShort.");
        }

        @Override
        public VDataContainer.CShort getShortContainer(int[] pt, boolean preserve) throws Throwable {
            return this.getShortContainer(pt, preserve, ByteOrder.nativeOrder());
        }

        @Override
        public short[] asShortArray(boolean preserve, int[] pt) throws Throwable {
            VDataContainer.CShort container;
            try {
                container = this.getShortContainer(pt, preserve, ByteOrder.nativeOrder());
            }
            catch (Throwable th) {
                throw new Throwable("Variable " + this.getName() + " cannot return short[].");
            }
            container.run();
            return container.as1DArray();
        }

        @Override
        public short[] asShortArray() throws Throwable {
            return this.asShortArray(true, null);
        }

        @Override
        public short[] asShortArray(int[] pt) throws Throwable {
            return this.asShortArray(true, pt);
        }

        @Override
        public Vector getElementCount() {
            int[] dimensions = this.getDimensions();
            Vector<Integer> ecount = new Vector<Integer>();
            for (int i = 0; i < dimensions.length; ++i) {
                if (!this.getVarys()[i]) continue;
                ecount.add(dimensions[i]);
            }
            return ecount;
        }
    }

    public class CDFAttributeEntry
    implements AttributeEntry,
    Serializable {
        transient ByteBuffer _buf;
        int variableNumber;
        int type;
        int nelement;
        String attribute;
        String stringValue;
        String[] stringValues = null;
        Object value;

        public CDFAttributeEntry(ByteBuffer buf, String name) {
            this.attribute = name;
            this._buf = buf.duplicate();
            this._buf.position(CDFImpl.this.offset_ENTRYNUM);
            this.variableNumber = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_ATTR_DATATYPE);
            this.type = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_ATTR_NUM_ELEMENTS);
            this.nelement = this._buf.getInt();
            this._buf.position(CDFImpl.this.offset_VALUE);
            if (this.type > 50) {
                int i;
                byte[] ba = new byte[this.nelement];
                for (i = 0; i < this.nelement; ++i) {
                    ba[i] = this._buf.get();
                    if (ba[i] == 0) break;
                }
                this.stringValue = new String(ba, 0, i);
                this._buf.position(CDFImpl.this.offset_ATTR_NUM_ELEMENTS + 4);
                int numStrings = this._buf.getInt();
                if (numStrings > 1) {
                    this.stringValues = new String[numStrings];
                    int lastIndex = 0;
                    int begin = 0;
                    int count = 0;
                    while ((lastIndex = this.stringValue.indexOf(STRINGDELIMITER, begin)) != -1) {
                        this.stringValues[count] = this.stringValue.substring(begin, lastIndex);
                        begin += this.stringValues[count].length() + STRINGDELIMITER.length();
                        ++count;
                    }
                    this.stringValues[count] = this.stringValue.substring(begin);
                } else {
                    this.stringValues = null;
                }
            } else {
                this.value = CDFImpl.getNumberAttribute(this.type, this.nelement, this._buf, CDFImpl.this.byteOrder);
            }
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public int getNumberOfElements() {
            return this.nelement;
        }

        @Override
        public boolean isLongType() {
            return DataTypes.typeCategory[this.type] == 5;
        }

        @Override
        public boolean isStringType() {
            return DataTypes.isStringType(this.type);
        }

        @Override
        public Object getValue() {
            return this.isStringType() ? (this.stringValues != null ? this.stringValues : this.stringValue) : this.value;
        }

        @Override
        public String getAttributeName() {
            return this.attribute;
        }

        @Override
        public int getVariableNumber() {
            return this.variableNumber;
        }

        @Override
        public boolean isSameAs(AttributeEntry ae) {
            if (this.getType() != ae.getType()) {
                return false;
            }
            if (this.getNumberOfElements() != ae.getNumberOfElements()) {
                return false;
            }
            if (this.isStringType() != ae.isStringType()) {
                return false;
            }
            if (this.isStringType()) {
                if (this.stringValues != null) {
                    Object newValue = ae.getValue();
                    if (!newValue.getClass().isArray()) {
                        return false;
                    }
                    Object[] oldStrings = this.stringValues;
                    Object[] newStrings = (String[])newValue;
                    return Arrays.equals(oldStrings, newStrings);
                }
                return this.stringValue.equals(ae.getValue());
            }
            if (this.isLongType() != ae.isLongType()) {
                return false;
            }
            if (this.isLongType()) {
                return Arrays.equals((long[])this.value, (long[])ae.getValue());
            }
            return Arrays.equals((double[])this.value, (double[])ae.getValue());
        }
    }

    class CDFAttribute
    implements Serializable,
    Attribute {
        String name;
        int scope;
        int num;
        Vector zEntries = new Vector();
        Vector gEntries = new Vector();

        public CDFAttribute(long offset) {
            this.name = CDFImpl.this.getString(offset + (long)CDFImpl.this.offset_ATTR_NAME);
            LOGGER.log(Level.FINER, "new attribute {0} at {1}", new Object[]{this.name, offset});
            ByteBuffer _buf = CDFImpl.this.getRecord(offset);
            _buf.position(CDFImpl.this.offset_SCOPE);
            this.scope = _buf.getInt();
            this.num = _buf.getInt();
            _buf.position(CDFImpl.this.offset_AgrEDRHead);
            long n = CDFImpl.this.longInt(_buf);
            if (n > 0L) {
                this.gEntries = this.getAttributeEntries(n);
                LOGGER.log(Level.FINEST, "link attr {0} to {1} gEntries", new Object[]{this.name, this.gEntries.size()});
                if (this.scope == 2 || this.scope == 4) {
                    this.linkToVariables(this.gEntries, "r");
                }
            }
            _buf.position(CDFImpl.this.offset_AzEDRHead);
            n = CDFImpl.this.longInt(_buf);
            if (n > 0L) {
                this.zEntries = this.getAttributeEntries(n);
                LOGGER.log(Level.FINEST, "link attr {0} to {1} zEntries", new Object[]{this.name, this.zEntries.size()});
                this.linkToVariables(this.zEntries, "z");
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Vector getAttributeEntries(long offset) {
            if (offset == 0L) {
                return null;
            }
            Vector<CDFAttributeEntry> list = new Vector<CDFAttributeEntry>();
            ByteBuffer _buf = CDFImpl.this.getRecord(offset);
            while (true) {
                _buf.position(CDFImpl.this.offset_NEXT_AEDR);
                long next = CDFImpl.this.longInt(_buf);
                _buf.position(0);
                CDFAttributeEntry ae = new CDFAttributeEntry(_buf, this.name);
                list.add(ae);
                if (next == 0L) break;
                _buf = CDFImpl.this.getRecord(next);
            }
            return list;
        }

        public void linkToVariables(Vector entries, String type) {
            for (int e = 0; e < entries.size(); ++e) {
                AttributeEntry ae = (AttributeEntry)entries.elementAt(e);
                CDFVariable var = (CDFVariable)CDFImpl.this.getCDFVariable(type, ae.getVariableNumber());
                if (var == null) {
                    System.out.println("An attribute entry for " + ae.getAttributeName() + " of type " + type + " links to variable number " + ae.getVariableNumber() + ".");
                    System.out.println("Variable whose number is " + ae.getVariableNumber() + " was not found.");
                    continue;
                }
                var.attributes.add(ae);
            }
        }

        @Override
        public boolean isGlobal() {
            return this.scope != 2 && this.scope != 4;
        }
    }
}

