/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AArray;
import gov.nasa.gsfc.spdf.cdfj.ADR;
import gov.nasa.gsfc.spdf.cdfj.AEDR;
import gov.nasa.gsfc.spdf.cdfj.ArrayAttribute;
import gov.nasa.gsfc.spdf.cdfj.CDFDataType;
import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFTimeType;
import gov.nasa.gsfc.spdf.cdfj.CDR;
import gov.nasa.gsfc.spdf.cdfj.DataContainer;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.GDR;
import gov.nasa.gsfc.spdf.cdfj.GlobalAttributeEntry;
import gov.nasa.gsfc.spdf.cdfj.SparseRecordOption;
import gov.nasa.gsfc.spdf.cdfj.VDR;
import gov.nasa.gsfc.spdf.cdfj.VariableAttributeEntry;
import gov.nasa.gsfc.spdf.cdfj.VariableDataBuffer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.Vector;

public class GenericWriter {
    LinkedHashMap<String, ADR> attributes = new LinkedHashMap();
    LinkedHashMap<String, Vector<AEDR>> attributeEntries = new LinkedHashMap();
    LinkedHashMap<String, VDR> variableDescriptors = new LinkedHashMap();
    int lastLeapSecondId = -1;
    CDR cdr = new CDR();
    GDR gdr = new GDR();
    public final boolean rowMajority;
    LinkedHashMap<String, DataContainer> dataContainers = new LinkedHashMap();
    boolean needDigest = false;

    public GenericWriter() {
        this(true);
    }

    public GenericWriter(boolean rowMajority) {
        this.rowMajority = rowMajority;
    }

    ADR getAttribute(String name, boolean global) {
        return this.getAttribute(name, global, true);
    }

    ADR getAttribute(String name, boolean global, boolean create) {
        ADR adr = this.attributes.get(name);
        if (adr != null) {
            return this.attributes.get(name);
        }
        if (!create) {
            return null;
        }
        adr = new ADR();
        adr.setScope(global ? 1 : 2);
        adr.name = name;
        int anumber = this.attributes.size();
        adr.setNum(anumber);
        this.attributes.put(name, adr);
        return adr;
    }

    public void addGlobalAttributeEntry(String name, Object value) throws CDFException.WriterError {
        this.addGlobalAttributeEntry(name, null, value);
    }

    public void addGlobalAttributeEntry(String name, CDFDataType dataType, Object value) throws CDFException.WriterError {
        GlobalAttributeEntry gae;
        ADR adr = this.getAttribute(name, true);
        Vector<AEDR> values = this.attributeEntries.get(name);
        if (values == null) {
            values = new Vector();
            this.attributeEntries.put(name, values);
        }
        int type = dataType == null ? -1 : dataType.getValue();
        try {
            gae = new GlobalAttributeEntry(adr, type, value);
        }
        catch (Throwable th) {
            throw new CDFException.WriterError(th.getMessage());
        }
        gae.setNum(adr.ngrEntries);
        adr.mAXgrEntry = adr.ngrEntries++;
        values.add(gae);
    }

    Vector<VariableAttributeEntry> findVariableAttributeEntries(String vname, String aname) throws CDFException.WriterError {
        VDR vdesc = this.variableDescriptors.get(vname);
        if (vdesc == null) {
            throw new CDFException.WriterError("Variable " + vname + " has not been defined.");
        }
        Vector<VariableAttributeEntry> result = new Vector<VariableAttributeEntry>();
        Vector<AEDR> entries = this.attributeEntries.get(aname);
        if (entries == null) {
            return result;
        }
        for (int i = 0; i < entries.size(); ++i) {
            VariableAttributeEntry vae;
            try {
                vae = (VariableAttributeEntry)entries.get(i);
            }
            catch (Exception ex) {
                continue;
            }
            if (vae.getNum() != vdesc.getNum()) continue;
            result.add(vae);
        }
        return result;
    }

    public void setVariableAttributeEntry(String vname, String aname, Object value) throws CDFException.WriterError {
        this.setVariableAttributeEntry(vname, aname, null, value);
    }

    public void setVariableAttributeEntry(String vname, String aname, CDFDataType dataType, Object value) throws CDFException.WriterError {
        Vector<VariableAttributeEntry> entries = this.findVariableAttributeEntries(vname, aname);
        if (entries.size() > 0) {
            if (!value.getClass().isArray() && value.getClass() != String.class) {
                throw new CDFException.WriterError("Value should be numeric array or a String.");
            }
            for (int i = 0; i < entries.size(); ++i) {
                this.attributeEntries.get(aname).remove(entries.get(i));
            }
            ADR adr = this.getAttribute(aname, false);
            --adr.nzEntries;
        }
        this.addVariableAttributeEntry(vname, aname, dataType, value);
    }

    public void addVariableAttributeEntry(String vname, String aname, Object value) throws CDFException.WriterError {
        this.addVariableAttributeEntry(vname, aname, null, value);
    }

    public void addVariableAttributeEntry(String vname, String aname, CDFDataType dataType, Object value) throws CDFException.WriterError {
        VariableAttributeEntry vae;
        int _type;
        VDR vdesc = this.variableDescriptors.get(vname);
        if (vdesc == null) {
            throw new CDFException.WriterError("Variable " + vname + " has not been defined.");
        }
        Vector<VariableAttributeEntry> currentEntries = this.findVariableAttributeEntries(vname, aname);
        if (currentEntries.size() == 0) {
            if (!this.attributeEntries.containsKey(aname)) {
                this.attributeEntries.put(aname, new Vector());
            }
        } else if (value.getClass() != String.class && DataTypes.isStringType(_type = currentEntries.get((int)(currentEntries.size() - 1)).dataType)) {
            throw new CDFException.WriterError("Only String values can be added");
        }
        ADR adr = this.getAttribute(aname, false);
        int type = dataType == null ? -1 : dataType.getValue();
        try {
            vae = new VariableAttributeEntry(adr, type, value);
        }
        catch (Throwable th) {
            throw new CDFException.WriterError(th.getMessage());
        }
        vae.setNum(vdesc.getNum());
        this.attributeEntries.get(aname).add(vae);
        if (vdesc.getNum() > adr.mAXzEntry) {
            adr.mAXzEntry = vdesc.getNum();
        }
        ++adr.nzEntries;
    }

    public boolean hasTimeVariable(String name) throws CDFException.WriterError {
        VDR vdr = this.variableDescriptors.get(name);
        if (vdr == null) {
            throw new CDFException.WriterError("Variable " + name + " has not been defined yet.");
        }
        return this.findVariableAttributeEntries(name, "DEPEND_0").size() == 0;
    }

    public void defineTimeVariable(String name, CDFTimeType timeType) throws CDFException.WriterError {
        this.defineVariable(name, CDFDataType.getType(timeType), new int[0]);
    }

    public void defineTimeSeries(String name, CDFDataType dataType, int[] dim) throws CDFException.WriterError {
        this.defineTimeSeries(name, dataType, dim, "Epoch");
    }

    public void defineTimeSeries(String name, CDFDataType dataType, int[] dim, String tname) throws CDFException.WriterError {
        this.defineVariable(name, dataType, dim);
        VDR vdr = this.variableDescriptors.get(name);
        VDR tvdr = this.variableDescriptors.get(tname);
        if (tvdr == null) {
            throw new CDFException.WriterError("TimeVariable " + tname + " does not exist.");
        }
        this.addVariableAttributeEntry(name, "DEPEND_0", tname);
    }

    public void defineCompressedTimeSeries(String name, CDFDataType dataType, int[] dim, String tname, CDFTimeType timeType) throws CDFException.WriterError {
        this.defineTimeSeries(name, dataType, dim, tname, timeType, true);
    }

    public void defineTimeSeries(String name, CDFDataType dataType, int[] dim, String tname, CDFTimeType timeType, boolean compressed) throws CDFException.WriterError {
        if (!compressed) {
            this.defineVariable(name, dataType, dim);
        }
        if (compressed) {
            this.defineCompressedVariable(name, dataType, dim);
        }
        VDR vdr = this.variableDescriptors.get(name);
        VDR tvdr = this.variableDescriptors.get(tname);
        if (tvdr != null) {
            throw new CDFException.WriterError("TimeVariable " + tname + " already exists.");
        }
        this.defineTimeVariable(tname, timeType);
        this.addVariableAttributeEntry(name, "DEPEND_0", tname);
    }

    public void defineVariable(String name, CDFDataType dataType, int[] dim) throws CDFException.WriterError {
        boolean[] varys = new boolean[dim.length];
        for (int i = 0; i < varys.length; ++i) {
            varys[i] = true;
        }
        this.defineVariable(name, dataType, dim, 1);
    }

    public void defineStringVariable(String name, int[] dim, int size) throws CDFException.WriterError {
        this.defineVariable(name, CDFDataType.CHAR, dim, size);
    }

    public void defineVariable(String name, CDFDataType dataType, int[] dim, int size) throws CDFException.WriterError {
        if (dataType != CDFDataType.CHAR && size > 1) {
            throw new CDFException.WriterError("incompatible size for type " + dataType);
        }
        boolean[] varys = new boolean[dim.length];
        for (int i = 0; i < varys.length; ++i) {
            varys[i] = true;
        }
        this.defineVariable(name, dataType, dim, varys, true, false, null, size);
    }

    public void defineCompressedVariable(String name, CDFDataType dataType, int[] dim) throws CDFException.WriterError {
        boolean[] varys = new boolean[dim.length];
        for (int i = 0; i < varys.length; ++i) {
            varys[i] = true;
        }
        this.defineCompressedVariable(name, dataType, dim, 1);
    }

    public void defineCompressedStringVariable(String name, int[] dim, int size) throws CDFException.WriterError {
        this.defineCompressedVariable(name, CDFDataType.CHAR, dim, size);
    }

    public void defineCompressedVariable(String name, CDFDataType dataType, int[] dim, int size) throws CDFException.WriterError {
        boolean[] varys = new boolean[dim.length];
        for (int i = 0; i < varys.length; ++i) {
            varys[i] = true;
        }
        this.defineVariable(name, dataType, dim, varys, true, true, null, size);
    }

    public void addNRVString(String name, String value) throws CDFException.WriterError {
        this.addNRVVariable(name, CDFDataType.CHAR, new int[0], value.length(), value);
    }

    public void addNRVVariable(String name, CDFDataType dataType, Object value) throws CDFException.WriterError {
        this.addNRVVariable(name, dataType, new int[0], 1, value);
    }

    public void addNRVVariable(String name, CDFDataType dataType, int[] dim, Object value) throws CDFException.WriterError {
        if (dataType == CDFDataType.CHAR) {
            throw new CDFException.WriterError("Invalid method for string type. Use addNRVVariable(name, dataType, dim, size, value)");
        }
        this.addNRVVariable(name, dataType, dim, 1, value);
    }

    public void addNRVVariable(String name, CDFDataType dataType, int[] dim, int size, Object value) throws CDFException.WriterError {
        if (dataType != CDFDataType.CHAR && size > 1) {
            throw new CDFException.WriterError("incompatible size for type " + dataType);
        }
        boolean[] varys = new boolean[dim.length];
        for (int i = 0; i < varys.length; ++i) {
            varys[i] = true;
        }
        this.defineVariable(name, dataType, dim, varys, false, false, null, size);
        if (dim.length > 0 || dataType == CDFDataType.EPOCH16) {
            try {
                this.addData(name, AArray.getPoint(value));
            }
            catch (Throwable th) {
                throw new CDFException.WriterError(th.getMessage());
            }
        } else {
            this.dispatch(name, value);
        }
    }

    public void defineNRVVariable(String name, CDFDataType dataType, int[] dim, int size) throws CDFException.WriterError {
        boolean[] varys = new boolean[dim.length];
        for (int i = 0; i < varys.length; ++i) {
            varys[i] = true;
        }
        int _size = dataType == CDFDataType.CHAR ? size : 1;
        this.defineVariable(name, dataType, dim, varys, false, false, null, _size);
    }

    public void defineVariable(String name, CDFDataType dataType, int[] dim, boolean[] varys, boolean recordVariance, boolean compressed, Object pad) throws CDFException.WriterError {
        this.defineVariable(name, dataType, dim, varys, recordVariance, compressed, pad, 1, SparseRecordOption.NONE);
    }

    public void defineVariable(String name, CDFDataType dataType, int[] dim, boolean[] varys, boolean recordVariance, boolean compressed, Object pad, SparseRecordOption option) throws CDFException.WriterError {
        this.defineVariable(name, dataType, dim, varys, recordVariance, compressed, pad, 1, option);
    }

    public void defineStringVariable(String name, int[] dim, boolean[] varys, boolean recordVariance, boolean compressed, Object pad, int size) throws CDFException.WriterError {
        this.defineVariable(name, CDFDataType.CHAR, dim, varys, recordVariance, compressed, pad, size, SparseRecordOption.NONE);
    }

    public void defineStringVariable(String name, int[] dim, boolean[] varys, boolean recordVariance, boolean compressed, Object pad, int size, SparseRecordOption option) throws CDFException.WriterError {
        this.defineVariable(name, CDFDataType.CHAR, dim, varys, recordVariance, compressed, pad, size, option);
    }

    public void defineVariable(String name, CDFDataType dataType, int[] dim, boolean[] varys, boolean recordVariance, boolean compressed, Object pad, int size) throws CDFException.WriterError {
        this.defineVariable(name, dataType, dim, varys, recordVariance, compressed, pad, size, SparseRecordOption.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void defineVariable(String name, CDFDataType dataType, int[] dim, boolean[] varys, boolean recordVariance, boolean compressed, Object pad, int size, SparseRecordOption option) throws CDFException.WriterError {
        Object[] objectArray = dim;
        synchronized (dim) {
            int i;
            int[] _dim = new int[dim.length];
            for (i = 0; i < dim.length; ++i) {
                _dim[i] = dim[i];
            }
            // ** MonitorExit[var12_10 /* !! */ ] (shouldn't be in output)
            objectArray = varys;
            synchronized (varys) {
                boolean[] _varys = new boolean[varys.length];
                for (i = 0; i < varys.length; ++i) {
                    _varys[i] = varys[i];
                }
                // ** MonitorExit[var12_10 /* !! */ ] (shouldn't be in output)
                if (dataType == CDFDataType.EPOCH16 && dim.length > 0) {
                    throw new CDFException.WriterError("Only scalar variables of type EPOCH16 are supported.");
                }
                VDR vdr = this.variableDescriptors.get(name);
                if (vdr != null) {
                    throw new CDFException.WriterError("Variable " + name + " exists already.");
                }
                Object _pad = null;
                if (pad != null) {
                    Class<?> cl = pad.getClass();
                    if (!cl.isArray()) {
                        _pad = Array.newInstance(cl, 1);
                        Array.set(_pad, 0, pad);
                    } else {
                        _pad = pad;
                    }
                }
                try {
                    vdr = new VDR(name, dataType.getValue(), dim, varys, recordVariance, compressed, _pad, size, option);
                }
                catch (Throwable th) {
                    throw new CDFException.WriterError(th.getMessage());
                }
                vdr.setNum(this.variableDescriptors.size());
                this.variableDescriptors.put(name, vdr);
                DataContainer dc = new DataContainer(vdr, this.rowMajority);
                this.dataContainers.put(name, dc);
                return;
            }
        }
    }

    HashMap<String, VDR> getVariableDescriptors() {
        return this.variableDescriptors;
    }

    DataContainer getContainer(String name, Object data) throws CDFException.WriterError {
        ArrayAttribute aa = null;
        try {
            aa = new ArrayAttribute(data);
        }
        catch (Throwable th) {
            throw new CDFException.WriterError(th.getMessage());
        }
        if (aa.getDimensions().length != 1) {
            throw new CDFException.WriterError("data must be a 1 dimensional array. ");
        }
        DataContainer container = this.dataContainers.get(name);
        if (container == null) {
            throw new CDFException.WriterError("Variable " + name + " is not defined.");
        }
        return container;
    }

    public void addOneD(String name, Object data) throws CDFException.WriterError {
        DataContainer container = this.getContainer(name, data);
        try {
            container.addData(data, null, true, false);
        }
        catch (Throwable th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    public void addOneD(String name, Object data, boolean relax) throws CDFException.WriterError {
        DataContainer container = this.getContainer(name, data);
        try {
            container.addData(data, null, true, relax);
        }
        catch (Throwable th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    public void addOneD(String name, Object data, int[] recordRange) throws CDFException.WriterError {
        DataContainer container = this.getContainer(name, data);
        try {
            container.addData(data, recordRange, true, false);
        }
        catch (Throwable th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    public void addOneD(String name, Object data, int[] recordRange, boolean relax) throws CDFException.WriterError {
        DataContainer container = this.getContainer(name, data);
        try {
            container.addData(data, recordRange, true, relax);
        }
        catch (Throwable th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    public void addData(String name, Object data) throws CDFException.WriterError {
        DataContainer container = this.dataContainers.get(name);
        if (container == null) {
            throw new CDFException.WriterError("Variable " + name + " is not defined.");
        }
        try {
            container.addData(data, null, false, false);
        }
        catch (Throwable th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    public void addData(String name, Object data, boolean relax) throws CDFException.WriterError {
        DataContainer container = this.dataContainers.get(name);
        if (container == null) {
            throw new CDFException.WriterError("Variable " + name + " is not defined.");
        }
        try {
            container.addData(data, null, false, relax);
        }
        catch (Throwable th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    public void addData(String name, Object data, int[] recordRange) throws CDFException.WriterError {
        DataContainer container = this.dataContainers.get(name);
        if (container == null) {
            throw new CDFException.WriterError("Variable " + name + " is not defined.");
        }
        try {
            container.addData(data, recordRange, false, false);
        }
        catch (Throwable th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    public void addData(String name, Object data, int[] recordRange, boolean relax) throws CDFException.WriterError {
        DataContainer container = this.dataContainers.get(name);
        if (container == null) {
            throw new CDFException.WriterError("Variable " + name + " is not defined.");
        }
        try {
            container.addData(data, recordRange, false, relax);
        }
        catch (Throwable th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    void addBuffer(String name, VariableDataBuffer data) throws CDFException.WriterError {
        DataContainer container = this.dataContainers.get(name);
        if (container == null) {
            throw new CDFException.WriterError("Variable " + name + " is not defined.");
        }
        try {
            container.addData(data.getBuffer(), new int[]{data.getFirstRecord(), data.getLastRecord()}, false, false);
        }
        catch (Throwable th) {
            throw new CDFException.WriterError(th.getMessage());
        }
    }

    public void setMD5Needed(boolean need) {
        this.needDigest = need;
    }

    long getSize() {
        long size = this.cdr.getSize();
        size += (long)this.gdr.getSize();
        Set<String> atset = this.attributes.keySet();
        Iterator<String> ait = atset.iterator();
        while (ait.hasNext()) {
            ADR adr = this.attributes.get(ait.next());
            size += (long)adr.getSize();
        }
        Set<String> ateset = this.attributeEntries.keySet();
        Iterator<String> aeit = ateset.iterator();
        while (aeit.hasNext()) {
            Vector<AEDR> vec = this.attributeEntries.get(aeit.next());
            for (int i = 0; i < vec.size(); ++i) {
                size += (long)vec.get(i).getSize();
            }
        }
        Set<String> dcset = this.dataContainers.keySet();
        Iterator<String> dcit = dcset.iterator();
        boolean first = true;
        DataContainer lastContainer = null;
        while (dcit.hasNext()) {
            DataContainer dc = this.dataContainers.get(dcit.next());
            dc.position = size;
            if (first) {
                this.gdr.setZVDRHead(size);
                first = false;
            } else {
                lastContainer.getVDR().setVDRNext(dc.position);
            }
            lastContainer = dc;
            size += (long)dc.getSize();
        }
        return size;
    }

    public void write(String fname) throws IOException {
        Vector<AEDR> vec = this.attributeEntries.get("cdfj_source");
        if (vec != null && new String(vec.get((int)0).values).equals(fname)) {
            System.out.println("overwriting " + fname);
            this.write(fname, true);
            return;
        }
        this.write(fname, false);
    }

    public boolean write(String fname, boolean overwrite) throws IOException {
        AEDR ae;
        int i;
        Vector<AEDR> vec;
        String name;
        ADR adr;
        ByteBuffer obuf;
        if (this.lastLeapSecondId != -1) {
            this.gdr.setLastLeapSecondId(this.lastLeapSecondId);
        }
        long len = this.getSize();
        if (this.needDigest) {
            len += 32L;
        }
        RandomAccessFile raf = null;
        FileChannel channel = null;
        if (len > Integer.MAX_VALUE) {
            raf = new RandomAccessFile(new File(fname), "rw");
            channel = raf.getChannel();
            this.write(channel, len);
            raf.close();
            return true;
        }
        if (this.isWindows()) {
            obuf = ByteBuffer.allocate((int)len);
        } else if (overwrite) {
            obuf = ByteBuffer.allocateDirect((int)len);
        } else {
            raf = new RandomAccessFile(new File(fname), "rw");
            channel = raf.getChannel();
            obuf = channel.map(FileChannel.MapMode.READ_WRITE, 0L, len);
        }
        this.cdr.setRowMajority(this.rowMajority);
        this.cdr.setMD5Needed(this.needDigest);
        obuf.put(this.cdr.get());
        this.gdr.position = obuf.position();
        obuf.position((int)(this.gdr.position + (long)this.gdr.getSize()));
        Set<String> atset = this.attributes.keySet();
        Iterator<String> ait = atset.iterator();
        boolean first = true;
        ADR lastADR = null;
        while (ait.hasNext()) {
            adr = this.attributes.get(ait.next());
            name = adr.name;
            adr.position = obuf.position();
            obuf.position((int)(adr.position + (long)adr.getSize()));
            vec = this.attributeEntries.get(name);
            for (i = 0; i < vec.size(); ++i) {
                ae = vec.get(i);
                ae.position = obuf.position();
                if (i == 0) {
                    if (adr.scope == 1) {
                        adr.setAgrEDRHead(ae.position);
                    } else {
                        adr.setAzEDRHead(ae.position);
                    }
                } else {
                    vec.get(i - 1).setAEDRNext(ae.position);
                }
                obuf.position(obuf.position() + ae.getSize());
            }
            if (first) {
                this.gdr.setADRHead(adr.position);
                first = false;
            } else if (lastADR != null) {
                lastADR.setADRNext(adr.position);
            }
            lastADR = adr;
        }
        ait = atset.iterator();
        while (ait.hasNext()) {
            adr = this.attributes.get(ait.next());
            name = adr.name;
            obuf.position((int)adr.position);
            obuf.put(adr.get());
            vec = this.attributeEntries.get(name);
            for (i = 0; i < vec.size(); ++i) {
                ae = vec.get(i);
                obuf.position((int)ae.position);
                obuf.put(ae.get());
            }
        }
        Set<String> dcset = this.dataContainers.keySet();
        Iterator<String> dcit = dcset.iterator();
        ByteBuffer cbuf = obuf;
        while (dcit.hasNext()) {
            DataContainer dc = this.dataContainers.get(dcit.next());
            cbuf = dc.update(cbuf);
        }
        obuf.position((int)this.gdr.position);
        this.gdr.setEof(obuf.limit());
        this.gdr.setNumAttr(this.attributes.size());
        this.gdr.setNzVars(this.dataContainers.size());
        obuf.put(this.gdr.get());
        ByteBuffer digest = null;
        if (this.needDigest) {
            obuf.position(0);
            digest = this.getDigest(obuf);
        }
        if (digest != null) {
            cbuf.put(digest);
        }
        if (this.isWindows()) {
            this.writeWin(fname, obuf);
        } else {
            if (overwrite) {
                raf = new RandomAccessFile(new File(fname), "rw");
                channel = raf.getChannel();
                obuf.position(0);
                channel.write(obuf);
            }
            channel.force(true);
            raf.close();
        }
        return true;
    }

    ByteBuffer getDigest(ByteBuffer obuf) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsa) {
            nsa.printStackTrace();
            return null;
        }
        int pos = obuf.position();
        byte[] ba = new byte[0x100000];
        while (obuf.remaining() > 0) {
            int csize = obuf.remaining();
            if (csize > ba.length) {
                csize = ba.length;
            }
            obuf.get(ba, 0, csize);
            md.update(ba, 0, csize);
        }
        obuf.position(pos);
        return ByteBuffer.wrap(md.digest());
    }

    void dispatch(String name, Object value) throws CDFException.WriterError {
        Class<?> cl = value.getClass();
        if (cl == String.class) {
            this.addData(name, new String[]{(String)value});
            return;
        }
        Number num = (Number)value;
        if (cl == Byte.class) {
            this.addData(name, new byte[]{num.byteValue()});
            return;
        }
        if (cl == Short.class) {
            this.addData(name, new short[]{num.shortValue()});
            return;
        }
        if (cl == Integer.class) {
            this.addData(name, new int[]{num.intValue()});
            return;
        }
        if (cl == Double.class) {
            this.addData(name, new double[]{num.doubleValue()});
            return;
        }
        if (cl == Float.class) {
            this.addData(name, new float[]{num.floatValue()});
            return;
        }
        if (cl == Long.class) {
            this.addData(name, new long[]{num.longValue()});
            return;
        }
        throw new CDFException.WriterError("Unrecognized type " + cl);
    }

    public void setLastLeapSecondId(int n) {
        this.lastLeapSecondId = n;
    }

    void write(FileChannel channel, long len) throws IOException {
        AEDR ae;
        int i;
        Vector<AEDR> vec;
        String name;
        ADR adr;
        this.cdr.setRowMajority(this.rowMajority);
        this.cdr.setMD5Needed(this.needDigest);
        channel.write(this.cdr.get());
        this.gdr.position = channel.position();
        channel.position(this.gdr.position + (long)this.gdr.getSize());
        Set<String> atset = this.attributes.keySet();
        Iterator<String> ait = atset.iterator();
        boolean first = true;
        ADR lastADR = null;
        while (ait.hasNext()) {
            adr = this.attributes.get(ait.next());
            name = adr.name;
            adr.position = channel.position();
            channel.position(adr.position + (long)adr.getSize());
            vec = this.attributeEntries.get(name);
            for (i = 0; i < vec.size(); ++i) {
                ae = vec.get(i);
                ae.position = channel.position();
                if (i == 0) {
                    if (adr.scope == 1) {
                        adr.setAgrEDRHead(ae.position);
                    } else {
                        adr.setAzEDRHead(ae.position);
                    }
                } else {
                    vec.get(i - 1).setAEDRNext(ae.position);
                }
                channel.position(channel.position() + (long)ae.getSize());
            }
            if (first) {
                this.gdr.setADRHead(adr.position);
                first = false;
            } else if (lastADR != null) {
                lastADR.setADRNext(adr.position);
            }
            lastADR = adr;
        }
        ait = atset.iterator();
        while (ait.hasNext()) {
            adr = this.attributes.get(ait.next());
            name = adr.name;
            channel.position(adr.position);
            channel.write(adr.get());
            vec = this.attributeEntries.get(name);
            for (i = 0; i < vec.size(); ++i) {
                ae = vec.get(i);
                channel.position(ae.position);
                channel.write(ae.get());
            }
        }
        Set<String> dcset = this.dataContainers.keySet();
        Iterator<String> dcit = dcset.iterator();
        while (dcit.hasNext()) {
            DataContainer dc = this.dataContainers.get(dcit.next());
            dc.update(channel);
        }
        channel.position(this.gdr.position);
        this.gdr.setEof(channel.size());
        this.gdr.setNumAttr(this.attributes.size());
        this.gdr.setNzVars(this.dataContainers.size());
        channel.write(this.gdr.get());
        channel.position(channel.size());
        if (this.needDigest) {
            this.getDigest(channel);
        }
    }

    void getDigest(FileChannel channel) throws IOException {
        int trans;
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsa) {
            nsa.printStackTrace();
            return;
        }
        byte[] ba = new byte[0x100000];
        ByteBuffer buf = ByteBuffer.wrap(ba);
        channel.position(0L);
        for (long remaining = channel.size(); remaining > 0L; remaining -= (long)trans) {
            long csize = remaining;
            if (csize > (long)ba.length) {
                csize = ba.length;
            }
            buf.position(0);
            buf.limit((int)csize);
            trans = channel.read(buf);
            if (trans == -1) {
                throw new IOException("Unexpected end of data");
            }
            md.update(ba, 0, trans);
        }
        channel.write(ByteBuffer.wrap(md.digest()));
    }

    void writeWin(String fname, ByteBuffer buf) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(fname);){
            byte[] ba = buf.array();
            fos.write(ba);
        }
    }

    boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("win");
    }
}

