/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.AttributeEntry;
import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.CDFTimeType;
import gov.nasa.gsfc.spdf.cdfj.GlobalAttribute;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.nio.ByteOrder;
import java.util.Vector;

public abstract class MetaData {
    CDFImpl thisCDF;

    public final ByteOrder getByteOrder() {
        return this.thisCDF.getByteOrder();
    }

    public final boolean rowMajority() {
        return this.thisCDF.rowMajority();
    }

    public final String[] getVariableNames() {
        return this.thisCDF.getVariableNames();
    }

    public final String[] getVariableNames(String type) {
        return this.thisCDF.getVariableNames(type);
    }

    public final String[] globalAttributeNames() {
        return this.thisCDF.globalAttributeNames();
    }

    public final String[] variableAttributeNames(String name) {
        return this.thisCDF.variableAttributeNames(name);
    }

    public final Object getAttribute(String atr) {
        return this.thisCDF.getAttribute(atr);
    }

    public final int globalAttributeEntryCount(String atr) throws CDFException.ReaderError {
        return this.getGlobalAttribute(atr).getEntryCount();
    }

    public final Object getAttribute(String varName, String aname) throws CDFException.ReaderError {
        return this.thisCDF.getAttribute(varName, aname);
    }

    public final Vector<AttributeEntry> getAttributeEntries(String varName, String aname) throws CDFException.ReaderError {
        return this.thisCDF.getAttributeEntries(varName, aname);
    }

    public final Vector<AttributeEntry> getAttributeEntries(String aname) throws CDFException.ReaderError {
        try {
            return this.thisCDF.getAttributeEntries(aname);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public final GlobalAttribute getGlobalAttribute(String atr) throws CDFException.ReaderError {
        try {
            return this.thisCDF.getGlobalAttribute(atr);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public final boolean recordVariance(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        return this.thisCDF.getVariable(varName).recordVariance();
    }

    public final boolean isCompressed(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        return this.thisCDF.getVariable(varName).isCompressed();
    }

    public final int getType(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        return this.thisCDF.getVariable(varName).getType();
    }

    public final int getDataItemSize(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        return this.thisCDF.getVariable(varName).getDataItemSize();
    }

    public final int getNumber(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        return this.thisCDF.getVariable(varName).getNumber();
    }

    public final int getNumberOfElements(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        return this.thisCDF.getVariable(varName).getNumberOfElements();
    }

    public final int getNumberOfValues(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        return this.thisCDF.getVariable(varName).getNumberOfValues();
    }

    public final Object getPadValue(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        return this.thisCDF.getVariable(varName).getPadValue();
    }

    public final Object getPadValue(String varName, boolean preservePrecision) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        Variable var = this.thisCDF.getVariable(varName);
        return var.getPadValue(preservePrecision);
    }

    public final int[] getDimensions(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        return this.thisCDF.getVariable(varName).getDimensions();
    }

    public final boolean[] getVarys(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        return this.thisCDF.getVariable(varName).getVarys();
    }

    public final int getEffectiveRank(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        return this.thisCDF.getVariable(varName).getEffectiveRank();
    }

    public final boolean isMissingRecords(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        return this.thisCDF.getVariable(varName).isMissingRecords();
    }

    public final int[] getRecordRange(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        return this.thisCDF.getVariable(varName).getRecordRange();
    }

    public final boolean isCompatible(String varName, Class cl) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        try {
            return this.thisCDF.getVariable(varName).isCompatible(cl);
        }
        catch (Throwable th) {
            throw new CDFException.ReaderError(th.getMessage());
        }
    }

    public final boolean isCompatible(String varName, Class cl, boolean preserve) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        Variable var = this.thisCDF.getVariable(varName);
        return var.isCompatible(cl, preserve);
    }

    public final boolean missingRecordValueIsPrevious(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        Variable var = this.thisCDF.getVariable(varName);
        return var.missingRecordValueIsPrevious();
    }

    public final boolean missingRecordValueIsPad(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        Variable var = this.thisCDF.getVariable(varName);
        return var.missingRecordValueIsPad();
    }

    public final Vector<Integer> getElementCount(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        return this.thisCDF.getVariable(varName).getElementCount();
    }

    public final int[] getEffectiveDimensions(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        Variable var = this.thisCDF.getVariable(varName);
        return var.getEffectiveDimensions();
    }

    public final boolean isTimeType(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        Variable var = this.thisCDF.getVariable(varName);
        int type = var.getType();
        boolean isTimeType = CDFTimeType.EPOCH.getValue() == type;
        isTimeType |= CDFTimeType.EPOCH16.getValue() == type;
        return isTimeType |= CDFTimeType.TT2000.getValue() == type;
    }

    public final boolean existsVariable(String varName) {
        if (varName == null) {
            return false;
        }
        return this.thisCDF.getVariable(varName) != null;
    }

    public abstract String userTimeVariableName(String var1) throws CDFException.ReaderError;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String getTimeVariableName(String varName) throws Throwable {
        if (!this.existsVariable(varName)) {
            throw new Throwable("CDF does not hava a variable named " + varName);
        }
        String tname = this.userTimeVariableName(varName);
        if (tname != null) {
            return tname;
        }
        Variable var = this.thisCDF.getVariable(varName);
        String vname = var.getName();
        Vector v = (Vector)this.thisCDF.getAttribute(vname, "DEPEND_0");
        if (v.size() > 0) {
            tname = (String)v.elementAt(0);
        }
        if (tname != null) return tname;
        if (vname.equals("Epoch")) throw new Throwable("Variable named Epoch has no DEPEND_0 attribute.");
        if (this.thisCDF.getVariable("Epoch") == null) throw new Throwable("Time variable not found for " + vname);
        tname = "Epoch";
        System.out.println("Variable " + vname + " has no DEPEND_0 attribute. Variable named Epoch assumed to be the right time variable");
        return tname;
    }

    public final int getLastLeapSecondId() {
        return this.thisCDF.lastLeapSecondId;
    }

    public final int getBlockingFactor(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        return this.thisCDF.getVariable(varName).getBlockingFactor();
    }

    public final boolean isTypeR(String varName) throws CDFException.ReaderError {
        if (!this.existsVariable(varName)) {
            throw new CDFException.ReaderError("CDF does not hava a variable named " + varName);
        }
        return this.thisCDF.getVariable(varName).isTypeR();
    }
}

