/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.Extractor;
import gov.nasa.gsfc.spdf.cdfj.MetaData;
import gov.nasa.gsfc.spdf.cdfj.Stride;
import gov.nasa.gsfc.spdf.cdfj.TimeInstantModel;
import gov.nasa.gsfc.spdf.cdfj.TimeSeries;
import gov.nasa.gsfc.spdf.cdfj.TimeSeriesX;
import gov.nasa.gsfc.spdf.cdfj.TimeUtil;
import gov.nasa.gsfc.spdf.cdfj.TimeVariableFactory;
import gov.nasa.gsfc.spdf.cdfj.TimeVariableX;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.TimeZone;

public class TSExtractor
extends Extractor {
    static Calendar cal;

    public static double[][] getTimeSeries0(MetaData rdr, Variable var, Boolean ignoreFill, double[] timeRange) throws Throwable {
        return TSExtractor.getTimeSeries(rdr, var, null, ignoreFill, timeRange);
    }

    public static double[][] getTimeSeries1(MetaData rdr, Variable var, Integer which, Boolean ignoreFill, double[] timeRange) throws Throwable {
        return TSExtractor.getTimeSeries(rdr, var, which, ignoreFill, timeRange);
    }

    public static double[][] getTimeSeries(MetaData rdr, Variable var, Integer which, Boolean ignoreFill, double[] timeRange) throws Throwable {
        double[] stimes;
        Number pad;
        int element;
        if (var.getNumberOfValues() == 0) {
            return null;
        }
        boolean ignore = ignoreFill;
        int[] recordRange = null;
        TimeVariableFactory.CDFTimeVariable tv = TimeVariableFactory.getTimeVariable(rdr, var.getName());
        double[] times = tv.getTimes();
        if (times == null) {
            return null;
        }
        boolean longType = false;
        int type = var.getType();
        int n = element = which == null ? 0 : which;
        if (DataTypes.typeCategory[type] == 5) {
            longType = true;
            pad = ((long[])TSExtractor.getPadValue(rdr.thisCDF, var))[element];
        } else {
            pad = ((double[])TSExtractor.getPadValue(rdr.thisCDF, var))[element];
        }
        Object o = null;
        Object[] oa = null;
        if (timeRange == null) {
            Object object = o = which == null ? Extractor.getSeries0(rdr.thisCDF, var) : Extractor.getElement1(rdr.thisCDF, var, which);
            if (var.isMissingRecords()) {
                long[][] locations = var.getLocator().getLocations();
                oa = TSExtractor.filterPad(o, times, pad, locations, 0);
            } else {
                oa = new Object[]{times, (double[])o};
            }
        } else {
            recordRange = TSExtractor.getRecordRange(rdr, var, timeRange);
            if (recordRange == null) {
                return null;
            }
            o = which == null ? TSExtractor.getRange0(rdr.thisCDF, var, recordRange[0], recordRange[1]) : TSExtractor.getRangeForElement1(rdr.thisCDF, var, recordRange[0], recordRange[1], which);
            stimes = new double[Array.getLength(o)];
            int index = recordRange[0];
            for (int i = 0; i < stimes.length; ++i) {
                stimes[i] = times[index++];
            }
            if (var.isMissingRecords()) {
                long[][] locations = var.getLocator().getLocations();
                oa = TSExtractor.filterPad(o, stimes, pad, locations, recordRange[0]);
            } else {
                oa = new Object[]{stimes, (double[])o};
            }
        }
        stimes = (double[])oa[0];
        if (!ignore) {
            double[] vdata = TSExtractor.castToDouble(oa[1], longType);
            return new double[][]{stimes, vdata};
        }
        Object fill = Extractor.getFillValue(rdr.thisCDF, var);
        boolean fillDefined = true;
        Number fillValue = null;
        if (fill.getClass().getComponentType() == Double.TYPE) {
            boolean bl = fillDefined = ((double[])fill)[0] == 0.0;
            if (fillDefined) {
                fillValue = ((double[])fill)[1];
            }
        } else {
            boolean bl = fillDefined = ((long[])fill)[0] == 0L;
            if (fillDefined) {
                fillValue = ((long[])fill)[1];
            }
        }
        if (!fillDefined) {
            double[] vdata = TSExtractor.castToDouble(oa[1], longType);
            return new double[][]{stimes, vdata};
        }
        return TSExtractor.filterFill(stimes, oa[1], fillValue);
    }

    static int[] getRecordRange(MetaData rdr, Variable var, double[] timeRange) {
        return TSExtractor.getRecordRange(rdr, var, timeRange, null);
    }

    static int[] getRecordRange(MetaData rdr, Variable var, double[] timeRange, TimeInstantModel ts) {
        try {
            TimeVariableFactory.CDFTimeVariable tvx = TimeVariableFactory.getTimeVariable(rdr, var.getName());
            return tvx.getRecordRange(timeRange);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static double[][] filterFill(double[] times, double[] vdata, double fill, int first) {
        int count = 0;
        for (int i = 0; i < vdata.length; ++i) {
            if (vdata[i] == fill) continue;
            ++count;
        }
        double[][] series = new double[2][count];
        int n = 0;
        for (int i = 0; i < vdata.length; ++i) {
            if (vdata[i] == fill) continue;
            series[0][n] = times[i + first];
            series[1][n] = vdata[i];
            ++n;
        }
        return series;
    }

    public static double[][] filterFill(double[] times, Object o, Number fillValue) {
        double[][] series;
        int count = 0;
        if (o.getClass().getComponentType() == Long.TYPE) {
            long fill = fillValue.longValue();
            long[] ldata = (long[])o;
            for (int i = 0; i < ldata.length; ++i) {
                if (ldata[i] == fill) continue;
                ++count;
            }
            series = new double[2][count];
            int n = 0;
            for (int i = 0; i < ldata.length; ++i) {
                if (ldata[i] == fill) continue;
                series[0][n] = times[i];
                series[1][n] = ldata[i];
                ++n;
            }
        } else {
            if (o.getClass().getComponentType() != Double.TYPE) {
                return null;
            }
            double fill = fillValue.doubleValue();
            double[] data = (double[])o;
            for (int i = 0; i < data.length; ++i) {
                if (data[i] == fill) continue;
                ++count;
            }
            series = new double[2][count];
            int n = 0;
            for (int i = 0; i < data.length; ++i) {
                if (data[i] == fill) continue;
                series[0][n] = times[i];
                series[1][n] = data[i];
                ++n;
            }
        }
        return series;
    }

    static Object[] filterPad(Object o, double[] times, Number pad, long[][] locations, int first) {
        RecordSensor sensor = new RecordSensor(locations);
        if (o.getClass().getComponentType() == Double.TYPE) {
            double dpad = pad.doubleValue();
            double[] vdata = (double[])o;
            int npad = 0;
            for (int i = 0; i < vdata.length; ++i) {
                if (sensor.hasRecord(first + i) || vdata[i] != dpad) continue;
                ++npad;
            }
            if (npad == 0) {
                return new Object[]{times, vdata};
            }
            double[] _data = new double[vdata.length - npad];
            double[] _times = new double[vdata.length - npad];
            int index = 0;
            for (int i = 0; i < vdata.length; ++i) {
                if (!sensor.hasRecord(first + i) && vdata[i] == dpad) continue;
                _data[index] = vdata[i];
                _times[index] = times[i];
                ++index;
            }
            return new Object[]{_times, _data};
        }
        if (o.getClass().getComponentType() != Long.TYPE) {
            return null;
        }
        long lpad = pad.longValue();
        long[] ldata = (long[])o;
        int npad = 0;
        for (int i = 0; i < ldata.length; ++i) {
            if (sensor.hasRecord(first + i) || ldata[i] != lpad) continue;
            ++npad;
        }
        if (npad == 0) {
            return new Object[]{times, ldata};
        }
        long[] _data = new long[ldata.length - npad];
        double[] _times = new double[ldata.length - npad];
        int index = 0;
        for (int i = 0; i < ldata.length; ++i) {
            if (!sensor.hasRecord(first + i) && ldata[i] == lpad) continue;
            _data[index] = ldata[i];
            _times[index] = times[i];
            ++index;
        }
        return new Object[]{_times, _data};
    }

    public static double[][] getSampledTimeSeries0(MetaData rdr, Variable var, Boolean ignoreFill, double[] timeRange, int[] stride) throws Throwable {
        return TSExtractor.getSampledTimeSeries(rdr, var, null, ignoreFill, timeRange, stride);
    }

    public static double[][] getSampledTimeSeries1(MetaData rdr, Variable var, Integer which, Boolean ignoreFill, double[] timeRange, int[] stride) throws Throwable {
        return TSExtractor.getSampledTimeSeries(rdr, var, which, ignoreFill, timeRange, stride);
    }

    public static double[][] getSampledTimeSeries(MetaData rdr, Variable var, Integer which, Boolean ignoreFill, double[] timeRange, int[] stride) throws Throwable {
        double[] vdata;
        if (var.getNumberOfValues() == 0) {
            return null;
        }
        boolean ignore = ignoreFill;
        int[] recordRange = null;
        TimeVariableFactory.CDFTimeVariable tv = TimeVariableFactory.getTimeVariable(rdr, var.getName());
        double[] times = tv.getTimes();
        if (times == null) {
            return null;
        }
        Stride strideObject = new Stride(stride);
        if (timeRange == null) {
            vdata = which == null ? (double[])TSExtractor.getSeries0(rdr.thisCDF, var, strideObject) : TSExtractor.getElement1(rdr.thisCDF, var, which, strideObject);
        } else {
            recordRange = TSExtractor.getRecordRange(rdr, var, timeRange);
            if (recordRange == null) {
                return null;
            }
            vdata = which == null ? (double[])TSExtractor.getRange0(rdr.thisCDF, var, recordRange[0], recordRange[1], strideObject) : (double[])TSExtractor.getRangeForElement1(rdr.thisCDF, var, recordRange[0], recordRange[1], which, strideObject);
        }
        int _stride = strideObject.getStride();
        double[] fill = (double[])TSExtractor.getFillValue(rdr.thisCDF, var);
        if (!ignore || fill[0] != 0.0) {
            if (timeRange == null) {
                if (_stride == 1) {
                    return new double[][]{times, vdata};
                }
                double[] stimes = new double[vdata.length];
                for (int i = 0; i < vdata.length; ++i) {
                    stimes[i] = times[i * _stride];
                }
                return new double[][]{stimes, vdata};
            }
            double[] stimes = new double[vdata.length];
            if (_stride == 1) {
                System.arraycopy(times, recordRange[0], stimes, 0, vdata.length);
                return new double[][]{stimes, vdata};
            }
            int srec = recordRange[0];
            for (int i = 0; i < vdata.length; ++i) {
                stimes[i] = times[srec + i * _stride];
            }
            return new double[][]{stimes, vdata};
        }
        if (timeRange == null) {
            if (_stride == 1) {
                return TSExtractor.filterFill(times, vdata, fill[1], 0);
            }
            double[] stimes = new double[vdata.length];
            for (int i = 0; i < vdata.length; ++i) {
                stimes[i] = times[i * _stride];
            }
            return TSExtractor.filterFill(stimes, vdata, fill[1], 0);
        }
        double[] stimes = new double[vdata.length];
        if (_stride == 1) {
            System.arraycopy(times, recordRange[0], stimes, 0, vdata.length);
            return TSExtractor.filterFill(stimes, vdata, fill[1], 0);
        }
        int srec = recordRange[0];
        for (int i = 0; i < vdata.length; ++i) {
            stimes[i] = times[srec + i * _stride];
        }
        return TSExtractor.filterFill(stimes, vdata, fill[1], 0);
    }

    public static TimeSeries getTimeSeriesObject0(MetaData rdr, Variable var, Boolean ignoreFill, double[] timeRange, TimeInstantModel ts) throws Throwable {
        return new GeneralTimeSeries(rdr, var, null, ignoreFill, timeRange, ts);
    }

    public static TimeSeries getTimeSeriesObject1(MetaData rdr, Variable var, Integer which, Boolean ignoreFill, double[] timeRange, TimeInstantModel ts) throws Throwable {
        return new GeneralTimeSeries(rdr, var, which, ignoreFill, timeRange, ts);
    }

    public static String identifier() {
        return "TSExtractor";
    }

    public static Method getMethod(Variable var, String name, int rank) throws Throwable {
        return TSExtractor.getMethod(var, name, rank, false);
    }

    static Method getMethod(Variable var, String name, int rank, boolean checkMissing) throws Throwable {
        if (var == null) {
            throw new Throwable("Internal error. Null variable encountered in call to TSExtractor.getMethod()");
        }
        int _rank = var.getEffectiveRank();
        if (_rank != rank) {
            throw new Throwable("Called method is not appropriate for variables of effective rank " + _rank);
        }
        if (checkMissing && var.isMissingRecords()) {
            System.out.println("Variable " + var.getName() + " has gaps. Sampled time series code is being tested. Feature is not  currently available if the variable has gaps.");
            return null;
        }
        Method method = TSExtractor.getMethod(var, name);
        if (method == null) {
            throw new Throwable("get" + name + " not implemented for " + var.getName());
        }
        return method;
    }

    public static long getTime(int[] time) {
        int i;
        int[] t = new int[6];
        for (i = 0; i < 3; ++i) {
            t[i] = time[i];
        }
        t[1] = t[1] - 1;
        for (i = 3; i < 6; ++i) {
            t[i] = 0;
        }
        int n = time.length;
        if (n >= 4) {
            t[3] = time[3];
            if (n >= 5) {
                t[4] = time[4];
                if (n >= 6) {
                    t[5] = time[5];
                }
            }
        }
        cal.clear();
        cal.set(t[0], t[1], t[2], t[3], t[4], t[5]);
        cal.set(14, n > 6 ? time[6] : 0);
        return cal.getTimeInMillis();
    }

    public static double getTime(MetaData rdr, String vname, int[] time) throws Throwable {
        boolean isTT2000 = TimeVariableFactory.getTimeVariable(rdr, vname).isTT2000();
        long t = TSExtractor.getTime(time);
        return isTT2000 ? TimeUtil.milliSecondSince1970(t) : (double)t;
    }

    public static double[] getOverlap(MetaData rdr, double[] trange, String varName, int[] startTime, int[] stopTime) throws Throwable {
        double[] overlap = new double[]{Double.MIN_VALUE, Double.MAX_VALUE};
        if (startTime != null) {
            if (startTime.length < 3) {
                throw new Throwable("incomplete start time definition.");
            }
            double _start = TSExtractor.getTime(rdr, varName, startTime);
            if (_start > trange[1]) {
                throw new Throwable("Start time is beyond end of data");
            }
            overlap[0] = _start < trange[0] ? trange[0] : _start;
        } else {
            overlap[0] = trange[0];
        }
        if (stopTime != null) {
            if (stopTime.length < 3) {
                throw new Throwable("incomplete stop time definition.");
            }
            double _stop = TSExtractor.getTime(rdr, varName, stopTime);
            if (_stop < trange[0]) {
                throw new Throwable("Stop time is before start of data");
            }
            if (_stop < overlap[0]) {
                throw new Throwable("Stop time is before start time");
            }
            overlap[1] = _stop;
        } else {
            overlap[1] = trange[1];
        }
        return overlap;
    }

    static {
        try {
            Class<?> variableClass = Class.forName("gov.nasa.gsfc.spdf.cdfj.Variable");
            Class<?> rdrClass = Class.forName("gov.nasa.gsfc.spdf.cdfj.MetaData");
            Class<?> cl = Class.forName("gov.nasa.gsfc.spdf.cdfj.TSExtractor");
            Class<?> timeSpecClass = Class.forName("gov.nasa.gsfc.spdf.cdfj.TimeInstantModel");
            double[] da = new double[]{};
            int[] ia = new int[]{};
            Class[][] arglist = new Class[][]{{rdrClass, variableClass, Boolean.class, da.getClass()}, {rdrClass, variableClass, Integer.class, Boolean.class, da.getClass()}, null, null};
            TSExtractor.addFunction("TimeSeries", cl, arglist);
            arglist = new Class[][]{{rdrClass, variableClass, Boolean.class, da.getClass(), ia.getClass()}, {rdrClass, variableClass, Integer.class, Boolean.class, da.getClass(), ia.getClass()}, null, null};
            TSExtractor.addFunction("SampledTimeSeries", cl, arglist);
            arglist = new Class[][]{{rdrClass, variableClass, Boolean.class, da.getClass(), timeSpecClass}, {rdrClass, variableClass, Integer.class, Boolean.class, da.getClass(), timeSpecClass}, null, null};
            TSExtractor.addFunction("TimeSeriesObject", cl, arglist);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    }

    static class RecordSensor {
        long[][] locations;
        int last = 0;

        RecordSensor(long[][] locations) {
            this.locations = locations;
        }

        boolean hasRecord(int number) {
            for (int i = this.last; i < this.locations.length; ++i) {
                if ((long)number < this.locations[i][0] || (long)number > this.locations[i][1]) continue;
                this.last = i;
                return true;
            }
            return false;
        }
    }

    public static class GeneralTimeSeriesX
    implements TimeSeriesX {
        final TimeInstantModel tspec;
        final TimeVariableX tv;
        final String vname;
        final CDFImpl thisCDF;
        final double[] timeRange;
        final boolean oned;
        final boolean columnMajor;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GeneralTimeSeriesX(MetaData rdr, Variable var, Boolean ignoreFill, double[] timeRange, TimeInstantModel ts, boolean oned, boolean columnMajor) throws Throwable {
            boolean ignore = ignoreFill;
            if (ts != null) {
                TimeInstantModel timeInstantModel = ts;
                synchronized (timeInstantModel) {
                    this.tspec = (TimeInstantModel)ts.clone();
                }
            } else {
                this.tspec = null;
            }
            this.vname = var.getName();
            this.tv = TimeVariableFactory.getTimeVariable(rdr, this.vname);
            this.thisCDF = rdr.thisCDF;
            this.timeRange = timeRange;
            this.oned = oned;
            this.columnMajor = columnMajor;
        }

        @Override
        public double[] getTimes() throws CDFException.ReaderError {
            try {
                if (this.timeRange == null) {
                    return this.tv.getTimes(this.tspec);
                }
                return this.tv.getTimes(this.timeRange, this.tspec);
            }
            catch (Throwable th) {
                throw new CDFException.ReaderError(th.getMessage());
            }
        }

        @Override
        public Object getValues() throws CDFException.ReaderError {
            try {
                if (this.timeRange == null) {
                    return this.oned ? (Object)this.thisCDF.getOneD(this.vname, this.columnMajor) : this.thisCDF.get(this.vname);
                }
                int[] recordRange = this.tv.getRecordRange(this.timeRange);
                if (recordRange == null) {
                    throw new CDFException.ReaderError("no data");
                }
                if (!this.oned) {
                    return this.thisCDF.getRange(this.vname, recordRange[0], recordRange[1]);
                }
                return this.thisCDF.getRangeOneD(this.vname, recordRange[0], recordRange[1], this.columnMajor);
            }
            catch (Throwable th) {
                throw new CDFException.ReaderError(th.getMessage());
            }
        }

        @Override
        public TimeInstantModel getTimeInstantModel() {
            return this.tspec;
        }

        @Override
        public boolean isOneD() {
            return this.oned;
        }

        @Override
        public boolean isColumnMajor() {
            return this.columnMajor;
        }
    }

    public static class GeneralTimeSeries
    implements TimeSeries {
        double[] vdata;
        double[] times;
        TimeInstantModel tspec;
        double[][] filtered = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GeneralTimeSeries(MetaData rdr, Variable var, Integer which, Boolean ignoreFill, double[] timeRange, TimeInstantModel ts) throws Throwable {
            boolean ignore = ignoreFill;
            int[] recordRange = null;
            if (ts != null) {
                TimeInstantModel timeInstantModel = ts;
                synchronized (timeInstantModel) {
                    this.tspec = (TimeInstantModel)ts.clone();
                }
            }
            TimeVariableFactory.CDFTimeVariable tv = TimeVariableFactory.getTimeVariable(rdr, var.getName());
            this.times = tv.getTimes(this.tspec);
            if (this.times == null) {
                throw new Throwable("times not available for " + var.getName());
            }
            boolean longType = false;
            int type = var.getType();
            if (DataTypes.typeCategory[type] == 5) {
                longType = true;
            }
            Object o = null;
            if (timeRange == null) {
                o = which == null ? Extractor.getSeries0(rdr.thisCDF, var) : Extractor.getElement1(rdr.thisCDF, var, which);
            } else {
                recordRange = TSExtractor.getRecordRange(rdr, var, timeRange, ts);
                if (recordRange == null) {
                    throw new Throwable("no record range");
                }
                o = which == null ? Extractor.getRange0(rdr.thisCDF, var, recordRange[0], recordRange[1]) : Extractor.getRangeForElement1(rdr.thisCDF, var, recordRange[0], recordRange[1], which);
            }
            this.vdata = Extractor.castToDouble(o, longType);
            if (!ignore) {
                if (timeRange != null) {
                    double[] stimes = new double[this.vdata.length];
                    System.arraycopy(this.times, recordRange[0], stimes, 0, this.vdata.length);
                    this.times = stimes;
                }
            } else {
                int first;
                double[] fill = (double[])Extractor.getFillValue(rdr.thisCDF, var);
                int n = first = timeRange != null ? recordRange[0] : 0;
                if (fill[0] != 0.0) {
                    double[] stimes = new double[this.vdata.length];
                    System.arraycopy(this.times, first, stimes, 0, this.vdata.length);
                    this.times = stimes;
                } else {
                    this.filtered = TSExtractor.filterFill(this.times, this.vdata, fill[1], first);
                }
            }
        }

        @Override
        public double[] getTimes() {
            return this.filtered != null ? this.filtered[0] : this.times;
        }

        public double[] getValues() {
            return this.filtered != null ? this.filtered[1] : this.vdata;
        }

        @Override
        public TimeInstantModel getTimeInstantModel() {
            return this.tspec;
        }
    }
}

