/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class TimeUtil {
    static final long[] jtimes;
    static final int[] leapSecondIds;
    static final long[] tt_times;
    static final int HIGHEST;
    static SimpleDateFormat sdf;
    public static final long TT_JANUARY_1_1970 = -946727957816000000L;
    static final long JANUARY_1_1972;
    static final int LAST_LEAP_SECOND_ID;
    static Calendar cal;

    public static double getOffset(long l) throws Throwable {
        double start;
        if (l < JANUARY_1_1972) {
            throw new Throwable("Times before January 1, 1972 are not supported at present");
        }
        if (l < jtimes[0]) {
            start = l;
        } else {
            start = -1.0;
            for (int i = 0; i < jtimes.length - 1; ++i) {
                if (l >= jtimes[i + 1]) continue;
                start = l + (long)((i + 1) * 1000);
                break;
            }
            if (start < 0.0) {
                start = l + (long)HIGHEST;
            }
        }
        return start;
    }

    public static double milliSecondSince1970(Date d) throws Throwable {
        return TimeUtil.milliSecondSince1970(d.getTime());
    }

    public static double milliSecondSince1970(long javaMilliSecond) throws Throwable {
        long l = javaMilliSecond;
        if (l < JANUARY_1_1972) {
            throw new Throwable("Times before January 1, 1972 are not supported at present");
        }
        for (int i = jtimes.length - 1; i >= 0; --i) {
            if (l <= jtimes[i]) continue;
            return l + (long)((i + 1) * 1000);
        }
        return l;
    }

    public static long tt2000(long l) throws Throwable {
        return -946727957816000000L + 1000000L * (long)TimeUtil.milliSecondSince1970(l);
    }

    public static long tt2000(Date d) throws Throwable {
        return -946727957816000000L + 1000000L * (long)TimeUtil.milliSecondSince1970(d);
    }

    public static long milliSecondSince1970(int[] time) throws Throwable {
        return TimeUtil.milliSecondSince1970(time, false);
    }

    static long milliSecondSince1970(int[] time, boolean tt) throws Throwable {
        int i;
        int[] t = new int[6];
        for (i = 0; i < 3; ++i) {
            t[i] = time[i];
        }
        t[1] = t[1] - 1;
        for (i = 3; i < 6; ++i) {
            t[i] = 0;
        }
        int n = time.length;
        if (n >= 4) {
            t[3] = time[3];
            if (n >= 5) {
                t[4] = time[4];
                if (n >= 6) {
                    t[5] = time[5];
                }
            }
        }
        int adjust = 0;
        if (t[5] == 60) {
            if (!tt) {
                throw new Throwable("second value 60 is valid for tt2000 only.");
            }
            int id = -1;
            if (t[4] == 59 && t[3] == 23) {
                if (time[2] == 30 && time[1] == 6) {
                    id = time[0] * 10000 + 701;
                } else if (time[2] == 31 && time[1] == 12) {
                    id = (1 + time[0]) * 10000 + 101;
                }
            }
            if (id == -1) {
                throw new Throwable("Invalid leap second time");
            }
            for (int i2 = leapSecondIds.length - 1; i2 >= 0; --i2) {
                if (id != leapSecondIds[i2]) continue;
                adjust = 1000000000;
                break;
            }
            if (adjust == 0) {
                throw new Throwable("Invalid leap second time");
            }
            t[5] = 59;
        }
        cal.clear();
        cal.set(t[0], t[1], t[2], t[3], t[4], t[5]);
        cal.set(14, n > 6 ? time[6] : 0);
        return cal.getTimeInMillis();
    }

    public static long tt2000(int[] time) throws Throwable {
        int adjust;
        long msec = TimeUtil.milliSecondSince1970(time, true);
        if (time.length < 6) {
            return TimeUtil.tt2000(msec);
        }
        int n = adjust = time[5] == 60 ? 1000000000 : 0;
        if (time.length <= 7) {
            return (long)adjust + TimeUtil.tt2000(msec);
        }
        if (time.length == 8) {
            return (long)adjust + TimeUtil.tt2000(msec) + (long)(time[7] * 1000);
        }
        return (long)adjust + TimeUtil.tt2000(msec) + (long)(time[7] * 1000) + (long)time[8];
    }

    static {
        int i;
        sdf = new SimpleDateFormat("y'-'M'-'dd'T'HH:mm:ss.SSS");
        JANUARY_1_1972 = Date.UTC(72, 0, 1, 0, 0, 0);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        boolean[][] transition = new boolean[100][2];
        transition[2][0] = true;
        transition[2][1] = true;
        transition[3][1] = true;
        transition[4][1] = true;
        transition[5][1] = true;
        transition[6][1] = true;
        transition[7][1] = true;
        transition[8][1] = true;
        transition[9][1] = true;
        transition[11][0] = true;
        transition[12][0] = true;
        transition[13][0] = true;
        transition[15][0] = true;
        transition[17][1] = true;
        transition[19][1] = true;
        transition[20][1] = true;
        transition[22][0] = true;
        transition[23][0] = true;
        transition[24][0] = true;
        transition[25][1] = true;
        transition[27][0] = true;
        transition[28][1] = true;
        transition[35][1] = true;
        transition[38][1] = true;
        transition[42][0] = true;
        transition[45][0] = true;
        transition[46][1] = true;
        Vector<Long> times = new Vector<Long>();
        Vector<Integer> ids = new Vector<Integer>();
        for (i = 0; i < transition.length; ++i) {
            if (transition[i][0]) {
                times.add(Date.UTC(70 + i, 5, 30, 23, 59, 59));
                ids.add((1970 + i) * 10000 + 701);
            }
            if (!transition[i][1]) continue;
            times.add(Date.UTC(70 + i, 11, 31, 23, 59, 59));
            ids.add((1971 + i) * 10000 + 101);
        }
        jtimes = new long[times.size()];
        tt_times = new long[times.size()];
        leapSecondIds = new int[times.size()];
        for (i = 0; i < jtimes.length; ++i) {
            TimeUtil.jtimes[i] = (Long)times.get(i);
            TimeUtil.leapSecondIds[i] = (Integer)ids.get(i);
            try {
                TimeUtil.tt_times[i] = TimeUtil.tt2000(jtimes[i]);
                continue;
            }
            catch (Throwable t) {
                System.out.println("Internal error.");
            }
        }
        HIGHEST = 1000 * jtimes.length;
        LAST_LEAP_SECOND_ID = leapSecondIds[leapSecondIds.length - 1];
        cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    }

    public static class Validator {
        public static long correctedIfNecessary(long varTime, int leapId) throws Throwable {
            if (leapId == LAST_LEAP_SECOND_ID) {
                return varTime;
            }
            if (leapId < LAST_LEAP_SECOND_ID) {
                int i;
                int id = -1;
                for (i = leapSecondIds.length - 1; i >= 0; --i) {
                    if (leapId != leapSecondIds[i]) continue;
                    id = i;
                    break;
                }
                if (id < 0) {
                    throw new Throwable("Invalid leapId");
                }
                if (varTime < tt_times[id + 1]) {
                    return varTime;
                }
                for (i = id + 1; i < jtimes.length - 1 && varTime >= tt_times[i + 1]; ++i) {
                }
                return varTime + (long)(i - id) * 1000000000L;
            }
            if (varTime < tt_times[jtimes.length - 1]) {
                return varTime;
            }
            throw new Throwable("Out of date Leap second table");
        }
    }
}

