/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.CDFImpl;
import gov.nasa.gsfc.spdf.cdfj.DoubleVarContainer;
import gov.nasa.gsfc.spdf.cdfj.LongVarContainer;
import gov.nasa.gsfc.spdf.cdfj.MetaData;
import gov.nasa.gsfc.spdf.cdfj.TSExtractor;
import gov.nasa.gsfc.spdf.cdfj.TimeInstantModel;
import gov.nasa.gsfc.spdf.cdfj.TimePrecision;
import gov.nasa.gsfc.spdf.cdfj.TimeUtil;
import gov.nasa.gsfc.spdf.cdfj.TimeVariableX;
import gov.nasa.gsfc.spdf.cdfj.Variable;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.LongBuffer;
import java.util.Date;
import java.util.Vector;

public class TimeVariableFactory {
    public static final double JANUARY_1_1970;
    static final long LONG_FILL = -9223372036854775807L;
    static final double DOUBLE_FILL = -1.0E31;
    private static TimeInstantModel defaultTimeInstantModel;
    public static final long JANUARY_1_1970_LONG;
    public static final long TT2000_DATE;

    private TimeVariableFactory() {
    }

    public static TimeInstantModel getDefaultTimeInstantModel() {
        return (TimeInstantModel)defaultTimeInstantModel.clone();
    }

    public static TimeInstantModel getDefaultTimeInstantModel(double msec) {
        TimeInstantModel tspec = (TimeInstantModel)defaultTimeInstantModel.clone();
        ((DefaultTimeInstantModelImpl)tspec).setBaseTime(msec);
        return tspec;
    }

    public static CDFTimeVariable getTimeVariable(MetaData rdr, String vname) throws Throwable {
        CDFImpl cdf = rdr.thisCDF;
        Variable var = cdf.getVariable(vname);
        int precision = -1;
        String tname = null;
        int recordCount = var.getNumberOfValues();
        if (var == null) {
            throw new Throwable("Bad variable name " + vname);
        }
        tname = rdr.getTimeVariableName(vname);
        Variable tvar = cdf.getVariable(tname);
        if (tvar == null) {
            throw new Throwable("Time variable not found for " + vname);
        }
        boolean themisLike = false;
        if (tvar.getNumberOfValues() == 0) {
            Vector v = (Vector)cdf.getAttribute(var.getName(), "DEPEND_TIME");
            if (v.size() > 0) {
                tname = (String)v.elementAt(0);
                tvar = cdf.getVariable(tname);
                themisLike = true;
            } else {
                throw new Throwable("Expected unix time variable not found for " + var.getName());
            }
        }
        if (tvar.getNumberOfValues() == 0) {
            throw new Throwable("Empty time variable for " + var.getName());
        }
        ByteBuffer buf = null;
        if (tvar.getType() == 33) {
            LongVarContainer lbuf = new LongVarContainer(cdf, tvar, null);
            lbuf.run();
            buf = lbuf.getBuffer();
        } else {
            DoubleVarContainer dbuf = new DoubleVarContainer(cdf, tvar, null, true);
            dbuf.run();
            buf = dbuf.getBuffer();
        }
        CDFTimeVariable tv = tvar.getType() == 32 ? new CDFEpoch16Variable(cdf, tname, buf) : (tvar.getType() == 33 ? new CDFTT2000Variable(cdf, tname, buf) : (themisLike ? new UnixTimeVariable(cdf, tname, buf) : new CDFEpochVariable(cdf, tname, buf)));
        tv.setRecordCount(recordCount);
        return tv;
    }

    static {
        int offset = 0;
        for (int year = 0; year < 1970; ++year) {
            int days = 365;
            if (year % 4 == 0) {
                ++days;
                if (year % 100 == 0) {
                    --days;
                    if (year % 400 == 0) {
                        ++days;
                    }
                }
            }
            offset += days;
        }
        JANUARY_1_1970 = (double)offset * 8.64E7;
        defaultTimeInstantModel = new DefaultTimeInstantModelImpl();
        JANUARY_1_1970_LONG = (long)JANUARY_1_1970;
        TT2000_DATE = JANUARY_1_1970_LONG + Date.UTC(100, 0, 1, 12, 0, 0) - 42184L;
    }

    static class DefaultTimeInstantModelImpl
    implements TimeInstantModel {
        double baseTime = JANUARY_1_1970;
        TimePrecision baseTimeUnits = TimePrecision.MILLISECOND;
        TimePrecision offsetUnits = TimePrecision.MILLISECOND;

        DefaultTimeInstantModelImpl() {
        }

        @Override
        public double getBaseTime() {
            return this.baseTime;
        }

        @Override
        public TimePrecision getBaseTimeUnits() {
            return this.baseTimeUnits;
        }

        @Override
        public TimePrecision getOffsetUnits() {
            return this.offsetUnits;
        }

        @Override
        public void setOffsetUnits(TimePrecision offsetUnits) {
            this.offsetUnits = offsetUnits;
        }

        void setBaseTime(double msec) {
            this.baseTime = msec;
        }

        @Override
        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }

    public static class UnixTimeVariable
    extends CDFTimeVariable {
        DoubleBuffer _dbuf;

        UnixTimeVariable(CDFImpl cdf, String name, ByteBuffer obuf) {
            super(cdf, name, obuf);
            this.precision = TimePrecision.MICROSECOND;
            this._dbuf = this.tbuf.asDoubleBuffer();
        }

        @Override
        public double[] getTimes(int first, int last, TimeInstantModel ts) throws Throwable {
            TimePrecision offsetUnits = TimePrecision.MILLISECOND;
            long base = JANUARY_1_1970_LONG;
            if (ts != null) {
                base = (long)ts.getBaseTime();
                offsetUnits = ts.getOffsetUnits();
            }
            int count = last - first + 1;
            double[] da = new double[count];
            ByteBuffer bbuf = this.tbuf.duplicate();
            bbuf.order(this.tbuf.order());
            DoubleBuffer dbuf = bbuf.asDoubleBuffer();
            dbuf.position(first);
            dbuf.get(da);
            if (offsetUnits == TimePrecision.MILLISECOND) {
                if (base == JANUARY_1_1970_LONG) {
                    for (int i = 0; i < count; ++i) {
                        if (da[i] == -1.0E31) {
                            da[i] = Double.NaN;
                            continue;
                        }
                        int n = i;
                        da[n] = da[n] * 1000.0;
                    }
                } else {
                    this.offset = base - JANUARY_1_1970_LONG;
                    for (int i = 0; i < count; ++i) {
                        if (da[i] == -1.0E31) {
                            da[i] = Double.NaN;
                            continue;
                        }
                        long milli = (long)(da[i] * 1000.0) - this.offset;
                        da[i] = milli;
                    }
                }
            } else {
                if (offsetUnits != TimePrecision.MICROSECOND) {
                    throw new Throwable("Desired precision exceeds highest available precision -- microsecond");
                }
                if ((double)base == JANUARY_1_1970) {
                    for (int i = 0; i < count; ++i) {
                        if (da[i] == -1.0E31) {
                            da[i] = Double.NaN;
                            continue;
                        }
                        int n = i;
                        da[n] = da[n] * 1000000.0;
                    }
                } else {
                    this.offset = 1000L * (base - JANUARY_1_1970_LONG);
                    for (int i = 0; i < count; ++i) {
                        if (da[i] == -1.0E31) {
                            da[i] = Double.NaN;
                            continue;
                        }
                        long micro = (long)(da[i] * 1000000.0) - this.offset;
                        da[i] = micro;
                    }
                }
            }
            return da;
        }

        @Override
        void reset() {
            this._dbuf.position(0);
        }

        @Override
        public boolean isTT2000() {
            return false;
        }

        @Override
        public boolean canSupportPrecision(TimePrecision tp) {
            if (tp == TimePrecision.MICROSECOND) {
                return true;
            }
            return tp == TimePrecision.MILLISECOND;
        }
    }

    public static class CDFEpoch16Variable
    extends CDFTimeVariable {
        DoubleBuffer _dbuf;

        CDFEpoch16Variable(CDFImpl cdf, String name, ByteBuffer obuf) {
            super(cdf, name, obuf);
            this.precision = TimePrecision.PICOSECOND;
            this._dbuf = this.tbuf.asDoubleBuffer();
        }

        @Override
        public double[] getTimes(int first, int last, TimeInstantModel ts) throws Throwable {
            TimePrecision offsetUnits = TimePrecision.MILLISECOND;
            long base = JANUARY_1_1970_LONG;
            if (ts != null) {
                base = (long)ts.getBaseTime();
                offsetUnits = ts.getOffsetUnits();
            }
            int count = last - first + 1;
            double[] da = new double[count];
            ByteBuffer bbuf = this.tbuf.duplicate();
            bbuf.order(this.tbuf.order());
            DoubleBuffer dbuf = bbuf.asDoubleBuffer();
            if (offsetUnits == TimePrecision.MILLISECOND) {
                long mul = 1000L;
                for (int i = first; i <= last; ++i) {
                    double _d = dbuf.get(2 * i);
                    if (_d == -1.0E31) {
                        da[i - first] = Double.NaN;
                        continue;
                    }
                    double d = (long)dbuf.get(2 * i) * mul - base;
                    da[i - first] = d + dbuf.get(2 * i + 1) / 1.0E9;
                }
            } else if (offsetUnits == TimePrecision.MICROSECOND) {
                this.offset = 1000L * base;
                long mul = 1000000L;
                for (int i = first; i <= last; ++i) {
                    double _d = dbuf.get(2 * i);
                    if (_d == -1.0E31) {
                        da[i - first] = Double.NaN;
                        continue;
                    }
                    double d = (long)dbuf.get(2 * i) * mul - this.offset;
                    da[i - first] = d + dbuf.get(2 * i + 1) / 1000000.0;
                }
            } else if (offsetUnits == TimePrecision.NANOSECOND) {
                this.offset = 1000000L * base;
                long mul = 1000000000L;
                for (int i = first; i <= last; ++i) {
                    double _d = dbuf.get(2 * i);
                    if (_d == -1.0E31) {
                        da[i - first] = Double.NaN;
                        continue;
                    }
                    double d = (long)dbuf.get(2 * i) * mul - this.offset;
                    da[i - first] = d + dbuf.get(2 * i + 1) / 1000.0;
                }
            } else {
                for (int i = first; i <= last; ++i) {
                    double _d = dbuf.get(2 * i);
                    if (_d == -1.0E31) {
                        da[i - first] = Double.NaN;
                        continue;
                    }
                    double d = dbuf.get(2 * i) * 1000.0 - (double)base;
                    da[i - first] = d * 1.0E9 + dbuf.get(2 * i + 1);
                }
            }
            return da;
        }

        @Override
        void reset() {
            this._dbuf.position(0);
        }

        @Override
        public boolean isTT2000() {
            return false;
        }

        @Override
        public boolean canSupportPrecision(TimePrecision tp) {
            return true;
        }
    }

    public static class CDFTT2000Variable
    extends CDFTimeVariable {
        LongBuffer _lbuf;

        CDFTT2000Variable(CDFImpl cdf, String name, ByteBuffer obuf) {
            super(cdf, name, obuf);
            this.precision = TimePrecision.NANOSECOND;
            this._lbuf = this.tbuf.asLongBuffer();
        }

        @Override
        public double[] getTimes(int first, int last, TimeInstantModel ts) throws Throwable {
            TimePrecision offsetUnits = TimePrecision.MILLISECOND;
            long base = JANUARY_1_1970_LONG;
            if (ts != null) {
                base = (long)ts.getBaseTime();
                offsetUnits = ts.getOffsetUnits();
            }
            int count = last - first + 1;
            double[] da = new double[count];
            ByteBuffer bbuf = this.tbuf.duplicate();
            bbuf.order(this.tbuf.order());
            LongBuffer lbuf = bbuf.asLongBuffer();
            if (offsetUnits == TimePrecision.MILLISECOND) {
                this.offset = base - TT2000_DATE;
                for (int i = first; i <= last; ++i) {
                    long nano = lbuf.get(i);
                    if (nano == -9223372036854775807L) {
                        da[i - first] = Double.NaN;
                        continue;
                    }
                    long milli = nano / 1000000L - this.offset;
                    double rem = (double)(nano % 1000000L) / 1000000.0;
                    da[i - first] = (double)milli + rem;
                }
            } else if (offsetUnits == TimePrecision.MICROSECOND) {
                this.offset = 1000L * (base - TT2000_DATE);
                for (int i = first; i <= last; ++i) {
                    long nano = lbuf.get(i);
                    if (nano == -9223372036854775807L) {
                        da[i - first] = Double.NaN;
                        continue;
                    }
                    long micro = nano / 1000L - this.offset;
                    double rem = (double)(nano % 1000L) / 1000.0;
                    da[i - first] = (double)micro + rem;
                }
            } else {
                if (offsetUnits != TimePrecision.NANOSECOND) {
                    throw new Throwable("You may request only millisecond, microsecond or nanosecond offset for a variable whose time variable is TT2000 type.");
                }
                this.offset = 1000000L * (base - TT2000_DATE);
                for (int i = first; i <= last; ++i) {
                    long nano = lbuf.get(i);
                    da[i - first] = nano == -9223372036854775807L ? Double.NaN : (double)(nano - this.offset);
                }
            }
            return da;
        }

        @Override
        void reset() {
            this._lbuf.position(0);
        }

        @Override
        public boolean isTT2000() {
            return true;
        }

        @Override
        public boolean canSupportPrecision(TimePrecision tp) {
            return tp != TimePrecision.PICOSECOND;
        }
    }

    public static class CDFEpochVariable
    extends CDFTimeVariable {
        TimePrecision offsetUnits = TimePrecision.MILLISECOND;
        DoubleBuffer _dbuf;

        CDFEpochVariable(CDFImpl cdf, String name, ByteBuffer obuf) {
            super(cdf, name, obuf);
            this.precision = TimePrecision.MILLISECOND;
            this._dbuf = this.tbuf.asDoubleBuffer();
        }

        @Override
        public double[] getTimes(int first, int last, TimeInstantModel ts) throws Throwable {
            double base = JANUARY_1_1970_LONG;
            if (ts != null) {
                if (ts.getOffsetUnits() != TimePrecision.MILLISECOND) {
                    throw new Throwable("Unsupported offset units: Only millisecond offset units are supported for this variable.");
                }
                base = ts.getBaseTime();
            }
            int count = last - first + 1;
            double[] da = new double[count];
            ByteBuffer bbuf = this.tbuf.duplicate();
            bbuf.order(this.tbuf.order());
            DoubleBuffer dbuf = bbuf.asDoubleBuffer();
            dbuf.position(first);
            dbuf.get(da);
            for (int i = 0; i < count; ++i) {
                if (da[i] == -1.0E31) {
                    System.out.println("at " + i + " fill found");
                    da[i] = Double.NaN;
                    continue;
                }
                int n = i;
                da[n] = da[n] - base;
            }
            return da;
        }

        @Override
        void reset() {
            this._dbuf.position(0);
        }

        @Override
        public boolean isTT2000() {
            return false;
        }

        @Override
        public boolean canSupportPrecision(TimePrecision tp) {
            return tp == TimePrecision.MILLISECOND;
        }
    }

    public static abstract class CDFTimeVariable
    implements TimeVariableX {
        CDFImpl cdf;
        String name;
        TimePrecision precision;
        final ByteBuffer tbuf;
        long offset;
        int recordCount;

        CDFTimeVariable(CDFImpl cdf, String name, ByteBuffer obuf) {
            this.name = name;
            this.cdf = cdf;
            this.tbuf = obuf;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TimePrecision getPrecision() {
            return this.precision;
        }

        @Override
        public double[] getTimes() {
            try {
                return this.getTimes(0, this.recordCount - 1, null);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }

        @Override
        public double[] getTimes(TimeInstantModel ts) throws Throwable {
            return this.getTimes(0, this.recordCount - 1, ts);
        }

        @Override
        public double[] getTimes(int[] recordRange) throws Throwable {
            try {
                return this.getTimes(recordRange, defaultTimeInstantModel);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }

        abstract double[] getTimes(int var1, int var2, TimeInstantModel var3) throws Throwable;

        @Override
        public double[] getTimes(int[] recordRange, TimeInstantModel ts) throws Throwable {
            return this.getTimes(recordRange[0], recordRange[1], ts);
        }

        public double[] getTimes(double[] timeRange) {
            try {
                return this.getTimes(timeRange, null);
            }
            catch (Throwable t) {
                t.printStackTrace();
                return null;
            }
        }

        @Override
        public double[] getTimes(double[] timeRange, TimeInstantModel ts) throws Throwable {
            if (timeRange == null) {
                return this.getTimes(0, this.recordCount - 1, ts);
            }
            int[] rr = this.getRecordRange(timeRange, ts);
            if (rr == null) {
                return null;
            }
            return this.getTimes(rr[0], rr[1], ts);
        }

        @Override
        public double[] getTimes(int[] startTime, int[] stopTime, TimeInstantModel ts) throws Throwable {
            if (startTime == null) {
                throw new Throwable("start time is required");
            }
            if (stopTime == null) {
                throw new Throwable("stop time is required");
            }
            if (startTime.length < 3) {
                throw new Throwable("incomplete start time definition.");
            }
            long start = TSExtractor.getTime(startTime);
            if (stopTime.length < 3) {
                throw new Throwable("incomplete stop time definition.");
            }
            long stop = TSExtractor.getTime(stopTime);
            if (this.isTT2000()) {
                start = (long)TimeUtil.milliSecondSince1970(start);
                stop = (long)TimeUtil.milliSecondSince1970(stop);
            }
            return this.getTimes(new double[]{start, stop}, ts);
        }

        @Override
        public double[] getTimes(int[] startTime, int[] stopTime) throws Throwable {
            return this.getTimes(startTime, stopTime, null);
        }

        @Override
        public int[] getRecordRange(double[] timeRange) throws Throwable {
            return this.getRecordRange(timeRange, null);
        }

        @Override
        public int[] getRecordRange(int[] startTime, int[] stopTime) throws Throwable {
            return this.getRecordRange(startTime, stopTime, null);
        }

        @Override
        public int[] getRecordRange(int[] startTime, int[] stopTime, TimeInstantModel ts) throws Throwable {
            if (startTime.length < 3) {
                throw new Throwable("incomplete start time definition.");
            }
            if (stopTime.length < 3) {
                throw new Throwable("incomplete stop time definition.");
            }
            long start = TSExtractor.getTime(startTime);
            long stop = TSExtractor.getTime(stopTime);
            if (this.isTT2000()) {
                start = (long)TimeUtil.milliSecondSince1970(start);
                stop = (long)TimeUtil.milliSecondSince1970(stop);
            }
            return this.getRecordRange(new double[]{start, stop}, ts);
        }

        public int[] getRecordRange(double[] timeRange, TimeInstantModel ts) throws Throwable {
            int i;
            double[] temp = this.getTimes(0, this.recordCount - 1, ts);
            double start = timeRange[0];
            double stop = timeRange[1];
            if (ts != null && ts != defaultTimeInstantModel) {
                start = start - ts.getBaseTime() + (double)JANUARY_1_1970_LONG;
                stop = stop - ts.getBaseTime() + (double)JANUARY_1_1970_LONG;
                if (ts.getOffsetUnits() == TimePrecision.MICROSECOND) {
                    start *= 1000.0;
                    stop *= 1000.0;
                } else if (ts.getOffsetUnits() == TimePrecision.NANOSECOND) {
                    start *= 1000000.0;
                    stop *= 1000000.0;
                }
            }
            for (i = 0; i < temp.length && (Double.isNaN(temp[i]) || start > temp[i]); ++i) {
            }
            if (i == temp.length) {
                return null;
            }
            int low = i;
            int last = i;
            while (i < temp.length) {
                if (!Double.isNaN(temp[i])) {
                    last = i;
                    if (stop < temp[i]) break;
                    if (stop == temp[i]) {
                        last = i - 1;
                        break;
                    }
                }
                ++i;
            }
            return new int[]{low, last};
        }

        protected void setRecordCount(int count) {
            this.recordCount = count;
        }

        @Override
        public double getFirstMilliSecond() {
            TimeInstantModel tspec = TimeVariableFactory.getDefaultTimeInstantModel();
            ((DefaultTimeInstantModelImpl)tspec).setBaseTime(0.0);
            tspec.setOffsetUnits(TimePrecision.MILLISECOND);
            try {
                double d = Double.NaN;
                for (int n = 0; n < this.recordCount; ++n) {
                    d = this.getTimes(n, n, tspec)[0];
                    if (Double.isNaN(d)) continue;
                    return d;
                }
                return d;
            }
            catch (Throwable t) {
                t.printStackTrace();
                return Double.NaN;
            }
        }

        abstract void reset();

        @Override
        public abstract boolean isTT2000();

        @Override
        public ByteBuffer getRawBuffer() {
            return this.tbuf;
        }
    }
}

