/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.gsfc.spdf.cdfj;

import gov.nasa.gsfc.spdf.cdfj.DataTypes;
import gov.nasa.gsfc.spdf.cdfj.SparseRecordOption;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Vector;

public class VDR {
    ByteBuffer record = ByteBuffer.allocate(344);
    long vDRNext;
    long longMask = 0xFFFFFFFFL;
    byte[] padValues;
    protected int position;
    String sname;
    int dataType;
    int maxRec = -1;
    long vXRHead;
    long vXRTail = -1L;
    int flags;
    int sRecords = 0;
    protected int numElems = 1;
    int num;
    long cPROffset;
    int blockingFactor;
    byte[] name = new byte[256];
    int zNumDims;
    ByteBuffer dimBuf;
    protected int itemsPerPoint = 1;
    protected Vector<Integer> efdim;

    public VDR(String name, int dataType, int[] dim, boolean[] varys, boolean recordVariance, boolean compressed, Object pad, int size, SparseRecordOption option) throws Throwable {
        this.sname = name;
        this.setName(name);
        this.setDataType(dataType);
        if (dim.length != varys.length) {
            throw new Throwable("Length of varys and dim arrays differ.");
        }
        this.numElems = size;
        this.itemsPerPoint = size;
        this.setDimensions(dim, varys, dataType);
        if (compressed) {
            this.flags |= 4;
        }
        if (recordVariance) {
            this.flags |= 1;
        }
        this.setSparseRecordOption(option);
        if (pad != null) {
            Class<?> cl = pad.getClass();
            if (!cl.isArray()) {
                throw new Throwable("Pad must be an array.");
            }
            Number[] _pad = null;
            if (cl.getComponentType() != String.class) {
                _pad = new Number[1];
                if (cl.getComponentType() == Double.TYPE) {
                    _pad[0] = ((double[])pad)[0];
                }
                if (cl.getComponentType() == Float.TYPE) {
                    _pad[0] = Float.valueOf(((float[])pad)[0]);
                }
                if (cl.getComponentType() == Integer.TYPE) {
                    _pad[0] = ((int[])pad)[0];
                }
                if (cl.getComponentType() == Long.TYPE) {
                    _pad[0] = ((long[])pad)[0];
                }
                if (cl.getComponentType() == Short.TYPE) {
                    _pad[0] = ((short[])pad)[0];
                }
                if (cl.getComponentType() == Byte.TYPE) {
                    _pad[0] = ((byte[])pad)[0];
                }
            }
            int category = DataTypes.typeCategory[dataType];
            this.flags |= 2;
            ByteBuffer buf = null;
            if (category == 2 || category == 3) {
                if (DataTypes.size[dataType] == 4 && category == 3) {
                    int i;
                    long[] lvalues = new long[_pad.length];
                    for (i = 0; i < lvalues.length; ++i) {
                        lvalues[i] = _pad[i].longValue();
                    }
                    buf = ByteBuffer.allocate(4 * lvalues.length);
                    buf.order(ByteOrder.LITTLE_ENDIAN);
                    for (i = 0; i < lvalues.length; ++i) {
                        buf.putInt((int)(lvalues[i] & this.longMask));
                    }
                    buf.position(0);
                } else {
                    int i;
                    int[] values = new int[_pad.length];
                    for (i = 0; i < values.length; ++i) {
                        values[i] = _pad[i].intValue();
                    }
                    buf = ByteBuffer.allocate(DataTypes.size[dataType] * values.length);
                    buf.order(ByteOrder.LITTLE_ENDIAN);
                    if (DataTypes.size[dataType] == 1) {
                        for (i = 0; i < values.length; ++i) {
                            buf.put((byte)(values[i] & 0xFF));
                        }
                    } else if (DataTypes.size[dataType] == 2) {
                        for (i = 0; i < values.length; ++i) {
                            buf.putShort((short)(values[i] & 0xFFFF));
                        }
                    } else {
                        buf.asIntBuffer().put(values);
                    }
                }
            } else if (category == 0) {
                float[] values = new float[_pad.length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = _pad[i].floatValue();
                }
                buf = ByteBuffer.allocate(4 * values.length);
                buf.order(ByteOrder.LITTLE_ENDIAN);
                buf.asFloatBuffer().put(values);
            } else if (category == 1) {
                double[] values = new double[_pad.length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = _pad[i].doubleValue();
                }
                buf = ByteBuffer.allocate(8 * values.length);
                buf.order(ByteOrder.LITTLE_ENDIAN);
                buf.asDoubleBuffer().put(values);
            } else if (category == 5) {
                long[] values = new long[_pad.length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = _pad[i].longValue();
                }
                buf = ByteBuffer.allocate(8 * values.length);
                buf.order(ByteOrder.LITTLE_ENDIAN);
                buf.asLongBuffer().put(values);
            } else {
                if (category != 4) {
                    throw new Throwable("Unrecognized type  pad value");
                }
                String[] values = new String[]{((String[])pad)[0]};
                int len = values[0].length();
                buf = ByteBuffer.allocate(len *= values.length);
                for (String value : values) {
                    try {
                        buf.put(value.getBytes());
                    }
                    catch (Exception ex) {
                        throw new Throwable("encoding");
                    }
                    buf.position(0);
                }
            }
            this.padValues = new byte[buf.limit()];
            buf.position(0);
            buf.get(this.padValues);
        }
    }

    public VDR(String name, int dataType, int[] dim, boolean[] varys, boolean compressed) throws Throwable {
        this(name, dataType, dim, varys, true, compressed, null, 1, SparseRecordOption.NONE);
    }

    public VDR(String name, int dataType, int[] dim, boolean[] varys) throws Throwable {
        this(name, dataType, dim, varys, false);
    }

    public void setVDRNext(long l) {
        this.vDRNext = l;
    }

    public void setDataType(int n) {
        this.dataType = n;
    }

    public void setMaxRec(int n) {
        this.maxRec = n;
    }

    public void setVXRHead(long l) {
        this.vXRHead = l;
    }

    public void setVXRTail(long l) {
        this.vXRTail = l;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public boolean isCompressed() {
        boolean compressed;
        boolean bl = compressed = (this.flags & 4) != 0;
        if (compressed) {
            // empty if block
        }
        return compressed;
    }

    public void setSparseRecordOption(SparseRecordOption option) {
        this.sRecords = option.getValue();
    }

    public void setNumElems(int[] dim, boolean[] varys) {
        this.numElems = 1;
    }

    public void setNum(int n) {
        this.num = n;
    }

    public int getNum() {
        return this.num;
    }

    public void setCPROffset(long l) {
        this.cPROffset = l;
    }

    public void setBlockingFactor(int n) {
        this.blockingFactor = n;
    }

    public void setName(String s) {
        int i;
        byte[] bs = s.getBytes();
        for (i = 0; i < bs.length; ++i) {
            this.name[i] = bs[i];
        }
        while (i < this.name.length) {
            this.name[i] = 0;
            ++i;
        }
    }

    public void setDimensions(int[] dim, boolean[] varys, int dataType) {
        int i;
        this.zNumDims = dim.length;
        if (dataType == 32) {
            this.itemsPerPoint = 2;
            this.zNumDims = 0;
        }
        this.efdim = new Vector();
        if (this.zNumDims == 0) {
            return;
        }
        for (i = 0; i < dim.length; ++i) {
            if (!varys[i]) continue;
            this.itemsPerPoint *= dim[i];
        }
        this.dimBuf = ByteBuffer.allocate(4 * this.zNumDims * 2);
        for (i = 0; i < this.zNumDims; ++i) {
            this.dimBuf.putInt(dim[i]);
        }
        for (i = 0; i < this.zNumDims; ++i) {
            this.dimBuf.putInt(varys[i] ? -1 : 0);
            if (!varys[i]) continue;
            this.efdim.add(dim[i]);
        }
        this.dimBuf.position(0);
    }

    public ByteBuffer get() {
        int capacity = this.record.capacity();
        if (this.padValues != null) {
            capacity += this.padValues.length;
        }
        if (this.zNumDims > 0) {
            capacity += this.dimBuf.capacity();
        }
        ByteBuffer buf = ByteBuffer.allocate(capacity);
        this.record.position(0);
        this.record.putLong(capacity);
        this.record.putInt(8);
        this.record.putLong(this.vDRNext);
        this.record.putInt(this.dataType);
        this.record.putInt(this.maxRec);
        this.record.putLong(this.vXRHead);
        this.record.putLong(this.vXRTail < 0L ? this.vXRHead : this.vXRTail);
        this.record.putInt(this.flags);
        this.record.putInt(this.sRecords);
        this.record.putInt(0);
        this.record.putInt(-1);
        this.record.putInt(-1);
        this.record.putInt(this.numElems);
        this.record.putInt(this.num);
        this.record.putLong(this.cPROffset);
        this.record.putInt(this.blockingFactor);
        this.record.put(this.name);
        this.record.putInt(this.zNumDims);
        this.record.position(0);
        buf.put(this.record);
        if (this.zNumDims > 0) {
            buf.put(this.dimBuf);
        }
        if (this.padValues != null) {
            buf.put(this.padValues);
        }
        buf.position(0);
        return buf;
    }

    public int getSize() {
        int size = this.record.capacity();
        if (this.zNumDims > 0) {
            size += this.dimBuf.capacity();
        }
        if (this.padValues != null) {
            size += this.padValues.length;
        }
        return size;
    }

    public String getName() {
        return this.sname;
    }
}

