/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdf;

import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFReader;
import gov.nasa.gsfc.spdf.cdfj.ReaderFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.cdf.CdfDataSetUtil;
import org.autoplot.cdf.CdfUtil;
import org.autoplot.cdf.CdfVirtualVars;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.datasource.ReferenceCache;
import org.autoplot.metatree.IstpMetadataModel;
import org.autoplot.metatree.MetadataUtil;
import org.autoplot.util.TickleTimer;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.ReplicateDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.buffer.BufferDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.DasMath;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class CdfDataSource
extends AbstractDataSource {
    protected static final String PARAM_DODEP = "doDep";
    protected static final String PARAM_WHERE = "where";
    protected static final String PARAM_DEPEND0 = "depend0";
    protected static final String PARAM_X = "X";
    protected static final String PARAM_Y = "Y";
    protected static final String PARAM_INTERPMETA = "interpMeta";
    protected static final String PARAM_ID = "id";
    protected static final String PARAM_SLICE1 = "slice1";
    protected static final String PARAM_SLICE2 = "slice2";
    protected static final String ATTR_SLICE1_LABELS = "slice1_labels";
    protected static final String ATTR_SLICE1 = "slice1";
    protected static final String ATTR_SLICE2_LABELS = "slice2_labels";
    protected static final String ATTR_SLICE2 = "slice2";
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.cdf");
    private Map<String, Object> attributes;
    private static final int FILE_CACHE_SIZE_LIMIT = 2;
    private static final LinkedHashMap<String, CDFReader> openFiles = new LinkedHashMap();
    private static final Map<CDFReader, String> openFilesRev = new HashMap<CDFReader, String>();
    private static final Map<String, Long> openFilesFresh = new HashMap<String, Long>();
    private static final Object lock = new Object();
    private static final int DS_CACHE_SIZE_LIMIT = 2;
    private static final LinkedHashMap<String, MutablePropertyDataSet> dsCache = new LinkedHashMap();
    private static final HashMap<String, Long> dsCacheFresh = new HashMap();
    private static final Object dslock = new Object();
    public static final TickleTimer timer = new TickleTimer(10000L, new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            logger.log(Level.FINER, "unloading CDF cache to resolve bug 1002");
            Object object = lock;
            synchronized (object) {
                openFiles.clear();
                openFilesRev.clear();
                openFilesFresh.clear();
            }
        }
    });
    private static int allocateDirect = -1;

    public CdfDataSource(URI uri) {
        super(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cdfCacheUnload(String fileName, boolean unloadDs) {
        Object object = lock;
        synchronized (object) {
            logger.log(Level.FINER, "cdfCacheUnload cdf file {0} from cache: unloadDs={1}", new Object[]{fileName, unloadDs});
            CDFReader cdf = (CDFReader)openFiles.remove(fileName);
            openFilesRev.remove(cdf);
            openFilesFresh.remove(fileName);
            if (unloadDs) {
                Object object2 = dslock;
                synchronized (object2) {
                    ArrayList<String> unload = new ArrayList<String>();
                    for (String ds : dsCache.keySet()) {
                        if (!ds.startsWith(fileName)) continue;
                        unload.add(ds);
                    }
                    for (String ds : unload) {
                        dsCache.remove(ds);
                        dsCacheFresh.remove(ds);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void cdfCacheReset() {
        Object object = lock;
        synchronized (object) {
            openFiles.clear();
            openFilesRev.clear();
            openFilesFresh.clear();
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String cdfCacheFileForReader(CDFReader cdf) {
        String cdfFile;
        Object object = lock;
        synchronized (object) {
            cdfFile = openFilesRev.get(cdf);
        }
        return cdfFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void dsCachePut(String uri, MutablePropertyDataSet ds) {
        Object object = dslock;
        synchronized (object) {
            logger.log(Level.FINER, "dsCachePut uri={0} ds={1}", new Object[]{uri, ds});
            dsCache.remove(uri);
            dsCache.put(uri, ds);
            dsCacheFresh.put(uri, System.currentTimeMillis());
            while (dsCache.size() > 2) {
                Map.Entry<String, MutablePropertyDataSet> first = dsCache.entrySet().iterator().next();
                dsCache.remove(first.getKey());
                logger.log(Level.FINER, "remove {0}", first.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printCacheReport() {
        Object object = dslock;
        synchronized (object) {
            for (Map.Entry<String, MutablePropertyDataSet> entry : dsCache.entrySet()) {
                int mem = CdfUtil.jvmMemory((QDataSet)entry.getValue());
                System.err.println(String.format("%9d %s %s", mem, entry.getKey(), entry.getValue()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CDFReader getCdfFile(String fileName) {
        CDFReader cdf;
        block30: {
            if (allocateDirect == -1) {
                allocateDirect = BufferDataSet.shouldAllocateDirect();
            }
            try {
                Object object = lock;
                synchronized (object) {
                    cdf = openFiles.get(fileName);
                    logger.log(Level.FINER, "cdf open files cache contained: {0}", cdf);
                }
                if (cdf == null) {
                    object = lock;
                    synchronized (object) {
                        File cdfFile = new File(fileName);
                        if (!cdfFile.exists()) {
                            throw new IllegalArgumentException("CDF file does not exist: " + fileName);
                        }
                        if (cdfFile.length() == 0L) {
                            throw new IllegalArgumentException("CDF file length is zero: " + fileName);
                        }
                        if (cdfFile.length() < Integer.MAX_VALUE) {
                            if (allocateDirect == 0) {
                                try {
                                    cdf = ReaderFactory.getReader(fileName);
                                }
                                catch (Exception e) {
                                    try {
                                        cdf = new CDFReader(fileName);
                                    }
                                    catch (Exception e2) {
                                        throw e;
                                    }
                                }
                            } else {
                                cdf = new CDFReader(fileName);
                            }
                        } else {
                            cdf = ReaderFactory.getReader(fileName);
                        }
                        openFiles.put(fileName, cdf);
                        openFilesRev.put(cdf, fileName);
                        openFilesFresh.put(fileName, System.currentTimeMillis());
                        logger.log(Level.FINER, "added cdf file {0} to cache: {1}", new Object[]{fileName, cdf});
                        if (openFiles.size() > 2) {
                            String oldest = openFiles.entrySet().iterator().next().getKey();
                            CdfDataSource.cdfCacheUnload(oldest, true);
                        }
                        break block30;
                    }
                }
                object = lock;
                synchronized (object) {
                    Long date = openFilesFresh.get(fileName);
                    if (date == null || new File(fileName).lastModified() > date) {
                        if (allocateDirect == 0) {
                            cdf = ReaderFactory.getReader(fileName);
                        } else {
                            cdf = new CDFReader(fileName);
                        }
                        openFiles.put(fileName, cdf);
                        openFilesRev.put(cdf, fileName);
                        openFilesFresh.put(fileName, System.currentTimeMillis());
                    } else {
                        openFiles.put(fileName, cdf);
                        openFilesRev.put(cdf, fileName);
                        openFilesFresh.put(fileName, System.currentTimeMillis());
                        logger.log(Level.FINE, "using cached open CDF {0}", fileName);
                    }
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "An exception was caught in CdfJava openFiles caching", ex);
                throw new RuntimeException(ex);
            }
        }
        timer.tickle("unload cdf soon");
        return cdf;
    }

    public synchronized QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        boolean useReferenceCache = "true".equals(System.getProperty("enableReferenceCache", "false"));
        ReferenceCache.ReferenceCacheEntry rcent = null;
        if (useReferenceCache) {
            rcent = ReferenceCache.getInstance().getDataSetOrLock(this.getURI(), mon);
            if (!rcent.shouldILoad(Thread.currentThread())) {
                QDataSet result = rcent.park(mon);
                logger.log(Level.FINE, "reference cache used to resolve {0}", new Object[]{String.valueOf(result)});
                logger.log(Level.FINE, "ref uri {0}", new Object[]{this.resourceURI});
                return result;
            }
            logger.log(Level.FINE, "reference cache in use, {0} is loading {1}", new Object[]{Thread.currentThread().toString(), this.resourceURI});
        }
        try {
            long numRec;
            String[] svariables;
            File cdfFile = this.getFile(mon.getSubtaskMonitor("download file"));
            logger.log(Level.FINE, "getDataSet ({0})", this.getURI());
            String fileName = cdfFile.toString();
            Map map = this.getParams();
            mon.setProgressMessage("open CDF file");
            CDFReader cdf = CdfDataSource.getCdfFile(fileName);
            logger.log(Level.FINE, "got cdf file for {0} {1}", new Object[]{fileName, cdf});
            String svariable = (String)map.get(PARAM_ID);
            if (svariable == null) {
                svariable = (String)map.get("arg_0");
            }
            String constraint = null;
            if (svariable == null) {
                throw new IllegalArgumentException("CDF URI needs an argument");
            }
            int i = svariable.indexOf("[");
            if (i != -1) {
                constraint = svariable.substring(i);
                int i2 = constraint.indexOf(";");
                if (i2 > -1) {
                    constraint = constraint.substring(0, i2);
                }
                svariable = svariable.substring(0, i);
            }
            if ((i = svariable.indexOf(";")) != -1) {
                svariables = svariable.split(";");
                svariable = svariable.substring(0, i);
            } else {
                svariables = null;
            }
            long numRecDepend0 = -1L;
            try {
                Vector depend0namev = (Vector)cdf.getAttribute(svariable, "DEPEND_0");
                if (depend0namev != null && depend0namev.size() == 1) {
                    String n = depend0namev.get(0).toString();
                    numRecDepend0 = cdf.getNumberOfValues(n);
                }
                numRec = cdf.getNumberOfValues(svariable);
            }
            catch (CDFException ex) {
                throw new Exception("CDFException " + ex.getMessage());
            }
            String interpMeta = (String)map.get(PARAM_INTERPMETA);
            if (!"no".equals(interpMeta)) {
                List<String> ss = Arrays.asList(cdf.getVariableNames());
                if (!ss.contains(svariable)) {
                    throw new IllegalArgumentException("No Such Variable: " + svariable);
                }
                int[] dimensions = cdf.getDimensions(svariable);
                long[] ndimensions = new long[dimensions.length + 1];
                ndimensions[0] = numRec;
                for (i = 0; i < dimensions.length; ++i) {
                    ndimensions[i + 1] = dimensions[i];
                }
                Map constraints = DataSourceUtil.parseConstraint((String)constraint, (long[])ndimensions);
                long[] recs = (long[])constraints.get(0);
                if (this.attributes == null) {
                    this.getMetadata((ProgressMonitor)new NullProgressMonitor());
                    this.attributes = svariables != null ? new HashMap<String, Object>() : CdfDataSource.readAttributes(cdf, svariable, 0);
                    if (recs[2] == -1L) {
                        this.attributes = MetadataUtil.sliceProperties(this.attributes, (int)0);
                    }
                    if (map.get("slice1") != null) {
                        this.attributes.put("slice1", map.get("slice1"));
                    }
                    if (constraint != null) {
                        Matcher m = Pattern.compile("\\[\\:\\,(\\d+)\\]").matcher(constraint);
                        if (m.matches()) {
                            this.attributes.put("slice1", m.group(1));
                        }
                        if ((m = Pattern.compile("\\[\\:\\,\\:\\,(\\d+)\\]").matcher(constraint)).matches()) {
                            this.attributes.put("slice2", m.group(1));
                        }
                    }
                    if (map.get(PARAM_X) != null) {
                        Map<String, Object> xattr = this.readXorYAttributes(cdf, (String)map.get(PARAM_X), 0);
                        this.attributes.put("DEPEND_0", xattr);
                    }
                    if (map.get(PARAM_Y) != null) {
                        Map<String, Object> yattr = this.readXorYAttributes(cdf, (String)map.get(PARAM_Y), 0);
                        this.attributes.put(PARAM_Y, yattr);
                    }
                }
            }
            QDataSet result = this.getDataSet(mon, this.attributes);
            if (numRec > 0L && numRec < numRecDepend0 && result instanceof BufferDataSet && (long)result.length() < numRecDepend0 && constraint == null) {
                double fill;
                BufferDataSet resultExt = (BufferDataSet)result;
                resultExt.grow((int)numRecDepend0);
                int[] size = Ops.size((QDataSet)result);
                BufferDataSet fillRecs = BufferDataSet.create((int)resultExt.rank(), (Object)resultExt.getType(), (int)((int)(numRecDepend0 - numRec)), (int[])size);
                fillRecs.putProperty("UNITS", result.property("UNITS"));
                Number nfill = (Number)resultExt.property("FILL_VALUE");
                if (nfill == null) {
                    logger.log(Level.WARNING, "required fill value is missing: {0}", svariable);
                    fill = Double.NaN;
                } else {
                    fill = ((Number)resultExt.property("FILL_VALUE")).doubleValue();
                }
                QubeDataSetIterator it = new QubeDataSetIterator((QDataSet)fillRecs);
                while (it.hasNext()) {
                    it.next();
                    it.putValue((WritableDataSet)fillRecs, fill);
                }
                resultExt.append(fillRecs);
                logger.warning("assuming virtual records because data is shorter than DEPEND_0");
                result = resultExt;
            }
            if (rcent != null) {
                rcent.finished(result);
            }
            return result;
        }
        catch (Exception ex) {
            if (rcent != null) {
                rcent.exception(ex);
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDataSet getDataSet(ProgressMonitor mon, Map<String, Object> attr1) throws Exception {
        String lsurl = this.uri.toString();
        logger.entering("CdfDataSource", "getDataSet", new Object[]{lsurl});
        Object object = dslock;
        synchronized (object) {
            MutablePropertyDataSet cached = dsCache.get(lsurl);
            if (cached != null) {
                CdfDataSource.dsCachePut(lsurl, cached);
            }
        }
        mon.started();
        File cdfFile = this.getFile(mon.getSubtaskMonitor("download file"));
        String fileName = cdfFile.toString();
        Map map = this.getParams();
        mon.setProgressMessage("open CDF file");
        CDFReader cdf = CdfDataSource.getCdfFile(fileName);
        String svariable = (String)map.get(PARAM_ID);
        if (svariable == null) {
            svariable = (String)map.get("arg_0");
        }
        if (svariable == null) {
            throw new IllegalArgumentException("CDF URI needs an argument");
        }
        MutablePropertyDataSet result = CdfDataSource.getDataSet(cdfFile, cdf, svariable, attr1, map, mon);
        if (this.getParam("loadErrors", "F").equals("F")) {
            if (result.property("DELTA_MINUS") != null) {
                result.putProperty("DELTA_MINUS", null);
            }
            if (result.property("DELTA_PLUS") != null) {
                result.putProperty("DELTA_PLUS", null);
            }
            if (result.property("BIN_MINUS") != null) {
                result.putProperty("BIN_MINUS", null);
            }
            if (result.property("BIN_PLUS") != null) {
                result.putProperty("BIN_PLUS", null);
            }
        }
        if ("T".equals(this.getParam("replaceLabels", "F"))) {
            CdfDataSource.maybeReplaceLabels(result);
        }
        result.makeImmutable();
        logger.exiting("CdfDataSource", "getDataSet");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MutablePropertyDataSet getDataSet(File cdfFile, CDFReader cdf, String svariable, Map<String, Object> attr1, Map map, ProgressMonitor mon) throws Exception {
        String interpMeta;
        String w;
        String sy;
        String sx;
        HashMap<String, Object> attrs1;
        String os1;
        WritableDataSet result;
        boolean doDep;
        String constraint = null;
        ArrayList<String> constraints = new ArrayList<String>();
        int ibracket = svariable.indexOf("[");
        if (ibracket != -1) {
            constraint = svariable.substring(ibracket);
            StringBuilder newSvariableBuilder = new StringBuilder(svariable.substring(0, ibracket));
            int i2 = constraint.indexOf(";");
            if (i2 > -1) {
                int i4;
                constraint = constraint.substring(0, i2);
                constraints.add(constraint);
                i2 = svariable.indexOf(";");
                int i3 = svariable.indexOf(";", i2 + 1);
                while (i3 > -1) {
                    i4 = svariable.indexOf("[", i2 + 1);
                    if (i4 == -1) {
                        newSvariableBuilder.append(";").append(svariable.substring(i2 + 1, i3));
                        constraints.add("");
                    } else {
                        newSvariableBuilder.append(";").append(svariable.substring(i2 + 1, i4));
                        constraints.add(svariable.substring(i4, i3));
                    }
                    i2 = i3;
                    i3 = svariable.indexOf(";", i3 + 1);
                }
                i4 = svariable.indexOf("[", i2 + 1);
                if (i4 == -1) {
                    newSvariableBuilder.append(";").append(svariable.substring(i2 + 1));
                    constraints.add("");
                } else {
                    newSvariableBuilder.append(";").append(svariable.substring(i2 + 1, i4));
                    constraints.add(svariable.substring(i4));
                }
            }
            svariable = newSvariableBuilder.toString();
        }
        String[] svariables = svariable.contains(";") ? svariable.split(";") : null;
        boolean bl = doDep = !"no".equals(map.get(PARAM_DODEP));
        if (attr1 != null && attr1.containsKey("VIRTUAL") && (attr1.containsKey("FUNCTION") || attr1.containsKey("FUNCT"))) {
            if (svariables != null) {
                throw new IllegalArgumentException("virtual variables not supported for multi-variable reads");
            }
            ArrayList<QDataSet> args = new ArrayList<QDataSet>();
            String function = (String)attr1.get("FUNCTION");
            if (function == null) {
                function = (String)attr1.get("FUNCT");
            }
            if (attr1.get("COMPONENT_0") != null) {
                args.add((QDataSet)CdfDataSource.loadVariableAndDependents(cdf, (String)attr1.get("COMPONENT_0"), constraint, false, true, null, -1, -1, mon.getSubtaskMonitor("c0")));
            }
            if (attr1.get("COMPONENT_1") != null) {
                args.add((QDataSet)CdfDataSource.loadVariableAndDependents(cdf, (String)attr1.get("COMPONENT_1"), constraint, false, true, null, -1, -1, mon.getSubtaskMonitor("c1")));
            }
            if (attr1.get("COMPONENT_2") != null) {
                args.add((QDataSet)CdfDataSource.loadVariableAndDependents(cdf, (String)attr1.get("COMPONENT_2"), constraint, false, true, null, -1, -1, mon.getSubtaskMonitor("c2")));
            }
            if (attr1.get("COMPONENT_3") != null) {
                args.add((QDataSet)CdfDataSource.loadVariableAndDependents(cdf, (String)attr1.get("COMPONENT_3"), constraint, false, true, null, -1, -1, mon.getSubtaskMonitor("c3")));
            }
            if (attr1.get("COMPONENT_4") != null) {
                args.add((QDataSet)CdfDataSource.loadVariableAndDependents(cdf, (String)attr1.get("COMPONENT_4"), constraint, false, true, null, -1, -1, mon.getSubtaskMonitor("c4")));
            }
            result = (MutablePropertyDataSet)CdfVirtualVars.execute(attr1, function, args, mon.getSubtaskMonitor("virtual variable"));
            String os12 = (String)map.get("slice1");
            if (os12 != null && !os12.equals("") && cdf.getDimensions(svariable).length > 0) {
                int is = Integer.parseInt(os12);
                result = (MutablePropertyDataSet)Ops.slice1((QDataSet)result, (int)is);
            }
        } else if (svariables != null) {
            os1 = (String)map.get("slice1");
            if (os1 != null && !os1.equals("") && cdf.getDimensions(svariable).length > 0) {
                throw new IllegalArgumentException("slice is not supported for multi-variable reads");
            }
            QDataSet result0 = null;
            for (int i = 0; i < svariables.length; ++i) {
                String s = svariables[i];
                if (!cdf.existsVariable(s)) {
                    throw new IllegalArgumentException("variable does not exist: " + s);
                }
                String c = constraints.isEmpty() ? null : (String)constraints.get(i);
                attrs1 = CdfDataSource.readAttributes(cdf, s, 0);
                MutablePropertyDataSet result1 = CdfDataSource.loadVariableAndDependents(cdf, s, c, false, doDep, attrs1, -1, -1, mon.getSubtaskMonitor("reading " + s + " from CDF file"));
                Pattern p = Pattern.compile("\\[\\:\\,(\\d+)\\]");
                if (c != null) {
                    Matcher m = p.matcher(c);
                    QDataSet labels = (QDataSet)attrs1.get(ATTR_SLICE1_LABELS);
                    if (m.matches() && labels != null) {
                        int i2 = Integer.parseInt(m.group(1));
                        result1 = Ops.putProperty((QDataSet)result1, (String)"LABEL", (Object)labels.slice(i2).svalue());
                    }
                }
                result0 = Ops.bundle(result0, (QDataSet)result1);
            }
            result = Ops.maybeCopy(result0);
        } else {
            os1 = (String)map.get("slice1");
            if (os1 != null && !os1.equals("") && cdf.getDimensions(svariable).length > 0) {
                int is = Integer.parseInt(os1);
                result = CdfDataSource.loadVariableAndDependents(cdf, svariable, constraint, false, doDep, attr1, is, -1, mon.getSubtaskMonitor("reading " + svariable + " from CDF file"));
            } else {
                result = CdfDataSource.loadVariableAndDependents(cdf, svariable, constraint, false, doDep, attr1, -1, -1, mon.getSubtaskMonitor("reading " + svariable + " from CDF file"));
            }
        }
        if (logger.isLoggable(Level.FINE) && cdfFile != null) {
            String fileName = cdfFile.toString();
            int islash = fileName.lastIndexOf(47);
            logger.log(Level.FINE, "reading from {0}", fileName.substring(0, islash));
            logger.log(Level.FINE, "read variable {0}?{1} got {2}", new Object[]{fileName.substring(islash), svariable, String.valueOf(result)});
        }
        if ((sx = (String)map.get(PARAM_X)) == null) {
            sx = (String)map.get("x");
        }
        if (sx != null && sx.length() > 0) {
            String constraint1;
            int k = sx.indexOf("[");
            if (k != -1) {
                constraint1 = sx.substring(k);
                sx = sx.substring(0, k);
            } else {
                constraint1 = constraint;
            }
            MutablePropertyDataSet parm = CdfDataSource.loadVariableAndDependents(cdf, sx, constraint1, false, false, null, -1, result.length(), (ProgressMonitor)new NullProgressMonitor());
            if (parm.length() != result.length()) {
                throw new IllegalArgumentException("length of X doesn't match that of data, check each variable's length.");
            }
            result = (MutablePropertyDataSet)Ops.link((QDataSet)parm, (QDataSet)result);
        }
        if ((sy = (String)map.get(PARAM_Y)) == null) {
            sy = (String)map.get("y");
        }
        if (sy != null && sy.length() > 0) {
            String constraint1;
            int k = sy.indexOf("[");
            if (k != -1) {
                constraint1 = sy.substring(k);
                sy = sy.substring(0, k);
            } else {
                constraint1 = constraint;
            }
            MutablePropertyDataSet parm = CdfDataSource.loadVariableAndDependents(cdf, sy, constraint1, false, false, null, -1, result.length(), (ProgressMonitor)new NullProgressMonitor());
            if (parm.length() == 1 && parm.rank() == 2 && result.rank() > 1 && result.length() > 1) {
                parm = parm.slice(0);
            }
            result = (MutablePropertyDataSet)Ops.link((Object)result.property("DEPEND_0"), (Object)parm, (Object)result);
        }
        if ((w = (String)map.get(PARAM_WHERE)) != null && w.length() > 0) {
            String constraint1;
            int ieq = w.indexOf(".");
            String sparm = w.substring(0, ieq);
            int k = sparm.indexOf("[");
            if (k != -1) {
                constraint1 = sparm.substring(k);
                sparm = sparm.substring(0, k);
            } else {
                constraint1 = constraint;
            }
            MutablePropertyDataSet parm = CdfDataSource.loadVariableAndDependents(cdf, sparm, constraint1, false, false, null, -1, result.length(), (ProgressMonitor)new NullProgressMonitor());
            if (parm.length() == 1 && parm.rank() == 2 && result.rank() > 1 && result.length() > 1) {
                parm = Ops.replicate((QDataSet)parm.slice(0), (int)result.length());
            }
            result = CdfDataSource.doWhereFilter((String)w, (QDataSet)parm, (MutablePropertyDataSet)result);
        }
        if (!doDep) {
            result.putProperty("DEPEND_0", null);
            result.putProperty("DEPEND_1", null);
            result.putProperty("DEPEND_2", null);
            result.putProperty("DEPEND_3", null);
            if (attr1 != null) {
                attr1.remove("DEPEND_0");
                attr1.remove("DEPEND_1");
                attr1.remove("DEPEND_2");
                attr1.remove("DEPEND_3");
            }
        }
        if (!"no".equals(interpMeta = (String)map.get(PARAM_INTERPMETA))) {
            if (svariables == null) {
                CdfUtil.doApplyAttributes(attr1, (MutablePropertyDataSet)result, (String)map.get("slice1"), constraint);
                if (sy != null || sx != null) {
                    result.putProperty("RENDER_TYPE", null);
                }
            } else {
                for (int j = 0; j < svariables.length; ++j) {
                    attrs1 = CdfDataSource.readAttributes(cdf, svariables[j], 0);
                    CdfUtil.doApplyAttributes(attrs1, (MutablePropertyDataSet)result.slice(j), (String)map.get("slice1"), constraint);
                    if (sy == null && sx == null) continue;
                    result.putProperty("RENDER_TYPE", null);
                }
            }
        } else {
            QDataSet dep = (QDataSet)result.property("DEPEND_0");
            if (dep != null && dep.length() != result.length()) {
                result.putProperty("DEPEND_0", null);
            }
            result.putProperty("DEPEND_1", null);
            result.putProperty("DEPEND_2", null);
            result.putProperty("DEPEND_3", null);
            if (svariables == null) {
                result.putProperty("METADATA", attr1);
                result.putProperty("METADATA_MODEL", (Object)"ISTP-CDF");
            } else {
                logger.info("TODO: attributes should appear in each bundled dataset, to be consistent.");
            }
        }
        Class<CdfDataSource> clazz = CdfDataSource.class;
        synchronized (CdfDataSource.class) {
            Units dep1units;
            QDataSet dep1;
            if (attr1 != null && "waveform".equals(attr1.get("DISPLAY_TYPE")) && (dep1 = (QDataSet)result.property("DEPEND_1")) != null && Units.ns != (dep1units = SemanticOps.getUnits((QDataSet)dep1))) {
                ArrayDataSet dep1_ = ArrayDataSet.copy((QDataSet)dep1);
                dep1_.putProperty("VALID_MIN", null);
                dep1_.putProperty("VALID_MAX", null);
                dep1_.putProperty("FILL_VALUE", null);
                while (dep1_.rank() > 0) {
                    dep1_ = (ArrayDataSet)Ops.reduceMax((QDataSet)dep1_, (int)0);
                }
                if (dep1_.value() > 1000000.0) {
                    logger.log(Level.WARNING, "offset units do not appear to be in {0}, using ns", dep1units);
                    ((MutablePropertyDataSet)dep1).putProperty("UNITS", (Object)Units.ns);
                }
            }
            // ** MonitorExit[var16_33] (shouldn't be in output)
            if (!mon.isFinished()) {
                mon.finished();
            }
            return result;
        }
    }

    private static void maybeReplaceLabels(MutablePropertyDataSet ds) {
        for (int i = 1; i < 5; ++i) {
            MutablePropertyDataSet depDs = (MutablePropertyDataSet)((QDataSet)ds.property("DEPEND_" + i));
            MutablePropertyDataSet lablDs = (MutablePropertyDataSet)((QDataSet)ds.property("BUNDLE_" + i));
            if (depDs == null || depDs.rank() != 1 || lablDs == null) continue;
            ds.putProperty("BUNDLE_" + i, null);
        }
    }

    private static boolean hasVariable(CDFReader cdf, String var) {
        List<String> names = Arrays.asList(cdf.getVariableNames());
        return names.contains(var);
    }

    private static Object getAttribute(CDFReader cdf, String attr) {
        try {
            return cdf.getAttribute(attr);
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private Map<String, Object> readXorYAttributes(CDFReader cdf, String var, int depth) {
        int j;
        String[] labels;
        int[] qube;
        MutablePropertyDataSet v;
        boolean labelsAreRead;
        int i = var.indexOf("[");
        String slice1 = null;
        String slice2 = null;
        if (i > -1) {
            Matcher m = Pattern.compile("\\[\\:\\,(\\d+)\\]").matcher(var.substring(i));
            if (m.matches()) {
                slice1 = m.group(1);
            } else {
                m = Pattern.compile("\\[\\:\\,\\:\\,(\\d+)\\]").matcher(var.substring(i));
                if (m.matches()) {
                    slice2 = m.group(1);
                } else {
                    logger.warning("only [:,i] or [:,:,i] supported");
                }
            }
            var = var.substring(0, i);
        }
        HashMap<String, Object> xyAttributes = CdfDataSource.readAttributes(cdf, var, depth);
        if (slice1 != null) {
            String labl_ptr_1 = (String)xyAttributes.get("LABL_PTR_1");
            labelsAreRead = false;
            if (labl_ptr_1 != null) {
                try {
                    v = CdfUtil.loadVariable(cdf, labl_ptr_1);
                    xyAttributes.put(ATTR_SLICE1_LABELS, v);
                    xyAttributes.put("slice1", slice1);
                    labelsAreRead = true;
                }
                catch (Exception ex) {
                    Logger.getLogger(CdfDataSource.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (!labelsAreRead) {
                try {
                    qube = cdf.getDimensions(var);
                    labels = new String[qube[0]];
                    for (j = 0; j < qube[0]; ++j) {
                        labels[j] = "ch_" + j;
                    }
                    xyAttributes.put(ATTR_SLICE1_LABELS, Ops.labelsDataset((String[])labels));
                    xyAttributes.put("slice1", slice1);
                }
                catch (CDFException.ReaderError ex) {
                    Logger.getLogger(CdfDataSource.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (slice2 != null) {
            String labl_ptr_2 = (String)xyAttributes.get("LABL_PTR_2");
            labelsAreRead = false;
            if (labl_ptr_2 != null) {
                try {
                    v = CdfUtil.loadVariable(cdf, labl_ptr_2);
                    xyAttributes.put(ATTR_SLICE2_LABELS, v);
                    xyAttributes.put("slice2", slice2);
                    labelsAreRead = true;
                }
                catch (Exception ex) {
                    Logger.getLogger(CdfDataSource.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (!labelsAreRead) {
                try {
                    qube = cdf.getDimensions(var);
                    labels = new String[qube[0]];
                    for (j = 0; j < qube[0]; ++j) {
                        labels[j] = "ch_" + j;
                    }
                    xyAttributes.put(ATTR_SLICE2_LABELS, Ops.labelsDataset((String[])labels));
                    xyAttributes.put("slice2", slice2);
                }
                catch (CDFException.ReaderError ex) {
                    Logger.getLogger(CdfDataSource.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return xyAttributes;
    }

    private static synchronized HashMap<String, Object> readAttributes(CDFReader cdf, String var, int depth) {
        try {
            boolean[] vvs;
            Object o;
            String[] vv;
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> gattrs = new LinkedHashMap<String, Object>();
            Pattern p = Pattern.compile("DEPEND_[0-9]");
            try {
                vv = cdf.variableAttributeNames(var);
            }
            catch (NullPointerException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
                throw ex;
            }
            Object gattr = CdfDataSource.getAttribute(cdf, "Source_name");
            if (gattr != null && gattr.getClass().isArray() && Array.getLength(gattr) > 0) {
                props.put("Source_name", String.valueOf(Array.get(gattr, 0)));
            }
            if ((gattr = CdfDataSource.getAttribute(cdf, "Descriptor")) != null && gattr.getClass().isArray() && Array.getLength(gattr) > 0) {
                props.put("Descriptor", String.valueOf(Array.get(gattr, 0)));
            }
            for (int ipass = 0; ipass < 2; ++ipass) {
                String[] stringArray = vv;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    Object val;
                    String vv1 = stringArray[i];
                    Object attrv = cdf.getAttribute(var, vv1);
                    boolean isDep = p.matcher(vv1).matches() & depth == 0;
                    if (ipass == 0 && isDep) {
                        String name = (String)((List)attrv).get(0);
                        if (CdfDataSource.hasVariable(cdf, name)) {
                            HashMap<String, Object> newVal = CdfDataSource.readAttributes(cdf, name, depth + 1);
                            newVal.put("NAME", name);
                            props.put(vv1, newVal);
                            continue;
                        }
                        logger.log(Level.FINE, "No such variable: {0} in CDF ", name);
                        continue;
                    }
                    if (ipass != 1 || isDep || (val = ((List)attrv).get(0)) == null) continue;
                    if (val.getClass().isArray() && Array.getLength(val) == 1) {
                        val = Array.get(val, 0);
                    }
                    if ((vv1.equals("VALIDMAX") || vv1.equals("VALIDMIN") || vv1.equals("FILLVAL")) && val instanceof Double && Math.abs((Double)val) > 1.0E20) {
                        val = DasMath.roundNSignificantDigits((double)((Double)val), (int)7);
                    }
                    props.put(vv1, val);
                }
            }
            if (depth == 0) {
                try {
                    vv = cdf.globalAttributeNames();
                }
                catch (NullPointerException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    throw ex;
                }
                for (String vv1 : vv) {
                    try {
                        Object attr = cdf.getAttribute(vv1);
                        if (attr == null || !attr.getClass().isArray() || Array.getLength(attr) <= 0) continue;
                        int n = Array.getLength(attr);
                        if (n > 1) {
                            Object[] oo = new Object[n];
                            for (int ii = 0; ii < n; ++ii) {
                                oo[ii] = Array.get(attr, ii);
                            }
                            gattrs.put(vv1, oo);
                            continue;
                        }
                        gattrs.put(vv1, Array.get(attr, 0));
                    }
                    catch (RuntimeException ex) {
                        logger.log(Level.WARNING, "Runtime exception while trying to read attribute \"{0}\": {1}", new Object[]{vv1, ex.getMessage()});
                    }
                }
                props.put("GlobalAttributes", gattrs);
            }
            if ((o = props.get("UNIT_PTR")) != null && o instanceof String) {
                try {
                    MutablePropertyDataSet v = CdfUtil.loadVariable(cdf, (String)o);
                    props.put("UNIT_PTR_VALUE", v);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            if ((o = props.get("LABL_PTR_1")) != null) {
                try {
                    MutablePropertyDataSet v = CdfUtil.loadVariable(cdf, (String)o);
                    props.put(ATTR_SLICE1_LABELS, v);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            if ((o = props.get("LABL_PTR_2")) != null) {
                try {
                    MutablePropertyDataSet v = CdfUtil.loadVariable(cdf, (String)o);
                    props.put(ATTR_SLICE2_LABELS, v);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            if ((vvs = cdf.getVarys(var)).length > 0) {
                props.put("_Varies", vvs[0]);
            }
            props.put("_BlockingFactor", cdf.getBlockingFactor(var));
            props.put("_Type", CdfUtil.getStringDataType(cdf.getType(var)));
            props.put("_RecCount", cdf.getNumberOfValues(var));
            return props;
        }
        catch (CDFException ex) {
            return new HashMap<String, Object>();
        }
    }

    private static QDataSet getDeltaPlusMinus(CDFReader cdf, QDataSet ds, String deltaPlus, String constraints) throws Exception {
        MutablePropertyDataSet delta = CdfDataSource.loadVariableAndDependents(cdf, deltaPlus, constraints, false, false, null, -1, ds.length(), (ProgressMonitor)new NullProgressMonitor());
        if (delta.rank() > 0 && delta.length() == 1 && (delta.length() != ds.length() || ds.length() == 1)) {
            delta = delta.slice(0);
        }
        if (ds.rank() == 2 && delta.rank() == 1 && delta.length() == ds.length(0)) {
            delta = Ops.replicate((QDataSet)delta, (int)ds.length());
        }
        return delta;
    }

    private static boolean isFinite(double v) {
        return !Double.isInfinite(v) && !Double.isNaN(v);
    }

    private static MutablePropertyDataSet loadVariableAndDependents(CDFReader cdf, String svariable, String constraints, boolean reform) throws Exception, ParseException {
        return CdfDataSource.loadVariableAndDependents(cdf, svariable, constraints, reform, false, null, -1, -1, (ProgressMonitor)new NullProgressMonitor());
    }

    private static boolean someonesDepend0(CDFReader cdf, String svariable) throws CDFException.ReaderError {
        String[] ss;
        cdf.variableAttributeNames(svariable);
        for (String s : ss = cdf.getVariableNames()) {
            String depend0value;
            Object o = cdf.getAttribute(s, "DEPEND_0");
            if (o == null || !(o instanceof Vector) || ((Vector)o).size() != 1 || !(depend0value = String.valueOf(((Vector)o).get(0))).equals(svariable)) continue;
            logger.log(Level.FINER, "some CDF variable ({0}) uses variable as DEPEND_0: {1}", new Object[]{s, svariable});
            return true;
        }
        return false;
    }

    private static boolean reformTest(CDFReader cdf, String svariable, Map<String, Object> thisAttributes) throws CDFException.ReaderError {
        boolean result = true;
        if (thisAttributes.containsKey("DEPEND_0")) {
            Object o = thisAttributes.get("DEPEND_0");
            if (o != null) {
                String dep0;
                int numDep0;
                Object mapo = thisAttributes.get("DEPEND_0");
                if (mapo instanceof Map) {
                    Map so = (Map)mapo;
                    String dep02 = (String)so.get("NAME");
                    int numDep02 = cdf.getNumberOfValues(dep02);
                    if (numDep02 == 1) {
                        result = false;
                    }
                } else if (mapo instanceof String && (numDep0 = cdf.getNumberOfValues(dep0 = (String)mapo)) == 1) {
                    result = false;
                }
            } else {
                String[] dependents = cdf.getDependent(svariable);
                int numDep0 = cdf.getNumberOfValues(dependents[0]);
                if (numDep0 == 1) {
                    result = false;
                }
            }
        } else if (CdfDataSource.someonesDepend0(cdf, svariable)) {
            result = false;
        }
        logger.log(Level.FINE, "reformTest for {0}: {1}", new Object[]{svariable, result});
        return result;
    }

    private static Units maybeGetUnits(Map<String, Object> thisAttributes, MutablePropertyDataSet result, Units units, String svariable, CDFReader cdf) {
        if (thisAttributes.containsKey("UNITS")) {
            String sunits = (String)thisAttributes.get("UNITS");
            Units mu = sunits.equalsIgnoreCase("row number") || sunits.equalsIgnoreCase("column number") ? Units.dimensionless : Units.lookupUnits((String)sunits);
            Units u = (Units)result.property("UNITS");
            if (u == null) {
                result.putProperty("UNITS", (Object)mu);
                units = mu;
            } else {
                units = u;
            }
        } else if (thisAttributes.containsKey("UNIT_PTR")) {
            String svar = (String)thisAttributes.get("UNIT_PTR");
            if (svar != null) {
                logger.log(Level.FINER, "found UNIT_PTR for {0}", svariable);
                boolean okay = true;
                MutablePropertyDataSet s = null;
                try {
                    if (CdfDataSource.hasVariable(cdf, svar)) {
                        s = CdfUtil.loadVariable(cdf, svar, 0L, 1L, 1L, -1, (ProgressMonitor)new NullProgressMonitor());
                        s = s.slice(0);
                        double s1 = s.value(0);
                        for (int i = 1; i < s.length(); ++i) {
                            if (s.value(i) == s1) continue;
                            logger.log(Level.INFO, "units are not all the same, unable to use: {0}", svar);
                            okay = false;
                        }
                    } else {
                        logger.log(Level.INFO, "units variable does not exist: {0}", svar);
                        okay = false;
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    okay = false;
                }
                if (okay) {
                    assert (s != null);
                    units = Units.lookupUnits((String)DataSetUtil.getStringValue((QDataSet)s, (double)s.value(0)));
                    result.putProperty("UNITS", (Object)units);
                } else {
                    units = SemanticOps.getUnits((QDataSet)result);
                }
            } else {
                units = SemanticOps.getUnits((QDataSet)result);
            }
        } else {
            units = SemanticOps.getUnits((QDataSet)result);
        }
        return units;
    }

    private static void maybeAddValidRange(Map<String, Object> thisAttributes, MutablePropertyDataSet result, Units units, boolean loadDependents) {
        DatumRange vrange;
        Object f = thisAttributes.get("FILLVAL");
        double dv = IstpMetadataModel.doubleValue((Object)f, (Units)units, (double)Double.NaN, (Object)IstpMetadataModel.VALUE_MIN);
        if (!Double.isNaN(dv)) {
            result.putProperty("FILL_VALUE", (Object)dv);
        }
        if ((vrange = IstpMetadataModel.getValidRange(thisAttributes, (Units)units)) != null) {
            if (vrange.width().value() <= 0.0) {
                logger.fine("ignoring VALID_MIN and VALID_MAX because they are equal or out of order.");
            } else {
                QDataSet extentds = Ops.extentSimple((QDataSet)result, null);
                if (CdfDataSource.isFinite(extentds.value(0))) {
                    DatumRange extent = DataSetUtil.asDatumRange((QDataSet)extentds);
                    if (loadDependents || extent.intersects(vrange)) {
                        if (UnitsUtil.isTimeLocation((Units)vrange.getUnits())) {
                            if (extent.intersects(vrange)) {
                                result.putProperty("VALID_MIN", (Object)vrange.min().doubleValue(units));
                                result.putProperty("VALID_MAX", (Object)vrange.max().doubleValue(units));
                            }
                        } else {
                            result.putProperty("VALID_MIN", (Object)vrange.min().doubleValue(units));
                            result.putProperty("VALID_MAX", (Object)vrange.max().doubleValue(units));
                        }
                    } else {
                        logger.fine("ignoring VALID_MIN and VALID_MAX because no timetags would be considered valid.");
                    }
                } else {
                    logger.fine("using VALID_MIN and VALID_MAX to indictate that all data is invalid.");
                    result.putProperty("VALID_MIN", (Object)vrange.min().doubleValue(units));
                    result.putProperty("VALID_MAX", (Object)vrange.max().doubleValue(units));
                }
            }
        }
    }

    private static void maybeAddDeltaPlusMinus(boolean loadDependents, Map<String, Object> thisAttributes, String svariable, CDFReader cdf, MutablePropertyDataSet result, String constraints) throws Exception {
        boolean doPlusMinus = !loadDependents;
        Object deltaPlus = thisAttributes.get("DELTA_PLUS_VAR");
        Object deltaMinus = thisAttributes.get("DELTA_MINUS_VAR");
        if (doPlusMinus && deltaPlus != null && deltaPlus instanceof String && !deltaPlus.equals(svariable) && deltaMinus != null && deltaMinus instanceof String && !deltaPlus.equals(svariable)) {
            if (CdfDataSource.hasVariable(cdf, (String)deltaPlus)) {
                QDataSet delta;
                try {
                    delta = CdfDataSource.getDeltaPlusMinus(cdf, (QDataSet)result, (String)deltaPlus, constraints);
                }
                catch (NoDataInIntervalException ex) {
                    logger.log(Level.FINE, "DELTA_PLUS_VAR variable has no records {0}: {1}", new Object[]{svariable, deltaPlus});
                    delta = null;
                }
                if (delta != null) {
                    String plusAttr = !loadDependents ? "BIN_PLUS" : "DELTA_PLUS";
                    String minusAttr = !loadDependents ? "BIN_MINUS" : "DELTA_MINUS";
                    Units deltaUnits = SemanticOps.getUnits((QDataSet)delta);
                    if (UnitsUtil.isRatioMeasurement((Units)deltaUnits) && deltaUnits.isConvertibleTo(SemanticOps.getUnits((QDataSet)result).getOffsetUnits()) && (delta.rank() == 0 || result.length() == delta.length())) {
                        result.putProperty(plusAttr, (Object)delta);
                        if (!deltaMinus.equals(deltaPlus) && (delta = CdfDataSource.getDeltaPlusMinus(cdf, (QDataSet)result, (String)deltaMinus, constraints)).length() == 1 && delta.rank() == 1 && delta.length() != result.length()) {
                            delta = delta.slice(0);
                        }
                        if (SemanticOps.getUnits((QDataSet)delta).isConvertibleTo(SemanticOps.getUnits((QDataSet)result).getOffsetUnits())) {
                            result.putProperty(minusAttr, (Object)delta);
                        } else {
                            result.putProperty(plusAttr, null);
                            logger.log(Level.FINE, "DELTA_MINUS_VAR units are not convertible: {0}", SemanticOps.getUnits((QDataSet)delta));
                        }
                    } else if (!UnitsUtil.isRatioMeasurement((Units)deltaUnits)) {
                        logger.log(Level.FINE, "DELTA_PLUS_VAR units are not ratio measurements having a meaningful zero: {0}", new Object[]{deltaUnits});
                    } else if (result.length() != delta.length()) {
                        logger.log(Level.FINE, "DELTA_PLUS_VAR length ({0,number,#})!= data length ({1,number,#})", new Object[]{delta.length(), result.length()});
                    } else {
                        logger.log(Level.FINE, "DELTA_PLUS_VAR units are not convertible: {0}", SemanticOps.getUnits((QDataSet)delta));
                    }
                }
            } else {
                logger.log(Level.FINE, "DELTA_PLUS_VAR variable is not found for {0}: {1}", new Object[]{svariable, deltaPlus});
            }
        }
    }

    private static synchronized MutablePropertyDataSet loadVariableAndDependents(CDFReader cdf, String svariable, String constraints, boolean reform, boolean loadDependents, Map<String, Object> thisAttributes, int slice1, int expectRec, ProgressMonitor mon) throws Exception, ParseException {
        long[] slice3s;
        int index;
        long[] slice2s;
        Map dep0map;
        MutablePropertyDataSet result;
        boolean slice;
        long[] slice1s;
        logger.log(Level.FINE, "loadVariableAndDependents {0} constraints={1} dependVar={2} slice1={3} reform={4}", new Object[]{svariable, constraints, loadDependents, slice1, reform});
        if (!CdfDataSource.hasVariable(cdf, svariable)) {
            throw new IllegalArgumentException("No such variable: " + svariable);
        }
        if (thisAttributes == null) {
            thisAttributes = CdfDataSource.readAttributes(cdf, svariable, 0);
        }
        long numRec = cdf.getNumberOfValues(svariable);
        if (mon == null) {
            mon = new NullProgressMonitor();
        }
        String displayType = (String)thisAttributes.get("DISPLAY_TYPE");
        if (numRec == 0L) {
            String funct = (String)thisAttributes.get("FUNCTION");
            if (funct == null) {
                funct = (String)thisAttributes.get("FUNCT");
            }
            if (thisAttributes.containsKey("COMPONENT_0") && funct != null) {
                if (funct.startsWith("comp_themis_epoch")) {
                    MutablePropertyDataSet c0 = CdfDataSource.loadVariableAndDependents(cdf, (String)thisAttributes.get("COMPONENT_0"), constraints, true);
                    if (thisAttributes.containsKey("COMPONENT_1")) {
                        MutablePropertyDataSet c1 = CdfDataSource.loadVariableAndDependents(cdf, (String)thisAttributes.get("COMPONENT_1"), constraints, false);
                        if (c0.rank() == 1 && CdfDataSetUtil.validCount((QDataSet)c0, 2) == 1 && c1.length() > 1 && Units.cdfEpoch == (c0 = DataSetOps.slice0((QDataSet)c0, (int)0)).property("UNITS")) {
                            double value = ((RankZeroDataSet)c0).value();
                            double valueUs2000 = Units.cdfEpoch.convertDoubleTo((Units)Units.us2000, value);
                            c0 = DataSetUtil.asDataSet((Datum)Units.us2000.createDatum(valueUs2000));
                        }
                        if (c0.property("UNITS") != null && c1.property("UNITS") != null) {
                            c0 = Ops.add((QDataSet)c0, (QDataSet)c1);
                        }
                    }
                    return DDataSet.maybeCopy((QDataSet)c0);
                }
                return CdfDataSource.getDataSet(null, cdf, svariable, thisAttributes, new HashMap(), mon.getSubtaskMonitor("read virtual var: " + svariable));
            }
            throw new NoDataInIntervalException("variable " + svariable + " contains no records!");
        }
        int[] dimensions = CdfUtil.getDimensions(cdf, svariable);
        long[] ndimensions = new long[dimensions.length + 1];
        ndimensions[0] = numRec;
        for (int i = 0; i < dimensions.length; ++i) {
            ndimensions[i + 1] = dimensions[i];
        }
        Map mc = DataSourceUtil.parseConstraint((String)constraints, (long[])ndimensions);
        if (mc.size() > 1 && (slice1s = (long[])mc.get(1)) != null && slice1s[0] != -1L && slice1s[1] == -1L && slice1s[2] == -1L) {
            slice1 = (int)slice1s[0];
            if (reform) {
                logger.fine("clearing reform flag because of slice1");
                reform = false;
            }
        }
        long[] recs = (long[])mc.get(0);
        if (numRec == 1L) {
            boolean[] varies = cdf.getVarys(svariable);
            if (CdfUtil.getEffectiveRank(varies) == cdf.getNumberOfElements(svariable)) {
                recs[0] = 0L;
            }
            if (CdfUtil.getEffectiveRank(varies) == 0) {
                recs[0] = 0L;
            }
        }
        boolean bl = slice = recs[1] == -1L;
        if (cdf.getDimensions(svariable).length > 0 && slice1 > -1) {
            int n1 = cdf.getDimensions(svariable)[0];
            if ((long)cdf.getType(svariable) == 32L) {
                logger.fine("CDF_EPOCH16, ew...");
            } else if (slice1 >= n1) {
                throw new IllegalArgumentException("slice1=" + slice1 + " is too big for the dimension size (" + n1 + ")");
            }
        }
        long recCount = (recs[1] - recs[0]) / recs[2];
        if (!reform && recs[1] == 1L && ndimensions[ndimensions.length - 1] > 1L && ndimensions.length > 0 && ndimensions[0] == 1L && CdfDataSource.reformTest(cdf, svariable, thisAttributes)) {
            logger.fine("variable is not marked as non-time-varying, but the single record implies it should be.");
            reform = true;
        }
        if (reform) {
            result = CdfUtil.loadVariable(cdf, svariable, 0L, -1L, 1L, slice1, (ProgressMonitor)new NullProgressMonitor());
        } else {
            if (slice) {
                recCount = -1L;
                recs[2] = 1L;
            }
            result = CdfUtil.loadVariable(cdf, svariable, recs[0], recCount, recs[2], slice1, mon);
        }
        if (slice1 > -1) {
            result.putProperty("NAME", (Object)(svariable + "__" + slice1));
            QDataSet ll = (QDataSet)thisAttributes.get(ATTR_SLICE1_LABELS);
            if (ll != null) {
                result.putProperty("LABEL", (Object)ll.slice(slice1).svalue());
            }
        } else {
            result.putProperty("NAME", (Object)svariable);
        }
        boolean doUnits = true;
        Units units = null;
        units = CdfDataSource.maybeGetUnits(thisAttributes, result, units, svariable, cdf);
        CdfDataSource.maybeAddValidRange(thisAttributes, result, units, loadDependents);
        if (slice && loadDependents && (dep0map = (Map)thisAttributes.get("DEPEND_0")) != null) {
            MutablePropertyDataSet dep0 = CdfDataSource.loadVariableAndDependents(cdf, (String)dep0map.get("NAME"), constraints, false, false, null, -1, result.length(), (ProgressMonitor)new NullProgressMonitor());
            result.putProperty("CONTEXT_0", (Object)dep0);
        }
        CdfDataSource.maybeAddDeltaPlusMinus(loadDependents, thisAttributes, svariable, cdf, result, constraints);
        int[] qubeDims = DataSetUtil.qubeDims((QDataSet)result);
        if (loadDependents) {
            int maybeShift = 0;
            for (int idep = 0; idep <= dimensions.length; ++idep) {
                MutablePropertyDataSet bundleDs;
                MutablePropertyDataSet b;
                int sidep = idep;
                Map depAttr = (Map)thisAttributes.get("DEPEND_" + (sidep + maybeShift));
                Object oo = thisAttributes.get("LABL_PTR_" + (sidep + maybeShift));
                if (idep == 0 && depAttr == null) {
                    maybeShift = 1;
                    depAttr = (Map)thisAttributes.get("DEPEND_" + (sidep + maybeShift));
                    oo = thisAttributes.get("LABL_PTR_" + (sidep + maybeShift));
                }
                MutablePropertyDataSet lablDs = null;
                String labl = null;
                if (oo instanceof MutablePropertyDataSet) {
                    labl = (String)((MutablePropertyDataSet)oo).property("NAME");
                } else if (oo instanceof String) {
                    if (CdfDataSource.hasVariable(cdf, (String)oo)) {
                        labl = (String)oo;
                    } else {
                        logger.log(Level.FINE, "LABL_PTR_{0} pointed to non-existant variable {1}", new Object[]{sidep, oo});
                    }
                }
                if (labl == null) {
                    labl = (String)thisAttributes.get("LABEL_" + sidep);
                }
                if (labl != null) {
                    try {
                        lablDs = CdfDataSource.loadVariableAndDependents(cdf, labl, constraints, idep > 0);
                    }
                    catch (Exception ex) {
                        logger.log(Level.FINE, "unable to load LABL_PTR_" + sidep + " for " + svariable, ex);
                        thisAttributes.remove("LABL_PTR_" + sidep);
                    }
                    if (lablDs != null && lablDs.length() < 4 && displayType == null) {
                        logger.log(Level.FINER, "setting null displayType to time_series");
                        displayType = "time_series";
                    }
                }
                MutablePropertyDataSet depDs = null;
                logger.log(Level.FINER, "displayType={0}", displayType);
                if (depAttr != null) {
                    boolean reformDep;
                    String depName = (String)depAttr.get("NAME");
                    if (!CdfDataSource.hasVariable(cdf, depName)) {
                        logger.log(Level.FINE, "unable to find variable \"{0}\" for DEPEND_{1} of {2}", new Object[]{depName, sidep, svariable});
                        continue;
                    }
                    boolean bl2 = reformDep = idep > 0;
                    if (reformDep && cdf.recordVariance(depName)) {
                        reformDep = false;
                    }
                    depDs = CdfDataSource.loadVariableAndDependents(cdf, depName, constraints, reformDep, false, depAttr, -1, result.length(), null);
                    if (!(idep <= 0 || reformDep || depDs.length() != 1 || qubeDims[0] != 1 && qubeDims[0] <= depDs.length())) {
                        depDs = (MutablePropertyDataSet)depDs.slice(0);
                    }
                    if (depDs.rank() == 2 && depDs.length() == 2 && qubeDims[idep] == depDs.length(0)) {
                        depDs = Ops.maybeCopy((QDataSet)Ops.transpose((QDataSet)depDs));
                        depDs.putProperty("BINS_1", (Object)"min,max");
                    }
                    if (depDs.rank() > 1 && result.rank() > 2 && !cdf.recordVariance(depName) && depDs.length() == result.length(0) && depDs.length(0) == result.length(0, 0)) {
                        depDs = Ops.replicate((QDataSet)depDs, (int)result.length());
                    }
                    if (idep == 0 && result.length() == 1 && cdf.getNumberOfValues(svariable) == 1 && depDs.length() > 1) {
                        logger.fine("it looks like the variable should repeat to match DEPEND_0");
                        ReplicateDataSet nresult = result.rank() > 1 ? new ReplicateDataSet(result.slice(0), depDs.length()) : new ReplicateDataSet((QDataSet)result, depDs.length());
                        result = nresult;
                    }
                    if (DataSetUtil.isMonotonic((QDataSet)depDs)) {
                        depDs.putProperty("MONOTONIC", (Object)Boolean.TRUE);
                    } else {
                        logger.log(Level.FINE, "data has dependency which is non-monotonic: {0}", depName);
                        depDs.putProperty("MONOTONIC", (Object)Boolean.FALSE);
                    }
                    if (slice1 < 0) {
                        boolean dim0lengthCheck;
                        int[] depDsDims = DataSetUtil.qubeDims((QDataSet)depDs);
                        boolean bl3 = dim0lengthCheck = constraints != null || (long)depDsDims[0] == ndimensions[idep + maybeShift];
                        if (idep == 0) {
                            if (depDs.rank() == 1 && idep < ndimensions.length && dim0lengthCheck) {
                                result.putProperty("DEPEND_" + idep, (Object)depDs);
                            } else if (depDs.rank() == 2 && idep < ndimensions.length && (long)depDsDims[0] == ndimensions[0] && depDsDims[0] != 1) {
                                result.putProperty("DEPEND_" + idep, (Object)depDs);
                            }
                        } else {
                            result.putProperty("DEPEND_" + idep, (Object)depDs);
                        }
                    } else {
                        if (idep == 1) {
                            if (depDs.rank() == 0) {
                                result.putProperty("CONTEXT_0", (Object)depDs);
                            } else {
                                result.putProperty("CONTEXT_0", (Object)depDs.slice(slice1));
                            }
                        } else if (idep > 1) {
                            result.putProperty("DEPEND_" + (idep - 1), (Object)depDs);
                        } else {
                            result.putProperty("DEPEND_" + idep, (Object)depDs);
                        }
                        if (idep == 0) {
                            thisAttributes.remove("LABL_PTR_1");
                        }
                    }
                }
                if (lablDs == null || depDs != null && depDs.rank() != 2 && (depDs.rank() != 1 || depDs.length() >= 100)) continue;
                if (depDs != null && lablDs.rank() == 1 && depDs.rank() == 2 && DataSetUtil.asDatum((QDataSet)lablDs.slice(0)).toString().equals("channel00") && (b = IstpMetadataModel.maybeReduceRank2(depDs)) != null) {
                    lablDs = b;
                }
                if (depDs != null && lablDs.rank() == 1 && depDs.rank() == 2 && DataSetUtil.asDatum((QDataSet)lablDs.slice(0)).toString().equals("channel00")) {
                    QDataSet ex;
                    int i0;
                    QDataSet wds = SemanticOps.weightsDataSet(depDs);
                    int l0 = (wds.length(0) - 1) * 1 / 8;
                    int l1 = (wds.length(0) - 1) * 7 / 8;
                    for (i0 = 0; !(i0 >= depDs.length() || wds.value(i0, l0) > 0.0 && wds.value(i0, l1) > 0.0); ++i0) {
                    }
                    if (i0 < depDs.length() && (ex = Ops.extent((QDataSet)DataSetOps.slice1((QDataSet)depDs, (int)0))).value(0) == ex.value(1)) {
                        lablDs = (MutablePropertyDataSet)depDs.slice(i0);
                    }
                }
                if (slice1 < 0) {
                    bundleDs = lablDs;
                    if (reform && result.rank() <= idep) {
                        result.putProperty("BUNDLE_" + (idep - 1), (Object)DataSetUtil.toBundleDs((QDataSet)bundleDs));
                        continue;
                    }
                    result.putProperty("BUNDLE_" + idep, (Object)DataSetUtil.toBundleDs((QDataSet)bundleDs));
                    continue;
                }
                if (idep == 1) continue;
                if (idep > 1) {
                    bundleDs = lablDs;
                    result.putProperty("BUNDLE_" + (idep - 1), (Object)DataSetUtil.toBundleDs((QDataSet)bundleDs));
                    continue;
                }
                bundleDs = lablDs;
                result.putProperty("BUNDLE_" + idep, (Object)DataSetUtil.toBundleDs((QDataSet)bundleDs));
            }
        }
        if (mc.size() == 3 && result.rank() == 3 && (slice2s = (long[])mc.get(2)) != null && slice2s[0] != -1L && slice2s[1] == -1L && slice2s[2] == -1L) {
            index = (int)slice2s[0];
            result = Ops.copy((QDataSet)Ops.slice2((QDataSet)result, (int)index));
        }
        if (mc.size() == 4 && result.rank() == 4 && (slice3s = (long[])mc.get(3)) != null && slice3s[0] != -1L && slice3s[1] == -1L && slice3s[2] == -1L) {
            index = (int)slice3s[0];
            result = Ops.copy((QDataSet)Ops.slice3((QDataSet)result, (int)index));
        }
        boolean swapHack = false;
        if (result.rank() == 3) {
            int n1 = result.length(0);
            int n2 = result.length(0, 0);
            QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
            QDataSet dep2 = (QDataSet)result.property("DEPEND_2");
            if (n1 != n2 && dep1 != null && dep1.length() == n2 && dep2 != null && dep2.length() == n1) {
                swapHack = true;
                logger.fine("swaphack avoids runtime error");
            }
        }
        if (slice && result.rank() == 2) {
            int n0 = result.length();
            int n1 = result.length(0);
            QDataSet dep0 = (QDataSet)result.property("DEPEND_0");
            QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
            if (n0 != n1 && dep0 != null && dep0.length() == n1 && dep1 != null && dep1.length() == n0) {
                swapHack = true;
                logger.fine("swaphack avoids runtime error");
            }
        }
        if (swapHack && result.rank() == 3) {
            QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
            QDataSet dep2 = (QDataSet)result.property("DEPEND_2");
            result.putProperty("DEPEND_2", (Object)dep1);
            result.putProperty("DEPEND_1", (Object)dep2);
            Object att1 = thisAttributes.get("DEPEND_1");
            Object att2 = thisAttributes.get("DEPEND_2");
            thisAttributes.put("DEPEND_1", att2);
            thisAttributes.put("DEPEND_2", att1);
        }
        if (swapHack && slice && result.rank() == 2) {
            QDataSet dep0 = (QDataSet)result.property("DEPEND_0");
            QDataSet dep1 = (QDataSet)result.property("DEPEND_1");
            result.putProperty("DEPEND_1", (Object)dep0);
            result.putProperty("DEPEND_0", (Object)dep1);
            Object att0 = thisAttributes.get("DEPEND_0");
            Object att1 = thisAttributes.get("DEPEND_1");
            thisAttributes.put("DEPEND_0", att1);
            thisAttributes.put("DEPEND_1", att0);
        }
        for (int idep = 1; idep < result.rank(); ++idep) {
            QDataSet depDs = (QDataSet)result.property("DEPEND_" + idep);
            if (result.length() == 2 || depDs == null || depDs.rank() != 2 || depDs.length(0) != 2 || depDs.length() != qubeDims[idep]) continue;
            logger.warning("applying min,max kludge for old LANL cdf files");
            MutablePropertyDataSet binmax = DataSetOps.slice1((QDataSet)depDs, (int)1);
            MutablePropertyDataSet binmin = DataSetOps.slice1((QDataSet)depDs, (int)0);
            MutablePropertyDataSet depDs1 = DataSetOps.makePropertiesMutable((QDataSet)Ops.add((QDataSet)binmin, (QDataSet)Ops.divide((Object)Ops.subtract((QDataSet)binmax, (QDataSet)binmin), (Object)2)));
            depDs1.putProperty("DELTA_MINUS", (Object)Ops.subtract((QDataSet)depDs1, (QDataSet)binmin));
            depDs1.putProperty("DELTA_PLUS", (Object)Ops.subtract((QDataSet)binmax, (QDataSet)depDs1));
            depDs = depDs1;
            result.putProperty("DEPEND_" + idep, (Object)depDs);
        }
        return result;
    }

    public MetadataModel getMetadataModel() {
        return new IstpMetadataModel();
    }

    public synchronized Map<String, Object> getMetadata(ProgressMonitor mon) throws IOException {
        if (this.attributes == null) {
            try {
                File cdfFile = this.getFile(mon);
                String fileName = cdfFile.toString();
                Map map = this.getParams();
                if (map.containsKey("slice1")) {
                    return null;
                }
                CDFReader cdf = CdfDataSource.getCdfFile(fileName);
                String svariable = (String)map.get(PARAM_ID);
                if (svariable == null) {
                    svariable = (String)map.get("arg_0");
                }
                if (svariable == null) {
                    throw new IllegalArgumentException("variable not specified");
                }
                int i = svariable.indexOf("[");
                if (i != -1) {
                    svariable = svariable.substring(0, i);
                }
                if ((i = svariable.lastIndexOf(";")) != -1) {
                    return Collections.emptyMap();
                }
                if (!CdfDataSource.hasVariable(cdf, svariable)) {
                    throw new IllegalArgumentException("No such variable \"" + svariable + "\"");
                }
                this.attributes = CdfDataSource.readAttributes(cdf, svariable, 0);
                if (map.containsKey(PARAM_X)) {
                    String s = (String)map.get(PARAM_X);
                    i = s.indexOf("[");
                    if (i != -1) {
                        s = s.substring(0, i);
                    }
                    HashMap<String, Object> dep0m = CdfDataSource.readAttributes(cdf, s, 0);
                    this.attributes.put("DEPEND_0", dep0m);
                }
                if ("no".equals(map.get(PARAM_INTERPMETA))) {
                    this.attributes.remove("DEPEND_0");
                    this.attributes.remove("DEPEND_1");
                    this.attributes.remove("DEPEND_2");
                    this.attributes.remove("DEPEND_3");
                    this.attributes.remove("DEPEND_4");
                }
                if (map.containsKey(PARAM_X)) {
                    this.attributes.remove("DEPEND_0");
                }
                if (map.containsKey(PARAM_Y)) {
                    this.attributes.remove("DEPEND_1");
                }
                return this.attributes;
            }
            catch (IOException | IllegalArgumentException ex) {
                if (ex instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)ex;
                }
                ex.printStackTrace();
                throw ex;
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(this.attributes);
        if (this.attributes.get("slice1") != null && String.valueOf(this.attributes.get("slice1")).length() > 0) {
            for (int i = 1; i < 3; ++i) {
                Object o = this.attributes.get("DEPEND_" + (i + 1));
                if (o == null) continue;
                result.put("DEPEND_" + i, o);
            }
        }
        return result;
    }

    private QDataSet labelToBundleDs(QDataSet depDs) {
        IDataSet result = IDataSet.createRank2((int)depDs.length(), (int)1);
        Units u = (Units)depDs.property("UNITS");
        for (int i = 0; i < depDs.length(); ++i) {
            String labl1 = u.createDatum(depDs.value()).toString();
            result.putProperty("LABEL__" + i, (Object)labl1);
            result.putProperty("NAME__" + i, (Object)Ops.safeName((String)labl1));
            result.putValue(i, 0, 1.0);
        }
        return result;
    }

    public static void checkCdf(File cdfFile) throws IOException {
        byte[] magic = new byte[4];
        if (cdfFile.length() < 4L) {
            throw new IllegalArgumentException("CDF file is empty");
        }
        try (FileInputStream in = new FileInputStream(cdfFile);){
            int n = ((InputStream)in).read(magic);
            if (n == 4) {
                if ((magic[0] & 0xFF) == 205 && (magic[1] & 0xFF) == 243) {
                    logger.fine("V2.6 or newer");
                } else {
                    if (magic[0] == 67 && magic[1] == 68 && magic[2] == 70) {
                        throw new IllegalArgumentException("File appears to be NetCDF, use vap+nc:");
                    }
                    if (magic[1] == 72 && magic[2] == 68 && magic[3] == 70) {
                        throw new IllegalArgumentException("File appears to be NetCDF (on HDF), use vap+nc:");
                    }
                    if (magic[0] == 0 && magic[1] == 0 && magic[2] == -1 && magic[3] == -1) {
                        logger.fine("pre-V2.6");
                    } else if ((magic[0] & 0xFF) == 204 && (magic[1] & 0xFF) == 204 && (magic[2] & 0xFF) == 0 && (magic[3] & 0xFF) == 1) {
                        logger.fine("compressed");
                    }
                }
            }
        }
    }
}

