/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdf;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.autoplot.datasource.DataSourceFormatEditorPanel;
import org.autoplot.datasource.URISplit;
import org.jdesktop.layout.GroupLayout;

public class CdfDataSourceFormatEditorPanel
extends JPanel
implements DataSourceFormatEditorPanel {
    String file;
    private JCheckBox bundleCB;
    private JCheckBox epochTimeTagsCB;
    private JCheckBox insertCB;
    private JLabel jLabel1;
    private JCheckBox majorityCB;
    private JComboBox typeComboBox;

    public CdfDataSourceFormatEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.typeComboBox = new JComboBox();
        this.insertCB = new JCheckBox();
        this.epochTimeTagsCB = new JCheckBox();
        this.bundleCB = new JCheckBox();
        this.majorityCB = new JCheckBox();
        this.setName("dataSourceFormatEditorPanel");
        this.jLabel1.setText("Type:");
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"double", "float", "int4", "int2", "byte"}));
        this.insertCB.setText("Insert instead of overwriting existing cdf file, allowing skeleton to be used.");
        this.epochTimeTagsCB.setText("Use legacy Epoch timetags instead of TT2000");
        this.bundleCB.setText("Unpack bundled data into separate variables");
        this.majorityCB.setText("Use row majority (faster in some situations)");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.typeComboBox, -2, 123, -2)).add((Component)this.insertCB).add((Component)this.epochTimeTagsCB).add((Component)this.bundleCB).add((Component)this.majorityCB)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.typeComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.insertCB).addPreferredGap(0).add((Component)this.epochTimeTagsCB).addPreferredGap(0).add((Component)this.bundleCB).addPreferredGap(0).add((Component)this.majorityCB).addContainerGap(154, Short.MAX_VALUE)));
    }

    public JPanel getPanel() {
        return this;
    }

    private String getParam(Map<String, String> args, String name, String defl) {
        String s = args.get(name);
        if (s == null) {
            return defl;
        }
        return s;
    }

    public void setURI(String uri) {
        URISplit split = URISplit.parse((String)uri);
        LinkedHashMap args = URISplit.parseParams((String)split.params);
        String s = this.getParam(args, "type", "double");
        this.typeComboBox.setSelectedItem(s);
        s = this.getParam(args, "append", "F");
        this.insertCB.setSelected(s.equals("T"));
        s = this.getParam(args, "timeType", "tt2000");
        this.epochTimeTagsCB.setSelected(s.equals("epoch"));
        s = this.getParam(args, "bundle", "F");
        this.bundleCB.setSelected(s.equals("T"));
        s = this.getParam(args, "marjority", "column");
        this.majorityCB.setSelected(s.equals("row"));
        this.file = split.file;
    }

    public String getURI() {
        String result = this.file;
        HashMap<String, String> args = new HashMap<String, String>();
        String s = (String)this.typeComboBox.getSelectedItem();
        if (!s.equals("double")) {
            args.put("type", s);
        }
        if (this.insertCB.isSelected()) {
            args.put("append", "T");
        } else {
            args.remove("append");
        }
        if (this.epochTimeTagsCB.isSelected()) {
            args.put("timeType", "epoch");
        } else {
            args.remove("timeType");
        }
        if (this.bundleCB.isSelected()) {
            args.put("bundle", "T");
        } else {
            args.remove("bundle");
        }
        if (this.majorityCB.isSelected()) {
            args.put("majority", "row");
        } else {
            args.remove("majority");
        }
        String params = URISplit.formatParams(args);
        if (result == null) {
            result = "file:///";
        }
        URISplit ss = URISplit.parse((String)result);
        if (params.length() > 0) {
            ss.params = params;
        }
        return URISplit.format((URISplit)ss);
    }
}

