/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdf;

import gov.nasa.gsfc.spdf.cdfj.AttributeEntry;
import gov.nasa.gsfc.spdf.cdfj.CDFException;
import gov.nasa.gsfc.spdf.cdfj.CDFReader;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.cdf.CdfDataSource;
import org.autoplot.cdf.CdfVirtualVars;
import org.autoplot.cdf.TrArrayDataSet;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.metatree.IstpMetadataModel;
import org.das2.datum.DatumRange;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.Slice0DataSet;
import org.das2.qds.buffer.BufferDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class CdfUtil {
    private static final Logger logger = LoggerManager.getLogger((String)"apdss.cdf");
    public static final String OPTION_INCLUDE_EMPTY_RECORDS = "includeEmptyRecords";
    public static final String OPTION_IS_MASTER = "isMaster";
    public static final String OPTION_DEEP = "deep";
    public static final String OPTION_DATA_ONLY = "dataOnly";
    public static final String OPTION_RANK_LIMIT = String.valueOf(4);

    private static String getTargetType(int type) {
        switch (type) {
            case 22: 
            case 31: 
            case 45: {
                return "double";
            }
            case 32: {
                return "double";
            }
            case 21: 
            case 44: {
                return "float";
            }
            case 14: {
                return "double";
            }
            case 8: 
            case 33: {
                return "long";
            }
            case 4: 
            case 12: {
                return "int";
            }
            case 2: 
            case 11: {
                return "short";
            }
            case 1: 
            case 41: {
                return "byte";
            }
            case 51: 
            case 52: {
                return "string";
            }
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    private static Object byteBufferType(int type) {
        switch (type) {
            case 22: 
            case 31: 
            case 45: {
                return BufferDataSet.DOUBLE;
            }
            case 21: 
            case 44: {
                return BufferDataSet.FLOAT;
            }
            case 14: {
                return BufferDataSet.DOUBLE;
            }
            case 8: 
            case 33: {
                return BufferDataSet.LONG;
            }
            case 4: 
            case 12: {
                return BufferDataSet.INT;
            }
            case 2: 
            case 11: {
                return BufferDataSet.SHORT;
            }
            case 1: 
            case 41: {
                return BufferDataSet.BYTE;
            }
            case 51: {
                return BufferDataSet.BYTE;
            }
            case 52: {
                return BufferDataSet.BYTE;
            }
            case 32: {
                return BufferDataSet.DOUBLE;
            }
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    private static ByteBuffer transpose(int recLenBytes, int[] qube, ByteBuffer byteBuffer, Object bbType) {
        if (qube.length < 3) {
            return byteBuffer;
        }
        ByteBuffer temp = ByteBuffer.allocate(recLenBytes);
        ByteBuffer result = ByteBuffer.allocate(recLenBytes * qube[0]);
        result.order(byteBuffer.order());
        int fieldBytes = BufferDataSet.byteCount((Object)bbType);
        switch (qube.length) {
            case 3: {
                int len1 = qube[1];
                int len2 = qube[2];
                for (int i0 = 0; i0 < qube[0]; ++i0) {
                    for (int i1 = 0; i1 < qube[1]; ++i1) {
                        for (int i2 = 0; i2 < qube[2]; ++i2) {
                            int iin = fieldBytes * (i1 * len2 + i2);
                            int iout = fieldBytes * (i0 * len1 * len2 + i2 * len1 + i1);
                            for (int j = 0; j < fieldBytes; ++j) {
                                temp.put(iin + j, byteBuffer.get(iout + j));
                            }
                        }
                    }
                    result.put(temp);
                    temp.flip();
                }
                break;
            }
            case 4: {
                int len1 = qube[1];
                int len2 = qube[2];
                int len3 = qube[3];
                for (int i0 = 0; i0 < qube[0]; ++i0) {
                    for (int i1 = 0; i1 < qube[1]; ++i1) {
                        for (int i2 = 0; i2 < qube[2]; ++i2) {
                            for (int i3 = 0; i3 < qube[3]; ++i3) {
                                int iin = fieldBytes * (i1 * len2 * len3 + i2 * len3 + i3);
                                int iout = fieldBytes * (i0 * len1 * len2 * len3 + i3 * len2 * len1 + i2 * len1 + i1);
                                for (int j = 0; j < fieldBytes; ++j) {
                                    temp.put(iin + j, byteBuffer.get(iout + j));
                                }
                            }
                        }
                    }
                    result.put(temp);
                    temp.flip();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("number of dimensions must be less than 5: " + qube.length);
            }
        }
        result.flip();
        return result;
    }

    private static ByteBuffer myGetBuffer(CDFReader cdf, String svariable, long recStart, int recStop, int recInterval) throws CDFException.ReaderError {
        ByteBuffer result;
        String stype = CdfUtil.getTargetType(cdf.getType(svariable));
        Object buff3 = cdf.getSampled(svariable, (int)recStart, recStop - 1, recInterval, stype, true);
        int type = cdf.getType(svariable);
        switch (type) {
            case 14: 
            case 22: 
            case 31: 
            case 32: 
            case 45: {
                double[] array = (double[])buff3;
                result = ByteBuffer.allocate(8 * array.length);
                for (double a : array) {
                    result.putDouble(a);
                }
                break;
            }
            case 21: 
            case 44: {
                float[] farray = (float[])buff3;
                result = ByteBuffer.allocate(4 * farray.length);
                for (float a : farray) {
                    result.putFloat(a);
                }
                break;
            }
            case 8: 
            case 33: {
                long[] larray = (long[])buff3;
                result = ByteBuffer.allocate(8 * larray.length);
                for (long a : larray) {
                    result.putLong(a);
                }
                break;
            }
            case 4: 
            case 12: {
                int[] iarray = (int[])buff3;
                result = ByteBuffer.allocate(4 * iarray.length);
                for (int a : iarray) {
                    result.putInt(a);
                }
                break;
            }
            case 2: 
            case 11: {
                short[] sarray = (short[])buff3;
                result = ByteBuffer.allocate(2 * sarray.length);
                for (short a : sarray) {
                    result.putShort(a);
                }
                break;
            }
            case 1: 
            case 41: 
            case 51: 
            case 52: {
                byte[] barray = (byte[])buff3;
                result = ByteBuffer.allocate(1 * barray.length);
                for (byte a : barray) {
                    result.put(a);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("not implemented: " + type);
            }
        }
        result.flip();
        return result;
    }

    private static double doubleValue(Object o) {
        if (o instanceof Float) {
            return ((Float)o).doubleValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Short) {
            return ((Short)o).doubleValue();
        }
        if (o instanceof String) {
            return Double.parseDouble((String)o);
        }
        throw new RuntimeException("Unsupported Data Type: " + o.getClass().getName());
    }

    public static DatumRange getRange(HashMap attrs) {
        DatumRange range = attrs.containsKey("SCALEMIN") && attrs.containsKey("SCALEMAX") ? new DatumRange(CdfUtil.doubleValue(attrs.get("SCALEMIN")), CdfUtil.doubleValue(attrs.get("SCALEMAX")), Units.dimensionless) : new DatumRange(CdfUtil.doubleValue(attrs.get("VALIDMIN")), CdfUtil.doubleValue(attrs.get("VALIDMAX")), Units.dimensionless);
        return range;
    }

    public static String getScaleType(HashMap attrs) {
        String type = "linear";
        if (attrs.containsKey("SCALETYP")) {
            type = (String)attrs.get("SCALETYP");
        }
        return type;
    }

    public static void maybeAddValidRange(Map<String, Object> props, MutablePropertyDataSet ds) {
        String t;
        Number nmin;
        UnitsConverter uc;
        Units pu = (Units)props.get("UNITS");
        Units u = (Units)ds.property("UNITS");
        if (pu == null || u == null) {
            uc = UnitsConverter.IDENTITY;
        } else if (u == Units.cdfEpoch) {
            uc = UnitsConverter.IDENTITY;
        } else if (pu == Units.microseconds && u == Units.us2000) {
            uc = UnitsConverter.IDENTITY;
        } else if (pu == u) {
            uc = UnitsConverter.IDENTITY;
        } else {
            if (UnitsUtil.isOrdinalMeasurement((Units)u) || UnitsUtil.isOrdinalMeasurement((Units)pu)) {
                return;
            }
            try {
                uc = UnitsConverter.getConverter((Units)pu, (Units)u);
            }
            catch (InconvertibleUnitsException ex) {
                uc = UnitsConverter.IDENTITY;
            }
        }
        double dmin = Double.NEGATIVE_INFINITY;
        double dmax = Double.POSITIVE_INFINITY;
        if (ds.rank() == 1 && ds.length() > 0) {
            QDataSet range = Ops.extent((QDataSet)ds, null, null);
            dmin = uc.convert(range.value(0));
            dmax = uc.convert(range.value(1));
        }
        double vmin = (nmin = (Number)props.get("VALID_MIN")) == null ? Double.POSITIVE_INFINITY : nmin.doubleValue();
        Number nmax = (Number)props.get("VALID_MAX");
        double vmax = nmax == null ? Double.POSITIVE_INFINITY : nmax.doubleValue();
        boolean intersects = false;
        if (dmax > vmin && dmin < vmax) {
            intersects = true;
        }
        if (u instanceof EnumerationUnits) {
            EnumerationUnits eu = (EnumerationUnits)u;
            if (nmax != null && nmax.intValue() <= eu.getHighestOrdinal()) {
                nmax = eu.getHighestOrdinal() + 1;
            }
        }
        if (intersects || dmax == dmin || dmax < -1.0E30 || dmin > 1.0E30) {
            if (nmax != null) {
                ds.putProperty("VALID_MAX", (Object)uc.convert(nmax));
            }
            if (nmin != null) {
                ds.putProperty("VALID_MIN", (Object)uc.convert(nmin));
            }
        }
        if ((t = (String)props.get("SCALE_TYPE")) != null) {
            ds.putProperty("SCALE_TYPE", (Object)t);
        }
    }

    protected static int sizeOf(long itype) {
        int sizeBytes;
        if (itype == 32L) {
            sizeBytes = 16;
        } else if (itype == 45L || itype == 22L || itype == 31L || itype == 33L || itype == 8L || itype == 14L) {
            sizeBytes = 8;
        } else if (itype == 44L || itype == 21L || itype == 4L || itype == 12L) {
            sizeBytes = 4;
        } else if (itype == 2L || itype == 11L || itype == 52L) {
            sizeBytes = 2;
        } else if (itype == 1L || itype == 41L || itype == 51L) {
            sizeBytes = 1;
        } else {
            throw new IllegalArgumentException("didn't code for type");
        }
        return sizeBytes;
    }

    private static long sizeOf(int dims, int[] dimSizes, long itype, long rc) {
        long size = dims == 0 ? rc : rc * (long)DataSetUtil.product((int[])dimSizes);
        return size *= (long)CdfUtil.sizeOf(itype);
    }

    protected static int getEffectiveRank(boolean[] varies) {
        int rank = 0;
        for (int i = 0; i < varies.length; ++i) {
            if (!varies[i]) continue;
            ++rank;
        }
        return rank;
    }

    private static ByteBuffer doSlice1(ByteBuffer buf, long varType, int[] qube, int slice1, boolean rowMajority) {
        int recSizeBytes = DataSetUtil.product((int[])qube) / qube[0] * CdfUtil.sizeOf(varType);
        ByteBuffer result = ByteBuffer.allocate(recSizeBytes / qube[1] * qube[0]);
        result.order(buf.order());
        if (rowMajority) {
            int p1 = slice1 * recSizeBytes / qube[1];
            int p2 = slice1 * recSizeBytes / qube[1] + recSizeBytes / qube[1];
            for (int irec = 0; irec < qube[0]; ++irec) {
                buf.limit(irec * recSizeBytes + p2);
                buf.position(irec * recSizeBytes + p1);
                ByteBuffer b = buf.slice();
                result.put(b);
            }
        } else {
            int varSize = CdfUtil.sizeOf(varType);
            for (int irec = 0; irec < qube[0]; ++irec) {
                for (int j = 0; j < recSizeBytes; ++j) {
                    if (j / varSize % qube[1] != slice1) continue;
                    result.put(buf.get(irec * recSizeBytes + j));
                }
            }
        }
        result.flip();
        buf.position(0);
        buf.limit(recSizeBytes * qube[0]);
        return result;
    }

    private static ByteBuffer doComponentSlice(ByteBuffer buf, long varType, int[] qube, int componentSlice, boolean rowMajority) {
        int recSizeBytes = DataSetUtil.product((int[])qube) / qube[0] * CdfUtil.sizeOf(varType);
        int newRecSizeBytes = recSizeBytes / qube[qube.length - 1];
        ByteBuffer result = ByteBuffer.allocate(newRecSizeBytes * qube[0]);
        result.order(buf.order());
        if (rowMajority) {
            int p1 = componentSlice * newRecSizeBytes;
            int p2 = (componentSlice + 1) * newRecSizeBytes + newRecSizeBytes;
            for (int irec = 0; irec < qube[0]; ++irec) {
                if (qube.length == 2) {
                    buf.limit(irec * recSizeBytes + p2);
                    buf.position(irec * recSizeBytes + p1);
                    ByteBuffer b = buf.slice();
                    result.put(b);
                    continue;
                }
                int offset = qube[2] * CdfUtil.sizeOf(varType);
                for (int i = 0; i < qube[1]; ++i) {
                    buf.limit(irec * recSizeBytes + i * offset + p2);
                    buf.position(irec * recSizeBytes + i * offset + p1);
                    ByteBuffer b = buf.slice();
                    result.put(b);
                }
            }
        } else {
            int varSize = CdfUtil.sizeOf(varType);
            int componentDimensionSize = qube[qube.length - 1];
            for (int irec = 0; irec < qube[0]; ++irec) {
                for (int j = 0; j < recSizeBytes; ++j) {
                    if (j / varSize % componentDimensionSize != componentSlice) continue;
                    result.put(buf.get(irec * recSizeBytes + j));
                }
            }
        }
        result.flip();
        buf.position(0);
        buf.limit(recSizeBytes * qube[0]);
        return result;
    }

    public static synchronized MutablePropertyDataSet wrapCdfData(CDFReader cdf, String svariable) throws Exception {
        return CdfUtil.loadVariable(cdf, svariable, 0L, -1L, 1L, -1, (ProgressMonitor)new NullProgressMonitor());
    }

    public static synchronized MutablePropertyDataSet loadVariable(CDFReader cdf, String svariable) throws Exception {
        return CdfUtil.loadVariable(cdf, svariable, 0L, -1L, 1L, -1, (ProgressMonitor)new NullProgressMonitor());
    }

    public static synchronized MutablePropertyDataSet wrapCdfData(CDFReader cdf, String svariable, long recStart, long recCount, long recInterval, int slice1, boolean depend, ProgressMonitor mon) throws Exception {
        return CdfUtil.loadVariable(cdf, svariable, recStart, recCount, recInterval, slice1, mon);
    }

    public static synchronized MutablePropertyDataSet loadVariable(CDFReader cdf, String svariable, long recStart, long recCount, long recInterval, int slice1, ProgressMonitor mon) throws Exception {
        String cdfFile;
        BufferDataSet result;
        int i;
        ByteBuffer buff;
        long t0;
        String stype;
        int[] dimSizes;
        long varType;
        block43: {
            int bytesPerRecord;
            int limit;
            int dims;
            if (recCount == 0L) {
                throw new IllegalArgumentException("recCount must be greater than 0 or -1");
            }
            if (recCount < -1L) {
                throw new IllegalArgumentException("recCount must be greater than -1");
            }
            logger.log(Level.FINE, "loadVariable {0}[{1}:{2}:{3}] slice1={4}", new Object[]{svariable, String.valueOf(recStart), "" + (recCount + recStart), recInterval, slice1});
            varType = cdf.getType(svariable);
            if (varType == 32L) {
                logger.fine("disabling slice1 because epoch16");
                slice1 = -1;
            }
            dimSizes = cdf.getDimensions(svariable);
            boolean[] dimVaries = cdf.getVarys(svariable);
            int[] repeatDimensions = new int[dimVaries.length];
            for (int i2 = 0; i2 < repeatDimensions.length; ++i2) {
                repeatDimensions[i2] = 1;
            }
            if (dimSizes == null) {
                dims = 0;
                dimSizes = new int[]{};
            } else {
                dims = dimSizes.length;
            }
            if (CdfUtil.getEffectiveRank(dimVaries) != dimSizes.length) {
                int[] dimSizes1 = new int[cdf.getEffectiveRank(svariable)];
                boolean[] varies = cdf.getVarys(svariable);
                int[] dimensions = cdf.getDimensions(svariable);
                int k = 0;
                for (int i3 = 0; i3 < varies.length; ++i3) {
                    if (varies[i3] && dimensions[i3] != 1) {
                        dimSizes1[k] = dimSizes[i3];
                        ++k;
                        continue;
                    }
                    repeatDimensions[i3] = dimSizes[i3];
                }
                dimSizes = dimSizes1;
            }
            if (dims > 3 && recCount != -1L) {
                throw new IllegalArgumentException("rank 5 not implemented");
            }
            int varRecCount = cdf.getNumberOfValues(svariable);
            if (recCount == -1L && recStart > 0L && varRecCount == 1) {
                recStart = 0L;
            }
            if (recCount > 1L && (long)(limit = 2147483) < recCount / 1000L / recInterval * (long)(bytesPerRecord = DataSetUtil.product((int[])dimSizes) * CdfUtil.sizeOf(varType))) {
                int newRecCount = (int)((long)limit * recInterval * 1000L / (long)bytesPerRecord);
                String suggest = recInterval > 1L ? "[0:" + newRecCount + ":" + recInterval + "]" : "[0:" + newRecCount + "]";
                throw new IllegalArgumentException("data read would result in more than 2GB read, which is not yet supported.  Use " + svariable + suggest + " to read first records.");
            }
            long rc = recCount;
            if (rc == -1L) {
                rc = 1L;
            }
            logger.log(Level.FINEST, "size of {0}: {1}MB  type: {2}", new Object[]{svariable, (double)CdfUtil.sizeOf(dims, dimSizes, varType, rc) / 1024.0 / 1024.0, varType});
            stype = CdfUtil.getTargetType(cdf.getType(svariable));
            t0 = System.currentTimeMillis();
            logger.entering("gov.nasa.gsfc.spdf.cdfj.CDFReader", "getBuffer");
            if (recInterval == 1L) {
                try {
                    boolean preserve = true;
                    if (stype.equals("string")) {
                        buff = null;
                        break block43;
                    }
                    buff = cdf.getBuffer(svariable, stype, new int[]{(int)recStart, (int)(recStart + recInterval * (rc - 1L))}, preserve);
                }
                catch (CDFException ex) {
                    buff = CdfUtil.myGetBuffer(cdf, svariable, (int)recStart, (int)(recStart + rc * recInterval), (int)recInterval);
                }
            } else {
                buff = CdfUtil.myGetBuffer(cdf, svariable, (int)recStart, (int)(recStart + rc * recInterval), (int)recInterval);
            }
        }
        logger.exiting("gov.nasa.gsfc.spdf.cdfj.CDFReader", "getBuffer");
        logger.log(Level.FINE, "read variable {0} in (ms): {1}", new Object[]{svariable, System.currentTimeMillis() - t0});
        Object bbType = CdfUtil.byteBufferType(cdf.getType(svariable));
        int recLenBytes = BufferDataSet.byteCount((Object)bbType);
        if (dimSizes.length > 0) {
            recLenBytes *= DataSetUtil.product((int[])dimSizes);
        }
        int[] qube = new int[1 + dimSizes.length];
        for (int i4 = 0; i4 < dimSizes.length; ++i4) {
            qube[i4 + 1] = dimSizes[i4];
        }
        qube[0] = recCount == -1L ? 1 : (int)recCount;
        if (stype.equals("string")) {
            MutablePropertyDataSet result2 = CdfUtil.readStringData(svariable, recInterval, cdf, recCount, qube);
            if (recCount == -1L && result2.rank() == 2) {
                return (MutablePropertyDataSet)result2.slice(0);
            }
            return result2;
        }
        if (slice1 > -1 && qube.length > 1) {
            buff = CdfUtil.doSlice1(buff, varType, qube, slice1, cdf.rowMajority());
            if (recCount == -1L) {
                logger.log(Level.FINE, "recCount==-1 and slice1>-1 when loading {0}", svariable);
            }
            int[] nqube = new int[qube.length - 1];
            nqube[0] = qube[0];
            for (i = 2; i < qube.length; ++i) {
                nqube[i - 1] = qube[i];
            }
            recLenBytes /= qube[1];
            qube = nqube;
        }
        if (varType == 31L && qube.length > 0) {
            boolean reform = true;
            for (i = 1; i < qube.length; ++i) {
                if (qube[i] == 1) continue;
                reform = false;
            }
            if (reform) {
                qube = Arrays.copyOf(qube, 1);
            }
        }
        if (cdf.rowMajority()) {
            if (recCount == -1L) {
                result = BufferDataSet.makeDataSet((int)qube.length, (int)recLenBytes, (int)0, (int[])qube, (ByteBuffer)buff, (Object)bbType);
                result = (MutablePropertyDataSet)result.slice(0);
            } else {
                result = BufferDataSet.makeDataSet((int)qube.length, (int)recLenBytes, (int)0, (int[])qube, (ByteBuffer)buff, (Object)bbType);
            }
        } else if (recCount == -1L) {
            buff = CdfUtil.transpose(recLenBytes, qube, buff, bbType);
            result = BufferDataSet.makeDataSet((int)qube.length, (int)recLenBytes, (int)0, (int[])qube, (ByteBuffer)buff, (Object)bbType);
            result = (MutablePropertyDataSet)result.slice(0);
        } else {
            buff = CdfUtil.transpose(recLenBytes, qube, buff, bbType);
            result = BufferDataSet.makeDataSet((int)qube.length, (int)recLenBytes, (int)0, (int[])qube, (ByteBuffer)buff, (Object)bbType);
        }
        if (varType == 51L || varType == 52L) {
            throw new IllegalArgumentException("We shouldn't get here because stype=string");
        }
        if (varType == 31L) {
            result.putProperty("UNITS", (Object)Units.cdfEpoch);
            result.putProperty("VALID_MIN", (Object)1.0);
        } else if (varType == 32L) {
            result.putProperty("UNITS", (Object)Units.cdfEpoch);
            result.putProperty("VALID_MIN", (Object)1.0);
            DDataSet result1 = DDataSet.createRank1((int)result.length());
            for (i = 0; i < result.length(); ++i) {
                double t2000 = result.value(i, 0) - 6.3113904E10;
                result1.putValue(i, t2000 * 1000000.0 + result.value(i, 1) / 1000000.0);
            }
            result1.putProperty("UNITS", (Object)Units.us2000);
            result = result1;
        } else if (varType == 33L) {
            result.putProperty("UNITS", (Object)Units.cdfTT2000);
        }
        if ((varType == 31L || varType == 32L || varType == 33L) && (cdfFile = CdfDataSource.cdfCacheFileForReader(cdf)) != null) {
            String uri = cdfFile + "?" + svariable;
            if (recStart != 0L || recCount != (long)cdf.getNumberOfValues(svariable) || recInterval > 1L) {
                uri = uri + "[" + recStart + ":" + (recStart + recCount) + ":" + recInterval + "]";
            }
            CdfDataSource.dsCachePut(uri, (MutablePropertyDataSet)result);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static MutablePropertyDataSet readStringData(String svariable, long recInterval, CDFReader cdf, long recCount, int[] qube) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, CDFException.ReaderError {
        boolean canSlice;
        String[] sdata;
        EnumerationUnits units = EnumerationUnits.create((Object)svariable);
        if (recInterval > 1L) {
            throw new IllegalArgumentException("recInterval>1 not supported here");
        }
        Object o = cdf.get(svariable);
        Object o0 = Array.get(o, 0);
        if (o0.getClass().isArray()) {
            if (qube.length == 3) {
                sdata = new String[DataSetUtil.product((int[])qube)];
                for (int i = 0; i < qube[0]; ++i) {
                    o0 = Array.get(o, i);
                    for (int j = 0; j < qube[1]; ++j) {
                        for (int k = 0; k < qube[2]; ++k) {
                            sdata[i * qube[1] * qube[2] + j * qube[2] + k] = (String)Array.get(Array.get(o0, j), k);
                        }
                    }
                }
            } else {
                if (qube.length != 2) throw new IllegalArgumentException("rank not supported");
                sdata = new String[Array.getLength(o0)];
                for (int j = 0; j < Array.getLength(o0); ++j) {
                    sdata[j] = (String)Array.get(o0, j);
                }
            }
        } else {
            if (o0.getClass() != String.class) throw new IllegalArgumentException("not handled single array where expected double array");
            sdata = (String[])o;
        }
        int[] back = new int[sdata.length];
        for (int i = 0; i < sdata.length; ++i) {
            back[i] = (int)units.createDatum((Object)sdata[i]).doubleValue((Units)units);
        }
        boolean[] varies = cdf.getVarys(svariable);
        boolean bl = canSlice = recCount == -1L;
        if (canSlice) {
            for (int i = 1; i < varies.length; ++i) {
                canSlice = canSlice && !varies[i];
            }
        }
        if (canSlice) {
            qube = new int[]{qube[1]};
        }
        ArrayDataSet result = ArrayDataSet.wrap((Object)back, (int[])qube, (boolean)false);
        result.putProperty("UNITS", (Object)units);
        return result;
    }

    public static int jvmMemory(QDataSet ds) {
        if (ds instanceof ArrayDataSet) {
            return ((ArrayDataSet)ds).jvmMemory();
        }
        if (ds instanceof TrArrayDataSet) {
            return ((TrArrayDataSet)ds).jvmMemory();
        }
        if (ds instanceof Slice0DataSet) {
            return 0;
        }
        if (ds instanceof BufferDataSet) {
            return ((BufferDataSet)ds).jvmMemory();
        }
        throw new IllegalArgumentException("not supported type of QDataSet: " + ds);
    }

    public static String getStringDataType(int type) {
        switch (type) {
            case 1: {
                return "CDF_INT1";
            }
            case 2: {
                return "CDF_INT2";
            }
            case 4: {
                return "CDF_INT4";
            }
            case 8: {
                return "CDF_INT8";
            }
            case 11: {
                return "CDF_UINT1";
            }
            case 12: {
                return "CDF_UINT2";
            }
            case 14: {
                return "CDF_UINT4";
            }
            case 41: {
                return "CDF_BYTE";
            }
            case 21: {
                return "CDF_REAL4";
            }
            case 22: {
                return "CDF_REAL8";
            }
            case 44: {
                return "CDF_FLOAT";
            }
            case 45: {
                return "CDF_DOUBLE";
            }
            case 31: {
                return "CDF_EPOCH";
            }
            case 32: {
                return "CDF_EPOCH16";
            }
            case 33: {
                return "CDF_TT2000";
            }
            case 51: {
                return "CDF_CHAR";
            }
        }
        return String.valueOf(type);
    }

    private static Object getAttribute(CDFReader cdf, String var, String attrname) {
        try {
            Object att = cdf.getAttribute(var, attrname);
            if (att == null) {
                return null;
            }
            if (((Vector)att).isEmpty()) {
                return null;
            }
            att = ((Vector)att).get(0);
            return att;
        }
        catch (CDFException ex) {
            logger.fine(ex.getMessage());
            return null;
        }
    }

    public static boolean hasAttribute(CDFReader cdf, String var, String attrname) {
        try {
            Object att = cdf.getAttribute(var, attrname);
            return att != null && !((Vector)att).isEmpty();
        }
        catch (CDFException ex) {
            return false;
        }
    }

    public static int[] getDimensions(CDFReader cdf, String variableName) throws CDFException.ReaderError {
        int[] dims = cdf.getDimensions(variableName);
        if (cdf.isTypeR(variableName)) {
            boolean[] dimVary = cdf.getVarys(variableName);
            int shift = dimVary.length > 0 ? (dimVary[0] ? 0 : 1) : 0;
            int lastVary = -1;
            for (int iv = dimVary.length - 1; iv >= shift; --iv) {
                if (!dimVary[iv]) continue;
                lastVary = iv;
                break;
            }
            if (lastVary > -1) {
                if (shift == 0) {
                    int[] newDims = Arrays.copyOfRange(dims, 0, lastVary + 1);
                    return newDims;
                }
                int[] newDims = Arrays.copyOfRange(dims, 1, lastVary + 1);
                return newDims;
            }
            return new int[0];
        }
        return dims;
    }

    private static DepDesc getDepDesc(CDFReader cdf, String svar, int rank, int[] dims, int dim, List<String> warn, boolean isMaster) {
        Object att;
        DepDesc result = new DepDesc();
        result.nrec = -1L;
        try {
            if (CdfUtil.hasAttribute(cdf, svar, "DEPEND_" + dim) && (att = CdfUtil.getAttribute(cdf, svar, "DEPEND_" + dim)) != null && rank > 1) {
                logger.log(Level.FINER, "get attribute DEPEND_" + dim + " entry for {0}", svar);
                result.dep = String.valueOf(att);
                if (cdf.getDimensions(result.dep).length > 0 && (isMaster || cdf.getNumberOfValues(result.dep) > 1) && cdf.recordVariance(result.dep)) {
                    result.rank2 = true;
                    result.nrec = cdf.getDimensions(result.dep)[0];
                    warn.add("NOTE: " + result.dep + " is record varying");
                } else {
                    result.nrec = cdf.getNumberOfValues(result.dep);
                    if (result.nrec == 1L) {
                        result.nrec = CdfUtil.getDimensions(cdf, result.dep)[0];
                    }
                }
                if (dims.length > dim - 1 && result.nrec != (long)dims[dim - 1]) {
                    warn.add("data dim " + dim + " length (" + dims[dim - 1] + ") is inconsistent with DEPEND_" + dim + " length (" + result.nrec + ")");
                }
            }
        }
        catch (CDFException e) {
            warn.add("problem with DEPEND_" + dim + ": " + e.getMessage());
        }
        try {
            if (result.nrec == -1L && CdfUtil.hasAttribute(cdf, svar, "LABL_PTR_" + dim)) {
                att = CdfUtil.getAttribute(cdf, svar, "LABL_PTR_" + dim);
                if (att != null && rank > 1) {
                    logger.log(Level.FINER, "get attribute LABL_PTR_" + dim + " entry for {0}", svar);
                    result.labl = String.valueOf(att);
                    if (!cdf.existsVariable(result.labl)) {
                        throw new Exception("No such variable: " + String.valueOf(att));
                    }
                    result.nrec = cdf.getNumberOfValues(result.labl);
                    if (result.nrec == 1L) {
                        result.nrec = cdf.getDimensions(svar)[0];
                    }
                    if (dim == 1 && dims.length > dim - 1 && result.nrec != (long)dims[dim - 1]) {
                        warn.add("data dim " + dim + " length (" + dims[dim - 1] + ") is inconsistent with LABL_PTR_" + dim + " length (" + result.nrec + ")");
                    }
                }
            } else if (CdfUtil.hasAttribute(cdf, svar, "LABL_PTR_" + dim) && (att = CdfUtil.getAttribute(cdf, svar, "LABL_PTR_" + dim)) != null && rank > 1) {
                logger.log(Level.FINER, "get attribute LABL_PTR_" + dim + " entry for {0}", svar);
                result.labl = String.valueOf(att);
                int nrec = cdf.getNumberOfValues(result.labl);
                if (nrec == 1) {
                    nrec = cdf.getDimensions(result.labl)[0];
                }
                if (dim == 1 && dims.length > dim - 1 && nrec != dims[dim - 1]) {
                    warn.add("data dim " + dim + " length (" + dims[dim - 1] + ") is inconsistent with LABL_PTR_" + dim + " length (" + nrec + ")");
                }
            }
        }
        catch (CDFException e) {
            warn.add("problem with LABL_PTR_" + dim + ": " + e.getMessage());
        }
        catch (Exception e) {
            warn.add("problem with LABL_PTR_" + dim + ": " + e.getMessage());
        }
        return result;
    }

    private static boolean hasVariable(CDFReader cdf, String var) {
        List<String> names = Arrays.asList(cdf.getVariableNames());
        return names.contains(var);
    }

    public static Map<String, String> getPlottable(CDFReader cdf, boolean dataOnly, int rankLimit) throws Exception {
        return CdfUtil.getPlottable(cdf, dataOnly, rankLimit, new HashMap<String, String>());
    }

    public static LinkedHashMap<String, CdfVariableDescription> getPlottable(CDFReader cdf, Map<String, String> options) throws CDFException.ReaderError {
        LinkedHashMap<String, CdfVariableDescription> result = new LinkedHashMap<String, CdfVariableDescription>();
        if (options == null) {
            options = Collections.emptyMap();
        }
        boolean isMaster = CdfUtil.getOption(options, OPTION_IS_MASTER, "false").equals("true");
        boolean deep = CdfUtil.getOption(options, OPTION_DEEP, "true").equals("true");
        boolean showEmpty = CdfUtil.getOption(options, OPTION_INCLUDE_EMPTY_RECORDS, "true").equals("true");
        boolean dataOnly = CdfUtil.getOption(options, OPTION_DATA_ONLY, "false").equals("true");
        int rankLimit = Integer.parseInt(CdfUtil.getOption(options, OPTION_RANK_LIMIT, String.valueOf(4)));
        logger.fine("getting CDF variables");
        String[] v = cdf.getVariableNames();
        logger.log(Level.FINE, "got {0} variables", v.length);
        logger.fine("getting CDF attributes");
        boolean[] isData = new boolean[v.length];
        int i = -1;
        int skipCount = 0;
        for (String svar : v) {
            ++i;
            if (!dataOnly) continue;
            Object attr = CdfUtil.getAttribute(cdf, svar, "VAR_TYPE");
            if (attr == null) {
                for (String s : cdf.variableAttributeNames(svar)) {
                    if (!s.equalsIgnoreCase("VAR_TYPE")) continue;
                    attr = CdfUtil.getAttribute(cdf, svar, s);
                }
                if (attr != null) {
                    logger.log(Level.INFO, "Wrong-case VAR_TYPE attribute found, should be \"VAR_TYPE\"");
                }
            }
            if (attr != null && "data".equalsIgnoreCase(attr.toString()) && !attr.equals("data")) {
                logger.log(Level.INFO, "var_type is case-sensitive, should be \"data\", not {0}", attr);
                attr = "data";
            }
            if (attr == null || !attr.equals("data")) {
                ++skipCount;
                isData[i] = false;
                continue;
            }
            isData[i] = true;
        }
        i = -1;
        for (String v1 : v) {
            ++i;
            String svar = null;
            ArrayList<String> warn = new ArrayList<String>();
            String xDependVariable = null;
            boolean isVirtual = false;
            long xMaxRec = -1L;
            long maxRec = -1L;
            long recCount = -1L;
            String scatDesc = null;
            String svarNotes = null;
            StringBuilder vdescr = null;
            int rank = -1;
            int[] dims = new int[]{};
            int varType = 0;
            try {
                svar = v1;
                try {
                    varType = cdf.getType(svar);
                }
                catch (CDFException ex) {
                    throw new RuntimeException(ex);
                }
                boolean hasDep0 = CdfUtil.hasAttribute(cdf, svar, "DEPEND_0");
                if (!((long)varType != 51L && (long)varType != 52L || hasDep0)) {
                    logger.log(Level.FINER, "skipping because ordinal and no depend_0: {0}", svar);
                    continue;
                }
                maxRec = cdf.getNumberOfValues(svar);
                recCount = maxRec;
                if (recCount == 0L && !showEmpty) {
                    logger.log(Level.FINER, "skipping because variable is empty: {0}", svar);
                    continue;
                }
                dims = CdfUtil.getDimensions(cdf, svar);
                rank = dims == null ? 1 : dims.length + 1;
                if (rank > rankLimit) continue;
                if (svar.equals("Time_PB5")) {
                    logger.log(Level.FINER, "skipping {0} because we always skip Time_PB5", svar);
                    continue;
                }
                if (dataOnly && !isData[i]) continue;
                Object att = CdfUtil.getAttribute(cdf, svar, "VIRTUAL");
                if (att != null) {
                    logger.log(Level.FINER, "get attribute VIRTUAL entry for {0}", svar);
                    if (String.valueOf(att).toUpperCase().equals("TRUE")) {
                        String funct = (String)CdfUtil.getAttribute(cdf, svar, "FUNCTION");
                        if (funct == null) {
                            funct = (String)CdfUtil.getAttribute(cdf, svar, "FUNCT");
                        }
                        if (!CdfVirtualVars.isSupported(funct)) {
                            if (funct.startsWith("comp_themis")) continue;
                            logger.log(Level.FINER, "virtual function not supported: {0}", funct);
                            continue;
                        }
                        vdescr = new StringBuilder(funct);
                        vdescr.append("( ");
                        int icomp = 0;
                        String comp = (String)CdfUtil.getAttribute(cdf, svar, "COMPONENT_" + icomp);
                        if (comp != null) {
                            vdescr.append(comp);
                            ++icomp;
                        }
                        while (icomp < 5 && (comp = (String)CdfUtil.getAttribute(cdf, svar, "COMPONENT_" + icomp)) != null) {
                            vdescr.append(", ").append(comp);
                            ++icomp;
                        }
                        vdescr.append(" )");
                        isVirtual = true;
                    }
                }
            }
            catch (CDFException | RuntimeException e) {
                logger.fine(e.getMessage());
            }
            try {
                if (CdfUtil.hasAttribute(cdf, svar, "DEPEND_0")) {
                    Object att = CdfUtil.getAttribute(cdf, svar, "DEPEND_0");
                    if (att != null) {
                        logger.log(Level.FINER, "get attribute DEPEND_0 entry for {0}", svar);
                        xDependVariable = String.valueOf(att);
                        if (!CdfUtil.hasVariable(cdf, xDependVariable)) {
                            throw new Exception("No such variable: " + String.valueOf(att));
                        }
                        xMaxRec = cdf.getNumberOfValues(xDependVariable);
                        if (xMaxRec != maxRec && vdescr == null && cdf.recordVariance(svar)) {
                            if (maxRec == -1L) {
                                ++maxRec;
                            }
                            if (maxRec == 0L) {
                                warn.add("data contains no records");
                            } else {
                                warn.add("depend0 length (" + xDependVariable + "[" + xMaxRec + "]) is inconsistent with length (" + maxRec + ")");
                            }
                        }
                    } else if (dataOnly) {
                        continue;
                    }
                }
            }
            catch (CDFException e) {
                warn.add("problem with DEPEND_0: " + e.getMessage());
            }
            catch (Exception e) {
                warn.add("problem with DEPEND_0: " + e.getMessage());
            }
            CdfVariableDescription description = new CdfVariableDescription();
            DepDesc dep1desc = CdfUtil.getDepDesc(cdf, svar, rank, dims, 1, warn, isMaster);
            DepDesc dep2desc = CdfUtil.getDepDesc(cdf, svar, rank, dims, 2, warn, isMaster);
            DepDesc dep3desc = CdfUtil.getDepDesc(cdf, svar, rank, dims, 3, warn, isMaster);
            if (deep) {
                Object o = CdfUtil.getAttribute(cdf, svar, "CATDESC");
                if (o != null && o instanceof String) {
                    logger.log(Level.FINER, "get attribute CATDESC entry for {0}", svar);
                    scatDesc = (String)o;
                }
                if ((o = CdfUtil.getAttribute(cdf, svar, "VAR_NOTES")) != null && o instanceof String) {
                    logger.log(Level.FINER, "get attribute VAR_NOTES entry for {0}", svar);
                    svarNotes = (String)o;
                }
            }
            String htmlDescription = svar;
            if (xDependVariable != null) {
                htmlDescription = htmlDescription + "[" + CdfUtil.maybeShorten(svar, xDependVariable);
                if (!(xMaxRec <= 0L && isMaster || xMaxRec != maxRec)) {
                    htmlDescription = htmlDescription + "=" + xMaxRec;
                }
                if (dep1desc.dep != null) {
                    htmlDescription = htmlDescription + "," + CdfUtil.maybeShorten(svar, dep1desc.dep) + "=" + dims[0] + (dep1desc.rank2 ? "*" : "");
                    if (dep2desc.dep != null) {
                        htmlDescription = htmlDescription + "," + CdfUtil.maybeShorten(svar, dep2desc.dep) + "=" + dims[1] + (dep2desc.rank2 ? "*" : "");
                        if (dep3desc.dep != null) {
                            htmlDescription = htmlDescription + "," + CdfUtil.maybeShorten(svar, dep3desc.dep) + "=" + dims[2] + (dep3desc.rank2 ? "*" : "");
                        }
                    }
                } else if (rank > 1) {
                    htmlDescription = htmlDescription + "," + DataSourceUtil.strjoin((int[])dims, (String)",");
                }
                htmlDescription = htmlDescription + "]";
            }
            if (deep) {
                Vector<AttributeEntry> variablePurpose;
                StringBuilder descbuf = new StringBuilder("<html><b>" + htmlDescription + "</b><br><br>");
                int itype = -1;
                try {
                    itype = cdf.getType(svar);
                }
                catch (CDFException cDFException) {
                    // empty catch block
                }
                String recDesc = "" + CdfUtil.getStringDataType(itype);
                if (dims != null && dims.length > 0) {
                    recDesc = recDesc + "[" + DataSourceUtil.strjoin((int[])dims, (String)",") + "]";
                }
                if (scatDesc != null) {
                    descbuf.append(scatDesc).append("<br><br>");
                }
                if (svarNotes != null) {
                    descbuf.append("<p><small>").append(svarNotes).append("</small></p><br>");
                }
                if ((variablePurpose = cdf.getAttributeEntries(svar, "VARIABLE_PURPOSE")).size() > 0) {
                    AttributeEntry e = variablePurpose.get(0);
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(e.getValue()));
                    for (int i1 = 1; i1 < variablePurpose.size(); ++i1) {
                        e = variablePurpose.get(i1);
                        stringBuilder.append(",").append(e.getValue());
                    }
                    descbuf.append("<p><small>VARIABLE_PURPOSE: ").append((CharSequence)stringBuilder).append("</small></p><br>");
                }
                if (maxRec != xMaxRec) {
                    if (isVirtual) {
                        descbuf.append("(virtual function ").append((CharSequence)vdescr).append(")<br>");
                    } else if (isMaster) {
                        descbuf.append("records of ").append(recDesc).append("<br>");
                    } else {
                        descbuf.append(recCount).append(" records of ").append(recDesc).append("<br>");
                    }
                } else if (isMaster) {
                    descbuf.append("records of ").append(recDesc).append("<br>");
                } else {
                    descbuf.append(recCount).append(" records of ").append(recDesc).append("<br>");
                }
                for (String string : warn) {
                    descbuf.append("<br>");
                    if (string.startsWith("NOTE")) {
                        descbuf.append(string);
                        continue;
                    }
                    descbuf.append("WARNING: ").append(string);
                }
                descbuf.append("</html>");
                htmlDescription = descbuf.toString();
            }
            if (svarNotes == null) {
                svarNotes = "";
            }
            description.name = svar;
            description.description = svarNotes;
            description.isSupport = !isData[i];
            description.htmlDescription = htmlDescription;
            description.variableType = CdfUtil.getStringDataType(varType);
            description.numberOfRecords = maxRec;
            description.depends = new String[rank - 1];
            description.dimensions = dims;
            description.depend0Name = xDependVariable;
            String desc = svar;
            if (xDependVariable != null) {
                desc = desc + "[" + CdfUtil.maybeShorten(svar, xDependVariable);
                if (!(xMaxRec <= 0L && isMaster || xMaxRec != maxRec)) {
                    desc = desc + "=" + xMaxRec;
                }
                if (dep1desc.dep != null) {
                    desc = desc + "," + CdfUtil.maybeShorten(svar, dep1desc.dep) + "=" + dims[0] + (dep1desc.rank2 ? "*" : "");
                    if (dep2desc.dep != null) {
                        desc = desc + "," + CdfUtil.maybeShorten(svar, dep2desc.dep) + "=" + dims[1] + (dep2desc.rank2 ? "*" : "");
                        if (dep3desc.dep != null) {
                            desc = desc + "," + CdfUtil.maybeShorten(svar, dep3desc.dep) + "=" + dims[2] + (dep3desc.rank2 ? "*" : "");
                        }
                    }
                } else if (rank > 1) {
                    desc = desc + "," + DataSourceUtil.strjoin((int[])dims, (String)",");
                }
                desc = desc + "]";
            }
            result.put(svar, description);
        }
        logger.fine("done, get plottable ");
        return result;
    }

    public static String maybeShorten(String context, String name) {
        int i2;
        int i1 = context.length() - 1;
        for (i2 = name.length() - 1; i1 > 0 && i2 > 0 && context.charAt(i1) == name.charAt(i2); --i1, --i2) {
        }
        if (++i2 < name.length() - 3) {
            return name.substring(0, i2) + "...";
        }
        return name;
    }

    private static String getOption(Map<String, String> options, String key, String deft) {
        if (options.containsKey(key)) {
            return options.get(key);
        }
        return deft;
    }

    public static Map<String, String> getPlottable(CDFReader cdf, boolean dataOnly, int rankLimit, Map<String, String> options) throws Exception {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> dependent = new LinkedHashMap<String, String>();
        boolean isMaster = CdfUtil.getOption(options, OPTION_IS_MASTER, "false").equals("true");
        boolean deep = CdfUtil.getOption(options, OPTION_DEEP, "false").equals("true");
        boolean showEmpty = CdfUtil.getOption(options, OPTION_INCLUDE_EMPTY_RECORDS, "true").equals("true");
        logger.fine("getting CDF variables");
        String[] v = cdf.getVariableNames();
        logger.log(Level.FINE, "got {0} variables", v.length);
        logger.fine("getting CDF attributes");
        boolean[] isData = new boolean[v.length];
        int i = -1;
        int skipCount = 0;
        for (String svar : v) {
            ++i;
            if (!dataOnly) continue;
            Object attr = CdfUtil.getAttribute(cdf, svar, "VAR_TYPE");
            if (attr == null) {
                for (String s : cdf.variableAttributeNames(svar)) {
                    if (!s.equalsIgnoreCase("VAR_TYPE")) continue;
                    attr = CdfUtil.getAttribute(cdf, svar, s);
                }
                if (attr != null) {
                    logger.log(Level.INFO, "Wrong-case VAR_TYPE attribute found, should be \"VAR_TYPE\"");
                }
            }
            if (attr != null && "data".equalsIgnoreCase(attr.toString()) && !attr.equals("data")) {
                logger.log(Level.INFO, "var_type is case-sensitive, should be \"data\", not {0}", attr);
                attr = "data";
            }
            if (attr == null || !attr.equals("data")) {
                ++skipCount;
                isData[i] = false;
                continue;
            }
            isData[i] = true;
        }
        i = -1;
        for (String v1 : v) {
            ++i;
            String svar = null;
            ArrayList<String> warn = new ArrayList<String>();
            String xDependVariable = null;
            boolean isVirtual = false;
            long xMaxRec = -1L;
            long maxRec = -1L;
            long recCount = -1L;
            String scatDesc = null;
            String svarNotes = null;
            StringBuilder vdescr = null;
            int rank = -1;
            int[] dims = new int[]{};
            int varType = 0;
            try {
                svar = v1;
                try {
                    varType = cdf.getType(svar);
                }
                catch (CDFException ex) {
                    throw new RuntimeException(ex);
                }
                boolean hasDep0 = CdfUtil.hasAttribute(cdf, svar, "DEPEND_0");
                if (!((long)varType != 51L && (long)varType != 52L || hasDep0)) {
                    logger.log(Level.FINER, "skipping because ordinal and no depend_0: {0}", svar);
                    continue;
                }
                maxRec = cdf.getNumberOfValues(svar);
                recCount = maxRec;
                if (recCount == 0L && !showEmpty) {
                    logger.log(Level.FINER, "skipping because variable is empty: {0}", svar);
                    continue;
                }
                dims = CdfUtil.getDimensions(cdf, svar);
                rank = dims.length + 1;
                if (rank > rankLimit) continue;
                if (svar.equals("Time_PB5")) {
                    logger.log(Level.FINER, "skipping {0} because we always skip Time_PB5", svar);
                    continue;
                }
                if (dataOnly && !isData[i]) continue;
                Object att = CdfUtil.getAttribute(cdf, svar, "VIRTUAL");
                if (att != null) {
                    logger.log(Level.FINER, "get attribute VIRTUAL entry for {0}", svar);
                    if (String.valueOf(att).toUpperCase().equals("TRUE")) {
                        String funct = (String)CdfUtil.getAttribute(cdf, svar, "FUNCTION");
                        if (funct == null) {
                            funct = (String)CdfUtil.getAttribute(cdf, svar, "FUNCT");
                        }
                        if (!CdfVirtualVars.isSupported(funct)) {
                            if (funct.startsWith("comp_themis")) continue;
                            logger.log(Level.FINER, "virtual function not supported: {0}", funct);
                            continue;
                        }
                        vdescr = new StringBuilder(funct);
                        vdescr.append("( ");
                        int icomp = 0;
                        String comp = (String)CdfUtil.getAttribute(cdf, svar, "COMPONENT_" + icomp);
                        if (comp != null) {
                            vdescr.append(comp);
                            ++icomp;
                        }
                        while (icomp < 5 && (comp = (String)CdfUtil.getAttribute(cdf, svar, "COMPONENT_" + icomp)) != null) {
                            vdescr.append(", ").append(comp);
                            ++icomp;
                        }
                        vdescr.append(" )");
                        isVirtual = true;
                    }
                }
            }
            catch (CDFException | RuntimeException e) {
                logger.fine(e.getMessage());
            }
            try {
                if (CdfUtil.hasAttribute(cdf, svar, "DEPEND_0")) {
                    Object att = CdfUtil.getAttribute(cdf, svar, "DEPEND_0");
                    if (att != null) {
                        logger.log(Level.FINER, "get attribute DEPEND_0 entry for {0}", svar);
                        xDependVariable = String.valueOf(att);
                        if (!CdfUtil.hasVariable(cdf, xDependVariable)) {
                            throw new Exception("No such variable: " + String.valueOf(att));
                        }
                        xMaxRec = cdf.getNumberOfValues(xDependVariable);
                        if (xMaxRec != maxRec && vdescr == null && cdf.recordVariance(svar)) {
                            if (maxRec == -1L) {
                                ++maxRec;
                            }
                            if (maxRec == 0L) {
                                warn.add("data contains no records");
                            } else {
                                warn.add("depend0 length (" + xDependVariable + "[" + xMaxRec + "]) is inconsistent with length (" + maxRec + ")");
                            }
                        }
                    } else if (dataOnly) {
                        continue;
                    }
                }
            }
            catch (CDFException e) {
                warn.add("problem with DEPEND_0: " + e.getMessage());
            }
            catch (Exception e) {
                warn.add("problem with DEPEND_0: " + e.getMessage());
            }
            DepDesc dep1desc = CdfUtil.getDepDesc(cdf, svar, rank, dims, 1, warn, isMaster);
            DepDesc dep2desc = CdfUtil.getDepDesc(cdf, svar, rank, dims, 2, warn, isMaster);
            DepDesc dep3desc = CdfUtil.getDepDesc(cdf, svar, rank, dims, 3, warn, isMaster);
            if (deep) {
                Object o = CdfUtil.getAttribute(cdf, svar, "CATDESC");
                if (o != null && o instanceof String) {
                    logger.log(Level.FINER, "get attribute CATDESC entry for {0}", svar);
                    scatDesc = (String)o;
                }
                if ((o = CdfUtil.getAttribute(cdf, svar, "VAR_NOTES")) != null && o instanceof String) {
                    logger.log(Level.FINER, "get attribute VAR_NOTES entry for {0}", svar);
                    svarNotes = (String)o;
                }
            }
            String desc = svar;
            if (xDependVariable != null) {
                desc = desc + "[" + CdfUtil.maybeShorten(svar, xDependVariable);
                if (!(xMaxRec <= 0L && isMaster || xMaxRec != maxRec)) {
                    desc = desc + "=" + xMaxRec;
                }
                if (dep1desc.dep != null) {
                    desc = desc + "," + CdfUtil.maybeShorten(svar, dep1desc.dep) + "=" + dims[0] + (dep1desc.rank2 ? "*" : "");
                    if (dep2desc.dep != null) {
                        desc = desc + "," + CdfUtil.maybeShorten(svar, dep2desc.dep) + "=" + dims[1] + (dep2desc.rank2 ? "*" : "");
                        if (dep3desc.dep != null) {
                            desc = desc + "," + CdfUtil.maybeShorten(svar, dep3desc.dep) + "=" + dims[2] + (dep3desc.rank2 ? "*" : "");
                        } else if (rank > 3) {
                            desc = desc + "," + DataSourceUtil.strjoin((int[])Arrays.copyOfRange(dims, 2, dims.length), (String)",");
                        }
                    } else if (rank > 2) {
                        desc = desc + "," + DataSourceUtil.strjoin((int[])Arrays.copyOfRange(dims, 1, dims.length), (String)",");
                    }
                } else if (rank > 1) {
                    desc = desc + "," + DataSourceUtil.strjoin((int[])dims, (String)",");
                }
                desc = desc + "]";
            }
            if (deep) {
                Vector<AttributeEntry> variablePurpose;
                StringBuilder descbuf = new StringBuilder("<html><b>" + desc + "</b><br><br>");
                int itype = -1;
                try {
                    itype = cdf.getType(svar);
                }
                catch (CDFException cDFException) {
                    // empty catch block
                }
                String recDesc = "" + CdfUtil.getStringDataType(itype);
                if (dims != null && dims.length > 0) {
                    recDesc = recDesc + "[" + DataSourceUtil.strjoin((int[])dims, (String)",") + "]";
                }
                if (scatDesc != null) {
                    descbuf.append(scatDesc).append("<br><br>");
                }
                if (svarNotes != null) {
                    descbuf.append("<p><small>").append(svarNotes).append("</small></p><br>");
                }
                if ((variablePurpose = cdf.getAttributeEntries(svar, "VARIABLE_PURPOSE")).size() > 0) {
                    AttributeEntry e = variablePurpose.get(0);
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(e.getValue()));
                    for (int i1 = 1; i1 < variablePurpose.size(); ++i1) {
                        e = variablePurpose.get(i1);
                        stringBuilder.append(",").append(e.getValue());
                    }
                    descbuf.append("<p><small>VARIABLE_PURPOSE: ").append((CharSequence)stringBuilder).append("</small></p><br>");
                }
                if (maxRec != xMaxRec) {
                    if (isVirtual) {
                        descbuf.append("(virtual function ").append((CharSequence)vdescr).append(")<br>");
                    } else if (isMaster) {
                        descbuf.append("records of ").append(recDesc).append("<br>");
                    } else {
                        descbuf.append(recCount).append(" records of ").append(recDesc).append("<br>");
                    }
                } else if (isMaster) {
                    descbuf.append("records of ").append(recDesc).append("<br>");
                } else {
                    descbuf.append(recCount).append(" records of ").append(recDesc).append("<br>");
                }
                for (String string : warn) {
                    descbuf.append("<br>");
                    if (string.startsWith("NOTE")) {
                        descbuf.append(string);
                        continue;
                    }
                    descbuf.append("WARNING: ").append(string);
                }
                descbuf.append("</html>");
                if (xDependVariable != null) {
                    dependent.put(svar, descbuf.toString());
                    continue;
                }
                result.put(svar, descbuf.toString());
                continue;
            }
            if (xDependVariable != null) {
                dependent.put(svar, desc);
                continue;
            }
            result.put(svar, desc);
        }
        logger.fine("done, get plottable ");
        dependent.putAll(result);
        return dependent;
    }

    public static void doApplyAttributes(Map<String, Object> attr1, MutablePropertyDataSet result, String os1, String constraint) {
        Matcher m;
        Pattern p;
        QDataSet labels;
        IstpMetadataModel model = new IstpMetadataModel();
        Map istpProps = model.properties(attr1);
        CdfUtil.maybeAddValidRange(istpProps, result);
        Number n = (Number)istpProps.get("FILL_VALUE");
        if (result instanceof BufferDataSet) {
            Class c = ((BufferDataSet)result).getCompatibleComponentType();
            if (n instanceof Double && c == Float.TYPE) {
                istpProps.put("FILL_VALUE", Float.valueOf((float)n.doubleValue()));
            }
        }
        result.putProperty("FILL_VALUE", istpProps.get("FILL_VALUE"));
        if (constraint == null) {
            result.putProperty("LABEL", istpProps.get("LABEL"));
        } else if (constraint.matches("\\[:\\,\\d+\\]")) {
            labels = (QDataSet)attr1.get("slice1_labels");
            if (labels != null) {
                p = Pattern.compile("\\[:\\,(\\d+)\\]");
                m = p.matcher(constraint);
                if (m.matches()) {
                    result.putProperty("LABEL", (Object)labels.slice(Integer.parseInt(m.group(1))).svalue());
                }
            } else {
                result.putProperty("LABEL", istpProps.get("LABEL"));
            }
        } else if (constraint.matches("\\[:\\,\\:\\,\\d+\\]")) {
            attr1.put("LABLAXIS", null);
            labels = (QDataSet)attr1.get("slice2_labels");
            if (labels != null) {
                p = Pattern.compile("\\[:\\,\\:\\,(\\d+)\\]");
                m = p.matcher(constraint);
                if (m.matches()) {
                    result.putProperty("LABEL", (Object)labels.slice(Integer.parseInt(m.group(1))).svalue());
                }
            } else {
                result.putProperty("LABEL", istpProps.get("LABEL"));
            }
        } else {
            result.putProperty("LABEL", istpProps.get("LABEL"));
        }
        result.putProperty("TITLE", istpProps.get("TITLE"));
        result.putProperty("DESCRIPTION", istpProps.get("DESCRIPTION"));
        String renderType = (String)istpProps.get("RENDER_TYPE");
        if (renderType != null && renderType.equals("time_series") && result.rank() > 1 && result.length(0) > 96) {
            logger.log(Level.FINE, "result.length(0)>QDataSet.MAX_UNIT_BUNDLE_COUNT={0}, this cannot be treated as a time_series", 96);
            renderType = null;
        }
        if (renderType != null && renderType.startsWith("image")) {
            logger.fine("renderType=image not supported in CDF files");
            renderType = null;
        }
        if (UnitsUtil.isNominalMeasurement((Units)SemanticOps.getUnits((QDataSet)result))) {
            renderType = "eventsbar";
        }
        if (constraint != null) {
            logger.finer("dropping render type because of constraint");
        } else if (os1 != null && os1.length() > 0) {
            logger.finer("dropping render type because of slice1");
            for (int i1 = 1; i1 < result.rank() + 1; ++i1) {
                istpProps.put("DEPEND_" + i1, istpProps.get("DEPEND_" + (i1 + 1)));
            }
        } else {
            result.putProperty("RENDER_TYPE", (Object)renderType);
        }
        if (UnitsUtil.isNominalMeasurement((Units)SemanticOps.getUnits((QDataSet)result))) {
            if (result.property("DEPEND_0") == null) {
                result.putProperty("RENDER_TYPE", (Object)"digital");
            } else {
                result.putProperty("RENDER_TYPE", (Object)"eventsBar");
            }
        } else if (result.rank() < 3 && result.rank() == 2 && result.length() > 0 && result.length(0) < 96) {
            String rt = (String)istpProps.get("RENDER_TYPE");
            if (rt != null) {
                result.putProperty("RENDER_TYPE", (Object)rt);
            }
            if (istpProps.get("RENDER_TYPE") == null && result.property("DEPEND_1") == null) {
                result.putProperty("RENDER_TYPE", (Object)"time_series");
            }
        }
        for (int j = 0; j < result.rank(); ++j) {
            MutablePropertyDataSet depds = (MutablePropertyDataSet)result.property("DEPEND_" + j);
            Map depProps = (Map)istpProps.get("DEPEND_" + j);
            if (depds == null || depProps == null) continue;
            CdfUtil.maybeAddValidRange(depProps, depds);
            Map istpProps2 = model.properties(depProps);
            depds.putProperty("FILL_VALUE", istpProps2.get("FILL_VALUE"));
            if (UnitsUtil.isTimeLocation((Units)SemanticOps.getUnits((QDataSet)depds))) continue;
            depds.putProperty("LABEL", istpProps2.get("LABEL"));
            depds.putProperty("TITLE", istpProps2.get("TITLE"));
        }
        result.putProperty("METADATA", attr1);
        result.putProperty("METADATA_MODEL", (Object)"ISTP-CDF");
    }

    public static class CdfVariableDescription {
        public String name;
        public String description;
        public String htmlDescription;
        public String variableType;
        public boolean isSupport;
        public long numberOfRecords;
        public String depend0Name;
        public int[] dimensions;
        public String[] depends;
    }

    private static class DepDesc {
        String dep;
        String labl;
        long nrec;
        boolean rank2;

        private DepDesc() {
        }
    }
}

