/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.cdf;

import java.util.HashMap;
import java.util.Map;
import org.autoplot.cdf.TrArrayDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.WritableDataSet;

public final class TrLDataSet
extends TrArrayDataSet
implements WritableDataSet,
RankZeroDataSet {
    long[] back;
    int rank;
    int len0;
    int len1;
    int len2;
    int len3;
    private static final boolean RANGE_CHECK = false;
    public static final String version = "20120419";

    public static TrLDataSet createRank1(int len0) {
        return new TrLDataSet(1, len0, 1, 1, 1);
    }

    public static TrLDataSet createRank2(int len0, int len1) {
        return new TrLDataSet(2, len0, len1, 1, 1);
    }

    public static TrLDataSet createRank3(int len0, int len1, int len2) {
        return new TrLDataSet(3, len0, len1, len2, 1);
    }

    public static TrLDataSet createRank4(int len0, int len1, int len2, int len3) {
        return new TrLDataSet(4, len0, len1, len2, len3);
    }

    public static TrLDataSet create(int[] qube) {
        if (qube.length == 0) {
            return new TrLDataSet(0, 1, 1, 1, 1);
        }
        if (qube.length == 1) {
            return TrLDataSet.createRank1(qube[0]);
        }
        if (qube.length == 2) {
            return TrLDataSet.createRank2(qube[0], qube[1]);
        }
        if (qube.length == 3) {
            return TrLDataSet.createRank3(qube[0], qube[1], qube[2]);
        }
        if (qube.length == 4) {
            return TrLDataSet.createRank4(qube[0], qube[1], qube[2], qube[3]);
        }
        throw new IllegalArgumentException("bad qube");
    }

    public static TrLDataSet wrap(long[] data, int[] qube) {
        if (qube.length == 0) {
            return new TrLDataSet(1, 1, 1, 1, 1, data);
        }
        if (qube.length == 1) {
            return new TrLDataSet(1, qube[0], 1, 1, 1, data);
        }
        if (qube.length == 2) {
            return new TrLDataSet(2, qube[0], qube[1], 1, 1, data);
        }
        if (qube.length == 3) {
            return new TrLDataSet(3, qube[0], qube[1], qube[2], 1, data);
        }
        if (qube.length == 4) {
            return new TrLDataSet(4, qube[0], qube[1], qube[2], qube[3], data);
        }
        throw new IllegalArgumentException("bad qube");
    }

    private TrLDataSet(int rank, int len0, int len1, int len2, int len3) {
        this(rank, len0, len1, len2, len3, new long[len0 * len1 * len2 * len3]);
    }

    private TrLDataSet(int rank, int len0, int len1, int len2, int len3, long[] back) {
        if (back == null) {
            throw new NullPointerException("back was null");
        }
        this.back = back;
        this.rank = rank;
        this.len0 = len0;
        this.len1 = len1;
        this.len2 = len2;
        this.len3 = len3;
        DataSetUtil.addQube((MutablePropertyDataSet)this);
    }

    @Override
    protected Object getBack() {
        return this.back;
    }

    public int rank() {
        return this.rank;
    }

    public int length() {
        return this.len0;
    }

    public int length(int i) {
        return this.len1;
    }

    public int length(int i0, int i1) {
        return this.len2;
    }

    public int length(int i0, int i1, int i2) {
        return this.len3;
    }

    public double value() {
        long v = this.back[0];
        return (float)v == this.fill ? this.dfill : (double)v;
    }

    public double value(int i0) {
        long v = this.back[i0];
        return (float)v == this.fill ? this.dfill : (double)v;
    }

    public double value(int i0, int i1) {
        long v = this.back[i0 * this.len1 + i1];
        return (float)v == this.fill ? this.dfill : (double)v;
    }

    public double value(int i0, int i1, int i2) {
        long v = this.back[i0 * this.len1 * this.len2 + i2 * this.len1 + i1];
        return (float)v == this.fill ? this.dfill : (double)v;
    }

    public double value(int i0, int i1, int i2, int i3) {
        long v = this.back[i0 * this.len1 * this.len2 * this.len3 + i3 * this.len2 * this.len1 + i2 * this.len1 + i1];
        return (float)v == this.fill ? this.dfill : (double)v;
    }

    public void putValue(double value) {
        this.back[0] = (long)value;
    }

    public void putValue(int i0, double value) {
        this.back[i0] = (long)value;
    }

    public void putValue(int i0, int i1, double value) {
        this.back[i0 * this.len1 + i1] = (long)value;
    }

    public void putValue(int i0, int i1, int i2, double value) {
        this.back[i0 * this.len1 * this.len2 + i2 * this.len1 + i1] = (long)value;
    }

    public void putValue(int i0, int i1, int i2, int i3, double value) {
        this.back[i0 * this.len1 * this.len2 * this.len3 + i3 * this.len1 * this.len2 + i2 * this.len1 + i1] = (long)value;
    }

    public void putLength(int len) {
        if (len > this.len0) {
            throw new IllegalArgumentException("dataset cannot be lengthened");
        }
        this.len0 = len;
    }

    public String toString() {
        return DataSetUtil.toString((QDataSet)this);
    }

    public void putProperty(String name, Object value) {
        super.putProperty(name, value);
    }

    protected static Map copyProperties(QDataSet ds) {
        QDataSet plane0;
        int i;
        HashMap<String, TrLDataSet> result = new HashMap<String, TrLDataSet>();
        Map srcProps = DataSetUtil.getProperties((QDataSet)ds);
        result.putAll(srcProps);
        for (i = 0; i < ds.rank(); ++i) {
            QDataSet dep = (QDataSet)ds.property("DEPEND_" + i);
            if (dep == ds) {
                throw new IllegalArgumentException("dataset is dependent on itsself!");
            }
            if (dep == null) continue;
            result.put("DEPEND_" + i, TrLDataSet.copy(dep));
        }
        for (i = 0; i < 50 && (plane0 = (QDataSet)ds.property("PLANE_" + i)) != null; ++i) {
            result.put("PLANE_" + i, TrLDataSet.copy(plane0));
        }
        return result;
    }

    private static TrLDataSet ddcopy(TrLDataSet ds) {
        int dsLength = ds.len0 * ds.len1 * ds.len2 * ds.len3;
        long[] newback = new long[dsLength];
        System.arraycopy(ds.back, 0, newback, 0, dsLength);
        TrLDataSet result = new TrLDataSet(ds.rank, ds.len0, ds.len1, ds.len2, ds.len3, newback);
        result.properties.putAll(TrLDataSet.copyProperties((QDataSet)ds));
        if (result.properties.containsKey("FILL_VALUE")) {
            result.checkFill();
        }
        return result;
    }

    public static TrLDataSet maybeCopy(QDataSet ds) {
        if (ds instanceof TrLDataSet) {
            return (TrLDataSet)ds;
        }
        return TrLDataSet.copy(ds);
    }

    public static TrLDataSet copy(QDataSet ds) {
        TrLDataSet result;
        if (ds instanceof TrLDataSet) {
            return TrLDataSet.ddcopy((TrLDataSet)ds);
        }
        int rank = ds.rank();
        if (!DataSetUtil.isQube((QDataSet)ds)) {
            logger.fine("copy of non-qube to DDataSet, which must be qube");
        }
        switch (rank) {
            case 0: {
                result = TrLDataSet.createRank1(1);
                result.rank = 0;
                result.putValue(ds.value());
                break;
            }
            case 1: {
                result = TrLDataSet.createRank1(ds.length());
                for (int i = 0; i < ds.length(); ++i) {
                    result.putValue(i, ds.value(i));
                }
                break;
            }
            case 2: {
                int len1 = ds.length() == 0 ? 0 : ds.length(0);
                result = TrLDataSet.createRank2(ds.length(), len1);
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        result.putValue(i, j, ds.value(i, j));
                    }
                }
                break;
            }
            case 3: {
                int len1 = ds.length() == 0 ? 0 : ds.length(0);
                int len2 = len1 == 0 ? 0 : ds.length(0, 0);
                result = TrLDataSet.createRank3(ds.length(), len1, len2);
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        for (int k = 0; k < ds.length(i, j); ++k) {
                            result.putValue(i, j, k, ds.value(i, j, k));
                        }
                    }
                }
                break;
            }
            case 4: {
                int len1 = ds.length() == 0 ? 0 : ds.length(0);
                int len2 = len1 == 0 ? 0 : ds.length(0, 0);
                int len3 = len2 == 0 ? 0 : ds.length(0, 0, 0);
                result = TrLDataSet.createRank4(ds.length(), len1, len2, len3);
                for (int i = 0; i < ds.length(); ++i) {
                    for (int j = 0; j < ds.length(i); ++j) {
                        for (int k = 0; k < ds.length(i, j); ++k) {
                            for (int l = 0; l < ds.length(i, j, k); ++l) {
                                result.putValue(i, j, k, l, ds.value(i, j, k, l));
                            }
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("bad rank");
            }
        }
        result.properties.putAll(TrLDataSet.copyProperties(ds));
        return result;
    }

    public static TrLDataSet wrap(long[] back) {
        return new TrLDataSet(1, back.length, 1, 1, 1, back);
    }

    public static TrLDataSet wrapRank2(long[] back, int n1) {
        return new TrLDataSet(2, back.length / n1, n1, 1, 1, back);
    }

    public static TrLDataSet wrapRank3(long[] back, int n1, int n2) {
        return new TrLDataSet(3, back.length / (n1 * n2), n1, n2, 1, back);
    }

    public static TrLDataSet wrap(long[] back, int nx, int ny) {
        return new TrLDataSet(2, nx, ny, 1, 1, back);
    }

    public static TrLDataSet wrap(long[] back, int rank, int len0, int len1, int len2) {
        return new TrLDataSet(rank, len0, len1, len2, 1, back);
    }

    public static TrLDataSet wrap(long[] back, int rank, int len0, int len1, int len2, int len3) {
        return new TrLDataSet(rank, len0, len1, len2, len3, back);
    }

    private void joinProperties(TrLDataSet ds) {
        TrLDataSet djoin;
        QDataSet dep0;
        QDataSet dep1;
        int i;
        HashMap<String, TrLDataSet> result = new HashMap<String, TrLDataSet>();
        for (i = 0; i < 1; ++i) {
            dep1 = (QDataSet)ds.property("DEPEND_" + i);
            if (dep1 == null) continue;
            dep0 = (QDataSet)this.property("DEPEND_" + i);
            djoin = TrLDataSet.copy(dep0);
            TrLDataSet ddep1 = dep1 instanceof TrLDataSet ? (TrLDataSet)dep1 : TrLDataSet.copy(dep1);
            djoin.append(ddep1);
            result.put("DEPEND_" + i, djoin);
        }
        for (i = 0; i < 50 && (dep1 = (QDataSet)ds.property("PLANE_" + i)) != null; ++i) {
            dep0 = (QDataSet)this.property("PLANE_" + i);
            djoin = TrLDataSet.copy(dep0);
            TrLDataSet dd1 = dep1 instanceof TrLDataSet ? (TrLDataSet)dep1 : TrLDataSet.copy(dep1);
            djoin.append(dd1);
            result.put("PLANE_" + i, djoin);
        }
        this.properties.putAll(result);
    }

    public static void copyElements(TrLDataSet src, int srcpos, TrLDataSet dest, int destpos, int len) {
        if (src.len1 != dest.len1 || src.len2 != dest.len2) {
            throw new IllegalArgumentException("src and dest geometry don't match");
        }
        TrLDataSet.copyElements(src, srcpos, dest, destpos, len * src.len1 * src.len2, false);
    }

    public static void copyElements(TrLDataSet src, int srcpos, TrLDataSet dest, int destpos, int len, boolean checkAlias) {
        if (checkAlias && src.len1 * src.len2 != dest.len1 * dest.len2) {
            throw new IllegalArgumentException("src and dest geometry don't match");
        }
        int srcpos1 = srcpos * src.len1 * src.len2;
        int destpos1 = destpos * dest.len1 * dest.len2;
        int len1 = len;
        System.arraycopy(src.back, srcpos1, dest.back, destpos1, len1);
    }

    public void join(TrLDataSet ds) {
        this.append(ds);
    }

    public void append(TrLDataSet ds) {
        if (ds.rank() != this.rank) {
            throw new IllegalArgumentException("rank mismatch");
        }
        if (ds.len1 != this.len1) {
            throw new IllegalArgumentException("len1 mismatch");
        }
        if (ds.len2 != this.len2) {
            throw new IllegalArgumentException("len2 mismatch");
        }
        if (ds.len3 != this.len3) {
            throw new IllegalArgumentException("len3 mismatch");
        }
        int myLength = this.len0 * this.len1 * this.len2 * this.len3;
        int dsLength = ds.len0 * ds.len1 * ds.len2 * ds.len3;
        long[] newback = new long[myLength + dsLength];
        System.arraycopy(this.back, 0, newback, 0, myLength);
        System.arraycopy(ds.back, 0, newback, myLength, dsLength);
        this.len0 += ds.len0;
        this.back = newback;
        this.joinProperties(ds);
    }

    public QDataSet trim(int start, int end) {
        int nrank = this.rank;
        int noff1 = start * this.len1 * this.len2 * this.len3;
        int noff2 = end * this.len1 * this.len2 * this.len3;
        long[] newback = new long[noff2 - noff1];
        System.arraycopy(this.back, noff1, newback, 0, noff2 - noff1);
        TrLDataSet result = new TrLDataSet(nrank, end - start, this.len1, this.len2, this.len3, newback);
        Map props = DataSetUtil.getProperties((QDataSet)this);
        Map depProps = DataSetUtil.trimProperties((QDataSet)this, (int)start, (int)end);
        props.putAll(depProps);
        DataSetUtil.putProperties((Map)props, (MutablePropertyDataSet)result);
        return result;
    }

    public <T> T capability(Class<T> clazz) {
        if (clazz == WritableDataSet.class) {
            return (T)((Object)this);
        }
        return (T)super.capability(clazz);
    }
}

